/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link HandlingUnitServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService HandlingUnitService}.
 *
 */
public class DefaultHandlingUnitServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<HandlingUnitServiceBatch, HandlingUnitServiceBatchChangeSet>
    implements
    HandlingUnitServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService service;

    @SuppressWarnings( "deprecation" )
    DefaultHandlingUnitServiceBatchChangeSet(
        @Nonnull final DefaultHandlingUnitServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultHandlingUnitServiceBatchChangeSet getThis()
    {
        return this;
    }

}
