/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem HandlingUnitItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.field.HandlingUnitItemField
 * HandlingUnitItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.link.HandlingUnitItemLink
 * HandlingUnitItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_EXTERNAL_ID
 * HANDLING_UNIT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#STOCK_ITEM_UUID
 * STOCK_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_ITEM
 * HANDLING_UNIT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_REFERENCE_DOCUMENT
 * HANDLING_UNIT_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_REF_DOCUMENT_ITEM
 * HANDLING_UNIT_REF_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_QUANTITY
 * HANDLING_UNIT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_QUANTITY_UNIT
 * HANDLING_UNIT_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_ALT_UNIT_OF_MEASURE
 * HANDLING_UNIT_ALT_UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#SHELF_LIFE_EXPIRATION_DATE
 * SHELF_LIFE_EXPIRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#HANDLING_UNIT_GOODS_RECEIPT_DATE
 * HANDLING_UNIT_GOODS_RECEIPT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem#TO_HANDLING_UNIT
 * TO_HANDLING_UNIT}</li>
 * </ul>
 *
 */
public interface HandlingUnitItemSelectable extends EntitySelectable<HandlingUnitItem>
{

}
