/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit HandlingUnit}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.field.HandlingUnitField
 * HandlingUnitField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.link.HandlingUnitLink
 * HandlingUnitLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_EXTERNAL_ID
 * HANDLING_UNIT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#WAREHOUSE WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#PACKAGING_MATERIAL
 * PACKAGING_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#PACKAGING_MATERIAL_TYPE
 * PACKAGING_MATERIAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#PARENT_HANDLING_UNIT_NUMBER
 * PARENT_HANDLING_UNIT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#GROSS_WEIGHT
 * GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#NET_WEIGHT NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_MAX_WEIGHT
 * HANDLING_UNIT_MAX_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#WEIGHT_UNIT
 * WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_TARE_WEIGHT
 * HANDLING_UNIT_TARE_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_TARE_WEIGHT_UNIT
 * HANDLING_UNIT_TARE_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#GROSS_VOLUME
 * GROSS_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_NET_VOLUME
 * HANDLING_UNIT_NET_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_TARE_VOLUME
 * HANDLING_UNIT_TARE_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_TARE_VOLUME_UNIT
 * HANDLING_UNIT_TARE_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_LENGTH
 * HANDLING_UNIT_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_WIDTH
 * HANDLING_UNIT_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_HEIGHT
 * HANDLING_UNIT_HEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#UNIT_OF_MEASURE_DIMENSION
 * UNIT_OF_MEASURE_DIMENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_PACKING_OBJECT_KEY
 * HANDLING_UNIT_PACKING_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_REFERENCE_DOCUMENT
 * HANDLING_UNIT_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#HANDLING_UNIT_PROCESS_STATUS
 * HANDLING_UNIT_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#STORAGE_SECTION
 * STORAGE_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#STORAGE_BIN
 * STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit#TO_HANDLING_UNIT_ITEM
 * TO_HANDLING_UNIT_ITEM}</li>
 * </ul>
 *
 */
public interface HandlingUnitSelectable extends EntitySelectable<HandlingUnit>
{

}
