/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.field.InbDeliveryHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.link.InbDeliveryHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.selectable.InbDeliveryHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_InbDeliveryHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InbDeliveryHeader extends VdmEntity<InbDeliveryHeader>
{

    /**
     * Selector for all available fields of InbDeliveryHeader.
     *
     */
    public final static InbDeliveryHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveryRoute</b>
     * </p>
     *
     * @return Route
     */
    @SerializedName( "ActualDeliveryRoute" )
    @JsonProperty( "ActualDeliveryRoute" )
    @Nullable
    @ODataField( odataName = "ActualDeliveryRoute" )
    private String actualDeliveryRoute;
    /**
     * Use with available fluent helpers to apply the <b>ActualDeliveryRoute</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> ACTUAL_DELIVERY_ROUTE =
        new InbDeliveryHeaderField<String>("ActualDeliveryRoute");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ActualGoodsMovementDate</b>
     * </p>
     *
     * @return Actual GI Date
     */
    @SerializedName( "ActualGoodsMovementDate" )
    @JsonProperty( "ActualGoodsMovementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualGoodsMovementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualGoodsMovementDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualGoodsMovementDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> ACTUAL_GOODS_MOVEMENT_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("ActualGoodsMovementDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualGoodsMovementTime</b>
     * </p>
     *
     * @return GI Time
     */
    @SerializedName( "ActualGoodsMovementTime" )
    @JsonProperty( "ActualGoodsMovementTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ActualGoodsMovementTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime actualGoodsMovementTime;
    /**
     * Use with available fluent helpers to apply the <b>ActualGoodsMovementTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> ACTUAL_GOODS_MOVEMENT_TIME =
        new InbDeliveryHeaderField<LocalTime>("ActualGoodsMovementTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @return Billing Date
     */
    @SerializedName( "BillingDocumentDate" )
    @JsonProperty( "BillingDocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingDocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingDocumentDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> BILLING_DOCUMENT_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("BillingDocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BillOfLading</b>
     * </p>
     *
     * @return Bill of Lading
     */
    @SerializedName( "BillOfLading" )
    @JsonProperty( "BillOfLading" )
    @Nullable
    @ODataField( odataName = "BillOfLading" )
    private String billOfLading;
    /**
     * Use with available fluent helpers to apply the <b>BillOfLading</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> BILL_OF_LADING =
        new InbDeliveryHeaderField<String>("BillOfLading");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @return Complete Dlv.
     */
    @SerializedName( "CompleteDeliveryIsDefined" )
    @JsonProperty( "CompleteDeliveryIsDefined" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CompleteDeliveryIsDefined" )
    private Boolean completeDeliveryIsDefined;
    /**
     * Use with available fluent helpers to apply the <b>CompleteDeliveryIsDefined</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<Boolean> COMPLETE_DELIVERY_IS_DEFINED =
        new InbDeliveryHeaderField<Boolean>("CompleteDeliveryIsDefined");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationTime</b>
     * </p>
     *
     * @return Confirm. Time
     */
    @SerializedName( "ConfirmationTime" )
    @JsonProperty( "ConfirmationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmationTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> CONFIRMATION_TIME =
        new InbDeliveryHeaderField<LocalTime>("ConfirmationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> CREATED_BY_USER =
        new InbDeliveryHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> CREATION_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> CREATION_TIME =
        new InbDeliveryHeaderField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> CUSTOMER_GROUP =
        new InbDeliveryHeaderField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @return Delivery Block
     */
    @SerializedName( "DeliveryBlockReason" )
    @JsonProperty( "DeliveryBlockReason" )
    @Nullable
    @ODataField( odataName = "DeliveryBlockReason" )
    private String deliveryBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryBlockReason</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> DELIVERY_BLOCK_REASON =
        new InbDeliveryHeaderField<String>("DeliveryBlockReason");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDate</b>
     * </p>
     *
     * @return Delivery Date
     */
    @SerializedName( "DeliveryDate" )
    @JsonProperty( "DeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> DELIVERY_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("DeliveryDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @Key
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> DELIVERY_DOCUMENT =
        new InbDeliveryHeaderField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentBySupplier</b>
     * </p>
     *
     * @return Ext. Delivery
     */
    @SerializedName( "DeliveryDocumentBySupplier" )
    @JsonProperty( "DeliveryDocumentBySupplier" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentBySupplier" )
    private String deliveryDocumentBySupplier;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentBySupplier</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> DELIVERY_DOCUMENT_BY_SUPPLIER =
        new InbDeliveryHeaderField<String>("DeliveryDocumentBySupplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentType</b>
     * </p>
     *
     * @return Delivery Type
     */
    @SerializedName( "DeliveryDocumentType" )
    @JsonProperty( "DeliveryDocumentType" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentType" )
    private String deliveryDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentType</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> DELIVERY_DOCUMENT_TYPE =
        new InbDeliveryHeaderField<String>("DeliveryDocumentType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryIsInPlant</b>
     * </p>
     *
     * @return In Plant
     */
    @SerializedName( "DeliveryIsInPlant" )
    @JsonProperty( "DeliveryIsInPlant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeliveryIsInPlant" )
    private Boolean deliveryIsInPlant;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryIsInPlant</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<Boolean> DELIVERY_IS_IN_PLANT =
        new InbDeliveryHeaderField<Boolean>("DeliveryIsInPlant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Prior.
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> DELIVERY_PRIORITY =
        new InbDeliveryHeaderField<String>("DeliveryPriority");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryTime</b>
     * </p>
     *
     * @return TimeOfDelivery
     */
    @SerializedName( "DeliveryTime" )
    @JsonProperty( "DeliveryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime deliveryTime;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> DELIVERY_TIME =
        new InbDeliveryHeaderField<LocalTime>("DeliveryTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryVersion</b>
     * </p>
     *
     * @return DLV.Version
     */
    @SerializedName( "DeliveryVersion" )
    @JsonProperty( "DeliveryVersion" )
    @Nullable
    @ODataField( odataName = "DeliveryVersion" )
    private String deliveryVersion;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryVersion</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> DELIVERY_VERSION =
        new InbDeliveryHeaderField<String>("DeliveryVersion");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DepreciationPercentage</b>
     * </p>
     *
     * @return Depreciation
     */
    @SerializedName( "DepreciationPercentage" )
    @JsonProperty( "DepreciationPercentage" )
    @Nullable
    @ODataField( odataName = "DepreciationPercentage" )
    private BigDecimal depreciationPercentage;
    /**
     * Use with available fluent helpers to apply the <b>DepreciationPercentage</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<BigDecimal> DEPRECIATION_PERCENTAGE =
        new InbDeliveryHeaderField<BigDecimal>("DepreciationPercentage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DistrStatusByDecentralizedWrhs</b>
     * </p>
     *
     * @return StatDecntrlWhse
     */
    @SerializedName( "DistrStatusByDecentralizedWrhs" )
    @JsonProperty( "DistrStatusByDecentralizedWrhs" )
    @Nullable
    @ODataField( odataName = "DistrStatusByDecentralizedWrhs" )
    private String distrStatusByDecentralizedWrhs;
    /**
     * Use with available fluent helpers to apply the <b>DistrStatusByDecentralizedWrhs</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> DISTR_STATUS_BY_DECENTRALIZED_WRHS =
        new InbDeliveryHeaderField<String>("DistrStatusByDecentralizedWrhs");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Document Date
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> DOCUMENT_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExternalIdentificationType</b>
     * </p>
     *
     * @return Type Ext. Ident
     */
    @SerializedName( "ExternalIdentificationType" )
    @JsonProperty( "ExternalIdentificationType" )
    @Nullable
    @ODataField( odataName = "ExternalIdentificationType" )
    private String externalIdentificationType;
    /**
     * Use with available fluent helpers to apply the <b>ExternalIdentificationType</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> EXTERNAL_IDENTIFICATION_TYPE =
        new InbDeliveryHeaderField<String>("ExternalIdentificationType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExternalTransportSystem</b>
     * </p>
     *
     * @return ID Transp.Syst.
     */
    @SerializedName( "ExternalTransportSystem" )
    @JsonProperty( "ExternalTransportSystem" )
    @Nullable
    @ODataField( odataName = "ExternalTransportSystem" )
    private String externalTransportSystem;
    /**
     * Use with available fluent helpers to apply the <b>ExternalTransportSystem</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> EXTERNAL_TRANSPORT_SYSTEM =
        new InbDeliveryHeaderField<String>("ExternalTransportSystem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendarByCustomer</b>
     * </p>
     *
     * @return FactoryCalendar
     */
    @SerializedName( "FactoryCalendarByCustomer" )
    @JsonProperty( "FactoryCalendarByCustomer" )
    @Nullable
    @ODataField( odataName = "FactoryCalendarByCustomer" )
    private String factoryCalendarByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendarByCustomer</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> FACTORY_CALENDAR_BY_CUSTOMER =
        new InbDeliveryHeaderField<String>("FactoryCalendarByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueOrReceiptSlipNumber</b>
     * </p>
     *
     * @return GR/GI Slip No.
     */
    @SerializedName( "GoodsIssueOrReceiptSlipNumber" )
    @JsonProperty( "GoodsIssueOrReceiptSlipNumber" )
    @Nullable
    @ODataField( odataName = "GoodsIssueOrReceiptSlipNumber" )
    private String goodsIssueOrReceiptSlipNumber;
    /**
     * Use with available fluent helpers to apply the <b>GoodsIssueOrReceiptSlipNumber</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> GOODS_ISSUE_OR_RECEIPT_SLIP_NUMBER =
        new InbDeliveryHeaderField<String>("GoodsIssueOrReceiptSlipNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueTime</b>
     * </p>
     *
     * @return GI Time
     */
    @SerializedName( "GoodsIssueTime" )
    @JsonProperty( "GoodsIssueTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "GoodsIssueTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime goodsIssueTime;
    /**
     * Use with available fluent helpers to apply the <b>GoodsIssueTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> GOODS_ISSUE_TIME =
        new InbDeliveryHeaderField<LocalTime>("GoodsIssueTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInStock</b>
     * </p>
     *
     * @return HU in Stock
     */
    @SerializedName( "HandlingUnitInStock" )
    @JsonProperty( "HandlingUnitInStock" )
    @Nullable
    @ODataField( odataName = "HandlingUnitInStock" )
    private String handlingUnitInStock;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitInStock</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HANDLING_UNIT_IN_STOCK =
        new InbDeliveryHeaderField<String>("HandlingUnitInStock");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HdrGeneralIncompletionStatus</b>
     * </p>
     *
     * @return Header Data
     */
    @SerializedName( "HdrGeneralIncompletionStatus" )
    @JsonProperty( "HdrGeneralIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "HdrGeneralIncompletionStatus" )
    private String hdrGeneralIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>HdrGeneralIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HDR_GENERAL_INCOMPLETION_STATUS =
        new InbDeliveryHeaderField<String>("HdrGeneralIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HdrGoodsMvtIncompletionStatus</b>
     * </p>
     *
     * @return Head. Data GM
     */
    @SerializedName( "HdrGoodsMvtIncompletionStatus" )
    @JsonProperty( "HdrGoodsMvtIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "HdrGoodsMvtIncompletionStatus" )
    private String hdrGoodsMvtIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>HdrGoodsMvtIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HDR_GOODS_MVT_INCOMPLETION_STATUS =
        new InbDeliveryHeaderField<String>("HdrGoodsMvtIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillgIncompletionStatus</b>
     * </p>
     *
     * @return Header Bill.Dat
     */
    @SerializedName( "HeaderBillgIncompletionStatus" )
    @JsonProperty( "HeaderBillgIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "HeaderBillgIncompletionStatus" )
    private String headerBillgIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>HeaderBillgIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HEADER_BILLG_INCOMPLETION_STATUS =
        new InbDeliveryHeaderField<String>("HeaderBillgIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block
     */
    @SerializedName( "HeaderBillingBlockReason" )
    @JsonProperty( "HeaderBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "HeaderBillingBlockReason" )
    private String headerBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>HeaderBillingBlockReason</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HEADER_BILLING_BLOCK_REASON =
        new InbDeliveryHeaderField<String>("HeaderBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderDelivIncompletionStatus</b>
     * </p>
     *
     * @return Header Dlv.Data
     */
    @SerializedName( "HeaderDelivIncompletionStatus" )
    @JsonProperty( "HeaderDelivIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "HeaderDelivIncompletionStatus" )
    private String headerDelivIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>HeaderDelivIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HEADER_DELIV_INCOMPLETION_STATUS =
        new InbDeliveryHeaderField<String>("HeaderDelivIncompletionStatus");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderGrossWeight</b>
     * </p>
     *
     * @return Total Weight
     */
    @SerializedName( "HeaderGrossWeight" )
    @JsonProperty( "HeaderGrossWeight" )
    @Nullable
    @ODataField( odataName = "HeaderGrossWeight" )
    private BigDecimal headerGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>HeaderGrossWeight</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<BigDecimal> HEADER_GROSS_WEIGHT =
        new InbDeliveryHeaderField<BigDecimal>("HeaderGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "HeaderNetWeight" )
    @JsonProperty( "HeaderNetWeight" )
    @Nullable
    @ODataField( odataName = "HeaderNetWeight" )
    private BigDecimal headerNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>HeaderNetWeight</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<BigDecimal> HEADER_NET_WEIGHT =
        new InbDeliveryHeaderField<BigDecimal>("HeaderNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderPackingIncompletionSts</b>
     * </p>
     *
     * @return Head.Data Pckg.
     */
    @SerializedName( "HeaderPackingIncompletionSts" )
    @JsonProperty( "HeaderPackingIncompletionSts" )
    @Nullable
    @ODataField( odataName = "HeaderPackingIncompletionSts" )
    private String headerPackingIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>HeaderPackingIncompletionSts</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HEADER_PACKING_INCOMPLETION_STS =
        new InbDeliveryHeaderField<String>("HeaderPackingIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderPickgIncompletionStatus</b>
     * </p>
     *
     * @return Head.Data Pck/Putawy
     */
    @SerializedName( "HeaderPickgIncompletionStatus" )
    @JsonProperty( "HeaderPickgIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "HeaderPickgIncompletionStatus" )
    private String headerPickgIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>HeaderPickgIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HEADER_PICKG_INCOMPLETION_STATUS =
        new InbDeliveryHeaderField<String>("HeaderPickgIncompletionStatus");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderVolume</b>
     * </p>
     *
     * @return Volume
     */
    @SerializedName( "HeaderVolume" )
    @JsonProperty( "HeaderVolume" )
    @Nullable
    @ODataField( odataName = "HeaderVolume" )
    private BigDecimal headerVolume;
    /**
     * Use with available fluent helpers to apply the <b>HeaderVolume</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<BigDecimal> HEADER_VOLUME =
        new InbDeliveryHeaderField<BigDecimal>("HeaderVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "HeaderVolumeUnit" )
    @JsonProperty( "HeaderVolumeUnit" )
    @Nullable
    @ODataField( odataName = "HeaderVolumeUnit" )
    private String headerVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>HeaderVolumeUnit</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HEADER_VOLUME_UNIT =
        new InbDeliveryHeaderField<String>("HeaderVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "HeaderWeightUnit" )
    @JsonProperty( "HeaderWeightUnit" )
    @Nullable
    @ODataField( odataName = "HeaderWeightUnit" )
    private String headerWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>HeaderWeightUnit</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> HEADER_WEIGHT_UNIT =
        new InbDeliveryHeaderField<String>("HeaderWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> INCOTERMS_CLASSIFICATION =
        new InbDeliveryHeaderField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms 2
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> INCOTERMS_TRANSFER_LOCATION =
        new InbDeliveryHeaderField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyBillingDate</b>
     * </p>
     *
     * @return Intco Bill Date
     */
    @SerializedName( "IntercompanyBillingDate" )
    @JsonProperty( "IntercompanyBillingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntercompanyBillingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intercompanyBillingDate;
    /**
     * Use with available fluent helpers to apply the <b>IntercompanyBillingDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> INTERCOMPANY_BILLING_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("IntercompanyBillingDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalFinancialDocument</b>
     * </p>
     *
     * @return Financ.Doc.No.
     */
    @SerializedName( "InternalFinancialDocument" )
    @JsonProperty( "InternalFinancialDocument" )
    @Nullable
    @ODataField( odataName = "InternalFinancialDocument" )
    private String internalFinancialDocument;
    /**
     * Use with available fluent helpers to apply the <b>InternalFinancialDocument</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> INTERNAL_FINANCIAL_DOCUMENT =
        new InbDeliveryHeaderField<String>("InternalFinancialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeliveryForSingleWarehouse</b>
     * </p>
     *
     * @return ID: Delivery Split
     */
    @SerializedName( "IsDeliveryForSingleWarehouse" )
    @JsonProperty( "IsDeliveryForSingleWarehouse" )
    @Nullable
    @ODataField( odataName = "IsDeliveryForSingleWarehouse" )
    private String isDeliveryForSingleWarehouse;
    /**
     * Use with available fluent helpers to apply the <b>IsDeliveryForSingleWarehouse</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> IS_DELIVERY_FOR_SINGLE_WAREHOUSE =
        new InbDeliveryHeaderField<String>("IsDeliveryForSingleWarehouse");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsExportDelivery</b>
     * </p>
     *
     * @return Export
     */
    @SerializedName( "IsExportDelivery" )
    @JsonProperty( "IsExportDelivery" )
    @Nullable
    @ODataField( odataName = "IsExportDelivery" )
    private String isExportDelivery;
    /**
     * Use with available fluent helpers to apply the <b>IsExportDelivery</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> IS_EXPORT_DELIVERY =
        new InbDeliveryHeaderField<String>("IsExportDelivery");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> LAST_CHANGE_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> LAST_CHANGED_BY_USER =
        new InbDeliveryHeaderField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LoadingDate</b>
     * </p>
     *
     * @return Loading Date
     */
    @SerializedName( "LoadingDate" )
    @JsonProperty( "LoadingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LoadingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime loadingDate;
    /**
     * Use with available fluent helpers to apply the <b>LoadingDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> LOADING_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("LoadingDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LoadingPoint</b>
     * </p>
     *
     * @return Loading Point
     */
    @SerializedName( "LoadingPoint" )
    @JsonProperty( "LoadingPoint" )
    @Nullable
    @ODataField( odataName = "LoadingPoint" )
    private String loadingPoint;
    /**
     * Use with available fluent helpers to apply the <b>LoadingPoint</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> LOADING_POINT =
        new InbDeliveryHeaderField<String>("LoadingPoint");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LoadingTime</b>
     * </p>
     *
     * @return Loading Time
     */
    @SerializedName( "LoadingTime" )
    @JsonProperty( "LoadingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LoadingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime loadingTime;
    /**
     * Use with available fluent helpers to apply the <b>LoadingTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> LOADING_TIME =
        new InbDeliveryHeaderField<LocalTime>("LoadingTime");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransport</b>
     * </p>
     *
     * @return Mns of Trans.ID
     */
    @SerializedName( "MeansOfTransport" )
    @JsonProperty( "MeansOfTransport" )
    @Nullable
    @ODataField( odataName = "MeansOfTransport" )
    private String meansOfTransport;
    /**
     * Use with available fluent helpers to apply the <b>MeansOfTransport</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> MEANS_OF_TRANSPORT =
        new InbDeliveryHeaderField<String>("MeansOfTransport");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransportRefMaterial</b>
     * </p>
     *
     * @return MeansTransp.
     */
    @SerializedName( "MeansOfTransportRefMaterial" )
    @JsonProperty( "MeansOfTransportRefMaterial" )
    @Nullable
    @ODataField( odataName = "MeansOfTransportRefMaterial" )
    private String meansOfTransportRefMaterial;
    /**
     * Use with available fluent helpers to apply the <b>MeansOfTransportRefMaterial</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> MEANS_OF_TRANSPORT_REF_MATERIAL =
        new InbDeliveryHeaderField<String>("MeansOfTransportRefMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransportType</b>
     * </p>
     *
     * @return MnsOfTrns Type
     */
    @SerializedName( "MeansOfTransportType" )
    @JsonProperty( "MeansOfTransportType" )
    @Nullable
    @ODataField( odataName = "MeansOfTransportType" )
    private String meansOfTransportType;
    /**
     * Use with available fluent helpers to apply the <b>MeansOfTransportType</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> MEANS_OF_TRANSPORT_TYPE =
        new InbDeliveryHeaderField<String>("MeansOfTransportType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderCombinationIsAllowed</b>
     * </p>
     *
     * @return Order Combinat.
     */
    @SerializedName( "OrderCombinationIsAllowed" )
    @JsonProperty( "OrderCombinationIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OrderCombinationIsAllowed" )
    private Boolean orderCombinationIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>OrderCombinationIsAllowed</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<Boolean> ORDER_COMBINATION_IS_ALLOWED =
        new InbDeliveryHeaderField<Boolean>("OrderCombinationIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> ORDER_ID = new InbDeliveryHeaderField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallDelivConfStatus</b>
     * </p>
     *
     * @return Confirmed
     */
    @SerializedName( "OverallDelivConfStatus" )
    @JsonProperty( "OverallDelivConfStatus" )
    @Nullable
    @ODataField( odataName = "OverallDelivConfStatus" )
    private String overallDelivConfStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallDelivConfStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_DELIV_CONF_STATUS =
        new InbDeliveryHeaderField<String>("OverallDelivConfStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallDelivReltdBillgStatus</b>
     * </p>
     *
     * @return Billing Status
     */
    @SerializedName( "OverallDelivReltdBillgStatus" )
    @JsonProperty( "OverallDelivReltdBillgStatus" )
    @Nullable
    @ODataField( odataName = "OverallDelivReltdBillgStatus" )
    private String overallDelivReltdBillgStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallDelivReltdBillgStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_DELIV_RELTD_BILLG_STATUS =
        new InbDeliveryHeaderField<String>("OverallDelivReltdBillgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallGoodsMovementStatus</b>
     * </p>
     *
     * @return TotalGdsMvtStat
     */
    @SerializedName( "OverallGoodsMovementStatus" )
    @JsonProperty( "OverallGoodsMovementStatus" )
    @Nullable
    @ODataField( odataName = "OverallGoodsMovementStatus" )
    private String overallGoodsMovementStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallGoodsMovementStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_GOODS_MOVEMENT_STATUS =
        new InbDeliveryHeaderField<String>("OverallGoodsMovementStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallIntcoBillingStatus</b>
     * </p>
     *
     * @return Totals Status
     */
    @SerializedName( "OverallIntcoBillingStatus" )
    @JsonProperty( "OverallIntcoBillingStatus" )
    @Nullable
    @ODataField( odataName = "OverallIntcoBillingStatus" )
    private String overallIntcoBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallIntcoBillingStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_INTCO_BILLING_STATUS =
        new InbDeliveryHeaderField<String>("OverallIntcoBillingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPackingStatus</b>
     * </p>
     *
     * @return Packing Status
     */
    @SerializedName( "OverallPackingStatus" )
    @JsonProperty( "OverallPackingStatus" )
    @Nullable
    @ODataField( odataName = "OverallPackingStatus" )
    private String overallPackingStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallPackingStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_PACKING_STATUS =
        new InbDeliveryHeaderField<String>("OverallPackingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPickingConfStatus</b>
     * </p>
     *
     * @return Confirmation
     */
    @SerializedName( "OverallPickingConfStatus" )
    @JsonProperty( "OverallPickingConfStatus" )
    @Nullable
    @ODataField( odataName = "OverallPickingConfStatus" )
    private String overallPickingConfStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallPickingConfStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_PICKING_CONF_STATUS =
        new InbDeliveryHeaderField<String>("OverallPickingConfStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPickingStatus</b>
     * </p>
     *
     * @return Ovr.Pick.Status
     */
    @SerializedName( "OverallPickingStatus" )
    @JsonProperty( "OverallPickingStatus" )
    @Nullable
    @ODataField( odataName = "OverallPickingStatus" )
    private String overallPickingStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallPickingStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_PICKING_STATUS =
        new InbDeliveryHeaderField<String>("OverallPickingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallProofOfDeliveryStatus</b>
     * </p>
     *
     * @return POD Status
     */
    @SerializedName( "OverallProofOfDeliveryStatus" )
    @JsonProperty( "OverallProofOfDeliveryStatus" )
    @Nullable
    @ODataField( odataName = "OverallProofOfDeliveryStatus" )
    private String overallProofOfDeliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallProofOfDeliveryStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_PROOF_OF_DELIVERY_STATUS =
        new InbDeliveryHeaderField<String>("OverallProofOfDeliveryStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Status
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_SD_PROCESS_STATUS =
        new InbDeliveryHeaderField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallWarehouseActivityStatus</b>
     * </p>
     *
     * @return OverallWMStatus
     */
    @SerializedName( "OverallWarehouseActivityStatus" )
    @JsonProperty( "OverallWarehouseActivityStatus" )
    @Nullable
    @ODataField( odataName = "OverallWarehouseActivityStatus" )
    private String overallWarehouseActivityStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallWarehouseActivityStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVERALL_WAREHOUSE_ACTIVITY_STATUS =
        new InbDeliveryHeaderField<String>("OverallWarehouseActivityStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmDelivIncompletionSts</b>
     * </p>
     *
     * @return Item Deliv.Data
     */
    @SerializedName( "OvrlItmDelivIncompletionSts" )
    @JsonProperty( "OvrlItmDelivIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OvrlItmDelivIncompletionSts" )
    private String ovrlItmDelivIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OvrlItmDelivIncompletionSts</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVRL_ITM_DELIV_INCOMPLETION_STS =
        new InbDeliveryHeaderField<String>("OvrlItmDelivIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmGdsMvtIncompletionSts</b>
     * </p>
     *
     * @return Item data: GM
     */
    @SerializedName( "OvrlItmGdsMvtIncompletionSts" )
    @JsonProperty( "OvrlItmGdsMvtIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OvrlItmGdsMvtIncompletionSts" )
    private String ovrlItmGdsMvtIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OvrlItmGdsMvtIncompletionSts</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVRL_ITM_GDS_MVT_INCOMPLETION_STS =
        new InbDeliveryHeaderField<String>("OvrlItmGdsMvtIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmGeneralIncompletionSts</b>
     * </p>
     *
     * @return Item Data
     */
    @SerializedName( "OvrlItmGeneralIncompletionSts" )
    @JsonProperty( "OvrlItmGeneralIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OvrlItmGeneralIncompletionSts" )
    private String ovrlItmGeneralIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OvrlItmGeneralIncompletionSts</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVRL_ITM_GENERAL_INCOMPLETION_STS =
        new InbDeliveryHeaderField<String>("OvrlItmGeneralIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmPackingIncompletionSts</b>
     * </p>
     *
     * @return It.Data Packag.
     */
    @SerializedName( "OvrlItmPackingIncompletionSts" )
    @JsonProperty( "OvrlItmPackingIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OvrlItmPackingIncompletionSts" )
    private String ovrlItmPackingIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OvrlItmPackingIncompletionSts</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVRL_ITM_PACKING_INCOMPLETION_STS =
        new InbDeliveryHeaderField<String>("OvrlItmPackingIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmPickingIncompletionSts</b>
     * </p>
     *
     * @return It.Data Pck/Putaway
     */
    @SerializedName( "OvrlItmPickingIncompletionSts" )
    @JsonProperty( "OvrlItmPickingIncompletionSts" )
    @Nullable
    @ODataField( odataName = "OvrlItmPickingIncompletionSts" )
    private String ovrlItmPickingIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>OvrlItmPickingIncompletionSts</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> OVRL_ITM_PICKING_INCOMPLETION_STS =
        new InbDeliveryHeaderField<String>("OvrlItmPickingIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PaymentGuaranteeProcedure</b>
     * </p>
     *
     * @return Paym.Guar.Proc.
     */
    @SerializedName( "PaymentGuaranteeProcedure" )
    @JsonProperty( "PaymentGuaranteeProcedure" )
    @Nullable
    @ODataField( odataName = "PaymentGuaranteeProcedure" )
    private String paymentGuaranteeProcedure;
    /**
     * Use with available fluent helpers to apply the <b>PaymentGuaranteeProcedure</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> PAYMENT_GUARANTEE_PROCEDURE =
        new InbDeliveryHeaderField<String>("PaymentGuaranteeProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PickedItemsLocation</b>
     * </p>
     *
     * @return PickedItmLocat.
     */
    @SerializedName( "PickedItemsLocation" )
    @JsonProperty( "PickedItemsLocation" )
    @Nullable
    @ODataField( odataName = "PickedItemsLocation" )
    private String pickedItemsLocation;
    /**
     * Use with available fluent helpers to apply the <b>PickedItemsLocation</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> PICKED_ITEMS_LOCATION =
        new InbDeliveryHeaderField<String>("PickedItemsLocation");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PickingDate</b>
     * </p>
     *
     * @return Pick Date
     */
    @SerializedName( "PickingDate" )
    @JsonProperty( "PickingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PickingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pickingDate;
    /**
     * Use with available fluent helpers to apply the <b>PickingDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> PICKING_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("PickingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PickingTime</b>
     * </p>
     *
     * @return Picking Time
     */
    @SerializedName( "PickingTime" )
    @JsonProperty( "PickingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PickingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime pickingTime;
    /**
     * Use with available fluent helpers to apply the <b>PickingTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> PICKING_TIME =
        new InbDeliveryHeaderField<LocalTime>("PickingTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlannedGoodsIssueDate</b>
     * </p>
     *
     * @return Planned Gds Mvmt
     */
    @SerializedName( "PlannedGoodsIssueDate" )
    @JsonProperty( "PlannedGoodsIssueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedGoodsIssueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedGoodsIssueDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedGoodsIssueDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> PLANNED_GOODS_ISSUE_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("PlannedGoodsIssueDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProofOfDeliveryDate</b>
     * </p>
     *
     * @return POD Date
     */
    @SerializedName( "ProofOfDeliveryDate" )
    @JsonProperty( "ProofOfDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProofOfDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proofOfDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ProofOfDeliveryDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> PROOF_OF_DELIVERY_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("ProofOfDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProposedDeliveryRoute</b>
     * </p>
     *
     * @return Route
     */
    @SerializedName( "ProposedDeliveryRoute" )
    @JsonProperty( "ProposedDeliveryRoute" )
    @Nullable
    @ODataField( odataName = "ProposedDeliveryRoute" )
    private String proposedDeliveryRoute;
    /**
     * Use with available fluent helpers to apply the <b>ProposedDeliveryRoute</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> PROPOSED_DELIVERY_ROUTE =
        new InbDeliveryHeaderField<String>("ProposedDeliveryRoute");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingPlant</b>
     * </p>
     *
     * @return Receiving Plant
     */
    @SerializedName( "ReceivingPlant" )
    @JsonProperty( "ReceivingPlant" )
    @Nullable
    @ODataField( odataName = "ReceivingPlant" )
    private String receivingPlant;
    /**
     * Use with available fluent helpers to apply the <b>ReceivingPlant</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> RECEIVING_PLANT =
        new InbDeliveryHeaderField<String>("ReceivingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RouteSchedule</b>
     * </p>
     *
     * @return Route Schedule
     */
    @SerializedName( "RouteSchedule" )
    @JsonProperty( "RouteSchedule" )
    @Nullable
    @ODataField( odataName = "RouteSchedule" )
    private String routeSchedule;
    /**
     * Use with available fluent helpers to apply the <b>RouteSchedule</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> ROUTE_SCHEDULE =
        new InbDeliveryHeaderField<String>("RouteSchedule");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SALES_DISTRICT =
        new InbDeliveryHeaderField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SALES_OFFICE = new InbDeliveryHeaderField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Org.
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SALES_ORGANIZATION =
        new InbDeliveryHeaderField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @return Document Cat.
     */
    @SerializedName( "SDDocumentCategory" )
    @JsonProperty( "SDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SDDocumentCategory" )
    private String sDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentCategory</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SD_DOCUMENT_CATEGORY =
        new InbDeliveryHeaderField<String>("SDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShipmentBlockReason</b>
     * </p>
     *
     * @return ShpmtBlReason
     */
    @SerializedName( "ShipmentBlockReason" )
    @JsonProperty( "ShipmentBlockReason" )
    @Nullable
    @ODataField( odataName = "ShipmentBlockReason" )
    private String shipmentBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ShipmentBlockReason</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SHIPMENT_BLOCK_REASON =
        new InbDeliveryHeaderField<String>("ShipmentBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SHIPPING_CONDITION =
        new InbDeliveryHeaderField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SHIPPING_POINT =
        new InbDeliveryHeaderField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SHIPPING_TYPE =
        new InbDeliveryHeaderField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SHIP_TO_PARTY =
        new InbDeliveryHeaderField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SOLD_TO_PARTY =
        new InbDeliveryHeaderField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SpecialProcessingCode</b>
     * </p>
     *
     * @return Spec.Processing
     */
    @SerializedName( "SpecialProcessingCode" )
    @JsonProperty( "SpecialProcessingCode" )
    @Nullable
    @ODataField( odataName = "SpecialProcessingCode" )
    private String specialProcessingCode;
    /**
     * Use with available fluent helpers to apply the <b>SpecialProcessingCode</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SPECIAL_PROCESSING_CODE =
        new InbDeliveryHeaderField<String>("SpecialProcessingCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsCurrency</b>
     * </p>
     *
     * @return Stats. Currency
     */
    @SerializedName( "StatisticsCurrency" )
    @JsonProperty( "StatisticsCurrency" )
    @Nullable
    @ODataField( odataName = "StatisticsCurrency" )
    private String statisticsCurrency;
    /**
     * Use with available fluent helpers to apply the <b>StatisticsCurrency</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> STATISTICS_CURRENCY =
        new InbDeliveryHeaderField<String>("StatisticsCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> SUPPLIER = new InbDeliveryHeaderField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalBlockStatus</b>
     * </p>
     *
     * @return Overall Blk St.
     */
    @SerializedName( "TotalBlockStatus" )
    @JsonProperty( "TotalBlockStatus" )
    @Nullable
    @ODataField( odataName = "TotalBlockStatus" )
    private String totalBlockStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalBlockStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> TOTAL_BLOCK_STATUS =
        new InbDeliveryHeaderField<String>("TotalBlockStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @return OverallCredStat
     */
    @SerializedName( "TotalCreditCheckStatus" )
    @JsonProperty( "TotalCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "TotalCreditCheckStatus" )
    private String totalCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalCreditCheckStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> TOTAL_CREDIT_CHECK_STATUS =
        new InbDeliveryHeaderField<String>("TotalCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TotalNumberOfPackage</b>
     * </p>
     *
     * @return No. of Packages
     */
    @SerializedName( "TotalNumberOfPackage" )
    @JsonProperty( "TotalNumberOfPackage" )
    @Nullable
    @ODataField( odataName = "TotalNumberOfPackage" )
    private String totalNumberOfPackage;
    /**
     * Use with available fluent helpers to apply the <b>TotalNumberOfPackage</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> TOTAL_NUMBER_OF_PACKAGE =
        new InbDeliveryHeaderField<String>("TotalNumberOfPackage");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Doc. Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> TRANSACTION_CURRENCY =
        new InbDeliveryHeaderField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransportationGroup</b>
     * </p>
     *
     * @return Trans. Group
     */
    @SerializedName( "TransportationGroup" )
    @JsonProperty( "TransportationGroup" )
    @Nullable
    @ODataField( odataName = "TransportationGroup" )
    private String transportationGroup;
    /**
     * Use with available fluent helpers to apply the <b>TransportationGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> TRANSPORTATION_GROUP =
        new InbDeliveryHeaderField<String>("TransportationGroup");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningDate</b>
     * </p>
     *
     * @return TranspPlngDate
     */
    @SerializedName( "TransportationPlanningDate" )
    @JsonProperty( "TransportationPlanningDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TransportationPlanningDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime transportationPlanningDate;
    /**
     * Use with available fluent helpers to apply the <b>TransportationPlanningDate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalDateTime> TRANSPORTATION_PLANNING_DATE =
        new InbDeliveryHeaderField<LocalDateTime>("TransportationPlanningDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningStatus</b>
     * </p>
     *
     * @return Trns.Plan.Stat.
     */
    @SerializedName( "TransportationPlanningStatus" )
    @JsonProperty( "TransportationPlanningStatus" )
    @Nullable
    @ODataField( odataName = "TransportationPlanningStatus" )
    private String transportationPlanningStatus;
    /**
     * Use with available fluent helpers to apply the <b>TransportationPlanningStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> TRANSPORTATION_PLANNING_STATUS =
        new InbDeliveryHeaderField<String>("TransportationPlanningStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningTime</b>
     * </p>
     *
     * @return Tr. Plan. Time
     */
    @SerializedName( "TransportationPlanningTime" )
    @JsonProperty( "TransportationPlanningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "TransportationPlanningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime transportationPlanningTime;
    /**
     * Use with available fluent helpers to apply the <b>TransportationPlanningTime</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<LocalTime> TRANSPORTATION_PLANNING_TIME =
        new InbDeliveryHeaderField<LocalTime>("TransportationPlanningTime");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> UNLOADING_POINT_NAME =
        new InbDeliveryHeaderField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse No.
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> WAREHOUSE = new InbDeliveryHeaderField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseGate</b>
     * </p>
     *
     * @return Door for Whse
     */
    @SerializedName( "WarehouseGate" )
    @JsonProperty( "WarehouseGate" )
    @Nullable
    @ODataField( odataName = "WarehouseGate" )
    private String warehouseGate;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseGate</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> WAREHOUSE_GATE =
        new InbDeliveryHeaderField<String>("WarehouseGate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStagingArea</b>
     * </p>
     *
     * @return Staging Area
     */
    @SerializedName( "WarehouseStagingArea" )
    @JsonProperty( "WarehouseStagingArea" )
    @Nullable
    @ODataField( odataName = "WarehouseStagingArea" )
    private String warehouseStagingArea;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStagingArea</b> field to query operations.
     *
     */
    public final static InbDeliveryHeaderField<String> WAREHOUSE_STAGING_AREA =
        new InbDeliveryHeaderField<String>("WarehouseStagingArea");
    /**
     * Navigation property <b>to_DeliveryDocumentItem</b> for <b>InbDeliveryHeader</b> to multiple
     * <b>InbDeliveryItem</b>.
     *
     */
    @SerializedName( "to_DeliveryDocumentItem" )
    @JsonProperty( "to_DeliveryDocumentItem" )
    @ODataField( odataName = "to_DeliveryDocumentItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InbDeliveryItem> toDeliveryDocumentItem;
    /**
     * Navigation property <b>to_DeliveryDocumentPartner</b> for <b>InbDeliveryHeader</b> to multiple
     * <b>InbDeliveryPartner</b>.
     *
     */
    @SerializedName( "to_DeliveryDocumentPartner" )
    @JsonProperty( "to_DeliveryDocumentPartner" )
    @ODataField( odataName = "to_DeliveryDocumentPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InbDeliveryPartner> toDeliveryDocumentPartner;
    /**
     * Use with available fluent helpers to apply the <b>to_DeliveryDocumentItem</b> navigation property to query
     * operations.
     *
     */
    public final static InbDeliveryHeaderLink<InbDeliveryItem> TO_DELIVERY_DOCUMENT_ITEM =
        new InbDeliveryHeaderLink<InbDeliveryItem>("to_DeliveryDocumentItem");
    /**
     * Use with available fluent helpers to apply the <b>to_DeliveryDocumentPartner</b> navigation property to query
     * operations.
     *
     */
    public final static InbDeliveryHeaderLink<InbDeliveryPartner> TO_DELIVERY_DOCUMENT_PARTNER =
        new InbDeliveryHeaderLink<InbDeliveryPartner>("to_DeliveryDocumentPartner");

    @Nonnull
    @Override
    public Class<InbDeliveryHeader> getType()
    {
        return InbDeliveryHeader.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveryRoute</b>
     * </p>
     *
     * @param actualDeliveryRoute
     *            Route
     */
    public void setActualDeliveryRoute( @Nullable final String actualDeliveryRoute )
    {
        rememberChangedField("ActualDeliveryRoute", this.actualDeliveryRoute);
        this.actualDeliveryRoute = actualDeliveryRoute;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ActualGoodsMovementDate</b>
     * </p>
     *
     * @param actualGoodsMovementDate
     *            Actual GI Date
     */
    public void setActualGoodsMovementDate( @Nullable final LocalDateTime actualGoodsMovementDate )
    {
        rememberChangedField("ActualGoodsMovementDate", this.actualGoodsMovementDate);
        this.actualGoodsMovementDate = actualGoodsMovementDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualGoodsMovementTime</b>
     * </p>
     *
     * @param actualGoodsMovementTime
     *            GI Time
     */
    public void setActualGoodsMovementTime( @Nullable final LocalTime actualGoodsMovementTime )
    {
        rememberChangedField("ActualGoodsMovementTime", this.actualGoodsMovementTime);
        this.actualGoodsMovementTime = actualGoodsMovementTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @param billingDocumentDate
     *            Billing Date
     */
    public void setBillingDocumentDate( @Nullable final LocalDateTime billingDocumentDate )
    {
        rememberChangedField("BillingDocumentDate", this.billingDocumentDate);
        this.billingDocumentDate = billingDocumentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BillOfLading</b>
     * </p>
     *
     * @param billOfLading
     *            Bill of Lading
     */
    public void setBillOfLading( @Nullable final String billOfLading )
    {
        rememberChangedField("BillOfLading", this.billOfLading);
        this.billOfLading = billOfLading;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @param completeDeliveryIsDefined
     *            Complete Dlv.
     */
    public void setCompleteDeliveryIsDefined( @Nullable final Boolean completeDeliveryIsDefined )
    {
        rememberChangedField("CompleteDeliveryIsDefined", this.completeDeliveryIsDefined);
        this.completeDeliveryIsDefined = completeDeliveryIsDefined;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationTime</b>
     * </p>
     *
     * @param confirmationTime
     *            Confirm. Time
     */
    public void setConfirmationTime( @Nullable final LocalTime confirmationTime )
    {
        rememberChangedField("ConfirmationTime", this.confirmationTime);
        this.confirmationTime = confirmationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @param deliveryBlockReason
     *            Delivery Block
     */
    public void setDeliveryBlockReason( @Nullable final String deliveryBlockReason )
    {
        rememberChangedField("DeliveryBlockReason", this.deliveryBlockReason);
        this.deliveryBlockReason = deliveryBlockReason;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDate</b>
     * </p>
     *
     * @param deliveryDate
     *            Delivery Date
     */
    public void setDeliveryDate( @Nullable final LocalDateTime deliveryDate )
    {
        rememberChangedField("DeliveryDate", this.deliveryDate);
        this.deliveryDate = deliveryDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentBySupplier</b>
     * </p>
     *
     * @param deliveryDocumentBySupplier
     *            Ext. Delivery
     */
    public void setDeliveryDocumentBySupplier( @Nullable final String deliveryDocumentBySupplier )
    {
        rememberChangedField("DeliveryDocumentBySupplier", this.deliveryDocumentBySupplier);
        this.deliveryDocumentBySupplier = deliveryDocumentBySupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentType</b>
     * </p>
     *
     * @param deliveryDocumentType
     *            Delivery Type
     */
    public void setDeliveryDocumentType( @Nullable final String deliveryDocumentType )
    {
        rememberChangedField("DeliveryDocumentType", this.deliveryDocumentType);
        this.deliveryDocumentType = deliveryDocumentType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryIsInPlant</b>
     * </p>
     *
     * @param deliveryIsInPlant
     *            In Plant
     */
    public void setDeliveryIsInPlant( @Nullable final Boolean deliveryIsInPlant )
    {
        rememberChangedField("DeliveryIsInPlant", this.deliveryIsInPlant);
        this.deliveryIsInPlant = deliveryIsInPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Prior.
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryTime</b>
     * </p>
     *
     * @param deliveryTime
     *            TimeOfDelivery
     */
    public void setDeliveryTime( @Nullable final LocalTime deliveryTime )
    {
        rememberChangedField("DeliveryTime", this.deliveryTime);
        this.deliveryTime = deliveryTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryVersion</b>
     * </p>
     *
     * @param deliveryVersion
     *            DLV.Version
     */
    public void setDeliveryVersion( @Nullable final String deliveryVersion )
    {
        rememberChangedField("DeliveryVersion", this.deliveryVersion);
        this.deliveryVersion = deliveryVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DepreciationPercentage</b>
     * </p>
     *
     * @param depreciationPercentage
     *            Depreciation
     */
    public void setDepreciationPercentage( @Nullable final BigDecimal depreciationPercentage )
    {
        rememberChangedField("DepreciationPercentage", this.depreciationPercentage);
        this.depreciationPercentage = depreciationPercentage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DistrStatusByDecentralizedWrhs</b>
     * </p>
     *
     * @param distrStatusByDecentralizedWrhs
     *            StatDecntrlWhse
     */
    public void setDistrStatusByDecentralizedWrhs( @Nullable final String distrStatusByDecentralizedWrhs )
    {
        rememberChangedField("DistrStatusByDecentralizedWrhs", this.distrStatusByDecentralizedWrhs);
        this.distrStatusByDecentralizedWrhs = distrStatusByDecentralizedWrhs;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Document Date
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExternalIdentificationType</b>
     * </p>
     *
     * @param externalIdentificationType
     *            Type Ext. Ident
     */
    public void setExternalIdentificationType( @Nullable final String externalIdentificationType )
    {
        rememberChangedField("ExternalIdentificationType", this.externalIdentificationType);
        this.externalIdentificationType = externalIdentificationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExternalTransportSystem</b>
     * </p>
     *
     * @param externalTransportSystem
     *            ID Transp.Syst.
     */
    public void setExternalTransportSystem( @Nullable final String externalTransportSystem )
    {
        rememberChangedField("ExternalTransportSystem", this.externalTransportSystem);
        this.externalTransportSystem = externalTransportSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendarByCustomer</b>
     * </p>
     *
     * @param factoryCalendarByCustomer
     *            FactoryCalendar
     */
    public void setFactoryCalendarByCustomer( @Nullable final String factoryCalendarByCustomer )
    {
        rememberChangedField("FactoryCalendarByCustomer", this.factoryCalendarByCustomer);
        this.factoryCalendarByCustomer = factoryCalendarByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueOrReceiptSlipNumber</b>
     * </p>
     *
     * @param goodsIssueOrReceiptSlipNumber
     *            GR/GI Slip No.
     */
    public void setGoodsIssueOrReceiptSlipNumber( @Nullable final String goodsIssueOrReceiptSlipNumber )
    {
        rememberChangedField("GoodsIssueOrReceiptSlipNumber", this.goodsIssueOrReceiptSlipNumber);
        this.goodsIssueOrReceiptSlipNumber = goodsIssueOrReceiptSlipNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueTime</b>
     * </p>
     *
     * @param goodsIssueTime
     *            GI Time
     */
    public void setGoodsIssueTime( @Nullable final LocalTime goodsIssueTime )
    {
        rememberChangedField("GoodsIssueTime", this.goodsIssueTime);
        this.goodsIssueTime = goodsIssueTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInStock</b>
     * </p>
     *
     * @param handlingUnitInStock
     *            HU in Stock
     */
    public void setHandlingUnitInStock( @Nullable final String handlingUnitInStock )
    {
        rememberChangedField("HandlingUnitInStock", this.handlingUnitInStock);
        this.handlingUnitInStock = handlingUnitInStock;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HdrGeneralIncompletionStatus</b>
     * </p>
     *
     * @param hdrGeneralIncompletionStatus
     *            Header Data
     */
    public void setHdrGeneralIncompletionStatus( @Nullable final String hdrGeneralIncompletionStatus )
    {
        rememberChangedField("HdrGeneralIncompletionStatus", this.hdrGeneralIncompletionStatus);
        this.hdrGeneralIncompletionStatus = hdrGeneralIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HdrGoodsMvtIncompletionStatus</b>
     * </p>
     *
     * @param hdrGoodsMvtIncompletionStatus
     *            Head. Data GM
     */
    public void setHdrGoodsMvtIncompletionStatus( @Nullable final String hdrGoodsMvtIncompletionStatus )
    {
        rememberChangedField("HdrGoodsMvtIncompletionStatus", this.hdrGoodsMvtIncompletionStatus);
        this.hdrGoodsMvtIncompletionStatus = hdrGoodsMvtIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillgIncompletionStatus</b>
     * </p>
     *
     * @param headerBillgIncompletionStatus
     *            Header Bill.Dat
     */
    public void setHeaderBillgIncompletionStatus( @Nullable final String headerBillgIncompletionStatus )
    {
        rememberChangedField("HeaderBillgIncompletionStatus", this.headerBillgIncompletionStatus);
        this.headerBillgIncompletionStatus = headerBillgIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @param headerBillingBlockReason
     *            Billing Block
     */
    public void setHeaderBillingBlockReason( @Nullable final String headerBillingBlockReason )
    {
        rememberChangedField("HeaderBillingBlockReason", this.headerBillingBlockReason);
        this.headerBillingBlockReason = headerBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderDelivIncompletionStatus</b>
     * </p>
     *
     * @param headerDelivIncompletionStatus
     *            Header Dlv.Data
     */
    public void setHeaderDelivIncompletionStatus( @Nullable final String headerDelivIncompletionStatus )
    {
        rememberChangedField("HeaderDelivIncompletionStatus", this.headerDelivIncompletionStatus);
        this.headerDelivIncompletionStatus = headerDelivIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderGrossWeight</b>
     * </p>
     *
     * @param headerGrossWeight
     *            Total Weight
     */
    public void setHeaderGrossWeight( @Nullable final BigDecimal headerGrossWeight )
    {
        rememberChangedField("HeaderGrossWeight", this.headerGrossWeight);
        this.headerGrossWeight = headerGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderNetWeight</b>
     * </p>
     *
     * @param headerNetWeight
     *            Net Weight
     */
    public void setHeaderNetWeight( @Nullable final BigDecimal headerNetWeight )
    {
        rememberChangedField("HeaderNetWeight", this.headerNetWeight);
        this.headerNetWeight = headerNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderPackingIncompletionSts</b>
     * </p>
     *
     * @param headerPackingIncompletionSts
     *            Head.Data Pckg.
     */
    public void setHeaderPackingIncompletionSts( @Nullable final String headerPackingIncompletionSts )
    {
        rememberChangedField("HeaderPackingIncompletionSts", this.headerPackingIncompletionSts);
        this.headerPackingIncompletionSts = headerPackingIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HeaderPickgIncompletionStatus</b>
     * </p>
     *
     * @param headerPickgIncompletionStatus
     *            Head.Data Pck/Putawy
     */
    public void setHeaderPickgIncompletionStatus( @Nullable final String headerPickgIncompletionStatus )
    {
        rememberChangedField("HeaderPickgIncompletionStatus", this.headerPickgIncompletionStatus);
        this.headerPickgIncompletionStatus = headerPickgIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderVolume</b>
     * </p>
     *
     * @param headerVolume
     *            Volume
     */
    public void setHeaderVolume( @Nullable final BigDecimal headerVolume )
    {
        rememberChangedField("HeaderVolume", this.headerVolume);
        this.headerVolume = headerVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderVolumeUnit</b>
     * </p>
     *
     * @param headerVolumeUnit
     *            Volume Unit
     */
    public void setHeaderVolumeUnit( @Nullable final String headerVolumeUnit )
    {
        rememberChangedField("HeaderVolumeUnit", this.headerVolumeUnit);
        this.headerVolumeUnit = headerVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderWeightUnit</b>
     * </p>
     *
     * @param headerWeightUnit
     *            Unit of Weight
     */
    public void setHeaderWeightUnit( @Nullable final String headerWeightUnit )
    {
        rememberChangedField("HeaderWeightUnit", this.headerWeightUnit);
        this.headerWeightUnit = headerWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms 2
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyBillingDate</b>
     * </p>
     *
     * @param intercompanyBillingDate
     *            Intco Bill Date
     */
    public void setIntercompanyBillingDate( @Nullable final LocalDateTime intercompanyBillingDate )
    {
        rememberChangedField("IntercompanyBillingDate", this.intercompanyBillingDate);
        this.intercompanyBillingDate = intercompanyBillingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalFinancialDocument</b>
     * </p>
     *
     * @param internalFinancialDocument
     *            Financ.Doc.No.
     */
    public void setInternalFinancialDocument( @Nullable final String internalFinancialDocument )
    {
        rememberChangedField("InternalFinancialDocument", this.internalFinancialDocument);
        this.internalFinancialDocument = internalFinancialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeliveryForSingleWarehouse</b>
     * </p>
     *
     * @param isDeliveryForSingleWarehouse
     *            ID: Delivery Split
     */
    public void setIsDeliveryForSingleWarehouse( @Nullable final String isDeliveryForSingleWarehouse )
    {
        rememberChangedField("IsDeliveryForSingleWarehouse", this.isDeliveryForSingleWarehouse);
        this.isDeliveryForSingleWarehouse = isDeliveryForSingleWarehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsExportDelivery</b>
     * </p>
     *
     * @param isExportDelivery
     *            Export
     */
    public void setIsExportDelivery( @Nullable final String isExportDelivery )
    {
        rememberChangedField("IsExportDelivery", this.isExportDelivery);
        this.isExportDelivery = isExportDelivery;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LoadingDate</b>
     * </p>
     *
     * @param loadingDate
     *            Loading Date
     */
    public void setLoadingDate( @Nullable final LocalDateTime loadingDate )
    {
        rememberChangedField("LoadingDate", this.loadingDate);
        this.loadingDate = loadingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LoadingPoint</b>
     * </p>
     *
     * @param loadingPoint
     *            Loading Point
     */
    public void setLoadingPoint( @Nullable final String loadingPoint )
    {
        rememberChangedField("LoadingPoint", this.loadingPoint);
        this.loadingPoint = loadingPoint;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LoadingTime</b>
     * </p>
     *
     * @param loadingTime
     *            Loading Time
     */
    public void setLoadingTime( @Nullable final LocalTime loadingTime )
    {
        rememberChangedField("LoadingTime", this.loadingTime);
        this.loadingTime = loadingTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransport</b>
     * </p>
     *
     * @param meansOfTransport
     *            Mns of Trans.ID
     */
    public void setMeansOfTransport( @Nullable final String meansOfTransport )
    {
        rememberChangedField("MeansOfTransport", this.meansOfTransport);
        this.meansOfTransport = meansOfTransport;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransportRefMaterial</b>
     * </p>
     *
     * @param meansOfTransportRefMaterial
     *            MeansTransp.
     */
    public void setMeansOfTransportRefMaterial( @Nullable final String meansOfTransportRefMaterial )
    {
        rememberChangedField("MeansOfTransportRefMaterial", this.meansOfTransportRefMaterial);
        this.meansOfTransportRefMaterial = meansOfTransportRefMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransportType</b>
     * </p>
     *
     * @param meansOfTransportType
     *            MnsOfTrns Type
     */
    public void setMeansOfTransportType( @Nullable final String meansOfTransportType )
    {
        rememberChangedField("MeansOfTransportType", this.meansOfTransportType);
        this.meansOfTransportType = meansOfTransportType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderCombinationIsAllowed</b>
     * </p>
     *
     * @param orderCombinationIsAllowed
     *            Order Combinat.
     */
    public void setOrderCombinationIsAllowed( @Nullable final Boolean orderCombinationIsAllowed )
    {
        rememberChangedField("OrderCombinationIsAllowed", this.orderCombinationIsAllowed);
        this.orderCombinationIsAllowed = orderCombinationIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallDelivConfStatus</b>
     * </p>
     *
     * @param overallDelivConfStatus
     *            Confirmed
     */
    public void setOverallDelivConfStatus( @Nullable final String overallDelivConfStatus )
    {
        rememberChangedField("OverallDelivConfStatus", this.overallDelivConfStatus);
        this.overallDelivConfStatus = overallDelivConfStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallDelivReltdBillgStatus</b>
     * </p>
     *
     * @param overallDelivReltdBillgStatus
     *            Billing Status
     */
    public void setOverallDelivReltdBillgStatus( @Nullable final String overallDelivReltdBillgStatus )
    {
        rememberChangedField("OverallDelivReltdBillgStatus", this.overallDelivReltdBillgStatus);
        this.overallDelivReltdBillgStatus = overallDelivReltdBillgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallGoodsMovementStatus</b>
     * </p>
     *
     * @param overallGoodsMovementStatus
     *            TotalGdsMvtStat
     */
    public void setOverallGoodsMovementStatus( @Nullable final String overallGoodsMovementStatus )
    {
        rememberChangedField("OverallGoodsMovementStatus", this.overallGoodsMovementStatus);
        this.overallGoodsMovementStatus = overallGoodsMovementStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallIntcoBillingStatus</b>
     * </p>
     *
     * @param overallIntcoBillingStatus
     *            Totals Status
     */
    public void setOverallIntcoBillingStatus( @Nullable final String overallIntcoBillingStatus )
    {
        rememberChangedField("OverallIntcoBillingStatus", this.overallIntcoBillingStatus);
        this.overallIntcoBillingStatus = overallIntcoBillingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPackingStatus</b>
     * </p>
     *
     * @param overallPackingStatus
     *            Packing Status
     */
    public void setOverallPackingStatus( @Nullable final String overallPackingStatus )
    {
        rememberChangedField("OverallPackingStatus", this.overallPackingStatus);
        this.overallPackingStatus = overallPackingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPickingConfStatus</b>
     * </p>
     *
     * @param overallPickingConfStatus
     *            Confirmation
     */
    public void setOverallPickingConfStatus( @Nullable final String overallPickingConfStatus )
    {
        rememberChangedField("OverallPickingConfStatus", this.overallPickingConfStatus);
        this.overallPickingConfStatus = overallPickingConfStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallPickingStatus</b>
     * </p>
     *
     * @param overallPickingStatus
     *            Ovr.Pick.Status
     */
    public void setOverallPickingStatus( @Nullable final String overallPickingStatus )
    {
        rememberChangedField("OverallPickingStatus", this.overallPickingStatus);
        this.overallPickingStatus = overallPickingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallProofOfDeliveryStatus</b>
     * </p>
     *
     * @param overallProofOfDeliveryStatus
     *            POD Status
     */
    public void setOverallProofOfDeliveryStatus( @Nullable final String overallProofOfDeliveryStatus )
    {
        rememberChangedField("OverallProofOfDeliveryStatus", this.overallProofOfDeliveryStatus);
        this.overallProofOfDeliveryStatus = overallProofOfDeliveryStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Status
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallWarehouseActivityStatus</b>
     * </p>
     *
     * @param overallWarehouseActivityStatus
     *            OverallWMStatus
     */
    public void setOverallWarehouseActivityStatus( @Nullable final String overallWarehouseActivityStatus )
    {
        rememberChangedField("OverallWarehouseActivityStatus", this.overallWarehouseActivityStatus);
        this.overallWarehouseActivityStatus = overallWarehouseActivityStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmDelivIncompletionSts</b>
     * </p>
     *
     * @param ovrlItmDelivIncompletionSts
     *            Item Deliv.Data
     */
    public void setOvrlItmDelivIncompletionSts( @Nullable final String ovrlItmDelivIncompletionSts )
    {
        rememberChangedField("OvrlItmDelivIncompletionSts", this.ovrlItmDelivIncompletionSts);
        this.ovrlItmDelivIncompletionSts = ovrlItmDelivIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmGdsMvtIncompletionSts</b>
     * </p>
     *
     * @param ovrlItmGdsMvtIncompletionSts
     *            Item data: GM
     */
    public void setOvrlItmGdsMvtIncompletionSts( @Nullable final String ovrlItmGdsMvtIncompletionSts )
    {
        rememberChangedField("OvrlItmGdsMvtIncompletionSts", this.ovrlItmGdsMvtIncompletionSts);
        this.ovrlItmGdsMvtIncompletionSts = ovrlItmGdsMvtIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmGeneralIncompletionSts</b>
     * </p>
     *
     * @param ovrlItmGeneralIncompletionSts
     *            Item Data
     */
    public void setOvrlItmGeneralIncompletionSts( @Nullable final String ovrlItmGeneralIncompletionSts )
    {
        rememberChangedField("OvrlItmGeneralIncompletionSts", this.ovrlItmGeneralIncompletionSts);
        this.ovrlItmGeneralIncompletionSts = ovrlItmGeneralIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmPackingIncompletionSts</b>
     * </p>
     *
     * @param ovrlItmPackingIncompletionSts
     *            It.Data Packag.
     */
    public void setOvrlItmPackingIncompletionSts( @Nullable final String ovrlItmPackingIncompletionSts )
    {
        rememberChangedField("OvrlItmPackingIncompletionSts", this.ovrlItmPackingIncompletionSts);
        this.ovrlItmPackingIncompletionSts = ovrlItmPackingIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OvrlItmPickingIncompletionSts</b>
     * </p>
     *
     * @param ovrlItmPickingIncompletionSts
     *            It.Data Pck/Putaway
     */
    public void setOvrlItmPickingIncompletionSts( @Nullable final String ovrlItmPickingIncompletionSts )
    {
        rememberChangedField("OvrlItmPickingIncompletionSts", this.ovrlItmPickingIncompletionSts);
        this.ovrlItmPickingIncompletionSts = ovrlItmPickingIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PaymentGuaranteeProcedure</b>
     * </p>
     *
     * @param paymentGuaranteeProcedure
     *            Paym.Guar.Proc.
     */
    public void setPaymentGuaranteeProcedure( @Nullable final String paymentGuaranteeProcedure )
    {
        rememberChangedField("PaymentGuaranteeProcedure", this.paymentGuaranteeProcedure);
        this.paymentGuaranteeProcedure = paymentGuaranteeProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PickedItemsLocation</b>
     * </p>
     *
     * @param pickedItemsLocation
     *            PickedItmLocat.
     */
    public void setPickedItemsLocation( @Nullable final String pickedItemsLocation )
    {
        rememberChangedField("PickedItemsLocation", this.pickedItemsLocation);
        this.pickedItemsLocation = pickedItemsLocation;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PickingDate</b>
     * </p>
     *
     * @param pickingDate
     *            Pick Date
     */
    public void setPickingDate( @Nullable final LocalDateTime pickingDate )
    {
        rememberChangedField("PickingDate", this.pickingDate);
        this.pickingDate = pickingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PickingTime</b>
     * </p>
     *
     * @param pickingTime
     *            Picking Time
     */
    public void setPickingTime( @Nullable final LocalTime pickingTime )
    {
        rememberChangedField("PickingTime", this.pickingTime);
        this.pickingTime = pickingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlannedGoodsIssueDate</b>
     * </p>
     *
     * @param plannedGoodsIssueDate
     *            Planned Gds Mvmt
     */
    public void setPlannedGoodsIssueDate( @Nullable final LocalDateTime plannedGoodsIssueDate )
    {
        rememberChangedField("PlannedGoodsIssueDate", this.plannedGoodsIssueDate);
        this.plannedGoodsIssueDate = plannedGoodsIssueDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProofOfDeliveryDate</b>
     * </p>
     *
     * @param proofOfDeliveryDate
     *            POD Date
     */
    public void setProofOfDeliveryDate( @Nullable final LocalDateTime proofOfDeliveryDate )
    {
        rememberChangedField("ProofOfDeliveryDate", this.proofOfDeliveryDate);
        this.proofOfDeliveryDate = proofOfDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProposedDeliveryRoute</b>
     * </p>
     *
     * @param proposedDeliveryRoute
     *            Route
     */
    public void setProposedDeliveryRoute( @Nullable final String proposedDeliveryRoute )
    {
        rememberChangedField("ProposedDeliveryRoute", this.proposedDeliveryRoute);
        this.proposedDeliveryRoute = proposedDeliveryRoute;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingPlant</b>
     * </p>
     *
     * @param receivingPlant
     *            Receiving Plant
     */
    public void setReceivingPlant( @Nullable final String receivingPlant )
    {
        rememberChangedField("ReceivingPlant", this.receivingPlant);
        this.receivingPlant = receivingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RouteSchedule</b>
     * </p>
     *
     * @param routeSchedule
     *            Route Schedule
     */
    public void setRouteSchedule( @Nullable final String routeSchedule )
    {
        rememberChangedField("RouteSchedule", this.routeSchedule);
        this.routeSchedule = routeSchedule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Org.
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @param sDDocumentCategory
     *            Document Cat.
     */
    public void setSDDocumentCategory( @Nullable final String sDDocumentCategory )
    {
        rememberChangedField("SDDocumentCategory", this.sDDocumentCategory);
        this.sDDocumentCategory = sDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShipmentBlockReason</b>
     * </p>
     *
     * @param shipmentBlockReason
     *            ShpmtBlReason
     */
    public void setShipmentBlockReason( @Nullable final String shipmentBlockReason )
    {
        rememberChangedField("ShipmentBlockReason", this.shipmentBlockReason);
        this.shipmentBlockReason = shipmentBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SpecialProcessingCode</b>
     * </p>
     *
     * @param specialProcessingCode
     *            Spec.Processing
     */
    public void setSpecialProcessingCode( @Nullable final String specialProcessingCode )
    {
        rememberChangedField("SpecialProcessingCode", this.specialProcessingCode);
        this.specialProcessingCode = specialProcessingCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsCurrency</b>
     * </p>
     *
     * @param statisticsCurrency
     *            Stats. Currency
     */
    public void setStatisticsCurrency( @Nullable final String statisticsCurrency )
    {
        rememberChangedField("StatisticsCurrency", this.statisticsCurrency);
        this.statisticsCurrency = statisticsCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalBlockStatus</b>
     * </p>
     *
     * @param totalBlockStatus
     *            Overall Blk St.
     */
    public void setTotalBlockStatus( @Nullable final String totalBlockStatus )
    {
        rememberChangedField("TotalBlockStatus", this.totalBlockStatus);
        this.totalBlockStatus = totalBlockStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @param totalCreditCheckStatus
     *            OverallCredStat
     */
    public void setTotalCreditCheckStatus( @Nullable final String totalCreditCheckStatus )
    {
        rememberChangedField("TotalCreditCheckStatus", this.totalCreditCheckStatus);
        this.totalCreditCheckStatus = totalCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TotalNumberOfPackage</b>
     * </p>
     *
     * @param totalNumberOfPackage
     *            No. of Packages
     */
    public void setTotalNumberOfPackage( @Nullable final String totalNumberOfPackage )
    {
        rememberChangedField("TotalNumberOfPackage", this.totalNumberOfPackage);
        this.totalNumberOfPackage = totalNumberOfPackage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Doc. Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransportationGroup</b>
     * </p>
     *
     * @param transportationGroup
     *            Trans. Group
     */
    public void setTransportationGroup( @Nullable final String transportationGroup )
    {
        rememberChangedField("TransportationGroup", this.transportationGroup);
        this.transportationGroup = transportationGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningDate</b>
     * </p>
     *
     * @param transportationPlanningDate
     *            TranspPlngDate
     */
    public void setTransportationPlanningDate( @Nullable final LocalDateTime transportationPlanningDate )
    {
        rememberChangedField("TransportationPlanningDate", this.transportationPlanningDate);
        this.transportationPlanningDate = transportationPlanningDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningStatus</b>
     * </p>
     *
     * @param transportationPlanningStatus
     *            Trns.Plan.Stat.
     */
    public void setTransportationPlanningStatus( @Nullable final String transportationPlanningStatus )
    {
        rememberChangedField("TransportationPlanningStatus", this.transportationPlanningStatus);
        this.transportationPlanningStatus = transportationPlanningStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningTime</b>
     * </p>
     *
     * @param transportationPlanningTime
     *            Tr. Plan. Time
     */
    public void setTransportationPlanningTime( @Nullable final LocalTime transportationPlanningTime )
    {
        rememberChangedField("TransportationPlanningTime", this.transportationPlanningTime);
        this.transportationPlanningTime = transportationPlanningTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse No.
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseGate</b>
     * </p>
     *
     * @param warehouseGate
     *            Door for Whse
     */
    public void setWarehouseGate( @Nullable final String warehouseGate )
    {
        rememberChangedField("WarehouseGate", this.warehouseGate);
        this.warehouseGate = warehouseGate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStagingArea</b>
     * </p>
     *
     * @param warehouseStagingArea
     *            Staging Area
     */
    public void setWarehouseStagingArea( @Nullable final String warehouseStagingArea )
    {
        rememberChangedField("WarehouseStagingArea", this.warehouseStagingArea);
        this.warehouseStagingArea = warehouseStagingArea;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InbDeliveryHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DeliveryDocument", getDeliveryDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ActualDeliveryRoute", getActualDeliveryRoute());
        values.put("ActualGoodsMovementDate", getActualGoodsMovementDate());
        values.put("ActualGoodsMovementTime", getActualGoodsMovementTime());
        values.put("BillingDocumentDate", getBillingDocumentDate());
        values.put("BillOfLading", getBillOfLading());
        values.put("CompleteDeliveryIsDefined", getCompleteDeliveryIsDefined());
        values.put("ConfirmationTime", getConfirmationTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("DeliveryBlockReason", getDeliveryBlockReason());
        values.put("DeliveryDate", getDeliveryDate());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("DeliveryDocumentBySupplier", getDeliveryDocumentBySupplier());
        values.put("DeliveryDocumentType", getDeliveryDocumentType());
        values.put("DeliveryIsInPlant", getDeliveryIsInPlant());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("DeliveryTime", getDeliveryTime());
        values.put("DeliveryVersion", getDeliveryVersion());
        values.put("DepreciationPercentage", getDepreciationPercentage());
        values.put("DistrStatusByDecentralizedWrhs", getDistrStatusByDecentralizedWrhs());
        values.put("DocumentDate", getDocumentDate());
        values.put("ExternalIdentificationType", getExternalIdentificationType());
        values.put("ExternalTransportSystem", getExternalTransportSystem());
        values.put("FactoryCalendarByCustomer", getFactoryCalendarByCustomer());
        values.put("GoodsIssueOrReceiptSlipNumber", getGoodsIssueOrReceiptSlipNumber());
        values.put("GoodsIssueTime", getGoodsIssueTime());
        values.put("HandlingUnitInStock", getHandlingUnitInStock());
        values.put("HdrGeneralIncompletionStatus", getHdrGeneralIncompletionStatus());
        values.put("HdrGoodsMvtIncompletionStatus", getHdrGoodsMvtIncompletionStatus());
        values.put("HeaderBillgIncompletionStatus", getHeaderBillgIncompletionStatus());
        values.put("HeaderBillingBlockReason", getHeaderBillingBlockReason());
        values.put("HeaderDelivIncompletionStatus", getHeaderDelivIncompletionStatus());
        values.put("HeaderGrossWeight", getHeaderGrossWeight());
        values.put("HeaderNetWeight", getHeaderNetWeight());
        values.put("HeaderPackingIncompletionSts", getHeaderPackingIncompletionSts());
        values.put("HeaderPickgIncompletionStatus", getHeaderPickgIncompletionStatus());
        values.put("HeaderVolume", getHeaderVolume());
        values.put("HeaderVolumeUnit", getHeaderVolumeUnit());
        values.put("HeaderWeightUnit", getHeaderWeightUnit());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IntercompanyBillingDate", getIntercompanyBillingDate());
        values.put("InternalFinancialDocument", getInternalFinancialDocument());
        values.put("IsDeliveryForSingleWarehouse", getIsDeliveryForSingleWarehouse());
        values.put("IsExportDelivery", getIsExportDelivery());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LoadingDate", getLoadingDate());
        values.put("LoadingPoint", getLoadingPoint());
        values.put("LoadingTime", getLoadingTime());
        values.put("MeansOfTransport", getMeansOfTransport());
        values.put("MeansOfTransportRefMaterial", getMeansOfTransportRefMaterial());
        values.put("MeansOfTransportType", getMeansOfTransportType());
        values.put("OrderCombinationIsAllowed", getOrderCombinationIsAllowed());
        values.put("OrderID", getOrderID());
        values.put("OverallDelivConfStatus", getOverallDelivConfStatus());
        values.put("OverallDelivReltdBillgStatus", getOverallDelivReltdBillgStatus());
        values.put("OverallGoodsMovementStatus", getOverallGoodsMovementStatus());
        values.put("OverallIntcoBillingStatus", getOverallIntcoBillingStatus());
        values.put("OverallPackingStatus", getOverallPackingStatus());
        values.put("OverallPickingConfStatus", getOverallPickingConfStatus());
        values.put("OverallPickingStatus", getOverallPickingStatus());
        values.put("OverallProofOfDeliveryStatus", getOverallProofOfDeliveryStatus());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("OverallWarehouseActivityStatus", getOverallWarehouseActivityStatus());
        values.put("OvrlItmDelivIncompletionSts", getOvrlItmDelivIncompletionSts());
        values.put("OvrlItmGdsMvtIncompletionSts", getOvrlItmGdsMvtIncompletionSts());
        values.put("OvrlItmGeneralIncompletionSts", getOvrlItmGeneralIncompletionSts());
        values.put("OvrlItmPackingIncompletionSts", getOvrlItmPackingIncompletionSts());
        values.put("OvrlItmPickingIncompletionSts", getOvrlItmPickingIncompletionSts());
        values.put("PaymentGuaranteeProcedure", getPaymentGuaranteeProcedure());
        values.put("PickedItemsLocation", getPickedItemsLocation());
        values.put("PickingDate", getPickingDate());
        values.put("PickingTime", getPickingTime());
        values.put("PlannedGoodsIssueDate", getPlannedGoodsIssueDate());
        values.put("ProofOfDeliveryDate", getProofOfDeliveryDate());
        values.put("ProposedDeliveryRoute", getProposedDeliveryRoute());
        values.put("ReceivingPlant", getReceivingPlant());
        values.put("RouteSchedule", getRouteSchedule());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SDDocumentCategory", getSDDocumentCategory());
        values.put("ShipmentBlockReason", getShipmentBlockReason());
        values.put("ShippingCondition", getShippingCondition());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ShippingType", getShippingType());
        values.put("ShipToParty", getShipToParty());
        values.put("SoldToParty", getSoldToParty());
        values.put("SpecialProcessingCode", getSpecialProcessingCode());
        values.put("StatisticsCurrency", getStatisticsCurrency());
        values.put("Supplier", getSupplier());
        values.put("TotalBlockStatus", getTotalBlockStatus());
        values.put("TotalCreditCheckStatus", getTotalCreditCheckStatus());
        values.put("TotalNumberOfPackage", getTotalNumberOfPackage());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("TransportationGroup", getTransportationGroup());
        values.put("TransportationPlanningDate", getTransportationPlanningDate());
        values.put("TransportationPlanningStatus", getTransportationPlanningStatus());
        values.put("TransportationPlanningTime", getTransportationPlanningTime());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseGate", getWarehouseGate());
        values.put("WarehouseStagingArea", getWarehouseStagingArea());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ActualDeliveryRoute") ) {
                final Object value = values.remove("ActualDeliveryRoute");
                if( (value == null) || (!value.equals(getActualDeliveryRoute())) ) {
                    setActualDeliveryRoute(((String) value));
                }
            }
            if( values.containsKey("ActualGoodsMovementDate") ) {
                final Object value = values.remove("ActualGoodsMovementDate");
                if( (value == null) || (!value.equals(getActualGoodsMovementDate())) ) {
                    setActualGoodsMovementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualGoodsMovementTime") ) {
                final Object value = values.remove("ActualGoodsMovementTime");
                if( (value == null) || (!value.equals(getActualGoodsMovementTime())) ) {
                    setActualGoodsMovementTime(((LocalTime) value));
                }
            }
            if( values.containsKey("BillingDocumentDate") ) {
                final Object value = values.remove("BillingDocumentDate");
                if( (value == null) || (!value.equals(getBillingDocumentDate())) ) {
                    setBillingDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillOfLading") ) {
                final Object value = values.remove("BillOfLading");
                if( (value == null) || (!value.equals(getBillOfLading())) ) {
                    setBillOfLading(((String) value));
                }
            }
            if( values.containsKey("CompleteDeliveryIsDefined") ) {
                final Object value = values.remove("CompleteDeliveryIsDefined");
                if( (value == null) || (!value.equals(getCompleteDeliveryIsDefined())) ) {
                    setCompleteDeliveryIsDefined(((Boolean) value));
                }
            }
            if( values.containsKey("ConfirmationTime") ) {
                final Object value = values.remove("ConfirmationTime");
                if( (value == null) || (!value.equals(getConfirmationTime())) ) {
                    setConfirmationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("DeliveryBlockReason") ) {
                final Object value = values.remove("DeliveryBlockReason");
                if( (value == null) || (!value.equals(getDeliveryBlockReason())) ) {
                    setDeliveryBlockReason(((String) value));
                }
            }
            if( values.containsKey("DeliveryDate") ) {
                final Object value = values.remove("DeliveryDate");
                if( (value == null) || (!value.equals(getDeliveryDate())) ) {
                    setDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentBySupplier") ) {
                final Object value = values.remove("DeliveryDocumentBySupplier");
                if( (value == null) || (!value.equals(getDeliveryDocumentBySupplier())) ) {
                    setDeliveryDocumentBySupplier(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentType") ) {
                final Object value = values.remove("DeliveryDocumentType");
                if( (value == null) || (!value.equals(getDeliveryDocumentType())) ) {
                    setDeliveryDocumentType(((String) value));
                }
            }
            if( values.containsKey("DeliveryIsInPlant") ) {
                final Object value = values.remove("DeliveryIsInPlant");
                if( (value == null) || (!value.equals(getDeliveryIsInPlant())) ) {
                    setDeliveryIsInPlant(((Boolean) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("DeliveryTime") ) {
                final Object value = values.remove("DeliveryTime");
                if( (value == null) || (!value.equals(getDeliveryTime())) ) {
                    setDeliveryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("DeliveryVersion") ) {
                final Object value = values.remove("DeliveryVersion");
                if( (value == null) || (!value.equals(getDeliveryVersion())) ) {
                    setDeliveryVersion(((String) value));
                }
            }
            if( values.containsKey("DepreciationPercentage") ) {
                final Object value = values.remove("DepreciationPercentage");
                if( (value == null) || (!value.equals(getDepreciationPercentage())) ) {
                    setDepreciationPercentage(((BigDecimal) value));
                }
            }
            if( values.containsKey("DistrStatusByDecentralizedWrhs") ) {
                final Object value = values.remove("DistrStatusByDecentralizedWrhs");
                if( (value == null) || (!value.equals(getDistrStatusByDecentralizedWrhs())) ) {
                    setDistrStatusByDecentralizedWrhs(((String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ExternalIdentificationType") ) {
                final Object value = values.remove("ExternalIdentificationType");
                if( (value == null) || (!value.equals(getExternalIdentificationType())) ) {
                    setExternalIdentificationType(((String) value));
                }
            }
            if( values.containsKey("ExternalTransportSystem") ) {
                final Object value = values.remove("ExternalTransportSystem");
                if( (value == null) || (!value.equals(getExternalTransportSystem())) ) {
                    setExternalTransportSystem(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendarByCustomer") ) {
                final Object value = values.remove("FactoryCalendarByCustomer");
                if( (value == null) || (!value.equals(getFactoryCalendarByCustomer())) ) {
                    setFactoryCalendarByCustomer(((String) value));
                }
            }
            if( values.containsKey("GoodsIssueOrReceiptSlipNumber") ) {
                final Object value = values.remove("GoodsIssueOrReceiptSlipNumber");
                if( (value == null) || (!value.equals(getGoodsIssueOrReceiptSlipNumber())) ) {
                    setGoodsIssueOrReceiptSlipNumber(((String) value));
                }
            }
            if( values.containsKey("GoodsIssueTime") ) {
                final Object value = values.remove("GoodsIssueTime");
                if( (value == null) || (!value.equals(getGoodsIssueTime())) ) {
                    setGoodsIssueTime(((LocalTime) value));
                }
            }
            if( values.containsKey("HandlingUnitInStock") ) {
                final Object value = values.remove("HandlingUnitInStock");
                if( (value == null) || (!value.equals(getHandlingUnitInStock())) ) {
                    setHandlingUnitInStock(((String) value));
                }
            }
            if( values.containsKey("HdrGeneralIncompletionStatus") ) {
                final Object value = values.remove("HdrGeneralIncompletionStatus");
                if( (value == null) || (!value.equals(getHdrGeneralIncompletionStatus())) ) {
                    setHdrGeneralIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("HdrGoodsMvtIncompletionStatus") ) {
                final Object value = values.remove("HdrGoodsMvtIncompletionStatus");
                if( (value == null) || (!value.equals(getHdrGoodsMvtIncompletionStatus())) ) {
                    setHdrGoodsMvtIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("HeaderBillgIncompletionStatus") ) {
                final Object value = values.remove("HeaderBillgIncompletionStatus");
                if( (value == null) || (!value.equals(getHeaderBillgIncompletionStatus())) ) {
                    setHeaderBillgIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("HeaderBillingBlockReason") ) {
                final Object value = values.remove("HeaderBillingBlockReason");
                if( (value == null) || (!value.equals(getHeaderBillingBlockReason())) ) {
                    setHeaderBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("HeaderDelivIncompletionStatus") ) {
                final Object value = values.remove("HeaderDelivIncompletionStatus");
                if( (value == null) || (!value.equals(getHeaderDelivIncompletionStatus())) ) {
                    setHeaderDelivIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("HeaderGrossWeight") ) {
                final Object value = values.remove("HeaderGrossWeight");
                if( (value == null) || (!value.equals(getHeaderGrossWeight())) ) {
                    setHeaderGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HeaderNetWeight") ) {
                final Object value = values.remove("HeaderNetWeight");
                if( (value == null) || (!value.equals(getHeaderNetWeight())) ) {
                    setHeaderNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HeaderPackingIncompletionSts") ) {
                final Object value = values.remove("HeaderPackingIncompletionSts");
                if( (value == null) || (!value.equals(getHeaderPackingIncompletionSts())) ) {
                    setHeaderPackingIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("HeaderPickgIncompletionStatus") ) {
                final Object value = values.remove("HeaderPickgIncompletionStatus");
                if( (value == null) || (!value.equals(getHeaderPickgIncompletionStatus())) ) {
                    setHeaderPickgIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("HeaderVolume") ) {
                final Object value = values.remove("HeaderVolume");
                if( (value == null) || (!value.equals(getHeaderVolume())) ) {
                    setHeaderVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HeaderVolumeUnit") ) {
                final Object value = values.remove("HeaderVolumeUnit");
                if( (value == null) || (!value.equals(getHeaderVolumeUnit())) ) {
                    setHeaderVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("HeaderWeightUnit") ) {
                final Object value = values.remove("HeaderWeightUnit");
                if( (value == null) || (!value.equals(getHeaderWeightUnit())) ) {
                    setHeaderWeightUnit(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IntercompanyBillingDate") ) {
                final Object value = values.remove("IntercompanyBillingDate");
                if( (value == null) || (!value.equals(getIntercompanyBillingDate())) ) {
                    setIntercompanyBillingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InternalFinancialDocument") ) {
                final Object value = values.remove("InternalFinancialDocument");
                if( (value == null) || (!value.equals(getInternalFinancialDocument())) ) {
                    setInternalFinancialDocument(((String) value));
                }
            }
            if( values.containsKey("IsDeliveryForSingleWarehouse") ) {
                final Object value = values.remove("IsDeliveryForSingleWarehouse");
                if( (value == null) || (!value.equals(getIsDeliveryForSingleWarehouse())) ) {
                    setIsDeliveryForSingleWarehouse(((String) value));
                }
            }
            if( values.containsKey("IsExportDelivery") ) {
                final Object value = values.remove("IsExportDelivery");
                if( (value == null) || (!value.equals(getIsExportDelivery())) ) {
                    setIsExportDelivery(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LoadingDate") ) {
                final Object value = values.remove("LoadingDate");
                if( (value == null) || (!value.equals(getLoadingDate())) ) {
                    setLoadingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LoadingPoint") ) {
                final Object value = values.remove("LoadingPoint");
                if( (value == null) || (!value.equals(getLoadingPoint())) ) {
                    setLoadingPoint(((String) value));
                }
            }
            if( values.containsKey("LoadingTime") ) {
                final Object value = values.remove("LoadingTime");
                if( (value == null) || (!value.equals(getLoadingTime())) ) {
                    setLoadingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MeansOfTransport") ) {
                final Object value = values.remove("MeansOfTransport");
                if( (value == null) || (!value.equals(getMeansOfTransport())) ) {
                    setMeansOfTransport(((String) value));
                }
            }
            if( values.containsKey("MeansOfTransportRefMaterial") ) {
                final Object value = values.remove("MeansOfTransportRefMaterial");
                if( (value == null) || (!value.equals(getMeansOfTransportRefMaterial())) ) {
                    setMeansOfTransportRefMaterial(((String) value));
                }
            }
            if( values.containsKey("MeansOfTransportType") ) {
                final Object value = values.remove("MeansOfTransportType");
                if( (value == null) || (!value.equals(getMeansOfTransportType())) ) {
                    setMeansOfTransportType(((String) value));
                }
            }
            if( values.containsKey("OrderCombinationIsAllowed") ) {
                final Object value = values.remove("OrderCombinationIsAllowed");
                if( (value == null) || (!value.equals(getOrderCombinationIsAllowed())) ) {
                    setOrderCombinationIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OverallDelivConfStatus") ) {
                final Object value = values.remove("OverallDelivConfStatus");
                if( (value == null) || (!value.equals(getOverallDelivConfStatus())) ) {
                    setOverallDelivConfStatus(((String) value));
                }
            }
            if( values.containsKey("OverallDelivReltdBillgStatus") ) {
                final Object value = values.remove("OverallDelivReltdBillgStatus");
                if( (value == null) || (!value.equals(getOverallDelivReltdBillgStatus())) ) {
                    setOverallDelivReltdBillgStatus(((String) value));
                }
            }
            if( values.containsKey("OverallGoodsMovementStatus") ) {
                final Object value = values.remove("OverallGoodsMovementStatus");
                if( (value == null) || (!value.equals(getOverallGoodsMovementStatus())) ) {
                    setOverallGoodsMovementStatus(((String) value));
                }
            }
            if( values.containsKey("OverallIntcoBillingStatus") ) {
                final Object value = values.remove("OverallIntcoBillingStatus");
                if( (value == null) || (!value.equals(getOverallIntcoBillingStatus())) ) {
                    setOverallIntcoBillingStatus(((String) value));
                }
            }
            if( values.containsKey("OverallPackingStatus") ) {
                final Object value = values.remove("OverallPackingStatus");
                if( (value == null) || (!value.equals(getOverallPackingStatus())) ) {
                    setOverallPackingStatus(((String) value));
                }
            }
            if( values.containsKey("OverallPickingConfStatus") ) {
                final Object value = values.remove("OverallPickingConfStatus");
                if( (value == null) || (!value.equals(getOverallPickingConfStatus())) ) {
                    setOverallPickingConfStatus(((String) value));
                }
            }
            if( values.containsKey("OverallPickingStatus") ) {
                final Object value = values.remove("OverallPickingStatus");
                if( (value == null) || (!value.equals(getOverallPickingStatus())) ) {
                    setOverallPickingStatus(((String) value));
                }
            }
            if( values.containsKey("OverallProofOfDeliveryStatus") ) {
                final Object value = values.remove("OverallProofOfDeliveryStatus");
                if( (value == null) || (!value.equals(getOverallProofOfDeliveryStatus())) ) {
                    setOverallProofOfDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("OverallWarehouseActivityStatus") ) {
                final Object value = values.remove("OverallWarehouseActivityStatus");
                if( (value == null) || (!value.equals(getOverallWarehouseActivityStatus())) ) {
                    setOverallWarehouseActivityStatus(((String) value));
                }
            }
            if( values.containsKey("OvrlItmDelivIncompletionSts") ) {
                final Object value = values.remove("OvrlItmDelivIncompletionSts");
                if( (value == null) || (!value.equals(getOvrlItmDelivIncompletionSts())) ) {
                    setOvrlItmDelivIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("OvrlItmGdsMvtIncompletionSts") ) {
                final Object value = values.remove("OvrlItmGdsMvtIncompletionSts");
                if( (value == null) || (!value.equals(getOvrlItmGdsMvtIncompletionSts())) ) {
                    setOvrlItmGdsMvtIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("OvrlItmGeneralIncompletionSts") ) {
                final Object value = values.remove("OvrlItmGeneralIncompletionSts");
                if( (value == null) || (!value.equals(getOvrlItmGeneralIncompletionSts())) ) {
                    setOvrlItmGeneralIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("OvrlItmPackingIncompletionSts") ) {
                final Object value = values.remove("OvrlItmPackingIncompletionSts");
                if( (value == null) || (!value.equals(getOvrlItmPackingIncompletionSts())) ) {
                    setOvrlItmPackingIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("OvrlItmPickingIncompletionSts") ) {
                final Object value = values.remove("OvrlItmPickingIncompletionSts");
                if( (value == null) || (!value.equals(getOvrlItmPickingIncompletionSts())) ) {
                    setOvrlItmPickingIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("PaymentGuaranteeProcedure") ) {
                final Object value = values.remove("PaymentGuaranteeProcedure");
                if( (value == null) || (!value.equals(getPaymentGuaranteeProcedure())) ) {
                    setPaymentGuaranteeProcedure(((String) value));
                }
            }
            if( values.containsKey("PickedItemsLocation") ) {
                final Object value = values.remove("PickedItemsLocation");
                if( (value == null) || (!value.equals(getPickedItemsLocation())) ) {
                    setPickedItemsLocation(((String) value));
                }
            }
            if( values.containsKey("PickingDate") ) {
                final Object value = values.remove("PickingDate");
                if( (value == null) || (!value.equals(getPickingDate())) ) {
                    setPickingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PickingTime") ) {
                final Object value = values.remove("PickingTime");
                if( (value == null) || (!value.equals(getPickingTime())) ) {
                    setPickingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PlannedGoodsIssueDate") ) {
                final Object value = values.remove("PlannedGoodsIssueDate");
                if( (value == null) || (!value.equals(getPlannedGoodsIssueDate())) ) {
                    setPlannedGoodsIssueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProofOfDeliveryDate") ) {
                final Object value = values.remove("ProofOfDeliveryDate");
                if( (value == null) || (!value.equals(getProofOfDeliveryDate())) ) {
                    setProofOfDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposedDeliveryRoute") ) {
                final Object value = values.remove("ProposedDeliveryRoute");
                if( (value == null) || (!value.equals(getProposedDeliveryRoute())) ) {
                    setProposedDeliveryRoute(((String) value));
                }
            }
            if( values.containsKey("ReceivingPlant") ) {
                final Object value = values.remove("ReceivingPlant");
                if( (value == null) || (!value.equals(getReceivingPlant())) ) {
                    setReceivingPlant(((String) value));
                }
            }
            if( values.containsKey("RouteSchedule") ) {
                final Object value = values.remove("RouteSchedule");
                if( (value == null) || (!value.equals(getRouteSchedule())) ) {
                    setRouteSchedule(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SDDocumentCategory") ) {
                final Object value = values.remove("SDDocumentCategory");
                if( (value == null) || (!value.equals(getSDDocumentCategory())) ) {
                    setSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ShipmentBlockReason") ) {
                final Object value = values.remove("ShipmentBlockReason");
                if( (value == null) || (!value.equals(getShipmentBlockReason())) ) {
                    setShipmentBlockReason(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("SpecialProcessingCode") ) {
                final Object value = values.remove("SpecialProcessingCode");
                if( (value == null) || (!value.equals(getSpecialProcessingCode())) ) {
                    setSpecialProcessingCode(((String) value));
                }
            }
            if( values.containsKey("StatisticsCurrency") ) {
                final Object value = values.remove("StatisticsCurrency");
                if( (value == null) || (!value.equals(getStatisticsCurrency())) ) {
                    setStatisticsCurrency(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("TotalBlockStatus") ) {
                final Object value = values.remove("TotalBlockStatus");
                if( (value == null) || (!value.equals(getTotalBlockStatus())) ) {
                    setTotalBlockStatus(((String) value));
                }
            }
            if( values.containsKey("TotalCreditCheckStatus") ) {
                final Object value = values.remove("TotalCreditCheckStatus");
                if( (value == null) || (!value.equals(getTotalCreditCheckStatus())) ) {
                    setTotalCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("TotalNumberOfPackage") ) {
                final Object value = values.remove("TotalNumberOfPackage");
                if( (value == null) || (!value.equals(getTotalNumberOfPackage())) ) {
                    setTotalNumberOfPackage(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("TransportationGroup") ) {
                final Object value = values.remove("TransportationGroup");
                if( (value == null) || (!value.equals(getTransportationGroup())) ) {
                    setTransportationGroup(((String) value));
                }
            }
            if( values.containsKey("TransportationPlanningDate") ) {
                final Object value = values.remove("TransportationPlanningDate");
                if( (value == null) || (!value.equals(getTransportationPlanningDate())) ) {
                    setTransportationPlanningDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TransportationPlanningStatus") ) {
                final Object value = values.remove("TransportationPlanningStatus");
                if( (value == null) || (!value.equals(getTransportationPlanningStatus())) ) {
                    setTransportationPlanningStatus(((String) value));
                }
            }
            if( values.containsKey("TransportationPlanningTime") ) {
                final Object value = values.remove("TransportationPlanningTime");
                if( (value == null) || (!value.equals(getTransportationPlanningTime())) ) {
                    setTransportationPlanningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseGate") ) {
                final Object value = values.remove("WarehouseGate");
                if( (value == null) || (!value.equals(getWarehouseGate())) ) {
                    setWarehouseGate(((String) value));
                }
            }
            if( values.containsKey("WarehouseStagingArea") ) {
                final Object value = values.remove("WarehouseStagingArea");
                if( (value == null) || (!value.equals(getWarehouseStagingArea())) ) {
                    setWarehouseStagingArea(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_DeliveryDocumentItem") ) {
                final Object value = (values).remove("to_DeliveryDocumentItem");
                if( value instanceof Iterable ) {
                    if( toDeliveryDocumentItem == null ) {
                        toDeliveryDocumentItem = Lists.newArrayList();
                    } else {
                        toDeliveryDocumentItem = Lists.newArrayList(toDeliveryDocumentItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InbDeliveryItem entity;
                        if( toDeliveryDocumentItem.size() > i ) {
                            entity = toDeliveryDocumentItem.get(i);
                        } else {
                            entity = new InbDeliveryItem();
                            toDeliveryDocumentItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_DeliveryDocumentPartner") ) {
                final Object value = (values).remove("to_DeliveryDocumentPartner");
                if( value instanceof Iterable ) {
                    if( toDeliveryDocumentPartner == null ) {
                        toDeliveryDocumentPartner = Lists.newArrayList();
                    } else {
                        toDeliveryDocumentPartner = Lists.newArrayList(toDeliveryDocumentPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InbDeliveryPartner entity;
                        if( toDeliveryDocumentPartner.size() > i ) {
                            entity = toDeliveryDocumentPartner.get(i);
                        } else {
                            entity = new InbDeliveryPartner();
                            toDeliveryDocumentPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InbDeliveryHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InbDeliveryHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InbDeliveryHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InbDeliveryHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDeliveryDocumentItem != null ) {
            (values).put("to_DeliveryDocumentItem", toDeliveryDocumentItem);
        }
        if( toDeliveryDocumentPartner != null ) {
            (values).put("to_DeliveryDocumentPartner", toDeliveryDocumentPartner);
        }
        return values;
    }

    /**
     * Fetches the <b>InbDeliveryItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DeliveryDocumentItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InbDeliveryItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InbDeliveryItem> fetchDeliveryDocumentItem()
    {
        return fetchFieldAsList("to_DeliveryDocumentItem", InbDeliveryItem.class);
    }

    /**
     * Retrieval of associated <b>InbDeliveryItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_DeliveryDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_DeliveryDocumentItem</b> of a queried <b>InbDeliveryHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InbDeliveryItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InbDeliveryItem> getDeliveryDocumentItemOrFetch()
    {
        if( toDeliveryDocumentItem == null ) {
            toDeliveryDocumentItem = fetchDeliveryDocumentItem();
        }
        return toDeliveryDocumentItem;
    }

    /**
     * Retrieval of associated <b>InbDeliveryItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_DeliveryDocumentItem</b>.
     * <p>
     * If the navigation property for an entity <b>InbDeliveryHeader</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DeliveryDocumentItem</b> is already loaded, the result
     *         will contain the <b>InbDeliveryItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InbDeliveryItem>> getDeliveryDocumentItemIfPresent()
    {
        return Option.of(toDeliveryDocumentItem);
    }

    /**
     * Overwrites the list of associated <b>InbDeliveryItem</b> entities for the loaded navigation property
     * <b>to_DeliveryDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_DeliveryDocumentItem</b> of a queried <b>InbDeliveryHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InbDeliveryItem</b> entities.
     */
    public void setDeliveryDocumentItem( @Nonnull final List<InbDeliveryItem> value )
    {
        if( toDeliveryDocumentItem == null ) {
            toDeliveryDocumentItem = Lists.newArrayList();
        }
        toDeliveryDocumentItem.clear();
        toDeliveryDocumentItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InbDeliveryItem</b> entities. This corresponds to the OData navigation
     * property <b>to_DeliveryDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_DeliveryDocumentItem</b> of a queried <b>InbDeliveryHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InbDeliveryItem</b> entities.
     */
    public void addDeliveryDocumentItem( InbDeliveryItem... entity )
    {
        if( toDeliveryDocumentItem == null ) {
            toDeliveryDocumentItem = Lists.newArrayList();
        }
        toDeliveryDocumentItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>InbDeliveryPartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DeliveryDocumentPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InbDeliveryPartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InbDeliveryPartner> fetchDeliveryDocumentPartner()
    {
        return fetchFieldAsList("to_DeliveryDocumentPartner", InbDeliveryPartner.class);
    }

    /**
     * Retrieval of associated <b>InbDeliveryPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DeliveryDocumentPartner</b>.
     * <p>
     * If the navigation property <b>to_DeliveryDocumentPartner</b> of a queried <b>InbDeliveryHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InbDeliveryPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InbDeliveryPartner> getDeliveryDocumentPartnerOrFetch()
    {
        if( toDeliveryDocumentPartner == null ) {
            toDeliveryDocumentPartner = fetchDeliveryDocumentPartner();
        }
        return toDeliveryDocumentPartner;
    }

    /**
     * Retrieval of associated <b>InbDeliveryPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DeliveryDocumentPartner</b>.
     * <p>
     * If the navigation property for an entity <b>InbDeliveryHeader</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DeliveryDocumentPartner</b> is already loaded, the
     *         result will contain the <b>InbDeliveryPartner</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InbDeliveryPartner>> getDeliveryDocumentPartnerIfPresent()
    {
        return Option.of(toDeliveryDocumentPartner);
    }

    /**
     * Overwrites the list of associated <b>InbDeliveryPartner</b> entities for the loaded navigation property
     * <b>to_DeliveryDocumentPartner</b>.
     * <p>
     * If the navigation property <b>to_DeliveryDocumentPartner</b> of a queried <b>InbDeliveryHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InbDeliveryPartner</b> entities.
     */
    public void setDeliveryDocumentPartner( @Nonnull final List<InbDeliveryPartner> value )
    {
        if( toDeliveryDocumentPartner == null ) {
            toDeliveryDocumentPartner = Lists.newArrayList();
        }
        toDeliveryDocumentPartner.clear();
        toDeliveryDocumentPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InbDeliveryPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_DeliveryDocumentPartner</b>.
     * <p>
     * If the navigation property <b>to_DeliveryDocumentPartner</b> of a queried <b>InbDeliveryHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InbDeliveryPartner</b> entities.
     */
    public void addDeliveryDocumentPartner( InbDeliveryPartner... entity )
    {
        if( toDeliveryDocumentPartner == null ) {
            toDeliveryDocumentPartner = Lists.newArrayList();
        }
        toDeliveryDocumentPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of InbDeliveryHeader instances.
     *
     */
    public final static class InbDeliveryHeaderBuilder
    {

        private List<InbDeliveryItem> toDeliveryDocumentItem = Lists.newArrayList();
        private List<InbDeliveryPartner> toDeliveryDocumentPartner = Lists.newArrayList();

        private InbDeliveryHeader.InbDeliveryHeaderBuilder toDeliveryDocumentItem( final List<InbDeliveryItem> value )
        {
            toDeliveryDocumentItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_DeliveryDocumentItem</b> for <b>InbDeliveryHeader</b> to multiple
         * <b>InbDeliveryItem</b>.
         *
         * @param value
         *            The InbDeliveryItems to build this InbDeliveryHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InbDeliveryHeader.InbDeliveryHeaderBuilder deliveryDocumentItem( InbDeliveryItem... value )
        {
            return toDeliveryDocumentItem(Lists.newArrayList(value));
        }

        private InbDeliveryHeader.InbDeliveryHeaderBuilder toDeliveryDocumentPartner(
            final List<InbDeliveryPartner> value )
        {
            toDeliveryDocumentPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_DeliveryDocumentPartner</b> for <b>InbDeliveryHeader</b> to multiple
         * <b>InbDeliveryPartner</b>.
         *
         * @param value
         *            The InbDeliveryPartners to build this InbDeliveryHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InbDeliveryHeader.InbDeliveryHeaderBuilder deliveryDocumentPartner( InbDeliveryPartner... value )
        {
            return toDeliveryDocumentPartner(Lists.newArrayList(value));
        }

    }

}
