/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.field.InbDeliveryItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.link.InbDeliveryItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.link.InbDeliveryItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.selectable.InbDeliveryItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_InbDeliveryItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InbDeliveryItem extends VdmEntity<InbDeliveryItem>
{

    /**
     * Selector for all available fields of InbDeliveryItem.
     *
     */
    public final static InbDeliveryItemSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveredQtyInBaseUnit</b>
     * </p>
     *
     * @return Qty (stckp.unt)
     */
    @SerializedName( "ActualDeliveredQtyInBaseUnit" )
    @JsonProperty( "ActualDeliveredQtyInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ActualDeliveredQtyInBaseUnit" )
    private BigDecimal actualDeliveredQtyInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualDeliveredQtyInBaseUnit</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> ACTUAL_DELIVERED_QTY_IN_BASE_UNIT =
        new InbDeliveryItemField<BigDecimal>("ActualDeliveredQtyInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveryQuantity</b>
     * </p>
     *
     * @return Delivery Qty
     */
    @SerializedName( "ActualDeliveryQuantity" )
    @JsonProperty( "ActualDeliveryQuantity" )
    @Nullable
    @ODataField( odataName = "ActualDeliveryQuantity" )
    private BigDecimal actualDeliveryQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ActualDeliveryQuantity</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> ACTUAL_DELIVERY_QUANTITY =
        new InbDeliveryItemField<BigDecimal>("ActualDeliveryQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @return Customer Grp 1
     */
    @SerializedName( "AdditionalCustomerGroup1" )
    @JsonProperty( "AdditionalCustomerGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup1" )
    private String additionalCustomerGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup1</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_CUSTOMER_GROUP1 =
        new InbDeliveryItemField<String>("AdditionalCustomerGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @return Customer Grp 2
     */
    @SerializedName( "AdditionalCustomerGroup2" )
    @JsonProperty( "AdditionalCustomerGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup2" )
    private String additionalCustomerGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup2</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_CUSTOMER_GROUP2 =
        new InbDeliveryItemField<String>("AdditionalCustomerGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @return Customer Grp 3
     */
    @SerializedName( "AdditionalCustomerGroup3" )
    @JsonProperty( "AdditionalCustomerGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup3" )
    private String additionalCustomerGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup3</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_CUSTOMER_GROUP3 =
        new InbDeliveryItemField<String>("AdditionalCustomerGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @return Customer Grp 4
     */
    @SerializedName( "AdditionalCustomerGroup4" )
    @JsonProperty( "AdditionalCustomerGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup4" )
    private String additionalCustomerGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup4</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_CUSTOMER_GROUP4 =
        new InbDeliveryItemField<String>("AdditionalCustomerGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @return Customer Grp 5
     */
    @SerializedName( "AdditionalCustomerGroup5" )
    @JsonProperty( "AdditionalCustomerGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup5" )
    private String additionalCustomerGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup5</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_CUSTOMER_GROUP5 =
        new InbDeliveryItemField<String>("AdditionalCustomerGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @return MaterialGroup 1
     */
    @SerializedName( "AdditionalMaterialGroup1" )
    @JsonProperty( "AdditionalMaterialGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup1" )
    private String additionalMaterialGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup1</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_MATERIAL_GROUP1 =
        new InbDeliveryItemField<String>("AdditionalMaterialGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @return MaterialGroup 2
     */
    @SerializedName( "AdditionalMaterialGroup2" )
    @JsonProperty( "AdditionalMaterialGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup2" )
    private String additionalMaterialGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup2</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_MATERIAL_GROUP2 =
        new InbDeliveryItemField<String>("AdditionalMaterialGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @return MaterialGroup 3
     */
    @SerializedName( "AdditionalMaterialGroup3" )
    @JsonProperty( "AdditionalMaterialGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup3" )
    private String additionalMaterialGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup3</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_MATERIAL_GROUP3 =
        new InbDeliveryItemField<String>("AdditionalMaterialGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @return MaterialGroup 4
     */
    @SerializedName( "AdditionalMaterialGroup4" )
    @JsonProperty( "AdditionalMaterialGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup4" )
    private String additionalMaterialGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup4</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_MATERIAL_GROUP4 =
        new InbDeliveryItemField<String>("AdditionalMaterialGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @return MaterialGroup 5
     */
    @SerializedName( "AdditionalMaterialGroup5" )
    @JsonProperty( "AdditionalMaterialGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup5" )
    private String additionalMaterialGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup5</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ADDITIONAL_MATERIAL_GROUP5 =
        new InbDeliveryItemField<String>("AdditionalMaterialGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AlternateProductNumber</b>
     * </p>
     *
     * @return Alt.ProdNr.
     */
    @SerializedName( "AlternateProductNumber" )
    @JsonProperty( "AlternateProductNumber" )
    @Nullable
    @ODataField( odataName = "AlternateProductNumber" )
    private String alternateProductNumber;
    /**
     * Use with available fluent helpers to apply the <b>AlternateProductNumber</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ALTERNATE_PRODUCT_NUMBER =
        new InbDeliveryItemField<String>("AlternateProductNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> BASE_UNIT = new InbDeliveryItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> BATCH = new InbDeliveryItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BatchBySupplier</b>
     * </p>
     *
     * @return Supplier Batch
     */
    @SerializedName( "BatchBySupplier" )
    @JsonProperty( "BatchBySupplier" )
    @Nullable
    @ODataField( odataName = "BatchBySupplier" )
    private String batchBySupplier;
    /**
     * Use with available fluent helpers to apply the <b>BatchBySupplier</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> BATCH_BY_SUPPLIER =
        new InbDeliveryItemField<String>("BatchBySupplier");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BatchClassification</b>
     * </p>
     *
     * @return Int.object no.
     */
    @SerializedName( "BatchClassification" )
    @JsonProperty( "BatchClassification" )
    @Nullable
    @ODataField( odataName = "BatchClassification" )
    private String batchClassification;
    /**
     * Use with available fluent helpers to apply the <b>BatchClassification</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> BATCH_CLASSIFICATION =
        new InbDeliveryItemField<String>("BatchClassification");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMExplosion</b>
     * </p>
     *
     * @return BOM Explos. No.
     */
    @SerializedName( "BOMExplosion" )
    @JsonProperty( "BOMExplosion" )
    @Nullable
    @ODataField( odataName = "BOMExplosion" )
    private String bOMExplosion;
    /**
     * Use with available fluent helpers to apply the <b>BOMExplosion</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> BOM_EXPLOSION = new InbDeliveryItemField<String>("BOMExplosion");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> BUSINESS_AREA = new InbDeliveryItemField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionPosting</b>
     * </p>
     *
     * @return Consumption
     */
    @SerializedName( "ConsumptionPosting" )
    @JsonProperty( "ConsumptionPosting" )
    @Nullable
    @ODataField( odataName = "ConsumptionPosting" )
    private String consumptionPosting;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionPosting</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> CONSUMPTION_POSTING =
        new InbDeliveryItemField<String>("ConsumptionPosting");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return CO Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> CONTROLLING_AREA =
        new InbDeliveryItemField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> COST_CENTER = new InbDeliveryItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> CREATED_BY_USER =
        new InbDeliveryItemField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalDateTime> CREATION_DATE =
        new InbDeliveryItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalTime> CREATION_TIME =
        new InbDeliveryItemField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CustEngineeringChgStatus</b>
     * </p>
     *
     * @return Engin. Change
     */
    @SerializedName( "CustEngineeringChgStatus" )
    @JsonProperty( "CustEngineeringChgStatus" )
    @Nullable
    @ODataField( odataName = "CustEngineeringChgStatus" )
    private String custEngineeringChgStatus;
    /**
     * Use with available fluent helpers to apply the <b>CustEngineeringChgStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> CUST_ENGINEERING_CHG_STATUS =
        new InbDeliveryItemField<String>("CustEngineeringChgStatus");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @Key
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_DOCUMENT =
        new InbDeliveryItemField<String>("DeliveryDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @return Item
     */
    @Key
    @SerializedName( "DeliveryDocumentItem" )
    @JsonProperty( "DeliveryDocumentItem" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItem" )
    private String deliveryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentItem</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_DOCUMENT_ITEM =
        new InbDeliveryItemField<String>("DeliveryDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItemCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "DeliveryDocumentItemCategory" )
    @JsonProperty( "DeliveryDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItemCategory" )
    private String deliveryDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentItemCategory</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_DOCUMENT_ITEM_CATEGORY =
        new InbDeliveryItemField<String>("DeliveryDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItemText</b>
     * </p>
     *
     * @return Item Descr.
     */
    @SerializedName( "DeliveryDocumentItemText" )
    @JsonProperty( "DeliveryDocumentItemText" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItemText" )
    private String deliveryDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentItemText</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_DOCUMENT_ITEM_TEXT =
        new InbDeliveryItemField<String>("DeliveryDocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @return Delivery Group
     */
    @SerializedName( "DeliveryGroup" )
    @JsonProperty( "DeliveryGroup" )
    @Nullable
    @ODataField( odataName = "DeliveryGroup" )
    private String deliveryGroup;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_GROUP = new InbDeliveryItemField<String>("DeliveryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "DeliveryQuantityUnit" )
    @JsonProperty( "DeliveryQuantityUnit" )
    @Nullable
    @ODataField( odataName = "DeliveryQuantityUnit" )
    private String deliveryQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryQuantityUnit</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_QUANTITY_UNIT =
        new InbDeliveryItemField<String>("DeliveryQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryRelatedBillingStatus</b>
     * </p>
     *
     * @return Billing Status
     */
    @SerializedName( "DeliveryRelatedBillingStatus" )
    @JsonProperty( "DeliveryRelatedBillingStatus" )
    @Nullable
    @ODataField( odataName = "DeliveryRelatedBillingStatus" )
    private String deliveryRelatedBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryRelatedBillingStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_RELATED_BILLING_STATUS =
        new InbDeliveryItemField<String>("DeliveryRelatedBillingStatus");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryToBaseQuantityDnmntr</b>
     * </p>
     *
     * @return Denominat.
     */
    @SerializedName( "DeliveryToBaseQuantityDnmntr" )
    @JsonProperty( "DeliveryToBaseQuantityDnmntr" )
    @Nullable
    @ODataField( odataName = "DeliveryToBaseQuantityDnmntr" )
    private BigDecimal deliveryToBaseQuantityDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryToBaseQuantityDnmntr</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> DELIVERY_TO_BASE_QUANTITY_DNMNTR =
        new InbDeliveryItemField<BigDecimal>("DeliveryToBaseQuantityDnmntr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryToBaseQuantityNmrtr</b>
     * </p>
     *
     * @return Numerator
     */
    @SerializedName( "DeliveryToBaseQuantityNmrtr" )
    @JsonProperty( "DeliveryToBaseQuantityNmrtr" )
    @Nullable
    @ODataField( odataName = "DeliveryToBaseQuantityNmrtr" )
    private BigDecimal deliveryToBaseQuantityNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryToBaseQuantityNmrtr</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> DELIVERY_TO_BASE_QUANTITY_NMRTR =
        new InbDeliveryItemField<BigDecimal>("DeliveryToBaseQuantityNmrtr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DepartmentClassificationByCust</b>
     * </p>
     *
     * @return Department
     */
    @SerializedName( "DepartmentClassificationByCust" )
    @JsonProperty( "DepartmentClassificationByCust" )
    @Nullable
    @ODataField( odataName = "DepartmentClassificationByCust" )
    private String departmentClassificationByCust;
    /**
     * Use with available fluent helpers to apply the <b>DepartmentClassificationByCust</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DEPARTMENT_CLASSIFICATION_BY_CUST =
        new InbDeliveryItemField<String>("DepartmentClassificationByCust");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distr. Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DISTRIBUTION_CHANNEL =
        new InbDeliveryItemField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DIVISION = new InbDeliveryItemField<String>("Division");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>FixedShipgProcgDurationInDays</b>
     * </p>
     *
     * @return Fixed proc.time
     */
    @SerializedName( "FixedShipgProcgDurationInDays" )
    @JsonProperty( "FixedShipgProcgDurationInDays" )
    @Nullable
    @ODataField( odataName = "FixedShipgProcgDurationInDays" )
    private BigDecimal fixedShipgProcgDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>FixedShipgProcgDurationInDays</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> FIXED_SHIPG_PROCG_DURATION_IN_DAYS =
        new InbDeliveryItemField<BigDecimal>("FixedShipgProcgDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> GL_ACCOUNT = new InbDeliveryItemField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @return Reason for mvt.
     */
    @SerializedName( "GoodsMovementReasonCode" )
    @JsonProperty( "GoodsMovementReasonCode" )
    @Nullable
    @ODataField( odataName = "GoodsMovementReasonCode" )
    private String goodsMovementReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementReasonCode</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> GOODS_MOVEMENT_REASON_CODE =
        new InbDeliveryItemField<String>("GoodsMovementReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementStatus</b>
     * </p>
     *
     * @return GoodsMovementSt
     */
    @SerializedName( "GoodsMovementStatus" )
    @JsonProperty( "GoodsMovementStatus" )
    @Nullable
    @ODataField( odataName = "GoodsMovementStatus" )
    private String goodsMovementStatus;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> GOODS_MOVEMENT_STATUS =
        new InbDeliveryItemField<String>("GoodsMovementStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> GOODS_MOVEMENT_TYPE =
        new InbDeliveryItemField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Lev.Item
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> HIGHER_LEVEL_ITEM =
        new InbDeliveryItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot
     */
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> INSPECTION_LOT = new InbDeliveryItemField<String>("InspectionLot");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialLot</b>
     * </p>
     *
     * @return Partial lot
     */
    @SerializedName( "InspectionPartialLot" )
    @JsonProperty( "InspectionPartialLot" )
    @Nullable
    @ODataField( odataName = "InspectionPartialLot" )
    private String inspectionPartialLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPartialLot</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> INSPECTION_PARTIAL_LOT =
        new InbDeliveryItemField<String>("InspectionPartialLot");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyBillingStatus</b>
     * </p>
     *
     * @return Interco. BillSt
     */
    @SerializedName( "IntercompanyBillingStatus" )
    @JsonProperty( "IntercompanyBillingStatus" )
    @Nullable
    @ODataField( odataName = "IntercompanyBillingStatus" )
    private String intercompanyBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>IntercompanyBillingStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> INTERCOMPANY_BILLING_STATUS =
        new InbDeliveryItemField<String>("IntercompanyBillingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @return EAN/UPC
     */
    @SerializedName( "InternationalArticleNumber" )
    @JsonProperty( "InternationalArticleNumber" )
    @Nullable
    @ODataField( odataName = "InternationalArticleNumber" )
    private String internationalArticleNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternationalArticleNumber</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> INTERNATIONAL_ARTICLE_NUMBER =
        new InbDeliveryItemField<String>("InternationalArticleNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Special Stock
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new InbDeliveryItemField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> INVENTORY_VALUATION_TYPE =
        new InbDeliveryItemField<String>("InventoryValuationType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @return Deliv. Compl.
     */
    @SerializedName( "IsCompletelyDelivered" )
    @JsonProperty( "IsCompletelyDelivered" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCompletelyDelivered" )
    private Boolean isCompletelyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>IsCompletelyDelivered</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<Boolean> IS_COMPLETELY_DELIVERED =
        new InbDeliveryItemField<Boolean>("IsCompletelyDelivered");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsNotGoodsMovementsRelevant</b>
     * </p>
     *
     * @return No gds movement
     */
    @SerializedName( "IsNotGoodsMovementsRelevant" )
    @JsonProperty( "IsNotGoodsMovementsRelevant" )
    @Nullable
    @ODataField( odataName = "IsNotGoodsMovementsRelevant" )
    private String isNotGoodsMovementsRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsNotGoodsMovementsRelevant</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> IS_NOT_GOODS_MOVEMENTS_RELEVANT =
        new InbDeliveryItemField<String>("IsNotGoodsMovementsRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSeparateValuation</b>
     * </p>
     *
     * @return Separate val.
     */
    @SerializedName( "IsSeparateValuation" )
    @JsonProperty( "IsSeparateValuation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSeparateValuation" )
    private Boolean isSeparateValuation;
    /**
     * Use with available fluent helpers to apply the <b>IsSeparateValuation</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<Boolean> IS_SEPARATE_VALUATION =
        new InbDeliveryItemField<Boolean>("IsSeparateValuation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgBatch</b>
     * </p>
     *
     * @return Receiving Batch
     */
    @SerializedName( "IssgOrRcvgBatch" )
    @JsonProperty( "IssgOrRcvgBatch" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgBatch" )
    private String issgOrRcvgBatch;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgBatch</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ISSG_OR_RCVG_BATCH =
        new InbDeliveryItemField<String>("IssgOrRcvgBatch");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgMaterial</b>
     * </p>
     *
     * @return Receiving Mat.
     */
    @SerializedName( "IssgOrRcvgMaterial" )
    @JsonProperty( "IssgOrRcvgMaterial" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgMaterial" )
    private String issgOrRcvgMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgMaterial</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ISSG_OR_RCVG_MATERIAL =
        new InbDeliveryItemField<String>("IssgOrRcvgMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgSpclStockInd</b>
     * </p>
     *
     * @return Sp.ind.st.tfr.
     */
    @SerializedName( "IssgOrRcvgSpclStockInd" )
    @JsonProperty( "IssgOrRcvgSpclStockInd" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgSpclStockInd" )
    private String issgOrRcvgSpclStockInd;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgSpclStockInd</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ISSG_OR_RCVG_SPCL_STOCK_IND =
        new InbDeliveryItemField<String>("IssgOrRcvgSpclStockInd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgStockCategory</b>
     * </p>
     *
     * @return Stock Category
     */
    @SerializedName( "IssgOrRcvgStockCategory" )
    @JsonProperty( "IssgOrRcvgStockCategory" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgStockCategory" )
    private String issgOrRcvgStockCategory;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgStockCategory</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ISSG_OR_RCVG_STOCK_CATEGORY =
        new InbDeliveryItemField<String>("IssgOrRcvgStockCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgValuationType</b>
     * </p>
     *
     * @return Val. Type Tfr.
     */
    @SerializedName( "IssgOrRcvgValuationType" )
    @JsonProperty( "IssgOrRcvgValuationType" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgValuationType" )
    private String issgOrRcvgValuationType;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgValuationType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ISSG_OR_RCVG_VALUATION_TYPE =
        new InbDeliveryItemField<String>("IssgOrRcvgValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @return Receiving plant
     */
    @SerializedName( "IssuingOrReceivingPlant" )
    @JsonProperty( "IssuingOrReceivingPlant" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingPlant" )
    private String issuingOrReceivingPlant;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingPlant</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ISSUING_OR_RECEIVING_PLANT =
        new InbDeliveryItemField<String>("IssuingOrReceivingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @return Receiving SLoc.
     */
    @SerializedName( "IssuingOrReceivingStorageLoc" )
    @JsonProperty( "IssuingOrReceivingStorageLoc" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingStorageLoc" )
    private String issuingOrReceivingStorageLoc;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingStorageLoc</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ISSUING_OR_RECEIVING_STORAGE_LOC =
        new InbDeliveryItemField<String>("IssuingOrReceivingStorageLoc");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block
     */
    @SerializedName( "ItemBillingBlockReason" )
    @JsonProperty( "ItemBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "ItemBillingBlockReason" )
    private String itemBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingBlockReason</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_BILLING_BLOCK_REASON =
        new InbDeliveryItemField<String>("ItemBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingIncompletionStatus</b>
     * </p>
     *
     * @return Item Bill.Data
     */
    @SerializedName( "ItemBillingIncompletionStatus" )
    @JsonProperty( "ItemBillingIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemBillingIncompletionStatus" )
    private String itemBillingIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_BILLING_INCOMPLETION_STATUS =
        new InbDeliveryItemField<String>("ItemBillingIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryIncompletionStatus</b>
     * </p>
     *
     * @return Item Deliv.Data
     */
    @SerializedName( "ItemDeliveryIncompletionStatus" )
    @JsonProperty( "ItemDeliveryIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemDeliveryIncompletionStatus" )
    private String itemDeliveryIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemDeliveryIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_DELIVERY_INCOMPLETION_STATUS =
        new InbDeliveryItemField<String>("ItemDeliveryIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemGdsMvtIncompletionSts</b>
     * </p>
     *
     * @return Item data: GM
     */
    @SerializedName( "ItemGdsMvtIncompletionSts" )
    @JsonProperty( "ItemGdsMvtIncompletionSts" )
    @Nullable
    @ODataField( odataName = "ItemGdsMvtIncompletionSts" )
    private String itemGdsMvtIncompletionSts;
    /**
     * Use with available fluent helpers to apply the <b>ItemGdsMvtIncompletionSts</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_GDS_MVT_INCOMPLETION_STS =
        new InbDeliveryItemField<String>("ItemGdsMvtIncompletionSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemGeneralIncompletionStatus</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "ItemGeneralIncompletionStatus" )
    @JsonProperty( "ItemGeneralIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemGeneralIncompletionStatus" )
    private String itemGeneralIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemGeneralIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_GENERAL_INCOMPLETION_STATUS =
        new InbDeliveryItemField<String>("ItemGeneralIncompletionStatus");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new InbDeliveryItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsBillingRelevant</b>
     * </p>
     *
     * @return Relev.for Bill.
     */
    @SerializedName( "ItemIsBillingRelevant" )
    @JsonProperty( "ItemIsBillingRelevant" )
    @Nullable
    @ODataField( odataName = "ItemIsBillingRelevant" )
    private String itemIsBillingRelevant;
    /**
     * Use with available fluent helpers to apply the <b>ItemIsBillingRelevant</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_IS_BILLING_RELEVANT =
        new InbDeliveryItemField<String>("ItemIsBillingRelevant");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> ITEM_NET_WEIGHT =
        new InbDeliveryItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemPackingIncompletionStatus</b>
     * </p>
     *
     * @return It.data pckgng
     */
    @SerializedName( "ItemPackingIncompletionStatus" )
    @JsonProperty( "ItemPackingIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemPackingIncompletionStatus" )
    private String itemPackingIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemPackingIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_PACKING_INCOMPLETION_STATUS =
        new InbDeliveryItemField<String>("ItemPackingIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemPickingIncompletionStatus</b>
     * </p>
     *
     * @return Item data pck/putawy
     */
    @SerializedName( "ItemPickingIncompletionStatus" )
    @JsonProperty( "ItemPickingIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemPickingIncompletionStatus" )
    private String itemPickingIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemPickingIncompletionStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_PICKING_INCOMPLETION_STATUS =
        new InbDeliveryItemField<String>("ItemPickingIncompletionStatus");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> ITEM_VOLUME =
        new InbDeliveryItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_VOLUME_UNIT =
        new InbDeliveryItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ITEM_WEIGHT_UNIT =
        new InbDeliveryItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalDateTime> LAST_CHANGE_DATE =
        new InbDeliveryItemField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LoadingGroup</b>
     * </p>
     *
     * @return Loading Group
     */
    @SerializedName( "LoadingGroup" )
    @JsonProperty( "LoadingGroup" )
    @Nullable
    @ODataField( odataName = "LoadingGroup" )
    private String loadingGroup;
    /**
     * Use with available fluent helpers to apply the <b>LoadingGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> LOADING_GROUP = new InbDeliveryItemField<String>("LoadingGroup");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @return Date of Manuf.
     */
    @SerializedName( "ManufactureDate" )
    @JsonProperty( "ManufactureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ManufactureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime manufactureDate;
    /**
     * Use with available fluent helpers to apply the <b>ManufactureDate</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalDateTime> MANUFACTURE_DATE =
        new InbDeliveryItemField<LocalDateTime>("ManufactureDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> MATERIAL = new InbDeliveryItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Cust. Material
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> MATERIAL_BY_CUSTOMER =
        new InbDeliveryItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaterialFreightGroup</b>
     * </p>
     *
     * @return Mat.Freight Grp
     */
    @SerializedName( "MaterialFreightGroup" )
    @JsonProperty( "MaterialFreightGroup" )
    @Nullable
    @ODataField( odataName = "MaterialFreightGroup" )
    private String materialFreightGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialFreightGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> MATERIAL_FREIGHT_GROUP =
        new InbDeliveryItemField<String>("MaterialFreightGroup");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> MATERIAL_GROUP = new InbDeliveryItemField<String>("MaterialGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsBatchManaged</b>
     * </p>
     *
     * @return Batch Mgmt Rqt
     */
    @SerializedName( "MaterialIsBatchManaged" )
    @JsonProperty( "MaterialIsBatchManaged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialIsBatchManaged" )
    private Boolean materialIsBatchManaged;
    /**
     * Use with available fluent helpers to apply the <b>MaterialIsBatchManaged</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<Boolean> MATERIAL_IS_BATCH_MANAGED =
        new InbDeliveryItemField<Boolean>("MaterialIsBatchManaged");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsIntBatchManaged</b>
     * </p>
     *
     * @return Batches
     */
    @SerializedName( "MaterialIsIntBatchManaged" )
    @JsonProperty( "MaterialIsIntBatchManaged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialIsIntBatchManaged" )
    private Boolean materialIsIntBatchManaged;
    /**
     * Use with available fluent helpers to apply the <b>MaterialIsIntBatchManaged</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<Boolean> MATERIAL_IS_INT_BATCH_MANAGED =
        new InbDeliveryItemField<Boolean>("MaterialIsIntBatchManaged");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfSerialNumbers</b>
     * </p>
     *
     * @return No.serial no.
     */
    @SerializedName( "NumberOfSerialNumbers" )
    @JsonProperty( "NumberOfSerialNumbers" )
    @Nullable
    @ODataField( odataName = "NumberOfSerialNumbers" )
    private Integer numberOfSerialNumbers;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfSerialNumbers</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<Integer> NUMBER_OF_SERIAL_NUMBERS =
        new InbDeliveryItemField<Integer>("NumberOfSerialNumbers");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ORDER_ID = new InbDeliveryItemField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderItem</b>
     * </p>
     *
     * @return Order item no.
     */
    @SerializedName( "OrderItem" )
    @JsonProperty( "OrderItem" )
    @Nullable
    @ODataField( odataName = "OrderItem" )
    private String orderItem;
    /**
     * Use with available fluent helpers to apply the <b>OrderItem</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ORDER_ITEM = new InbDeliveryItemField<String>("OrderItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OriginalDeliveryQuantity</b>
     * </p>
     *
     * @return Delivery Qty
     */
    @SerializedName( "OriginalDeliveryQuantity" )
    @JsonProperty( "OriginalDeliveryQuantity" )
    @Nullable
    @ODataField( odataName = "OriginalDeliveryQuantity" )
    private BigDecimal originalDeliveryQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OriginalDeliveryQuantity</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> ORIGINAL_DELIVERY_QUANTITY =
        new InbDeliveryItemField<BigDecimal>("OriginalDeliveryQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginallyRequestedMaterial</b>
     * </p>
     *
     * @return MaterialEntered
     */
    @SerializedName( "OriginallyRequestedMaterial" )
    @JsonProperty( "OriginallyRequestedMaterial" )
    @Nullable
    @ODataField( odataName = "OriginallyRequestedMaterial" )
    private String originallyRequestedMaterial;
    /**
     * Use with available fluent helpers to apply the <b>OriginallyRequestedMaterial</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> ORIGINALLY_REQUESTED_MATERIAL =
        new InbDeliveryItemField<String>("OriginallyRequestedMaterial");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Overdeliv. Tol.
     */
    @SerializedName( "OverdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "OverdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "OverdelivTolrtdLmtRatioInPct" )
    private BigDecimal overdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>OverdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new InbDeliveryItemField<BigDecimal>("OverdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PackingStatus</b>
     * </p>
     *
     * @return Packing Status
     */
    @SerializedName( "PackingStatus" )
    @JsonProperty( "PackingStatus" )
    @Nullable
    @ODataField( odataName = "PackingStatus" )
    private String packingStatus;
    /**
     * Use with available fluent helpers to apply the <b>PackingStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PACKING_STATUS = new InbDeliveryItemField<String>("PackingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialDeliveryIsAllowed</b>
     * </p>
     *
     * @return Part.Dlv./Item
     */
    @SerializedName( "PartialDeliveryIsAllowed" )
    @JsonProperty( "PartialDeliveryIsAllowed" )
    @Nullable
    @ODataField( odataName = "PartialDeliveryIsAllowed" )
    private String partialDeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PartialDeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PARTIAL_DELIVERY_IS_ALLOWED =
        new InbDeliveryItemField<String>("PartialDeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentGuaranteeForm</b>
     * </p>
     *
     * @return PaytGuarantForm
     */
    @SerializedName( "PaymentGuaranteeForm" )
    @JsonProperty( "PaymentGuaranteeForm" )
    @Nullable
    @ODataField( odataName = "PaymentGuaranteeForm" )
    private String paymentGuaranteeForm;
    /**
     * Use with available fluent helpers to apply the <b>PaymentGuaranteeForm</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PAYMENT_GUARANTEE_FORM =
        new InbDeliveryItemField<String>("PaymentGuaranteeForm");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingConfirmationStatus</b>
     * </p>
     *
     * @return Confirmation
     */
    @SerializedName( "PickingConfirmationStatus" )
    @JsonProperty( "PickingConfirmationStatus" )
    @Nullable
    @ODataField( odataName = "PickingConfirmationStatus" )
    private String pickingConfirmationStatus;
    /**
     * Use with available fluent helpers to apply the <b>PickingConfirmationStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PICKING_CONFIRMATION_STATUS =
        new InbDeliveryItemField<String>("PickingConfirmationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingControl</b>
     * </p>
     *
     * @return Picking ID
     */
    @SerializedName( "PickingControl" )
    @JsonProperty( "PickingControl" )
    @Nullable
    @ODataField( odataName = "PickingControl" )
    private String pickingControl;
    /**
     * Use with available fluent helpers to apply the <b>PickingControl</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PICKING_CONTROL =
        new InbDeliveryItemField<String>("PickingControl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingStatus</b>
     * </p>
     *
     * @return Picking Status
     */
    @SerializedName( "PickingStatus" )
    @JsonProperty( "PickingStatus" )
    @Nullable
    @ODataField( odataName = "PickingStatus" )
    private String pickingStatus;
    /**
     * Use with available fluent helpers to apply the <b>PickingStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PICKING_STATUS = new InbDeliveryItemField<String>("PickingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PLANT = new InbDeliveryItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrimaryPostingSwitch</b>
     * </p>
     *
     * @return Main posting id
     */
    @SerializedName( "PrimaryPostingSwitch" )
    @JsonProperty( "PrimaryPostingSwitch" )
    @Nullable
    @ODataField( odataName = "PrimaryPostingSwitch" )
    private String primaryPostingSwitch;
    /**
     * Use with available fluent helpers to apply the <b>PrimaryPostingSwitch</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PRIMARY_POSTING_SWITCH =
        new InbDeliveryItemField<String>("PrimaryPostingSwitch");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityDate</b>
     * </p>
     *
     * @return Mat.Avail.Date
     */
    @SerializedName( "ProductAvailabilityDate" )
    @JsonProperty( "ProductAvailabilityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductAvailabilityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productAvailabilityDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductAvailabilityDate</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalDateTime> PRODUCT_AVAILABILITY_DATE =
        new InbDeliveryItemField<LocalDateTime>("ProductAvailabilityDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityTime</b>
     * </p>
     *
     * @return Matl Staging Tme
     */
    @SerializedName( "ProductAvailabilityTime" )
    @JsonProperty( "ProductAvailabilityTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ProductAvailabilityTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime productAvailabilityTime;
    /**
     * Use with available fluent helpers to apply the <b>ProductAvailabilityTime</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalTime> PRODUCT_AVAILABILITY_TIME =
        new InbDeliveryItemField<LocalTime>("ProductAvailabilityTime");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductConfiguration</b>
     * </p>
     *
     * @return Configuration
     */
    @SerializedName( "ProductConfiguration" )
    @JsonProperty( "ProductConfiguration" )
    @Nullable
    @ODataField( odataName = "ProductConfiguration" )
    private String productConfiguration;
    /**
     * Use with available fluent helpers to apply the <b>ProductConfiguration</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PRODUCT_CONFIGURATION =
        new InbDeliveryItemField<String>("ProductConfiguration");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @return Prod. Hierarchy
     */
    @SerializedName( "ProductHierarchyNode" )
    @JsonProperty( "ProductHierarchyNode" )
    @Nullable
    @ODataField( odataName = "ProductHierarchyNode" )
    private String productHierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>ProductHierarchyNode</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PRODUCT_HIERARCHY_NODE =
        new InbDeliveryItemField<String>("ProductHierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Profit. Segment
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PROFITABILITY_SEGMENT =
        new InbDeliveryItemField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PROFIT_CENTER = new InbDeliveryItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProofOfDeliveryRelevanceCode</b>
     * </p>
     *
     * @return POD rel. RC/SC
     */
    @SerializedName( "ProofOfDeliveryRelevanceCode" )
    @JsonProperty( "ProofOfDeliveryRelevanceCode" )
    @Nullable
    @ODataField( odataName = "ProofOfDeliveryRelevanceCode" )
    private String proofOfDeliveryRelevanceCode;
    /**
     * Use with available fluent helpers to apply the <b>ProofOfDeliveryRelevanceCode</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PROOF_OF_DELIVERY_RELEVANCE_CODE =
        new InbDeliveryItemField<String>("ProofOfDeliveryRelevanceCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProofOfDeliveryStatus</b>
     * </p>
     *
     * @return POD status
     */
    @SerializedName( "ProofOfDeliveryStatus" )
    @JsonProperty( "ProofOfDeliveryStatus" )
    @Nullable
    @ODataField( odataName = "ProofOfDeliveryStatus" )
    private String proofOfDeliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProofOfDeliveryStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> PROOF_OF_DELIVERY_STATUS =
        new InbDeliveryItemField<String>("ProofOfDeliveryStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @return Qty. is fixed
     */
    @SerializedName( "QuantityIsFixed" )
    @JsonProperty( "QuantityIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "QuantityIsFixed" )
    private Boolean quantityIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsFixed</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<Boolean> QUANTITY_IS_FIXED =
        new InbDeliveryItemField<Boolean>("QuantityIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingPoint</b>
     * </p>
     *
     * @return Recv. Point
     */
    @SerializedName( "ReceivingPoint" )
    @JsonProperty( "ReceivingPoint" )
    @Nullable
    @ODataField( odataName = "ReceivingPoint" )
    private String receivingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ReceivingPoint</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> RECEIVING_POINT =
        new InbDeliveryItemField<String>("ReceivingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @return PrDocLogSys
     */
    @SerializedName( "ReferenceDocumentLogicalSystem" )
    @JsonProperty( "ReferenceDocumentLogicalSystem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentLogicalSystem" )
    private String referenceDocumentLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentLogicalSystem</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> REFERENCE_DOCUMENT_LOGICAL_SYSTEM =
        new InbDeliveryItemField<String>("ReferenceDocumentLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Reference Doc.
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> REFERENCE_SD_DOCUMENT =
        new InbDeliveryItemField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @return Prec.Doc.Categ.
     */
    @SerializedName( "ReferenceSDDocumentCategory" )
    @JsonProperty( "ReferenceSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentCategory" )
    private String referenceSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentCategory</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> REFERENCE_SD_DOCUMENT_CATEGORY =
        new InbDeliveryItemField<String>("ReferenceSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new InbDeliveryItemField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetailPromotion</b>
     * </p>
     *
     * @return Promotion
     */
    @SerializedName( "RetailPromotion" )
    @JsonProperty( "RetailPromotion" )
    @Nullable
    @ODataField( odataName = "RetailPromotion" )
    private String retailPromotion;
    /**
     * Use with available fluent helpers to apply the <b>RetailPromotion</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> RETAIL_PROMOTION =
        new InbDeliveryItemField<String>("RetailPromotion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemType</b>
     * </p>
     *
     * @return Item Type
     */
    @SerializedName( "SalesDocumentItemType" )
    @JsonProperty( "SalesDocumentItemType" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItemType" )
    private String salesDocumentItemType;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItemType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> SALES_DOCUMENT_ITEM_TYPE =
        new InbDeliveryItemField<String>("SalesDocumentItemType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> SALES_GROUP = new InbDeliveryItemField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> SALES_OFFICE = new InbDeliveryItemField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @return Document Cat.
     */
    @SerializedName( "SDDocumentCategory" )
    @JsonProperty( "SDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SDDocumentCategory" )
    private String sDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentCategory</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> SD_DOCUMENT_CATEGORY =
        new InbDeliveryItemField<String>("SDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Status
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> SD_PROCESS_STATUS =
        new InbDeliveryItemField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @return SLED/BBD
     */
    @SerializedName( "ShelfLifeExpirationDate" )
    @JsonProperty( "ShelfLifeExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShelfLifeExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shelfLifeExpirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDate</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalDateTime> SHELF_LIFE_EXPIRATION_DATE =
        new InbDeliveryItemField<LocalDateTime>("ShelfLifeExpirationDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsDate</b>
     * </p>
     *
     * @return Statistics Date
     */
    @SerializedName( "StatisticsDate" )
    @JsonProperty( "StatisticsDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "StatisticsDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime statisticsDate;
    /**
     * Use with available fluent helpers to apply the <b>StatisticsDate</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<LocalDateTime> STATISTICS_DATE =
        new InbDeliveryItemField<LocalDateTime>("StatisticsDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "StockType" )
    @JsonProperty( "StockType" )
    @Nullable
    @ODataField( odataName = "StockType" )
    private String stockType;
    /**
     * Use with available fluent helpers to apply the <b>StockType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> STOCK_TYPE = new InbDeliveryItemField<String>("StockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> STORAGE_BIN = new InbDeliveryItemField<String>("StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> STORAGE_LOCATION =
        new InbDeliveryItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> STORAGE_TYPE = new InbDeliveryItemField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentMovementType</b>
     * </p>
     *
     * @return Sub.movmnt type
     */
    @SerializedName( "SubsequentMovementType" )
    @JsonProperty( "SubsequentMovementType" )
    @Nullable
    @ODataField( odataName = "SubsequentMovementType" )
    private String subsequentMovementType;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentMovementType</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> SUBSEQUENT_MOVEMENT_TYPE =
        new InbDeliveryItemField<String>("SubsequentMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransportationGroup</b>
     * </p>
     *
     * @return Trans. Group
     */
    @SerializedName( "TransportationGroup" )
    @JsonProperty( "TransportationGroup" )
    @Nullable
    @ODataField( odataName = "TransportationGroup" )
    private String transportationGroup;
    /**
     * Use with available fluent helpers to apply the <b>TransportationGroup</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> TRANSPORTATION_GROUP =
        new InbDeliveryItemField<String>("TransportationGroup");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Underdel. Tol.
     */
    @SerializedName( "UnderdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "UnderdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "UnderdelivTolrtdLmtRatioInPct" )
    private BigDecimal underdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>UnderdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new InbDeliveryItemField<BigDecimal>("UnderdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @return Unlimited
     */
    @SerializedName( "UnlimitedOverdeliveryIsAllowed" )
    @JsonProperty( "UnlimitedOverdeliveryIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverdeliveryIsAllowed" )
    private Boolean unlimitedOverdeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverdeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<Boolean> UNLIMITED_OVERDELIVERY_IS_ALLOWED =
        new InbDeliveryItemField<Boolean>("UnlimitedOverdeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>VarblShipgProcgDurationInDays</b>
     * </p>
     *
     * @return Var. proc. time
     */
    @SerializedName( "VarblShipgProcgDurationInDays" )
    @JsonProperty( "VarblShipgProcgDurationInDays" )
    @Nullable
    @ODataField( odataName = "VarblShipgProcgDurationInDays" )
    private BigDecimal varblShipgProcgDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>VarblShipgProcgDurationInDays</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<BigDecimal> VARBL_SHIPG_PROCG_DURATION_IN_DAYS =
        new InbDeliveryItemField<BigDecimal>("VarblShipgProcgDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse No.
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> WAREHOUSE = new InbDeliveryItemField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseActivityStatus</b>
     * </p>
     *
     * @return WM Activ.Status
     */
    @SerializedName( "WarehouseActivityStatus" )
    @JsonProperty( "WarehouseActivityStatus" )
    @Nullable
    @ODataField( odataName = "WarehouseActivityStatus" )
    private String warehouseActivityStatus;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseActivityStatus</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> WAREHOUSE_ACTIVITY_STATUS =
        new InbDeliveryItemField<String>("WarehouseActivityStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStagingArea</b>
     * </p>
     *
     * @return Staging Area
     */
    @SerializedName( "WarehouseStagingArea" )
    @JsonProperty( "WarehouseStagingArea" )
    @Nullable
    @ODataField( odataName = "WarehouseStagingArea" )
    private String warehouseStagingArea;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStagingArea</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> WAREHOUSE_STAGING_AREA =
        new InbDeliveryItemField<String>("WarehouseStagingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryVersion</b>
     * </p>
     *
     * @return Delivery Version
     */
    @SerializedName( "DeliveryVersion" )
    @JsonProperty( "DeliveryVersion" )
    @Nullable
    @ODataField( odataName = "DeliveryVersion" )
    private String deliveryVersion;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryVersion</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> DELIVERY_VERSION =
        new InbDeliveryItemField<String>("DeliveryVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStockCategory</b>
     * </p>
     *
     * @return Stock Category
     */
    @SerializedName( "WarehouseStockCategory" )
    @JsonProperty( "WarehouseStockCategory" )
    @Nullable
    @ODataField( odataName = "WarehouseStockCategory" )
    private String warehouseStockCategory;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStockCategory</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> WAREHOUSE_STOCK_CATEGORY =
        new InbDeliveryItemField<String>("WarehouseStockCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "WarehouseStorageBin" )
    @JsonProperty( "WarehouseStorageBin" )
    @Nullable
    @ODataField( odataName = "WarehouseStorageBin" )
    private String warehouseStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStorageBin</b> field to query operations.
     *
     */
    public final static InbDeliveryItemField<String> WAREHOUSE_STORAGE_BIN =
        new InbDeliveryItemField<String>("WarehouseStorageBin");
    /**
     * Navigation property <b>to_SerialDeliveryItem</b> for <b>InbDeliveryItem</b> to single
     * <b>InbDeliverySerialNmbr</b>.
     *
     */
    @SerializedName( "to_SerialDeliveryItem" )
    @JsonProperty( "to_SerialDeliveryItem" )
    @ODataField( odataName = "to_SerialDeliveryItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private InbDeliverySerialNmbr toSerialDeliveryItem;
    /**
     * Navigation property <b>to_DocumentFlow</b> for <b>InbDeliveryItem</b> to multiple <b>InbDeliveryDocFlow</b>.
     *
     */
    @SerializedName( "to_DocumentFlow" )
    @JsonProperty( "to_DocumentFlow" )
    @ODataField( odataName = "to_DocumentFlow" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InbDeliveryDocFlow> toDocumentFlow;
    /**
     * Use with available fluent helpers to apply the <b>to_SerialDeliveryItem</b> navigation property to query
     * operations.
     *
     */
    public final static InbDeliveryItemOneToOneLink<InbDeliverySerialNmbr> TO_SERIAL_DELIVERY_ITEM =
        new InbDeliveryItemOneToOneLink<InbDeliverySerialNmbr>("to_SerialDeliveryItem");
    /**
     * Use with available fluent helpers to apply the <b>to_DocumentFlow</b> navigation property to query operations.
     *
     */
    public final static InbDeliveryItemLink<InbDeliveryDocFlow> TO_DOCUMENT_FLOW =
        new InbDeliveryItemLink<InbDeliveryDocFlow>("to_DocumentFlow");

    @Nonnull
    @Override
    public Class<InbDeliveryItem> getType()
    {
        return InbDeliveryItem.class;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveredQtyInBaseUnit</b>
     * </p>
     *
     * @param actualDeliveredQtyInBaseUnit
     *            Qty (stckp.unt)
     */
    public void setActualDeliveredQtyInBaseUnit( @Nullable final BigDecimal actualDeliveredQtyInBaseUnit )
    {
        rememberChangedField("ActualDeliveredQtyInBaseUnit", this.actualDeliveredQtyInBaseUnit);
        this.actualDeliveredQtyInBaseUnit = actualDeliveredQtyInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveryQuantity</b>
     * </p>
     *
     * @param actualDeliveryQuantity
     *            Delivery Qty
     */
    public void setActualDeliveryQuantity( @Nullable final BigDecimal actualDeliveryQuantity )
    {
        rememberChangedField("ActualDeliveryQuantity", this.actualDeliveryQuantity);
        this.actualDeliveryQuantity = actualDeliveryQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @param additionalCustomerGroup1
     *            Customer Grp 1
     */
    public void setAdditionalCustomerGroup1( @Nullable final String additionalCustomerGroup1 )
    {
        rememberChangedField("AdditionalCustomerGroup1", this.additionalCustomerGroup1);
        this.additionalCustomerGroup1 = additionalCustomerGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @param additionalCustomerGroup2
     *            Customer Grp 2
     */
    public void setAdditionalCustomerGroup2( @Nullable final String additionalCustomerGroup2 )
    {
        rememberChangedField("AdditionalCustomerGroup2", this.additionalCustomerGroup2);
        this.additionalCustomerGroup2 = additionalCustomerGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @param additionalCustomerGroup3
     *            Customer Grp 3
     */
    public void setAdditionalCustomerGroup3( @Nullable final String additionalCustomerGroup3 )
    {
        rememberChangedField("AdditionalCustomerGroup3", this.additionalCustomerGroup3);
        this.additionalCustomerGroup3 = additionalCustomerGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @param additionalCustomerGroup4
     *            Customer Grp 4
     */
    public void setAdditionalCustomerGroup4( @Nullable final String additionalCustomerGroup4 )
    {
        rememberChangedField("AdditionalCustomerGroup4", this.additionalCustomerGroup4);
        this.additionalCustomerGroup4 = additionalCustomerGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @param additionalCustomerGroup5
     *            Customer Grp 5
     */
    public void setAdditionalCustomerGroup5( @Nullable final String additionalCustomerGroup5 )
    {
        rememberChangedField("AdditionalCustomerGroup5", this.additionalCustomerGroup5);
        this.additionalCustomerGroup5 = additionalCustomerGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @param additionalMaterialGroup1
     *            MaterialGroup 1
     */
    public void setAdditionalMaterialGroup1( @Nullable final String additionalMaterialGroup1 )
    {
        rememberChangedField("AdditionalMaterialGroup1", this.additionalMaterialGroup1);
        this.additionalMaterialGroup1 = additionalMaterialGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @param additionalMaterialGroup2
     *            MaterialGroup 2
     */
    public void setAdditionalMaterialGroup2( @Nullable final String additionalMaterialGroup2 )
    {
        rememberChangedField("AdditionalMaterialGroup2", this.additionalMaterialGroup2);
        this.additionalMaterialGroup2 = additionalMaterialGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @param additionalMaterialGroup3
     *            MaterialGroup 3
     */
    public void setAdditionalMaterialGroup3( @Nullable final String additionalMaterialGroup3 )
    {
        rememberChangedField("AdditionalMaterialGroup3", this.additionalMaterialGroup3);
        this.additionalMaterialGroup3 = additionalMaterialGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @param additionalMaterialGroup4
     *            MaterialGroup 4
     */
    public void setAdditionalMaterialGroup4( @Nullable final String additionalMaterialGroup4 )
    {
        rememberChangedField("AdditionalMaterialGroup4", this.additionalMaterialGroup4);
        this.additionalMaterialGroup4 = additionalMaterialGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @param additionalMaterialGroup5
     *            MaterialGroup 5
     */
    public void setAdditionalMaterialGroup5( @Nullable final String additionalMaterialGroup5 )
    {
        rememberChangedField("AdditionalMaterialGroup5", this.additionalMaterialGroup5);
        this.additionalMaterialGroup5 = additionalMaterialGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AlternateProductNumber</b>
     * </p>
     *
     * @param alternateProductNumber
     *            Alt.ProdNr.
     */
    public void setAlternateProductNumber( @Nullable final String alternateProductNumber )
    {
        rememberChangedField("AlternateProductNumber", this.alternateProductNumber);
        this.alternateProductNumber = alternateProductNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BatchBySupplier</b>
     * </p>
     *
     * @param batchBySupplier
     *            Supplier Batch
     */
    public void setBatchBySupplier( @Nullable final String batchBySupplier )
    {
        rememberChangedField("BatchBySupplier", this.batchBySupplier);
        this.batchBySupplier = batchBySupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BatchClassification</b>
     * </p>
     *
     * @param batchClassification
     *            Int.object no.
     */
    public void setBatchClassification( @Nullable final String batchClassification )
    {
        rememberChangedField("BatchClassification", this.batchClassification);
        this.batchClassification = batchClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMExplosion</b>
     * </p>
     *
     * @param bOMExplosion
     *            BOM Explos. No.
     */
    public void setBOMExplosion( @Nullable final String bOMExplosion )
    {
        rememberChangedField("BOMExplosion", this.bOMExplosion);
        this.bOMExplosion = bOMExplosion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionPosting</b>
     * </p>
     *
     * @param consumptionPosting
     *            Consumption
     */
    public void setConsumptionPosting( @Nullable final String consumptionPosting )
    {
        rememberChangedField("ConsumptionPosting", this.consumptionPosting);
        this.consumptionPosting = consumptionPosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            CO Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CustEngineeringChgStatus</b>
     * </p>
     *
     * @param custEngineeringChgStatus
     *            Engin. Change
     */
    public void setCustEngineeringChgStatus( @Nullable final String custEngineeringChgStatus )
    {
        rememberChangedField("CustEngineeringChgStatus", this.custEngineeringChgStatus);
        this.custEngineeringChgStatus = custEngineeringChgStatus;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @param deliveryDocumentItem
     *            Item
     */
    public void setDeliveryDocumentItem( @Nullable final String deliveryDocumentItem )
    {
        rememberChangedField("DeliveryDocumentItem", this.deliveryDocumentItem);
        this.deliveryDocumentItem = deliveryDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItemCategory</b>
     * </p>
     *
     * @param deliveryDocumentItemCategory
     *            Item Category
     */
    public void setDeliveryDocumentItemCategory( @Nullable final String deliveryDocumentItemCategory )
    {
        rememberChangedField("DeliveryDocumentItemCategory", this.deliveryDocumentItemCategory);
        this.deliveryDocumentItemCategory = deliveryDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItemText</b>
     * </p>
     *
     * @param deliveryDocumentItemText
     *            Item Descr.
     */
    public void setDeliveryDocumentItemText( @Nullable final String deliveryDocumentItemText )
    {
        rememberChangedField("DeliveryDocumentItemText", this.deliveryDocumentItemText);
        this.deliveryDocumentItemText = deliveryDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @param deliveryGroup
     *            Delivery Group
     */
    public void setDeliveryGroup( @Nullable final String deliveryGroup )
    {
        rememberChangedField("DeliveryGroup", this.deliveryGroup);
        this.deliveryGroup = deliveryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     * </p>
     *
     * @param deliveryQuantityUnit
     *            Sales Unit
     */
    public void setDeliveryQuantityUnit( @Nullable final String deliveryQuantityUnit )
    {
        rememberChangedField("DeliveryQuantityUnit", this.deliveryQuantityUnit);
        this.deliveryQuantityUnit = deliveryQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryRelatedBillingStatus</b>
     * </p>
     *
     * @param deliveryRelatedBillingStatus
     *            Billing Status
     */
    public void setDeliveryRelatedBillingStatus( @Nullable final String deliveryRelatedBillingStatus )
    {
        rememberChangedField("DeliveryRelatedBillingStatus", this.deliveryRelatedBillingStatus);
        this.deliveryRelatedBillingStatus = deliveryRelatedBillingStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryToBaseQuantityDnmntr</b>
     * </p>
     *
     * @param deliveryToBaseQuantityDnmntr
     *            Denominat.
     */
    public void setDeliveryToBaseQuantityDnmntr( @Nullable final BigDecimal deliveryToBaseQuantityDnmntr )
    {
        rememberChangedField("DeliveryToBaseQuantityDnmntr", this.deliveryToBaseQuantityDnmntr);
        this.deliveryToBaseQuantityDnmntr = deliveryToBaseQuantityDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryToBaseQuantityNmrtr</b>
     * </p>
     *
     * @param deliveryToBaseQuantityNmrtr
     *            Numerator
     */
    public void setDeliveryToBaseQuantityNmrtr( @Nullable final BigDecimal deliveryToBaseQuantityNmrtr )
    {
        rememberChangedField("DeliveryToBaseQuantityNmrtr", this.deliveryToBaseQuantityNmrtr);
        this.deliveryToBaseQuantityNmrtr = deliveryToBaseQuantityNmrtr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DepartmentClassificationByCust</b>
     * </p>
     *
     * @param departmentClassificationByCust
     *            Department
     */
    public void setDepartmentClassificationByCust( @Nullable final String departmentClassificationByCust )
    {
        rememberChangedField("DepartmentClassificationByCust", this.departmentClassificationByCust);
        this.departmentClassificationByCust = departmentClassificationByCust;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distr. Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>FixedShipgProcgDurationInDays</b>
     * </p>
     *
     * @param fixedShipgProcgDurationInDays
     *            Fixed proc.time
     */
    public void setFixedShipgProcgDurationInDays( @Nullable final BigDecimal fixedShipgProcgDurationInDays )
    {
        rememberChangedField("FixedShipgProcgDurationInDays", this.fixedShipgProcgDurationInDays);
        this.fixedShipgProcgDurationInDays = fixedShipgProcgDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @param goodsMovementReasonCode
     *            Reason for mvt.
     */
    public void setGoodsMovementReasonCode( @Nullable final String goodsMovementReasonCode )
    {
        rememberChangedField("GoodsMovementReasonCode", this.goodsMovementReasonCode);
        this.goodsMovementReasonCode = goodsMovementReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementStatus</b>
     * </p>
     *
     * @param goodsMovementStatus
     *            GoodsMovementSt
     */
    public void setGoodsMovementStatus( @Nullable final String goodsMovementStatus )
    {
        rememberChangedField("GoodsMovementStatus", this.goodsMovementStatus);
        this.goodsMovementStatus = goodsMovementStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Lev.Item
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialLot</b>
     * </p>
     *
     * @param inspectionPartialLot
     *            Partial lot
     */
    public void setInspectionPartialLot( @Nullable final String inspectionPartialLot )
    {
        rememberChangedField("InspectionPartialLot", this.inspectionPartialLot);
        this.inspectionPartialLot = inspectionPartialLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyBillingStatus</b>
     * </p>
     *
     * @param intercompanyBillingStatus
     *            Interco. BillSt
     */
    public void setIntercompanyBillingStatus( @Nullable final String intercompanyBillingStatus )
    {
        rememberChangedField("IntercompanyBillingStatus", this.intercompanyBillingStatus);
        this.intercompanyBillingStatus = intercompanyBillingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @param internationalArticleNumber
     *            EAN/UPC
     */
    public void setInternationalArticleNumber( @Nullable final String internationalArticleNumber )
    {
        rememberChangedField("InternationalArticleNumber", this.internationalArticleNumber);
        this.internationalArticleNumber = internationalArticleNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Special Stock
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @param isCompletelyDelivered
     *            Deliv. Compl.
     */
    public void setIsCompletelyDelivered( @Nullable final Boolean isCompletelyDelivered )
    {
        rememberChangedField("IsCompletelyDelivered", this.isCompletelyDelivered);
        this.isCompletelyDelivered = isCompletelyDelivered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsNotGoodsMovementsRelevant</b>
     * </p>
     *
     * @param isNotGoodsMovementsRelevant
     *            No gds movement
     */
    public void setIsNotGoodsMovementsRelevant( @Nullable final String isNotGoodsMovementsRelevant )
    {
        rememberChangedField("IsNotGoodsMovementsRelevant", this.isNotGoodsMovementsRelevant);
        this.isNotGoodsMovementsRelevant = isNotGoodsMovementsRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSeparateValuation</b>
     * </p>
     *
     * @param isSeparateValuation
     *            Separate val.
     */
    public void setIsSeparateValuation( @Nullable final Boolean isSeparateValuation )
    {
        rememberChangedField("IsSeparateValuation", this.isSeparateValuation);
        this.isSeparateValuation = isSeparateValuation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgBatch</b>
     * </p>
     *
     * @param issgOrRcvgBatch
     *            Receiving Batch
     */
    public void setIssgOrRcvgBatch( @Nullable final String issgOrRcvgBatch )
    {
        rememberChangedField("IssgOrRcvgBatch", this.issgOrRcvgBatch);
        this.issgOrRcvgBatch = issgOrRcvgBatch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgMaterial</b>
     * </p>
     *
     * @param issgOrRcvgMaterial
     *            Receiving Mat.
     */
    public void setIssgOrRcvgMaterial( @Nullable final String issgOrRcvgMaterial )
    {
        rememberChangedField("IssgOrRcvgMaterial", this.issgOrRcvgMaterial);
        this.issgOrRcvgMaterial = issgOrRcvgMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgSpclStockInd</b>
     * </p>
     *
     * @param issgOrRcvgSpclStockInd
     *            Sp.ind.st.tfr.
     */
    public void setIssgOrRcvgSpclStockInd( @Nullable final String issgOrRcvgSpclStockInd )
    {
        rememberChangedField("IssgOrRcvgSpclStockInd", this.issgOrRcvgSpclStockInd);
        this.issgOrRcvgSpclStockInd = issgOrRcvgSpclStockInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgStockCategory</b>
     * </p>
     *
     * @param issgOrRcvgStockCategory
     *            Stock Category
     */
    public void setIssgOrRcvgStockCategory( @Nullable final String issgOrRcvgStockCategory )
    {
        rememberChangedField("IssgOrRcvgStockCategory", this.issgOrRcvgStockCategory);
        this.issgOrRcvgStockCategory = issgOrRcvgStockCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgValuationType</b>
     * </p>
     *
     * @param issgOrRcvgValuationType
     *            Val. Type Tfr.
     */
    public void setIssgOrRcvgValuationType( @Nullable final String issgOrRcvgValuationType )
    {
        rememberChangedField("IssgOrRcvgValuationType", this.issgOrRcvgValuationType);
        this.issgOrRcvgValuationType = issgOrRcvgValuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @param issuingOrReceivingPlant
     *            Receiving plant
     */
    public void setIssuingOrReceivingPlant( @Nullable final String issuingOrReceivingPlant )
    {
        rememberChangedField("IssuingOrReceivingPlant", this.issuingOrReceivingPlant);
        this.issuingOrReceivingPlant = issuingOrReceivingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @param issuingOrReceivingStorageLoc
     *            Receiving SLoc.
     */
    public void setIssuingOrReceivingStorageLoc( @Nullable final String issuingOrReceivingStorageLoc )
    {
        rememberChangedField("IssuingOrReceivingStorageLoc", this.issuingOrReceivingStorageLoc);
        this.issuingOrReceivingStorageLoc = issuingOrReceivingStorageLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @param itemBillingBlockReason
     *            Billing Block
     */
    public void setItemBillingBlockReason( @Nullable final String itemBillingBlockReason )
    {
        rememberChangedField("ItemBillingBlockReason", this.itemBillingBlockReason);
        this.itemBillingBlockReason = itemBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingIncompletionStatus</b>
     * </p>
     *
     * @param itemBillingIncompletionStatus
     *            Item Bill.Data
     */
    public void setItemBillingIncompletionStatus( @Nullable final String itemBillingIncompletionStatus )
    {
        rememberChangedField("ItemBillingIncompletionStatus", this.itemBillingIncompletionStatus);
        this.itemBillingIncompletionStatus = itemBillingIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryIncompletionStatus</b>
     * </p>
     *
     * @param itemDeliveryIncompletionStatus
     *            Item Deliv.Data
     */
    public void setItemDeliveryIncompletionStatus( @Nullable final String itemDeliveryIncompletionStatus )
    {
        rememberChangedField("ItemDeliveryIncompletionStatus", this.itemDeliveryIncompletionStatus);
        this.itemDeliveryIncompletionStatus = itemDeliveryIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemGdsMvtIncompletionSts</b>
     * </p>
     *
     * @param itemGdsMvtIncompletionSts
     *            Item data: GM
     */
    public void setItemGdsMvtIncompletionSts( @Nullable final String itemGdsMvtIncompletionSts )
    {
        rememberChangedField("ItemGdsMvtIncompletionSts", this.itemGdsMvtIncompletionSts);
        this.itemGdsMvtIncompletionSts = itemGdsMvtIncompletionSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemGeneralIncompletionStatus</b>
     * </p>
     *
     * @param itemGeneralIncompletionStatus
     *            Item
     */
    public void setItemGeneralIncompletionStatus( @Nullable final String itemGeneralIncompletionStatus )
    {
        rememberChangedField("ItemGeneralIncompletionStatus", this.itemGeneralIncompletionStatus);
        this.itemGeneralIncompletionStatus = itemGeneralIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsBillingRelevant</b>
     * </p>
     *
     * @param itemIsBillingRelevant
     *            Relev.for Bill.
     */
    public void setItemIsBillingRelevant( @Nullable final String itemIsBillingRelevant )
    {
        rememberChangedField("ItemIsBillingRelevant", this.itemIsBillingRelevant);
        this.itemIsBillingRelevant = itemIsBillingRelevant;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemPackingIncompletionStatus</b>
     * </p>
     *
     * @param itemPackingIncompletionStatus
     *            It.data pckgng
     */
    public void setItemPackingIncompletionStatus( @Nullable final String itemPackingIncompletionStatus )
    {
        rememberChangedField("ItemPackingIncompletionStatus", this.itemPackingIncompletionStatus);
        this.itemPackingIncompletionStatus = itemPackingIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemPickingIncompletionStatus</b>
     * </p>
     *
     * @param itemPickingIncompletionStatus
     *            Item data pck/putawy
     */
    public void setItemPickingIncompletionStatus( @Nullable final String itemPickingIncompletionStatus )
    {
        rememberChangedField("ItemPickingIncompletionStatus", this.itemPickingIncompletionStatus);
        this.itemPickingIncompletionStatus = itemPickingIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LoadingGroup</b>
     * </p>
     *
     * @param loadingGroup
     *            Loading Group
     */
    public void setLoadingGroup( @Nullable final String loadingGroup )
    {
        rememberChangedField("LoadingGroup", this.loadingGroup);
        this.loadingGroup = loadingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @param manufactureDate
     *            Date of Manuf.
     */
    public void setManufactureDate( @Nullable final LocalDateTime manufactureDate )
    {
        rememberChangedField("ManufactureDate", this.manufactureDate);
        this.manufactureDate = manufactureDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Cust. Material
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaterialFreightGroup</b>
     * </p>
     *
     * @param materialFreightGroup
     *            Mat.Freight Grp
     */
    public void setMaterialFreightGroup( @Nullable final String materialFreightGroup )
    {
        rememberChangedField("MaterialFreightGroup", this.materialFreightGroup);
        this.materialFreightGroup = materialFreightGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsBatchManaged</b>
     * </p>
     *
     * @param materialIsBatchManaged
     *            Batch Mgmt Rqt
     */
    public void setMaterialIsBatchManaged( @Nullable final Boolean materialIsBatchManaged )
    {
        rememberChangedField("MaterialIsBatchManaged", this.materialIsBatchManaged);
        this.materialIsBatchManaged = materialIsBatchManaged;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsIntBatchManaged</b>
     * </p>
     *
     * @param materialIsIntBatchManaged
     *            Batches
     */
    public void setMaterialIsIntBatchManaged( @Nullable final Boolean materialIsIntBatchManaged )
    {
        rememberChangedField("MaterialIsIntBatchManaged", this.materialIsIntBatchManaged);
        this.materialIsIntBatchManaged = materialIsIntBatchManaged;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfSerialNumbers</b>
     * </p>
     *
     * @param numberOfSerialNumbers
     *            No.serial no.
     */
    public void setNumberOfSerialNumbers( @Nullable final Integer numberOfSerialNumbers )
    {
        rememberChangedField("NumberOfSerialNumbers", this.numberOfSerialNumbers);
        this.numberOfSerialNumbers = numberOfSerialNumbers;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderItem</b>
     * </p>
     *
     * @param orderItem
     *            Order item no.
     */
    public void setOrderItem( @Nullable final String orderItem )
    {
        rememberChangedField("OrderItem", this.orderItem);
        this.orderItem = orderItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OriginalDeliveryQuantity</b>
     * </p>
     *
     * @param originalDeliveryQuantity
     *            Delivery Qty
     */
    public void setOriginalDeliveryQuantity( @Nullable final BigDecimal originalDeliveryQuantity )
    {
        rememberChangedField("OriginalDeliveryQuantity", this.originalDeliveryQuantity);
        this.originalDeliveryQuantity = originalDeliveryQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginallyRequestedMaterial</b>
     * </p>
     *
     * @param originallyRequestedMaterial
     *            MaterialEntered
     */
    public void setOriginallyRequestedMaterial( @Nullable final String originallyRequestedMaterial )
    {
        rememberChangedField("OriginallyRequestedMaterial", this.originallyRequestedMaterial);
        this.originallyRequestedMaterial = originallyRequestedMaterial;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param overdelivTolrtdLmtRatioInPct
     *            Overdeliv. Tol.
     */
    public void setOverdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal overdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("OverdelivTolrtdLmtRatioInPct", this.overdelivTolrtdLmtRatioInPct);
        this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PackingStatus</b>
     * </p>
     *
     * @param packingStatus
     *            Packing Status
     */
    public void setPackingStatus( @Nullable final String packingStatus )
    {
        rememberChangedField("PackingStatus", this.packingStatus);
        this.packingStatus = packingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialDeliveryIsAllowed</b>
     * </p>
     *
     * @param partialDeliveryIsAllowed
     *            Part.Dlv./Item
     */
    public void setPartialDeliveryIsAllowed( @Nullable final String partialDeliveryIsAllowed )
    {
        rememberChangedField("PartialDeliveryIsAllowed", this.partialDeliveryIsAllowed);
        this.partialDeliveryIsAllowed = partialDeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentGuaranteeForm</b>
     * </p>
     *
     * @param paymentGuaranteeForm
     *            PaytGuarantForm
     */
    public void setPaymentGuaranteeForm( @Nullable final String paymentGuaranteeForm )
    {
        rememberChangedField("PaymentGuaranteeForm", this.paymentGuaranteeForm);
        this.paymentGuaranteeForm = paymentGuaranteeForm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingConfirmationStatus</b>
     * </p>
     *
     * @param pickingConfirmationStatus
     *            Confirmation
     */
    public void setPickingConfirmationStatus( @Nullable final String pickingConfirmationStatus )
    {
        rememberChangedField("PickingConfirmationStatus", this.pickingConfirmationStatus);
        this.pickingConfirmationStatus = pickingConfirmationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingControl</b>
     * </p>
     *
     * @param pickingControl
     *            Picking ID
     */
    public void setPickingControl( @Nullable final String pickingControl )
    {
        rememberChangedField("PickingControl", this.pickingControl);
        this.pickingControl = pickingControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PickingStatus</b>
     * </p>
     *
     * @param pickingStatus
     *            Picking Status
     */
    public void setPickingStatus( @Nullable final String pickingStatus )
    {
        rememberChangedField("PickingStatus", this.pickingStatus);
        this.pickingStatus = pickingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrimaryPostingSwitch</b>
     * </p>
     *
     * @param primaryPostingSwitch
     *            Main posting id
     */
    public void setPrimaryPostingSwitch( @Nullable final String primaryPostingSwitch )
    {
        rememberChangedField("PrimaryPostingSwitch", this.primaryPostingSwitch);
        this.primaryPostingSwitch = primaryPostingSwitch;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityDate</b>
     * </p>
     *
     * @param productAvailabilityDate
     *            Mat.Avail.Date
     */
    public void setProductAvailabilityDate( @Nullable final LocalDateTime productAvailabilityDate )
    {
        rememberChangedField("ProductAvailabilityDate", this.productAvailabilityDate);
        this.productAvailabilityDate = productAvailabilityDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityTime</b>
     * </p>
     *
     * @param productAvailabilityTime
     *            Matl Staging Tme
     */
    public void setProductAvailabilityTime( @Nullable final LocalTime productAvailabilityTime )
    {
        rememberChangedField("ProductAvailabilityTime", this.productAvailabilityTime);
        this.productAvailabilityTime = productAvailabilityTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductConfiguration</b>
     * </p>
     *
     * @param productConfiguration
     *            Configuration
     */
    public void setProductConfiguration( @Nullable final String productConfiguration )
    {
        rememberChangedField("ProductConfiguration", this.productConfiguration);
        this.productConfiguration = productConfiguration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @param productHierarchyNode
     *            Prod. Hierarchy
     */
    public void setProductHierarchyNode( @Nullable final String productHierarchyNode )
    {
        rememberChangedField("ProductHierarchyNode", this.productHierarchyNode);
        this.productHierarchyNode = productHierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Profit. Segment
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProofOfDeliveryRelevanceCode</b>
     * </p>
     *
     * @param proofOfDeliveryRelevanceCode
     *            POD rel. RC/SC
     */
    public void setProofOfDeliveryRelevanceCode( @Nullable final String proofOfDeliveryRelevanceCode )
    {
        rememberChangedField("ProofOfDeliveryRelevanceCode", this.proofOfDeliveryRelevanceCode);
        this.proofOfDeliveryRelevanceCode = proofOfDeliveryRelevanceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProofOfDeliveryStatus</b>
     * </p>
     *
     * @param proofOfDeliveryStatus
     *            POD status
     */
    public void setProofOfDeliveryStatus( @Nullable final String proofOfDeliveryStatus )
    {
        rememberChangedField("ProofOfDeliveryStatus", this.proofOfDeliveryStatus);
        this.proofOfDeliveryStatus = proofOfDeliveryStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @param quantityIsFixed
     *            Qty. is fixed
     */
    public void setQuantityIsFixed( @Nullable final Boolean quantityIsFixed )
    {
        rememberChangedField("QuantityIsFixed", this.quantityIsFixed);
        this.quantityIsFixed = quantityIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingPoint</b>
     * </p>
     *
     * @param receivingPoint
     *            Recv. Point
     */
    public void setReceivingPoint( @Nullable final String receivingPoint )
    {
        rememberChangedField("ReceivingPoint", this.receivingPoint);
        this.receivingPoint = receivingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @param referenceDocumentLogicalSystem
     *            PrDocLogSys
     */
    public void setReferenceDocumentLogicalSystem( @Nullable final String referenceDocumentLogicalSystem )
    {
        rememberChangedField("ReferenceDocumentLogicalSystem", this.referenceDocumentLogicalSystem);
        this.referenceDocumentLogicalSystem = referenceDocumentLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Reference Doc.
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @param referenceSDDocumentCategory
     *            Prec.Doc.Categ.
     */
    public void setReferenceSDDocumentCategory( @Nullable final String referenceSDDocumentCategory )
    {
        rememberChangedField("ReferenceSDDocumentCategory", this.referenceSDDocumentCategory);
        this.referenceSDDocumentCategory = referenceSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetailPromotion</b>
     * </p>
     *
     * @param retailPromotion
     *            Promotion
     */
    public void setRetailPromotion( @Nullable final String retailPromotion )
    {
        rememberChangedField("RetailPromotion", this.retailPromotion);
        this.retailPromotion = retailPromotion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemType</b>
     * </p>
     *
     * @param salesDocumentItemType
     *            Item Type
     */
    public void setSalesDocumentItemType( @Nullable final String salesDocumentItemType )
    {
        rememberChangedField("SalesDocumentItemType", this.salesDocumentItemType);
        this.salesDocumentItemType = salesDocumentItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @param sDDocumentCategory
     *            Document Cat.
     */
    public void setSDDocumentCategory( @Nullable final String sDDocumentCategory )
    {
        rememberChangedField("SDDocumentCategory", this.sDDocumentCategory);
        this.sDDocumentCategory = sDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Status
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            SLED/BBD
     */
    public void setShelfLifeExpirationDate( @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        rememberChangedField("ShelfLifeExpirationDate", this.shelfLifeExpirationDate);
        this.shelfLifeExpirationDate = shelfLifeExpirationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>StatisticsDate</b>
     * </p>
     *
     * @param statisticsDate
     *            Statistics Date
     */
    public void setStatisticsDate( @Nullable final LocalDateTime statisticsDate )
    {
        rememberChangedField("StatisticsDate", this.statisticsDate);
        this.statisticsDate = statisticsDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @param stockType
     *            Stock Type
     */
    public void setStockType( @Nullable final String stockType )
    {
        rememberChangedField("StockType", this.stockType);
        this.stockType = stockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentMovementType</b>
     * </p>
     *
     * @param subsequentMovementType
     *            Sub.movmnt type
     */
    public void setSubsequentMovementType( @Nullable final String subsequentMovementType )
    {
        rememberChangedField("SubsequentMovementType", this.subsequentMovementType);
        this.subsequentMovementType = subsequentMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransportationGroup</b>
     * </p>
     *
     * @param transportationGroup
     *            Trans. Group
     */
    public void setTransportationGroup( @Nullable final String transportationGroup )
    {
        rememberChangedField("TransportationGroup", this.transportationGroup);
        this.transportationGroup = transportationGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param underdelivTolrtdLmtRatioInPct
     *            Underdel. Tol.
     */
    public void setUnderdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal underdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("UnderdelivTolrtdLmtRatioInPct", this.underdelivTolrtdLmtRatioInPct);
        this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverdeliveryIsAllowed
     *            Unlimited
     */
    public void setUnlimitedOverdeliveryIsAllowed( @Nullable final Boolean unlimitedOverdeliveryIsAllowed )
    {
        rememberChangedField("UnlimitedOverdeliveryIsAllowed", this.unlimitedOverdeliveryIsAllowed);
        this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>VarblShipgProcgDurationInDays</b>
     * </p>
     *
     * @param varblShipgProcgDurationInDays
     *            Var. proc. time
     */
    public void setVarblShipgProcgDurationInDays( @Nullable final BigDecimal varblShipgProcgDurationInDays )
    {
        rememberChangedField("VarblShipgProcgDurationInDays", this.varblShipgProcgDurationInDays);
        this.varblShipgProcgDurationInDays = varblShipgProcgDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse No.
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseActivityStatus</b>
     * </p>
     *
     * @param warehouseActivityStatus
     *            WM Activ.Status
     */
    public void setWarehouseActivityStatus( @Nullable final String warehouseActivityStatus )
    {
        rememberChangedField("WarehouseActivityStatus", this.warehouseActivityStatus);
        this.warehouseActivityStatus = warehouseActivityStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStagingArea</b>
     * </p>
     *
     * @param warehouseStagingArea
     *            Staging Area
     */
    public void setWarehouseStagingArea( @Nullable final String warehouseStagingArea )
    {
        rememberChangedField("WarehouseStagingArea", this.warehouseStagingArea);
        this.warehouseStagingArea = warehouseStagingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryVersion</b>
     * </p>
     *
     * @param deliveryVersion
     *            Delivery Version
     */
    public void setDeliveryVersion( @Nullable final String deliveryVersion )
    {
        rememberChangedField("DeliveryVersion", this.deliveryVersion);
        this.deliveryVersion = deliveryVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStockCategory</b>
     * </p>
     *
     * @param warehouseStockCategory
     *            Stock Category
     */
    public void setWarehouseStockCategory( @Nullable final String warehouseStockCategory )
    {
        rememberChangedField("WarehouseStockCategory", this.warehouseStockCategory);
        this.warehouseStockCategory = warehouseStockCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStorageBin</b>
     * </p>
     *
     * @param warehouseStorageBin
     *            Storage Bin
     */
    public void setWarehouseStorageBin( @Nullable final String warehouseStorageBin )
    {
        rememberChangedField("WarehouseStorageBin", this.warehouseStorageBin);
        this.warehouseStorageBin = warehouseStorageBin;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InbDeliveryItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DeliveryDocument", getDeliveryDocument());
        result.put("DeliveryDocumentItem", getDeliveryDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ActualDeliveredQtyInBaseUnit", getActualDeliveredQtyInBaseUnit());
        values.put("ActualDeliveryQuantity", getActualDeliveryQuantity());
        values.put("AdditionalCustomerGroup1", getAdditionalCustomerGroup1());
        values.put("AdditionalCustomerGroup2", getAdditionalCustomerGroup2());
        values.put("AdditionalCustomerGroup3", getAdditionalCustomerGroup3());
        values.put("AdditionalCustomerGroup4", getAdditionalCustomerGroup4());
        values.put("AdditionalCustomerGroup5", getAdditionalCustomerGroup5());
        values.put("AdditionalMaterialGroup1", getAdditionalMaterialGroup1());
        values.put("AdditionalMaterialGroup2", getAdditionalMaterialGroup2());
        values.put("AdditionalMaterialGroup3", getAdditionalMaterialGroup3());
        values.put("AdditionalMaterialGroup4", getAdditionalMaterialGroup4());
        values.put("AdditionalMaterialGroup5", getAdditionalMaterialGroup5());
        values.put("AlternateProductNumber", getAlternateProductNumber());
        values.put("BaseUnit", getBaseUnit());
        values.put("Batch", getBatch());
        values.put("BatchBySupplier", getBatchBySupplier());
        values.put("BatchClassification", getBatchClassification());
        values.put("BOMExplosion", getBOMExplosion());
        values.put("BusinessArea", getBusinessArea());
        values.put("ConsumptionPosting", getConsumptionPosting());
        values.put("ControllingArea", getControllingArea());
        values.put("CostCenter", getCostCenter());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CustEngineeringChgStatus", getCustEngineeringChgStatus());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("DeliveryDocumentItem", getDeliveryDocumentItem());
        values.put("DeliveryDocumentItemCategory", getDeliveryDocumentItemCategory());
        values.put("DeliveryDocumentItemText", getDeliveryDocumentItemText());
        values.put("DeliveryGroup", getDeliveryGroup());
        values.put("DeliveryQuantityUnit", getDeliveryQuantityUnit());
        values.put("DeliveryRelatedBillingStatus", getDeliveryRelatedBillingStatus());
        values.put("DeliveryToBaseQuantityDnmntr", getDeliveryToBaseQuantityDnmntr());
        values.put("DeliveryToBaseQuantityNmrtr", getDeliveryToBaseQuantityNmrtr());
        values.put("DepartmentClassificationByCust", getDepartmentClassificationByCust());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("FixedShipgProcgDurationInDays", getFixedShipgProcgDurationInDays());
        values.put("GLAccount", getGLAccount());
        values.put("GoodsMovementReasonCode", getGoodsMovementReasonCode());
        values.put("GoodsMovementStatus", getGoodsMovementStatus());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("InspectionLot", getInspectionLot());
        values.put("InspectionPartialLot", getInspectionPartialLot());
        values.put("IntercompanyBillingStatus", getIntercompanyBillingStatus());
        values.put("InternationalArticleNumber", getInternationalArticleNumber());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("IsCompletelyDelivered", getIsCompletelyDelivered());
        values.put("IsNotGoodsMovementsRelevant", getIsNotGoodsMovementsRelevant());
        values.put("IsSeparateValuation", getIsSeparateValuation());
        values.put("IssgOrRcvgBatch", getIssgOrRcvgBatch());
        values.put("IssgOrRcvgMaterial", getIssgOrRcvgMaterial());
        values.put("IssgOrRcvgSpclStockInd", getIssgOrRcvgSpclStockInd());
        values.put("IssgOrRcvgStockCategory", getIssgOrRcvgStockCategory());
        values.put("IssgOrRcvgValuationType", getIssgOrRcvgValuationType());
        values.put("IssuingOrReceivingPlant", getIssuingOrReceivingPlant());
        values.put("IssuingOrReceivingStorageLoc", getIssuingOrReceivingStorageLoc());
        values.put("ItemBillingBlockReason", getItemBillingBlockReason());
        values.put("ItemBillingIncompletionStatus", getItemBillingIncompletionStatus());
        values.put("ItemDeliveryIncompletionStatus", getItemDeliveryIncompletionStatus());
        values.put("ItemGdsMvtIncompletionSts", getItemGdsMvtIncompletionSts());
        values.put("ItemGeneralIncompletionStatus", getItemGeneralIncompletionStatus());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemIsBillingRelevant", getItemIsBillingRelevant());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemPackingIncompletionStatus", getItemPackingIncompletionStatus());
        values.put("ItemPickingIncompletionStatus", getItemPickingIncompletionStatus());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LoadingGroup", getLoadingGroup());
        values.put("ManufactureDate", getManufactureDate());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("MaterialFreightGroup", getMaterialFreightGroup());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialIsBatchManaged", getMaterialIsBatchManaged());
        values.put("MaterialIsIntBatchManaged", getMaterialIsIntBatchManaged());
        values.put("NumberOfSerialNumbers", getNumberOfSerialNumbers());
        values.put("OrderID", getOrderID());
        values.put("OrderItem", getOrderItem());
        values.put("OriginalDeliveryQuantity", getOriginalDeliveryQuantity());
        values.put("OriginallyRequestedMaterial", getOriginallyRequestedMaterial());
        values.put("OverdelivTolrtdLmtRatioInPct", getOverdelivTolrtdLmtRatioInPct());
        values.put("PackingStatus", getPackingStatus());
        values.put("PartialDeliveryIsAllowed", getPartialDeliveryIsAllowed());
        values.put("PaymentGuaranteeForm", getPaymentGuaranteeForm());
        values.put("PickingConfirmationStatus", getPickingConfirmationStatus());
        values.put("PickingControl", getPickingControl());
        values.put("PickingStatus", getPickingStatus());
        values.put("Plant", getPlant());
        values.put("PrimaryPostingSwitch", getPrimaryPostingSwitch());
        values.put("ProductAvailabilityDate", getProductAvailabilityDate());
        values.put("ProductAvailabilityTime", getProductAvailabilityTime());
        values.put("ProductConfiguration", getProductConfiguration());
        values.put("ProductHierarchyNode", getProductHierarchyNode());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProofOfDeliveryRelevanceCode", getProofOfDeliveryRelevanceCode());
        values.put("ProofOfDeliveryStatus", getProofOfDeliveryStatus());
        values.put("QuantityIsFixed", getQuantityIsFixed());
        values.put("ReceivingPoint", getReceivingPoint());
        values.put("ReferenceDocumentLogicalSystem", getReferenceDocumentLogicalSystem());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentCategory", getReferenceSDDocumentCategory());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("RetailPromotion", getRetailPromotion());
        values.put("SalesDocumentItemType", getSalesDocumentItemType());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOffice", getSalesOffice());
        values.put("SDDocumentCategory", getSDDocumentCategory());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("ShelfLifeExpirationDate", getShelfLifeExpirationDate());
        values.put("StatisticsDate", getStatisticsDate());
        values.put("StockType", getStockType());
        values.put("StorageBin", getStorageBin());
        values.put("StorageLocation", getStorageLocation());
        values.put("StorageType", getStorageType());
        values.put("SubsequentMovementType", getSubsequentMovementType());
        values.put("TransportationGroup", getTransportationGroup());
        values.put("UnderdelivTolrtdLmtRatioInPct", getUnderdelivTolrtdLmtRatioInPct());
        values.put("UnlimitedOverdeliveryIsAllowed", getUnlimitedOverdeliveryIsAllowed());
        values.put("VarblShipgProcgDurationInDays", getVarblShipgProcgDurationInDays());
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseActivityStatus", getWarehouseActivityStatus());
        values.put("WarehouseStagingArea", getWarehouseStagingArea());
        values.put("DeliveryVersion", getDeliveryVersion());
        values.put("WarehouseStockCategory", getWarehouseStockCategory());
        values.put("WarehouseStorageBin", getWarehouseStorageBin());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ActualDeliveredQtyInBaseUnit") ) {
                final Object value = values.remove("ActualDeliveredQtyInBaseUnit");
                if( (value == null) || (!value.equals(getActualDeliveredQtyInBaseUnit())) ) {
                    setActualDeliveredQtyInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualDeliveryQuantity") ) {
                final Object value = values.remove("ActualDeliveryQuantity");
                if( (value == null) || (!value.equals(getActualDeliveryQuantity())) ) {
                    setActualDeliveryQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup1") ) {
                final Object value = values.remove("AdditionalCustomerGroup1");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup1())) ) {
                    setAdditionalCustomerGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup2") ) {
                final Object value = values.remove("AdditionalCustomerGroup2");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup2())) ) {
                    setAdditionalCustomerGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup3") ) {
                final Object value = values.remove("AdditionalCustomerGroup3");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup3())) ) {
                    setAdditionalCustomerGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup4") ) {
                final Object value = values.remove("AdditionalCustomerGroup4");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup4())) ) {
                    setAdditionalCustomerGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup5") ) {
                final Object value = values.remove("AdditionalCustomerGroup5");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup5())) ) {
                    setAdditionalCustomerGroup5(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup1") ) {
                final Object value = values.remove("AdditionalMaterialGroup1");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup1())) ) {
                    setAdditionalMaterialGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup2") ) {
                final Object value = values.remove("AdditionalMaterialGroup2");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup2())) ) {
                    setAdditionalMaterialGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup3") ) {
                final Object value = values.remove("AdditionalMaterialGroup3");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup3())) ) {
                    setAdditionalMaterialGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup4") ) {
                final Object value = values.remove("AdditionalMaterialGroup4");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup4())) ) {
                    setAdditionalMaterialGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup5") ) {
                final Object value = values.remove("AdditionalMaterialGroup5");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup5())) ) {
                    setAdditionalMaterialGroup5(((String) value));
                }
            }
            if( values.containsKey("AlternateProductNumber") ) {
                final Object value = values.remove("AlternateProductNumber");
                if( (value == null) || (!value.equals(getAlternateProductNumber())) ) {
                    setAlternateProductNumber(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BatchBySupplier") ) {
                final Object value = values.remove("BatchBySupplier");
                if( (value == null) || (!value.equals(getBatchBySupplier())) ) {
                    setBatchBySupplier(((String) value));
                }
            }
            if( values.containsKey("BatchClassification") ) {
                final Object value = values.remove("BatchClassification");
                if( (value == null) || (!value.equals(getBatchClassification())) ) {
                    setBatchClassification(((String) value));
                }
            }
            if( values.containsKey("BOMExplosion") ) {
                final Object value = values.remove("BOMExplosion");
                if( (value == null) || (!value.equals(getBOMExplosion())) ) {
                    setBOMExplosion(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ConsumptionPosting") ) {
                final Object value = values.remove("ConsumptionPosting");
                if( (value == null) || (!value.equals(getConsumptionPosting())) ) {
                    setConsumptionPosting(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CustEngineeringChgStatus") ) {
                final Object value = values.remove("CustEngineeringChgStatus");
                if( (value == null) || (!value.equals(getCustEngineeringChgStatus())) ) {
                    setCustEngineeringChgStatus(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItem") ) {
                final Object value = values.remove("DeliveryDocumentItem");
                if( (value == null) || (!value.equals(getDeliveryDocumentItem())) ) {
                    setDeliveryDocumentItem(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItemCategory") ) {
                final Object value = values.remove("DeliveryDocumentItemCategory");
                if( (value == null) || (!value.equals(getDeliveryDocumentItemCategory())) ) {
                    setDeliveryDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItemText") ) {
                final Object value = values.remove("DeliveryDocumentItemText");
                if( (value == null) || (!value.equals(getDeliveryDocumentItemText())) ) {
                    setDeliveryDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("DeliveryGroup") ) {
                final Object value = values.remove("DeliveryGroup");
                if( (value == null) || (!value.equals(getDeliveryGroup())) ) {
                    setDeliveryGroup(((String) value));
                }
            }
            if( values.containsKey("DeliveryQuantityUnit") ) {
                final Object value = values.remove("DeliveryQuantityUnit");
                if( (value == null) || (!value.equals(getDeliveryQuantityUnit())) ) {
                    setDeliveryQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("DeliveryRelatedBillingStatus") ) {
                final Object value = values.remove("DeliveryRelatedBillingStatus");
                if( (value == null) || (!value.equals(getDeliveryRelatedBillingStatus())) ) {
                    setDeliveryRelatedBillingStatus(((String) value));
                }
            }
            if( values.containsKey("DeliveryToBaseQuantityDnmntr") ) {
                final Object value = values.remove("DeliveryToBaseQuantityDnmntr");
                if( (value == null) || (!value.equals(getDeliveryToBaseQuantityDnmntr())) ) {
                    setDeliveryToBaseQuantityDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("DeliveryToBaseQuantityNmrtr") ) {
                final Object value = values.remove("DeliveryToBaseQuantityNmrtr");
                if( (value == null) || (!value.equals(getDeliveryToBaseQuantityNmrtr())) ) {
                    setDeliveryToBaseQuantityNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("DepartmentClassificationByCust") ) {
                final Object value = values.remove("DepartmentClassificationByCust");
                if( (value == null) || (!value.equals(getDepartmentClassificationByCust())) ) {
                    setDepartmentClassificationByCust(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("FixedShipgProcgDurationInDays") ) {
                final Object value = values.remove("FixedShipgProcgDurationInDays");
                if( (value == null) || (!value.equals(getFixedShipgProcgDurationInDays())) ) {
                    setFixedShipgProcgDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementReasonCode") ) {
                final Object value = values.remove("GoodsMovementReasonCode");
                if( (value == null) || (!value.equals(getGoodsMovementReasonCode())) ) {
                    setGoodsMovementReasonCode(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementStatus") ) {
                final Object value = values.remove("GoodsMovementStatus");
                if( (value == null) || (!value.equals(getGoodsMovementStatus())) ) {
                    setGoodsMovementStatus(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspectionPartialLot") ) {
                final Object value = values.remove("InspectionPartialLot");
                if( (value == null) || (!value.equals(getInspectionPartialLot())) ) {
                    setInspectionPartialLot(((String) value));
                }
            }
            if( values.containsKey("IntercompanyBillingStatus") ) {
                final Object value = values.remove("IntercompanyBillingStatus");
                if( (value == null) || (!value.equals(getIntercompanyBillingStatus())) ) {
                    setIntercompanyBillingStatus(((String) value));
                }
            }
            if( values.containsKey("InternationalArticleNumber") ) {
                final Object value = values.remove("InternationalArticleNumber");
                if( (value == null) || (!value.equals(getInternationalArticleNumber())) ) {
                    setInternationalArticleNumber(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("IsCompletelyDelivered") ) {
                final Object value = values.remove("IsCompletelyDelivered");
                if( (value == null) || (!value.equals(getIsCompletelyDelivered())) ) {
                    setIsCompletelyDelivered(((Boolean) value));
                }
            }
            if( values.containsKey("IsNotGoodsMovementsRelevant") ) {
                final Object value = values.remove("IsNotGoodsMovementsRelevant");
                if( (value == null) || (!value.equals(getIsNotGoodsMovementsRelevant())) ) {
                    setIsNotGoodsMovementsRelevant(((String) value));
                }
            }
            if( values.containsKey("IsSeparateValuation") ) {
                final Object value = values.remove("IsSeparateValuation");
                if( (value == null) || (!value.equals(getIsSeparateValuation())) ) {
                    setIsSeparateValuation(((Boolean) value));
                }
            }
            if( values.containsKey("IssgOrRcvgBatch") ) {
                final Object value = values.remove("IssgOrRcvgBatch");
                if( (value == null) || (!value.equals(getIssgOrRcvgBatch())) ) {
                    setIssgOrRcvgBatch(((String) value));
                }
            }
            if( values.containsKey("IssgOrRcvgMaterial") ) {
                final Object value = values.remove("IssgOrRcvgMaterial");
                if( (value == null) || (!value.equals(getIssgOrRcvgMaterial())) ) {
                    setIssgOrRcvgMaterial(((String) value));
                }
            }
            if( values.containsKey("IssgOrRcvgSpclStockInd") ) {
                final Object value = values.remove("IssgOrRcvgSpclStockInd");
                if( (value == null) || (!value.equals(getIssgOrRcvgSpclStockInd())) ) {
                    setIssgOrRcvgSpclStockInd(((String) value));
                }
            }
            if( values.containsKey("IssgOrRcvgStockCategory") ) {
                final Object value = values.remove("IssgOrRcvgStockCategory");
                if( (value == null) || (!value.equals(getIssgOrRcvgStockCategory())) ) {
                    setIssgOrRcvgStockCategory(((String) value));
                }
            }
            if( values.containsKey("IssgOrRcvgValuationType") ) {
                final Object value = values.remove("IssgOrRcvgValuationType");
                if( (value == null) || (!value.equals(getIssgOrRcvgValuationType())) ) {
                    setIssgOrRcvgValuationType(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingPlant") ) {
                final Object value = values.remove("IssuingOrReceivingPlant");
                if( (value == null) || (!value.equals(getIssuingOrReceivingPlant())) ) {
                    setIssuingOrReceivingPlant(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingStorageLoc") ) {
                final Object value = values.remove("IssuingOrReceivingStorageLoc");
                if( (value == null) || (!value.equals(getIssuingOrReceivingStorageLoc())) ) {
                    setIssuingOrReceivingStorageLoc(((String) value));
                }
            }
            if( values.containsKey("ItemBillingBlockReason") ) {
                final Object value = values.remove("ItemBillingBlockReason");
                if( (value == null) || (!value.equals(getItemBillingBlockReason())) ) {
                    setItemBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("ItemBillingIncompletionStatus") ) {
                final Object value = values.remove("ItemBillingIncompletionStatus");
                if( (value == null) || (!value.equals(getItemBillingIncompletionStatus())) ) {
                    setItemBillingIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("ItemDeliveryIncompletionStatus") ) {
                final Object value = values.remove("ItemDeliveryIncompletionStatus");
                if( (value == null) || (!value.equals(getItemDeliveryIncompletionStatus())) ) {
                    setItemDeliveryIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("ItemGdsMvtIncompletionSts") ) {
                final Object value = values.remove("ItemGdsMvtIncompletionSts");
                if( (value == null) || (!value.equals(getItemGdsMvtIncompletionSts())) ) {
                    setItemGdsMvtIncompletionSts(((String) value));
                }
            }
            if( values.containsKey("ItemGeneralIncompletionStatus") ) {
                final Object value = values.remove("ItemGeneralIncompletionStatus");
                if( (value == null) || (!value.equals(getItemGeneralIncompletionStatus())) ) {
                    setItemGeneralIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemIsBillingRelevant") ) {
                final Object value = values.remove("ItemIsBillingRelevant");
                if( (value == null) || (!value.equals(getItemIsBillingRelevant())) ) {
                    setItemIsBillingRelevant(((String) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemPackingIncompletionStatus") ) {
                final Object value = values.remove("ItemPackingIncompletionStatus");
                if( (value == null) || (!value.equals(getItemPackingIncompletionStatus())) ) {
                    setItemPackingIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("ItemPickingIncompletionStatus") ) {
                final Object value = values.remove("ItemPickingIncompletionStatus");
                if( (value == null) || (!value.equals(getItemPickingIncompletionStatus())) ) {
                    setItemPickingIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LoadingGroup") ) {
                final Object value = values.remove("LoadingGroup");
                if( (value == null) || (!value.equals(getLoadingGroup())) ) {
                    setLoadingGroup(((String) value));
                }
            }
            if( values.containsKey("ManufactureDate") ) {
                final Object value = values.remove("ManufactureDate");
                if( (value == null) || (!value.equals(getManufactureDate())) ) {
                    setManufactureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("MaterialFreightGroup") ) {
                final Object value = values.remove("MaterialFreightGroup");
                if( (value == null) || (!value.equals(getMaterialFreightGroup())) ) {
                    setMaterialFreightGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialIsBatchManaged") ) {
                final Object value = values.remove("MaterialIsBatchManaged");
                if( (value == null) || (!value.equals(getMaterialIsBatchManaged())) ) {
                    setMaterialIsBatchManaged(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialIsIntBatchManaged") ) {
                final Object value = values.remove("MaterialIsIntBatchManaged");
                if( (value == null) || (!value.equals(getMaterialIsIntBatchManaged())) ) {
                    setMaterialIsIntBatchManaged(((Boolean) value));
                }
            }
            if( values.containsKey("NumberOfSerialNumbers") ) {
                final Object value = values.remove("NumberOfSerialNumbers");
                if( (value == null) || (!value.equals(getNumberOfSerialNumbers())) ) {
                    setNumberOfSerialNumbers(((Integer) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OrderItem") ) {
                final Object value = values.remove("OrderItem");
                if( (value == null) || (!value.equals(getOrderItem())) ) {
                    setOrderItem(((String) value));
                }
            }
            if( values.containsKey("OriginalDeliveryQuantity") ) {
                final Object value = values.remove("OriginalDeliveryQuantity");
                if( (value == null) || (!value.equals(getOriginalDeliveryQuantity())) ) {
                    setOriginalDeliveryQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OriginallyRequestedMaterial") ) {
                final Object value = values.remove("OriginallyRequestedMaterial");
                if( (value == null) || (!value.equals(getOriginallyRequestedMaterial())) ) {
                    setOriginallyRequestedMaterial(((String) value));
                }
            }
            if( values.containsKey("OverdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("OverdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getOverdelivTolrtdLmtRatioInPct())) ) {
                    setOverdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("PackingStatus") ) {
                final Object value = values.remove("PackingStatus");
                if( (value == null) || (!value.equals(getPackingStatus())) ) {
                    setPackingStatus(((String) value));
                }
            }
            if( values.containsKey("PartialDeliveryIsAllowed") ) {
                final Object value = values.remove("PartialDeliveryIsAllowed");
                if( (value == null) || (!value.equals(getPartialDeliveryIsAllowed())) ) {
                    setPartialDeliveryIsAllowed(((String) value));
                }
            }
            if( values.containsKey("PaymentGuaranteeForm") ) {
                final Object value = values.remove("PaymentGuaranteeForm");
                if( (value == null) || (!value.equals(getPaymentGuaranteeForm())) ) {
                    setPaymentGuaranteeForm(((String) value));
                }
            }
            if( values.containsKey("PickingConfirmationStatus") ) {
                final Object value = values.remove("PickingConfirmationStatus");
                if( (value == null) || (!value.equals(getPickingConfirmationStatus())) ) {
                    setPickingConfirmationStatus(((String) value));
                }
            }
            if( values.containsKey("PickingControl") ) {
                final Object value = values.remove("PickingControl");
                if( (value == null) || (!value.equals(getPickingControl())) ) {
                    setPickingControl(((String) value));
                }
            }
            if( values.containsKey("PickingStatus") ) {
                final Object value = values.remove("PickingStatus");
                if( (value == null) || (!value.equals(getPickingStatus())) ) {
                    setPickingStatus(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PrimaryPostingSwitch") ) {
                final Object value = values.remove("PrimaryPostingSwitch");
                if( (value == null) || (!value.equals(getPrimaryPostingSwitch())) ) {
                    setPrimaryPostingSwitch(((String) value));
                }
            }
            if( values.containsKey("ProductAvailabilityDate") ) {
                final Object value = values.remove("ProductAvailabilityDate");
                if( (value == null) || (!value.equals(getProductAvailabilityDate())) ) {
                    setProductAvailabilityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductAvailabilityTime") ) {
                final Object value = values.remove("ProductAvailabilityTime");
                if( (value == null) || (!value.equals(getProductAvailabilityTime())) ) {
                    setProductAvailabilityTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ProductConfiguration") ) {
                final Object value = values.remove("ProductConfiguration");
                if( (value == null) || (!value.equals(getProductConfiguration())) ) {
                    setProductConfiguration(((String) value));
                }
            }
            if( values.containsKey("ProductHierarchyNode") ) {
                final Object value = values.remove("ProductHierarchyNode");
                if( (value == null) || (!value.equals(getProductHierarchyNode())) ) {
                    setProductHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProofOfDeliveryRelevanceCode") ) {
                final Object value = values.remove("ProofOfDeliveryRelevanceCode");
                if( (value == null) || (!value.equals(getProofOfDeliveryRelevanceCode())) ) {
                    setProofOfDeliveryRelevanceCode(((String) value));
                }
            }
            if( values.containsKey("ProofOfDeliveryStatus") ) {
                final Object value = values.remove("ProofOfDeliveryStatus");
                if( (value == null) || (!value.equals(getProofOfDeliveryStatus())) ) {
                    setProofOfDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("QuantityIsFixed") ) {
                final Object value = values.remove("QuantityIsFixed");
                if( (value == null) || (!value.equals(getQuantityIsFixed())) ) {
                    setQuantityIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("ReceivingPoint") ) {
                final Object value = values.remove("ReceivingPoint");
                if( (value == null) || (!value.equals(getReceivingPoint())) ) {
                    setReceivingPoint(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentLogicalSystem") ) {
                final Object value = values.remove("ReferenceDocumentLogicalSystem");
                if( (value == null) || (!value.equals(getReferenceDocumentLogicalSystem())) ) {
                    setReferenceDocumentLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentCategory") ) {
                final Object value = values.remove("ReferenceSDDocumentCategory");
                if( (value == null) || (!value.equals(getReferenceSDDocumentCategory())) ) {
                    setReferenceSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("RetailPromotion") ) {
                final Object value = values.remove("RetailPromotion");
                if( (value == null) || (!value.equals(getRetailPromotion())) ) {
                    setRetailPromotion(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItemType") ) {
                final Object value = values.remove("SalesDocumentItemType");
                if( (value == null) || (!value.equals(getSalesDocumentItemType())) ) {
                    setSalesDocumentItemType(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SDDocumentCategory") ) {
                final Object value = values.remove("SDDocumentCategory");
                if( (value == null) || (!value.equals(getSDDocumentCategory())) ) {
                    setSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDate") ) {
                final Object value = values.remove("ShelfLifeExpirationDate");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDate())) ) {
                    setShelfLifeExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StatisticsDate") ) {
                final Object value = values.remove("StatisticsDate");
                if( (value == null) || (!value.equals(getStatisticsDate())) ) {
                    setStatisticsDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StockType") ) {
                final Object value = values.remove("StockType");
                if( (value == null) || (!value.equals(getStockType())) ) {
                    setStockType(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("SubsequentMovementType") ) {
                final Object value = values.remove("SubsequentMovementType");
                if( (value == null) || (!value.equals(getSubsequentMovementType())) ) {
                    setSubsequentMovementType(((String) value));
                }
            }
            if( values.containsKey("TransportationGroup") ) {
                final Object value = values.remove("TransportationGroup");
                if( (value == null) || (!value.equals(getTransportationGroup())) ) {
                    setTransportationGroup(((String) value));
                }
            }
            if( values.containsKey("UnderdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("UnderdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getUnderdelivTolrtdLmtRatioInPct())) ) {
                    setUnderdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverdeliveryIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverdeliveryIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverdeliveryIsAllowed())) ) {
                    setUnlimitedOverdeliveryIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("VarblShipgProcgDurationInDays") ) {
                final Object value = values.remove("VarblShipgProcgDurationInDays");
                if( (value == null) || (!value.equals(getVarblShipgProcgDurationInDays())) ) {
                    setVarblShipgProcgDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseActivityStatus") ) {
                final Object value = values.remove("WarehouseActivityStatus");
                if( (value == null) || (!value.equals(getWarehouseActivityStatus())) ) {
                    setWarehouseActivityStatus(((String) value));
                }
            }
            if( values.containsKey("WarehouseStagingArea") ) {
                final Object value = values.remove("WarehouseStagingArea");
                if( (value == null) || (!value.equals(getWarehouseStagingArea())) ) {
                    setWarehouseStagingArea(((String) value));
                }
            }
            if( values.containsKey("DeliveryVersion") ) {
                final Object value = values.remove("DeliveryVersion");
                if( (value == null) || (!value.equals(getDeliveryVersion())) ) {
                    setDeliveryVersion(((String) value));
                }
            }
            if( values.containsKey("WarehouseStockCategory") ) {
                final Object value = values.remove("WarehouseStockCategory");
                if( (value == null) || (!value.equals(getWarehouseStockCategory())) ) {
                    setWarehouseStockCategory(((String) value));
                }
            }
            if( values.containsKey("WarehouseStorageBin") ) {
                final Object value = values.remove("WarehouseStorageBin");
                if( (value == null) || (!value.equals(getWarehouseStorageBin())) ) {
                    setWarehouseStorageBin(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SerialDeliveryItem") ) {
                final Object value = (values).remove("to_SerialDeliveryItem");
                if( value instanceof Map ) {
                    if( toSerialDeliveryItem == null ) {
                        toSerialDeliveryItem = new InbDeliverySerialNmbr();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSerialDeliveryItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_DocumentFlow") ) {
                final Object value = (values).remove("to_DocumentFlow");
                if( value instanceof Iterable ) {
                    if( toDocumentFlow == null ) {
                        toDocumentFlow = Lists.newArrayList();
                    } else {
                        toDocumentFlow = Lists.newArrayList(toDocumentFlow);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InbDeliveryDocFlow entity;
                        if( toDocumentFlow.size() > i ) {
                            entity = toDocumentFlow.get(i);
                        } else {
                            entity = new InbDeliveryDocFlow();
                            toDocumentFlow.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InbDeliveryItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InbDeliveryItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InbDeliveryItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InbDeliveryItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSerialDeliveryItem != null ) {
            (values).put("to_SerialDeliveryItem", toSerialDeliveryItem);
        }
        if( toDocumentFlow != null ) {
            (values).put("to_DocumentFlow", toDocumentFlow);
        }
        return values;
    }

    /**
     * Fetches the <b>InbDeliverySerialNmbr</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SerialDeliveryItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>InbDeliverySerialNmbr</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InbDeliverySerialNmbr fetchSerialDeliveryItem()
    {
        return fetchFieldAsSingle("to_SerialDeliveryItem", InbDeliverySerialNmbr.class);
    }

    /**
     * Retrieval of associated <b>InbDeliverySerialNmbr</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SerialDeliveryItem</b>.
     * <p>
     * If the navigation property <b>to_SerialDeliveryItem</b> of a queried <b>InbDeliveryItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InbDeliverySerialNmbr</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InbDeliverySerialNmbr getSerialDeliveryItemOrFetch()
    {
        if( toSerialDeliveryItem == null ) {
            toSerialDeliveryItem = fetchSerialDeliveryItem();
        }
        return toSerialDeliveryItem;
    }

    /**
     * Retrieval of associated <b>InbDeliverySerialNmbr</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SerialDeliveryItem</b>.
     * <p>
     * If the navigation property for an entity <b>InbDeliveryItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SerialDeliveryItem</b> is already loaded, the result
     *         will contain the <b>InbDeliverySerialNmbr</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<InbDeliverySerialNmbr> getSerialDeliveryItemIfPresent()
    {
        return Option.of(toSerialDeliveryItem);
    }

    /**
     * Overwrites the associated <b>InbDeliverySerialNmbr</b> entity for the loaded navigation property
     * <b>to_SerialDeliveryItem</b>.
     *
     * @param value
     *            New <b>InbDeliverySerialNmbr</b> entity.
     */
    public void setSerialDeliveryItem( final InbDeliverySerialNmbr value )
    {
        toSerialDeliveryItem = value;
    }

    /**
     * Fetches the <b>InbDeliveryDocFlow</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DocumentFlow</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InbDeliveryDocFlow</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InbDeliveryDocFlow> fetchDocumentFlow()
    {
        return fetchFieldAsList("to_DocumentFlow", InbDeliveryDocFlow.class);
    }

    /**
     * Retrieval of associated <b>InbDeliveryDocFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DocumentFlow</b>.
     * <p>
     * If the navigation property <b>to_DocumentFlow</b> of a queried <b>InbDeliveryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InbDeliveryDocFlow</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InbDeliveryDocFlow> getDocumentFlowOrFetch()
    {
        if( toDocumentFlow == null ) {
            toDocumentFlow = fetchDocumentFlow();
        }
        return toDocumentFlow;
    }

    /**
     * Retrieval of associated <b>InbDeliveryDocFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DocumentFlow</b>.
     * <p>
     * If the navigation property for an entity <b>InbDeliveryItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DocumentFlow</b> is already loaded, the result will
     *         contain the <b>InbDeliveryDocFlow</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InbDeliveryDocFlow>> getDocumentFlowIfPresent()
    {
        return Option.of(toDocumentFlow);
    }

    /**
     * Overwrites the list of associated <b>InbDeliveryDocFlow</b> entities for the loaded navigation property
     * <b>to_DocumentFlow</b>.
     * <p>
     * If the navigation property <b>to_DocumentFlow</b> of a queried <b>InbDeliveryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InbDeliveryDocFlow</b> entities.
     */
    public void setDocumentFlow( @Nonnull final List<InbDeliveryDocFlow> value )
    {
        if( toDocumentFlow == null ) {
            toDocumentFlow = Lists.newArrayList();
        }
        toDocumentFlow.clear();
        toDocumentFlow.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InbDeliveryDocFlow</b> entities. This corresponds to the OData
     * navigation property <b>to_DocumentFlow</b>.
     * <p>
     * If the navigation property <b>to_DocumentFlow</b> of a queried <b>InbDeliveryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InbDeliveryDocFlow</b> entities.
     */
    public void addDocumentFlow( InbDeliveryDocFlow... entity )
    {
        if( toDocumentFlow == null ) {
            toDocumentFlow = Lists.newArrayList();
        }
        toDocumentFlow.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of InbDeliveryItem instances.
     *
     */
    public final static class InbDeliveryItemBuilder
    {

        private InbDeliverySerialNmbr toSerialDeliveryItem;
        private List<InbDeliveryDocFlow> toDocumentFlow = Lists.newArrayList();

        private InbDeliveryItem.InbDeliveryItemBuilder toSerialDeliveryItem( final InbDeliverySerialNmbr value )
        {
            toSerialDeliveryItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SerialDeliveryItem</b> for <b>InbDeliveryItem</b> to single
         * <b>InbDeliverySerialNmbr</b>.
         *
         * @param value
         *            The InbDeliverySerialNmbr to build this InbDeliveryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InbDeliveryItem.InbDeliveryItemBuilder serialDeliveryItem( final InbDeliverySerialNmbr value )
        {
            return toSerialDeliveryItem(value);
        }

        private InbDeliveryItem.InbDeliveryItemBuilder toDocumentFlow( final List<InbDeliveryDocFlow> value )
        {
            toDocumentFlow.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_DocumentFlow</b> for <b>InbDeliveryItem</b> to multiple <b>InbDeliveryDocFlow</b>.
         *
         * @param value
         *            The InbDeliveryDocFlows to build this InbDeliveryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InbDeliveryItem.InbDeliveryItemBuilder documentFlow( InbDeliveryDocFlow... value )
        {
            return toDocumentFlow(Lists.newArrayList(value));
        }

    }

}
