/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.field.MaintenanceItemObjListField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.selectable.MaintenanceItemObjListSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_MaintenanceItemObjListType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceItemObjList extends VdmEntity<MaintenanceItemObjList>
{

    /**
     * Selector for all available fields of MaintenanceItemObjList.
     *
     */
    public final static MaintenanceItemObjListSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Assembly
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<String> ASSEMBLY =
        new MaintenanceItemObjListField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<String> EQUIPMENT =
        new MaintenanceItemObjListField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional loc.
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<String> FUNCTIONAL_LOCATION =
        new MaintenanceItemObjListField<String>("FunctionalLocation");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObject</b>
     * </p>
     *
     * @return Object counters
     */
    @Key
    @SerializedName( "MaintenanceItemObject" )
    @JsonProperty( "MaintenanceItemObject" )
    @Nullable
    @ODataField( odataName = "MaintenanceItemObject" )
    private Integer maintenanceItemObject;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItemObject</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<Integer> MAINTENANCE_ITEM_OBJECT =
        new MaintenanceItemObjListField<Integer>("MaintenanceItemObject");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @return Object list
     */
    @Key
    @SerializedName( "MaintenanceItemObjectList" )
    @JsonProperty( "MaintenanceItemObjectList" )
    @Nullable
    @ODataField( odataName = "MaintenanceItemObjectList" )
    private Integer maintenanceItemObjectList;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItemObjectList</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<Integer> MAINTENANCE_ITEM_OBJECT_LIST =
        new MaintenanceItemObjListField<Integer>("MaintenanceItemObjectList");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification
     */
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<String> MAINTENANCE_NOTIFICATION =
        new MaintenanceItemObjListField<String>("MaintenanceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectLocAcctAssgmtNmbr</b>
     * </p>
     *
     * @return Loc/AccAssmt
     */
    @SerializedName( "MaintObjectLocAcctAssgmtNmbr" )
    @JsonProperty( "MaintObjectLocAcctAssgmtNmbr" )
    @Nullable
    @ODataField( odataName = "MaintObjectLocAcctAssgmtNmbr" )
    private String maintObjectLocAcctAssgmtNmbr;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectLocAcctAssgmtNmbr</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<String> MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR =
        new MaintenanceItemObjListField<String>("MaintObjectLocAcctAssgmtNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<String> MATERIAL =
        new MaintenanceItemObjListField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static MaintenanceItemObjListField<String> SERIAL_NUMBER =
        new MaintenanceItemObjListField<String>("SerialNumber");

    @Nonnull
    @Override
    public Class<MaintenanceItemObjList> getType()
    {
        return MaintenanceItemObjList.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional loc.
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObject</b>
     * </p>
     *
     * @param maintenanceItemObject
     *            Object counters
     */
    public void setMaintenanceItemObject( @Nullable final Integer maintenanceItemObject )
    {
        rememberChangedField("MaintenanceItemObject", this.maintenanceItemObject);
        this.maintenanceItemObject = maintenanceItemObject;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @param maintenanceItemObjectList
     *            Object list
     */
    public void setMaintenanceItemObjectList( @Nullable final Integer maintenanceItemObjectList )
    {
        rememberChangedField("MaintenanceItemObjectList", this.maintenanceItemObjectList);
        this.maintenanceItemObjectList = maintenanceItemObjectList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectLocAcctAssgmtNmbr</b>
     * </p>
     *
     * @param maintObjectLocAcctAssgmtNmbr
     *            Loc/AccAssmt
     */
    public void setMaintObjectLocAcctAssgmtNmbr( @Nullable final String maintObjectLocAcctAssgmtNmbr )
    {
        rememberChangedField("MaintObjectLocAcctAssgmtNmbr", this.maintObjectLocAcctAssgmtNmbr);
        this.maintObjectLocAcctAssgmtNmbr = maintObjectLocAcctAssgmtNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_MaintenanceItemObjList";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceItemObject", getMaintenanceItemObject());
        result.put("MaintenanceItemObjectList", getMaintenanceItemObjectList());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Assembly", getAssembly());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("MaintenanceItemObject", getMaintenanceItemObject());
        values.put("MaintenanceItemObjectList", getMaintenanceItemObjectList());
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("MaintObjectLocAcctAssgmtNmbr", getMaintObjectLocAcctAssgmtNmbr());
        values.put("Material", getMaterial());
        values.put("SerialNumber", getSerialNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceItemObject") ) {
                final Object value = values.remove("MaintenanceItemObject");
                if( (value == null) || (!value.equals(getMaintenanceItemObject())) ) {
                    setMaintenanceItemObject(((Integer) value));
                }
            }
            if( values.containsKey("MaintenanceItemObjectList") ) {
                final Object value = values.remove("MaintenanceItemObjectList");
                if( (value == null) || (!value.equals(getMaintenanceItemObjectList())) ) {
                    setMaintenanceItemObjectList(((Integer) value));
                }
            }
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("MaintObjectLocAcctAssgmtNmbr") ) {
                final Object value = values.remove("MaintObjectLocAcctAssgmtNmbr");
                if( (value == null) || (!value.equals(getMaintObjectLocAcctAssgmtNmbr())) ) {
                    setMaintObjectLocAcctAssgmtNmbr(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceItemObjListField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceItemObjListField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceItemObjListField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceItemObjListField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

}
