/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link InboundDeliveryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService InboundDeliveryService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultInboundDeliveryServiceBatch
    extends
    BatchFluentHelperBasic<InboundDeliveryServiceBatch, InboundDeliveryServiceBatchChangeSet>
    implements
    InboundDeliveryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultInboundDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultInboundDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultInboundDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultInboundDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultInboundDeliveryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public InboundDeliveryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultInboundDeliveryServiceBatchChangeSet(this, service);
    }

}
