/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItem;

/**
 * Implementation of the {@link InboundDeliveryServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService InboundDeliveryService}.
 *
 */
public class DefaultInboundDeliveryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<InboundDeliveryServiceBatch, InboundDeliveryServiceBatchChangeSet>
    implements
    InboundDeliveryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService service;

    @SuppressWarnings( "deprecation" )
    DefaultInboundDeliveryServiceBatchChangeSet(
        @Nonnull final DefaultInboundDeliveryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultInboundDeliveryServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public InboundDeliveryServiceBatchChangeSet updateInbDeliveryDocFlow(
        @Nonnull final InbDeliveryDocFlow inbDeliveryDocFlow )
    {
        return addRequestUpdate(service::updateInbDeliveryDocFlow, inbDeliveryDocFlow);
    }

    @Nonnull
    @Override
    public InboundDeliveryServiceBatchChangeSet createInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return addRequestCreate(service::createInbDeliveryHeader, inbDeliveryHeader);
    }

    @Nonnull
    @Override
    public InboundDeliveryServiceBatchChangeSet updateInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return addRequestUpdate(service::updateInbDeliveryHeader, inbDeliveryHeader);
    }

    @Nonnull
    @Override
    public InboundDeliveryServiceBatchChangeSet deleteInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return addRequestDelete(service::deleteInbDeliveryHeader, inbDeliveryHeader);
    }

    @Nonnull
    @Override
    public InboundDeliveryServiceBatchChangeSet updateInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return addRequestUpdate(service::updateInbDeliveryItem, inbDeliveryItem);
    }

    @Nonnull
    @Override
    public InboundDeliveryServiceBatchChangeSet deleteInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return addRequestDelete(service::deleteInbDeliveryItem, inbDeliveryItem);
    }

}
