/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryService InboundDeliveryService}.
 *
 */
public interface InboundDeliveryServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<InboundDeliveryServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<InboundDeliveryServiceBatch>
{

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryDocFlow
     * InbDeliveryDocFlow} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryDocFlow
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryDocFlow
     *            InbDeliveryDocFlow} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryServiceBatchChangeSet
        updateInbDeliveryDocFlow( @Nonnull final InbDeliveryDocFlow inbDeliveryDocFlow );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader
     * InbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryServiceBatchChangeSet createInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader
     * InbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryServiceBatchChangeSet updateInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader
     * InbDeliveryHeader} entity in the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryServiceBatchChangeSet deleteInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItem
     * InbDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItem
     *            InbDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryServiceBatchChangeSet updateInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItem
     * InbDeliveryItem} entity in the S/4HANA system.
     *
     * @param inbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddelivery.InbDeliveryItem
     *            InbDeliveryItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryServiceBatchChangeSet deleteInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem );

}
