/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.selectable.InbDeliverySerialNmbrSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliverySerialNmbr
 * InbDeliverySerialNmbr} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class InbDeliverySerialNmbrByKeyFluentHelper
    extends
    FluentHelperByKey<InbDeliverySerialNmbrByKeyFluentHelper, InbDeliverySerialNmbr, InbDeliverySerialNmbrSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliverySerialNmbr
     * InbDeliverySerialNmbr} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InbDeliverySerialNmbr}
     * @param servicePath
     *            Service path to be used to fetch a single {@code InbDeliverySerialNmbr}
     * @param maintenanceItemObjectList
     *            Object list
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public InbDeliverySerialNmbrByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final Long maintenanceItemObjectList )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceItemObjectList", maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    protected Class<InbDeliverySerialNmbr> getEntityClass()
    {
        return InbDeliverySerialNmbr.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
