/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2;

import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.CollectionValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>SetPutawayQuantityWithBaseQuantity</b> OData function import.
 *
 */
public class SetPutawayQuantityWithBaseQuantityFluentHelper
    extends
    CollectionValuedFluentHelperFunction<SetPutawayQuantityWithBaseQuantityFluentHelper, PutawayReport, List<PutawayReport>>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>SetPutawayQuantityWithBaseQuantity</b> OData function
     * import with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param baseUnit
     *            Base Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BaseUnit</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param actualDeliveredQtyInBaseUnit
     *            Qty (stckp.unt)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveredQtyInBaseUnit</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     */
    public SetPutawayQuantityWithBaseQuantityFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String baseUnit,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem )
    {
        super(servicePath);
        values.put("ActualDeliveredQtyInBaseUnit", actualDeliveredQtyInBaseUnit);
        values.put("BaseUnit", baseUnit);
        values.put("DeliveryDocument", deliveryDocument);
        values.put("DeliveryDocumentItem", deliveryDocumentItem);
    }

    @Override
    @Nonnull
    protected Class<PutawayReport> getEntityClass()
    {
        return PutawayReport.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "SetPutawayQuantityWithBaseQuantity";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nonnull
    public List<PutawayReport> executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeMultiple(destination);
    }

}
