/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem;

/**
 * Implementation of the {@link InboundDeliveryV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryV2Service InboundDeliveryV2Service}.
 *
 */
public class DefaultInboundDeliveryV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<InboundDeliveryV2ServiceBatch, InboundDeliveryV2ServiceBatchChangeSet>
    implements
    InboundDeliveryV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultInboundDeliveryV2ServiceBatchChangeSet(
        @Nonnull final DefaultInboundDeliveryV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultInboundDeliveryV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public InboundDeliveryV2ServiceBatchChangeSet updateInbDeliveryDocFlow(
        @Nonnull final InbDeliveryDocFlow inbDeliveryDocFlow )
    {
        return addRequestUpdate(service::updateInbDeliveryDocFlow, inbDeliveryDocFlow);
    }

    @Nonnull
    @Override
    public InboundDeliveryV2ServiceBatchChangeSet createInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return addRequestCreate(service::createInbDeliveryHeader, inbDeliveryHeader);
    }

    @Nonnull
    @Override
    public InboundDeliveryV2ServiceBatchChangeSet updateInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return addRequestUpdate(service::updateInbDeliveryHeader, inbDeliveryHeader);
    }

    @Nonnull
    @Override
    public InboundDeliveryV2ServiceBatchChangeSet deleteInbDeliveryHeader(
        @Nonnull final InbDeliveryHeader inbDeliveryHeader )
    {
        return addRequestDelete(service::deleteInbDeliveryHeader, inbDeliveryHeader);
    }

    @Nonnull
    @Override
    public InboundDeliveryV2ServiceBatchChangeSet updateInbDeliveryItem(
        @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return addRequestUpdate(service::updateInbDeliveryItem, inbDeliveryItem);
    }

    @Nonnull
    @Override
    public InboundDeliveryV2ServiceBatchChangeSet deleteInbDeliveryItem(
        @Nonnull final InbDeliveryItem inbDeliveryItem )
    {
        return addRequestDelete(service::deleteInbDeliveryItem, inbDeliveryItem);
    }

}
