/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InboundDeliveryV2Service InboundDeliveryV2Service}.
 *
 */
public interface InboundDeliveryV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<InboundDeliveryV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<InboundDeliveryV2ServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow
     * InbDeliveryDocFlow} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryDocFlow
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow
     *            InbDeliveryDocFlow} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryV2ServiceBatchChangeSet
        updateInbDeliveryDocFlow( @Nonnull final InbDeliveryDocFlow inbDeliveryDocFlow );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     * InbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryV2ServiceBatchChangeSet
        createInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     * InbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryV2ServiceBatchChangeSet
        updateInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader InbDeliveryHeader}
     * entity in the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryV2ServiceBatchChangeSet
        deleteInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     * InbDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *            InbDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryV2ServiceBatchChangeSet updateInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     * InbDeliveryItem} entity in the S/4HANA system.
     *
     * @param inbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *            InbDeliveryItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InboundDeliveryV2ServiceBatchChangeSet deleteInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem );

}
