/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress InbDeliveryAddress}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.field.InbDeliveryAddressField
 * InbDeliveryAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.link.InbDeliveryAddressLink
 * InbDeliveryAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#ADDITIONAL_STREET_PREFIX_NAME
 * ADDITIONAL_STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#ADDITIONAL_STREET_SUFFIX_NAME
 * ADDITIONAL_STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#ADDRESS_TIME_ZONE
 * ADDRESS_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#BUILDING
 * BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#BUSINESS_PARTNER_NAME1
 * BUSINESS_PARTNER_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#BUSINESS_PARTNER_NAME2
 * BUSINESS_PARTNER_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#BUSINESS_PARTNER_NAME3
 * BUSINESS_PARTNER_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#BUSINESS_PARTNER_NAME4
 * BUSINESS_PARTNER_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#CARE_OF_NAME
 * CARE_OF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#CITY_CODE
 * CITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#CITY_SEARCH
 * CITY_SEARCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#COMPANY_POSTAL_CODE
 * COMPANY_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#COUNTY
 * COUNTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#DELIVERY_SERVICE_NUMBER
 * DELIVERY_SERVICE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#DELIVERY_SERVICE_TYPE_CODE
 * DELIVERY_SERVICE_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#DISTRICT
 * DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#FAX_NUMBER
 * FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#FLOOR FLOOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#FULL_NAME
 * FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#HOME_CITY_NAME
 * HOME_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#HOUSE_NUMBER_SUPPLEMENT_TEXT
 * HOUSE_NUMBER_SUPPLEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#NATION
 * NATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PERSON
 * PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PO_BOX
 * PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PO_BOX_DEVIATING_CITY_NAME
 * PO_BOX_DEVIATING_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PO_BOX_DEVIATING_COUNTRY
 * PO_BOX_DEVIATING_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PO_BOX_DEVIATING_REGION
 * PO_BOX_DEVIATING_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PO_BOX_IS_WITHOUT_NUMBER
 * PO_BOX_IS_WITHOUT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PO_BOX_LOBBY_NAME
 * PO_BOX_LOBBY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#PRFRD_COMM_MEDIUM_TYPE
 * PRFRD_COMM_MEDIUM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#ROOM_NUMBER
 * ROOM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#SEARCH_TERM1
 * SEARCH_TERM1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#STREET_PREFIX_NAME
 * STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#STREET_SEARCH
 * STREET_SEARCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#STREET_SUFFIX_NAME
 * STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryAddress#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * </ul>
 *
 */
public interface InbDeliveryAddressSelectable extends EntitySelectable<InbDeliveryAddress>
{

}
