/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText
 * InbDeliveryItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.field.InbDeliveryItemTextField
 * InbDeliveryItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.link.InbDeliveryItemTextLink
 * InbDeliveryItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText#DELIVERY_DOCUMENT_ITEM
 * DELIVERY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText#TEXT_ELEMENT
 * TEXT_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText#TEXT_ELEMENT_DESCRIPTION
 * TEXT_ELEMENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText#TEXT_ELEMENT_TEXT
 * TEXT_ELEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemText#DELIVERY_LONG_TEXT_IS_FORMATTED
 * DELIVERY_LONG_TEXT_IS_FORMATTED}</li>
 * </ul>
 *
 */
public interface InbDeliveryItemTextSelectable extends EntitySelectable<InbDeliveryItemText>
{

}
