/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner InbDeliveryPartner}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.field.InbDeliveryPartnerField
 * InbDeliveryPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.link.InbDeliveryPartnerLink
 * InbDeliveryPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#SD_DOCUMENT
 * SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#SD_DOCUMENT_ITEM
 * SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner#TO_ADDRESS
 * TO_ADDRESS}</li>
 * </ul>
 *
 */
public interface InbDeliveryPartnerSelectable extends EntitySelectable<InbDeliveryPartner>
{

}
