/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList
 * MaintenanceItemObjList}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.field.MaintenanceItemObjListField
 * MaintenanceItemObjListField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.link.MaintenanceItemObjListLink
 * MaintenanceItemObjListLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#MAINTENANCE_ITEM_OBJECT
 * MAINTENANCE_ITEM_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#MAINTENANCE_ITEM_OBJECT_LIST
 * MAINTENANCE_ITEM_OBJECT_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR
 * MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.MaintenanceItemObjList#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * </ul>
 *
 */
public interface MaintenanceItemObjListSelectable extends EntitySelectable<MaintenanceItemObjList>
{

}
