/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.field.CN_TaxInputInvoiceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.link.CN_TaxInputInvoiceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable.CN_TaxInputInvoiceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * China Input Tax Invoice
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CN_TaxInputInvoiceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CN_TaxInputInvoice extends VdmEntity<CN_TaxInputInvoice>
{

    /**
     * Selector for all available fields of CN_TaxInputInvoice.
     *
     */
    public final static CN_TaxInputInvoiceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     * </p>
     *
     * @return China Tax Invoice UUID
     */
    @Key
    @SerializedName( "CN_TaxInvcUUID" )
    @JsonProperty( "CN_TaxInvcUUID" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcUUID" )
    private UUID cN_TaxInvcUUID;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcUUID</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<UUID> CN_TAX_INVC_UUID =
        new CN_TaxInputInvoiceField<UUID>("CN_TaxInvcUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCode</b>
     * </p>
     *
     * @return China Tax Invoice Code
     */
    @SerializedName( "CN_TaxInvcCode" )
    @JsonProperty( "CN_TaxInvcCode" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcCode" )
    private String cN_TaxInvcCode;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcCode</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_CODE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcCode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNmbr</b>
     * </p>
     *
     * @return China Tax Invoice Number
     */
    @SerializedName( "CN_TaxInvcNmbr" )
    @JsonProperty( "CN_TaxInvcNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcNmbr" )
    private String cN_TaxInvcNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_NMBR =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxSellerRegnNmbr</b>
     * </p>
     *
     * @return China Seller Unified Social Credit Code
     */
    @SerializedName( "CN_TaxSellerRegnNmbr" )
    @JsonProperty( "CN_TaxSellerRegnNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxSellerRegnNmbr" )
    private String cN_TaxSellerRegnNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxSellerRegnNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_SELLER_REGN_NMBR =
        new CN_TaxInputInvoiceField<String>("CN_TaxSellerRegnNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxBuyerRegnNmbr</b>
     * </p>
     *
     * @return China Buyer Unified Social Credit Code
     */
    @SerializedName( "CN_TaxBuyerRegnNmbr" )
    @JsonProperty( "CN_TaxBuyerRegnNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxBuyerRegnNmbr" )
    private String cN_TaxBuyerRegnNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxBuyerRegnNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_BUYER_REGN_NMBR =
        new CN_TaxInputInvoiceField<String>("CN_TaxBuyerRegnNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcType</b>
     * </p>
     *
     * @return China Tax Invoice Type
     */
    @SerializedName( "CN_TaxInvcType" )
    @JsonProperty( "CN_TaxInvcType" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcType" )
    private String cN_TaxInvcType;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcType</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_TYPE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDate</b>
     * </p>
     *
     * @return China Tax Invoice Date
     */
    @SerializedName( "CN_TaxInvcDate" )
    @JsonProperty( "CN_TaxInvcDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CN_TaxInvcDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime cN_TaxInvcDate;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcDate</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<LocalDateTime> CN_TAX_INVC_DATE =
        new CN_TaxInputInvoiceField<LocalDateTime>("CN_TaxInvcDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCrcy</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "CN_TaxInvcCrcy" )
    @JsonProperty( "CN_TaxInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcCrcy" )
    private String cN_TaxInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_CRCY =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNetAmtInInvcCrcy</b>
     * </p>
     *
     * @return China Tax Invoice Net Amount in Invoice Currency
     */
    @SerializedName( "CN_TaxInvcNetAmtInInvcCrcy" )
    @JsonProperty( "CN_TaxInvcNetAmtInInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcNetAmtInInvcCrcy" )
    private BigDecimal cN_TaxInvcNetAmtInInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcNetAmtInInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<BigDecimal> CN_TAX_INVC_NET_AMT_IN_INVC_CRCY =
        new CN_TaxInputInvoiceField<BigDecimal>("CN_TaxInvcNetAmtInInvcCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcTaxAmtInInvcCrcy</b>
     * </p>
     *
     * @return China Tax Invoice Tax Amount in Invoice Currency
     */
    @SerializedName( "CN_TaxInvcTaxAmtInInvcCrcy" )
    @JsonProperty( "CN_TaxInvcTaxAmtInInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcTaxAmtInInvcCrcy" )
    private BigDecimal cN_TaxInvcTaxAmtInInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcTaxAmtInInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<BigDecimal> CN_TAX_INVC_TAX_AMT_IN_INVC_CRCY =
        new CN_TaxInputInvoiceField<BigDecimal>("CN_TaxInvcTaxAmtInInvcCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDeductAmtInInvcCrcy</b>
     * </p>
     *
     * @return China Tax Invoice Deductive Tax Amount in Invoice Currency
     */
    @SerializedName( "CN_TaxInvcDeductAmtInInvcCrcy" )
    @JsonProperty( "CN_TaxInvcDeductAmtInInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcDeductAmtInInvcCrcy" )
    private BigDecimal cN_TaxInvcDeductAmtInInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcDeductAmtInInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<BigDecimal> CN_TAX_INVC_DEDUCT_AMT_IN_INVC_CRCY =
        new CN_TaxInputInvoiceField<BigDecimal>("CN_TaxInvcDeductAmtInInvcCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @return China Tax Invoice Tax Entity ID
     */
    @SerializedName( "BusinessPlace" )
    @JsonProperty( "BusinessPlace" )
    @Nullable
    @ODataField( odataName = "BusinessPlace" )
    private String businessPlace;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlace</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> BUSINESS_PLACE =
        new CN_TaxInputInvoiceField<String>("BusinessPlace");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDiscNetAmtInInvcCrcy</b>
     * </p>
     *
     * @return China Tax Invoice Net Amount in Invoice Currency
     */
    @SerializedName( "CN_TaxInvcDiscNetAmtInInvcCrcy" )
    @JsonProperty( "CN_TaxInvcDiscNetAmtInInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcDiscNetAmtInInvcCrcy" )
    private BigDecimal cN_TaxInvcDiscNetAmtInInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcDiscNetAmtInInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<BigDecimal> CN_TAX_INVC_DISC_NET_AMT_IN_INVC_CRCY =
        new CN_TaxInputInvoiceField<BigDecimal>("CN_TaxInvcDiscNetAmtInInvcCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDiscTaxAmtInInvcCrcy</b>
     * </p>
     *
     * @return China Tax Invoice Tax Amount in Invoice Currency
     */
    @SerializedName( "CN_TaxInvcDiscTaxAmtInInvcCrcy" )
    @JsonProperty( "CN_TaxInvcDiscTaxAmtInInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcDiscTaxAmtInInvcCrcy" )
    private BigDecimal cN_TaxInvcDiscTaxAmtInInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcDiscTaxAmtInInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<BigDecimal> CN_TAX_INVC_DISC_TAX_AMT_IN_INVC_CRCY =
        new CN_TaxInputInvoiceField<BigDecimal>("CN_TaxInvcDiscTaxAmtInInvcCrcy");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxRate</b>
     * </p>
     *
     * @return VAT Tax Rate
     */
    @SerializedName( "TaxRate" )
    @JsonProperty( "TaxRate" )
    @Nullable
    @ODataField( odataName = "TaxRate" )
    private BigDecimal taxRate;
    /**
     * Use with available fluent helpers to apply the <b>TaxRate</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<BigDecimal> TAX_RATE =
        new CN_TaxInputInvoiceField<BigDecimal>("TaxRate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> COMPANY_CODE =
        new CN_TaxInputInvoiceField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcGldnTxSystSts</b>
     * </p>
     *
     * @return China Tax Invoice Status in Golden Tax System
     */
    @SerializedName( "CN_TaxInvcGldnTxSystSts" )
    @JsonProperty( "CN_TaxInvcGldnTxSystSts" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcGldnTxSystSts" )
    private String cN_TaxInvcGldnTxSystSts;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcGldnTxSystSts</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_GLDN_TX_SYST_STS =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcGldnTxSystSts");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcGldnTxSystStsSyncTme</b>
     * </p>
     *
     * @return China Tax Invoice Last Synchronization Time with GT
     */
    @SerializedName( "CN_TaxInvcGldnTxSystStsSyncTme" )
    @JsonProperty( "CN_TaxInvcGldnTxSystStsSyncTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CN_TaxInvcGldnTxSystStsSyncTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime cN_TaxInvcGldnTxSystStsSyncTme;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcGldnTxSystStsSyncTme</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<ZonedDateTime> CN_TAX_INVC_GLDN_TX_SYST_STS_SYNC_TME =
        new CN_TaxInputInvoiceField<ZonedDateTime>("CN_TaxInvcGldnTxSystStsSyncTme");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcInptProcgSts</b>
     * </p>
     *
     * @return China Tax Invoice Incoming Invoice Processing Status
     */
    @SerializedName( "CN_TaxInvcInptProcgSts" )
    @JsonProperty( "CN_TaxInvcInptProcgSts" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcInptProcgSts" )
    private String cN_TaxInvcInptProcgSts;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcInptProcgSts</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_INPT_PROCG_STS =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcInptProcgSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDeductionType</b>
     * </p>
     *
     * @return China Tax Invoice Deduction Type
     */
    @SerializedName( "CN_TaxInvcDeductionType" )
    @JsonProperty( "CN_TaxInvcDeductionType" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcDeductionType" )
    private String cN_TaxInvcDeductionType;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcDeductionType</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_DEDUCTION_TYPE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcDeductionType");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxSellerName</b>
     * </p>
     *
     * @return China Tax Invoice Seller Name
     */
    @SerializedName( "CN_TaxSellerName" )
    @JsonProperty( "CN_TaxSellerName" )
    @Nullable
    @ODataField( odataName = "CN_TaxSellerName" )
    private String cN_TaxSellerName;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxSellerName</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_SELLER_NAME =
        new CN_TaxInputInvoiceField<String>("CN_TaxSellerName");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcComment</b>
     * </p>
     *
     * @return China Tax Invoice Comment
     */
    @SerializedName( "CN_TaxInvcComment" )
    @JsonProperty( "CN_TaxInvcComment" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcComment" )
    private String cN_TaxInvcComment;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcComment</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVC_COMMENT =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvcComment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceUsage</b>
     * </p>
     *
     * @return China Tax Invoice Usage
     */
    @SerializedName( "CN_TaxInvoiceUsage" )
    @JsonProperty( "CN_TaxInvoiceUsage" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceUsage" )
    private String cN_TaxInvoiceUsage;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceUsage</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_USAGE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceUsage");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceDataSource</b>
     * </p>
     *
     * @return China Tax Invoice Data Source
     */
    @SerializedName( "CN_TaxInvoiceDataSource" )
    @JsonProperty( "CN_TaxInvoiceDataSource" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceDataSource" )
    private String cN_TaxInvoiceDataSource;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceDataSource</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_DATA_SOURCE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceDataSource");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceExpenseReportNmbr</b>
     * </p>
     *
     * @return China Tax Invoice Expense Report Number
     */
    @SerializedName( "CN_TaxInvoiceExpenseReportNmbr" )
    @JsonProperty( "CN_TaxInvoiceExpenseReportNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceExpenseReportNmbr" )
    private String cN_TaxInvoiceExpenseReportNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceExpenseReportNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_EXPENSE_REPORT_NMBR =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceExpenseReportNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCategory</b>
     * </p>
     *
     * @return China Tax Input VAT Category
     */
    @SerializedName( "TaxCategory" )
    @JsonProperty( "TaxCategory" )
    @Nullable
    @ODataField( odataName = "TaxCategory" )
    private String taxCategory;
    /**
     * Use with available fluent helpers to apply the <b>TaxCategory</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> TAX_CATEGORY =
        new CN_TaxInputInvoiceField<String>("TaxCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxDeclnTime</b>
     * </p>
     *
     * @return China Tax Declaration Time
     */
    @SerializedName( "CN_TaxDeclnTime" )
    @JsonProperty( "CN_TaxDeclnTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CN_TaxDeclnTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime cN_TaxDeclnTime;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxDeclnTime</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<ZonedDateTime> CN_TAX_DECLN_TIME =
        new CN_TaxInputInvoiceField<ZonedDateTime>("CN_TaxDeclnTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxDeclnYear</b>
     * </p>
     *
     * @return China Tax Declaration Year
     */
    @SerializedName( "CN_TaxDeclnYear" )
    @JsonProperty( "CN_TaxDeclnYear" )
    @Nullable
    @ODataField( odataName = "CN_TaxDeclnYear" )
    private String cN_TaxDeclnYear;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxDeclnYear</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_DECLN_YEAR =
        new CN_TaxInputInvoiceField<String>("CN_TaxDeclnYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxDeclnMonth</b>
     * </p>
     *
     * @return China Tax Declaration Month
     */
    @SerializedName( "CN_TaxDeclnMonth" )
    @JsonProperty( "CN_TaxDeclnMonth" )
    @Nullable
    @ODataField( odataName = "CN_TaxDeclnMonth" )
    private String cN_TaxDeclnMonth;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxDeclnMonth</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_DECLN_MONTH =
        new CN_TaxInputInvoiceField<String>("CN_TaxDeclnMonth");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceBuyerAddressPhone</b>
     * </p>
     *
     * @return China Tax Invoice Buyer Address, Phone
     */
    @SerializedName( "TaxInvoiceBuyerAddressPhone" )
    @JsonProperty( "TaxInvoiceBuyerAddressPhone" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceBuyerAddressPhone" )
    private String taxInvoiceBuyerAddressPhone;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceBuyerAddressPhone</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> TAX_INVOICE_BUYER_ADDRESS_PHONE =
        new CN_TaxInputInvoiceField<String>("TaxInvoiceBuyerAddressPhone");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceBuyerBankAccount</b>
     * </p>
     *
     * @return China Tax Invoice Buyer Bank Account Info
     */
    @SerializedName( "TaxInvoiceBuyerBankAccount" )
    @JsonProperty( "TaxInvoiceBuyerBankAccount" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceBuyerBankAccount" )
    private String taxInvoiceBuyerBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceBuyerBankAccount</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> TAX_INVOICE_BUYER_BANK_ACCOUNT =
        new CN_TaxInputInvoiceField<String>("TaxInvoiceBuyerBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceSellerAddressPhone</b>
     * </p>
     *
     * @return China Tax Invoice Seller Address, Phone
     */
    @SerializedName( "TaxInvoiceSellerAddressPhone" )
    @JsonProperty( "TaxInvoiceSellerAddressPhone" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceSellerAddressPhone" )
    private String taxInvoiceSellerAddressPhone;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceSellerAddressPhone</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> TAX_INVOICE_SELLER_ADDRESS_PHONE =
        new CN_TaxInputInvoiceField<String>("TaxInvoiceSellerAddressPhone");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceSellerBankAccount</b>
     * </p>
     *
     * @return China Tax Invoice Seller Bank Account Info
     */
    @SerializedName( "TaxInvoiceSellerBankAccount" )
    @JsonProperty( "TaxInvoiceSellerBankAccount" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceSellerBankAccount" )
    private String taxInvoiceSellerBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceSellerBankAccount</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> TAX_INVOICE_SELLER_BANK_ACCOUNT =
        new CN_TaxInputInvoiceField<String>("TaxInvoiceSellerBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleType</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Type
     */
    @SerializedName( "CN_TaxInvoiceVehicleType" )
    @JsonProperty( "CN_TaxInvoiceVehicleType" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehicleType" )
    private String cN_TaxInvoiceVehicleType;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehicleType</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEHICLE_TYPE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehicleType");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehFactoryModel</b>
     * </p>
     *
     * @return Tax Invoice Vehicle Factory Model
     */
    @SerializedName( "CN_TaxInvoiceVehFactoryModel" )
    @JsonProperty( "CN_TaxInvoiceVehFactoryModel" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehFactoryModel" )
    private String cN_TaxInvoiceVehFactoryModel;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehFactoryModel</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEH_FACTORY_MODEL =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehFactoryModel");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleProdnPlace</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Place of Production
     */
    @SerializedName( "CN_TaxInvoiceVehicleProdnPlace" )
    @JsonProperty( "CN_TaxInvoiceVehicleProdnPlace" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehicleProdnPlace" )
    private String cN_TaxInvoiceVehicleProdnPlace;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehicleProdnPlace</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEHICLE_PRODN_PLACE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehicleProdnPlace");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleCertNumber</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Certification Number
     */
    @SerializedName( "CN_TaxInvoiceVehicleCertNumber" )
    @JsonProperty( "CN_TaxInvoiceVehicleCertNumber" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehicleCertNumber" )
    private String cN_TaxInvoiceVehicleCertNumber;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehicleCertNumber</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEHICLE_CERT_NUMBER =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehicleCertNumber");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehImportCertNmbr</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Import Certification Number
     */
    @SerializedName( "CN_TaxInvoiceVehImportCertNmbr" )
    @JsonProperty( "CN_TaxInvoiceVehImportCertNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehImportCertNmbr" )
    private String cN_TaxInvoiceVehImportCertNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehImportCertNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEH_IMPORT_CERT_NMBR =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehImportCertNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleInspNumber</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Inspection Number
     */
    @SerializedName( "CN_TaxInvoiceVehicleInspNumber" )
    @JsonProperty( "CN_TaxInvoiceVehicleInspNumber" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehicleInspNumber" )
    private String cN_TaxInvoiceVehicleInspNumber;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehicleInspNumber</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEHICLE_INSP_NUMBER =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehicleInspNumber");
    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleEngineNmbr</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Engine Number
     */
    @SerializedName( "CN_TaxInvoiceVehicleEngineNmbr" )
    @JsonProperty( "CN_TaxInvoiceVehicleEngineNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehicleEngineNmbr" )
    private String cN_TaxInvoiceVehicleEngineNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehicleEngineNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEHICLE_ENGINE_NMBR =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehicleEngineNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleNumber</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Number
     */
    @SerializedName( "CN_TaxInvoiceVehicleNumber" )
    @JsonProperty( "CN_TaxInvoiceVehicleNumber" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehicleNumber" )
    private String cN_TaxInvoiceVehicleNumber;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehicleNumber</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEHICLE_NUMBER =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehicleNumber");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcVehTotAmtInInvcCrcy</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Total Amount
     */
    @SerializedName( "CN_TaxInvcVehTotAmtInInvcCrcy" )
    @JsonProperty( "CN_TaxInvcVehTotAmtInInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcVehTotAmtInInvcCrcy" )
    private BigDecimal cN_TaxInvcVehTotAmtInInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcVehTotAmtInInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<BigDecimal> CN_TAX_INVC_VEH_TOT_AMT_IN_INVC_CRCY =
        new CN_TaxInputInvoiceField<BigDecimal>("CN_TaxInvcVehTotAmtInInvcCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehTxnRecordNmbr</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Taxation Record Number
     */
    @SerializedName( "CN_TaxInvoiceVehTxnRecordNmbr" )
    @JsonProperty( "CN_TaxInvoiceVehTxnRecordNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehTxnRecordNmbr" )
    private String cN_TaxInvoiceVehTxnRecordNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehTxnRecordNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEH_TXN_RECORD_NMBR =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehTxnRecordNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleTonnage</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Tonnage
     */
    @SerializedName( "CN_TaxInvoiceVehicleTonnage" )
    @JsonProperty( "CN_TaxInvoiceVehicleTonnage" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehicleTonnage" )
    private String cN_TaxInvoiceVehicleTonnage;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehicleTonnage</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEHICLE_TONNAGE =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehicleTonnage");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehPassengerLimit</b>
     * </p>
     *
     * @return China Tax Invoice Vehicle Limitation on Passengers
     */
    @SerializedName( "CN_TaxInvoiceVehPassengerLimit" )
    @JsonProperty( "CN_TaxInvoiceVehPassengerLimit" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvoiceVehPassengerLimit" )
    private String cN_TaxInvoiceVehPassengerLimit;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvoiceVehPassengerLimit</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> CN_TAX_INVOICE_VEH_PASSENGER_LIMIT =
        new CN_TaxInputInvoiceField<String>("CN_TaxInvoiceVehPassengerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> PURCHASING_ORGANIZATION =
        new CN_TaxInputInvoiceField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> PURCHASING_GROUP =
        new CN_TaxInputInvoiceField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceField<String> SUPPLIER = new CN_TaxInputInvoiceField<String>("Supplier");
    /**
     * Navigation property <b>to_Binding</b> for <b>CN_TaxInputInvoice</b> to multiple
     * <b>CN_TaxInvoiceBindingRecord</b>.
     *
     */
    @SerializedName( "to_Binding" )
    @JsonProperty( "to_Binding" )
    @ODataField( odataName = "to_Binding" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CN_TaxInvoiceBindingRecord> toBinding;
    /**
     * Navigation property <b>to_Item</b> for <b>CN_TaxInputInvoice</b> to multiple <b>CN_TaxInputInvoiceItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CN_TaxInputInvoiceItem> toItem;
    /**
     * Use with available fluent helpers to apply the <b>to_Binding</b> navigation property to query operations.
     *
     */
    public final static CN_TaxInputInvoiceLink<CN_TaxInvoiceBindingRecord> TO_BINDING =
        new CN_TaxInputInvoiceLink<CN_TaxInvoiceBindingRecord>("to_Binding");
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static CN_TaxInputInvoiceLink<CN_TaxInputInvoiceItem> TO_ITEM =
        new CN_TaxInputInvoiceLink<CN_TaxInputInvoiceItem>("to_Item");

    @Nonnull
    @Override
    public Class<CN_TaxInputInvoice> getType()
    {
        return CN_TaxInputInvoice.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     * </p>
     *
     * @param cN_TaxInvcUUID
     *            China Tax Invoice UUID
     */
    public void setCN_TaxInvcUUID( @Nullable final UUID cN_TaxInvcUUID )
    {
        rememberChangedField("CN_TaxInvcUUID", this.cN_TaxInvcUUID);
        this.cN_TaxInvcUUID = cN_TaxInvcUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCode</b>
     * </p>
     *
     * @param cN_TaxInvcCode
     *            China Tax Invoice Code
     */
    public void setCN_TaxInvcCode( @Nullable final String cN_TaxInvcCode )
    {
        rememberChangedField("CN_TaxInvcCode", this.cN_TaxInvcCode);
        this.cN_TaxInvcCode = cN_TaxInvcCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNmbr</b>
     * </p>
     *
     * @param cN_TaxInvcNmbr
     *            China Tax Invoice Number
     */
    public void setCN_TaxInvcNmbr( @Nullable final String cN_TaxInvcNmbr )
    {
        rememberChangedField("CN_TaxInvcNmbr", this.cN_TaxInvcNmbr);
        this.cN_TaxInvcNmbr = cN_TaxInvcNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxSellerRegnNmbr</b>
     * </p>
     *
     * @param cN_TaxSellerRegnNmbr
     *            China Seller Unified Social Credit Code
     */
    public void setCN_TaxSellerRegnNmbr( @Nullable final String cN_TaxSellerRegnNmbr )
    {
        rememberChangedField("CN_TaxSellerRegnNmbr", this.cN_TaxSellerRegnNmbr);
        this.cN_TaxSellerRegnNmbr = cN_TaxSellerRegnNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxBuyerRegnNmbr</b>
     * </p>
     *
     * @param cN_TaxBuyerRegnNmbr
     *            China Buyer Unified Social Credit Code
     */
    public void setCN_TaxBuyerRegnNmbr( @Nullable final String cN_TaxBuyerRegnNmbr )
    {
        rememberChangedField("CN_TaxBuyerRegnNmbr", this.cN_TaxBuyerRegnNmbr);
        this.cN_TaxBuyerRegnNmbr = cN_TaxBuyerRegnNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcType</b>
     * </p>
     *
     * @param cN_TaxInvcType
     *            China Tax Invoice Type
     */
    public void setCN_TaxInvcType( @Nullable final String cN_TaxInvcType )
    {
        rememberChangedField("CN_TaxInvcType", this.cN_TaxInvcType);
        this.cN_TaxInvcType = cN_TaxInvcType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDate</b>
     * </p>
     *
     * @param cN_TaxInvcDate
     *            China Tax Invoice Date
     */
    public void setCN_TaxInvcDate( @Nullable final LocalDateTime cN_TaxInvcDate )
    {
        rememberChangedField("CN_TaxInvcDate", this.cN_TaxInvcDate);
        this.cN_TaxInvcDate = cN_TaxInvcDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcCrcy
     *            Currency Key
     */
    public void setCN_TaxInvcCrcy( @Nullable final String cN_TaxInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcCrcy", this.cN_TaxInvcCrcy);
        this.cN_TaxInvcCrcy = cN_TaxInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNetAmtInInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcNetAmtInInvcCrcy
     *            China Tax Invoice Net Amount in Invoice Currency
     */
    public void setCN_TaxInvcNetAmtInInvcCrcy( @Nullable final BigDecimal cN_TaxInvcNetAmtInInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcNetAmtInInvcCrcy", this.cN_TaxInvcNetAmtInInvcCrcy);
        this.cN_TaxInvcNetAmtInInvcCrcy = cN_TaxInvcNetAmtInInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcTaxAmtInInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcTaxAmtInInvcCrcy
     *            China Tax Invoice Tax Amount in Invoice Currency
     */
    public void setCN_TaxInvcTaxAmtInInvcCrcy( @Nullable final BigDecimal cN_TaxInvcTaxAmtInInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcTaxAmtInInvcCrcy", this.cN_TaxInvcTaxAmtInInvcCrcy);
        this.cN_TaxInvcTaxAmtInInvcCrcy = cN_TaxInvcTaxAmtInInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDeductAmtInInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcDeductAmtInInvcCrcy
     *            China Tax Invoice Deductive Tax Amount in Invoice Currency
     */
    public void setCN_TaxInvcDeductAmtInInvcCrcy( @Nullable final BigDecimal cN_TaxInvcDeductAmtInInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcDeductAmtInInvcCrcy", this.cN_TaxInvcDeductAmtInInvcCrcy);
        this.cN_TaxInvcDeductAmtInInvcCrcy = cN_TaxInvcDeductAmtInInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @param businessPlace
     *            China Tax Invoice Tax Entity ID
     */
    public void setBusinessPlace( @Nullable final String businessPlace )
    {
        rememberChangedField("BusinessPlace", this.businessPlace);
        this.businessPlace = businessPlace;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDiscNetAmtInInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcDiscNetAmtInInvcCrcy
     *            China Tax Invoice Net Amount in Invoice Currency
     */
    public void setCN_TaxInvcDiscNetAmtInInvcCrcy( @Nullable final BigDecimal cN_TaxInvcDiscNetAmtInInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcDiscNetAmtInInvcCrcy", this.cN_TaxInvcDiscNetAmtInInvcCrcy);
        this.cN_TaxInvcDiscNetAmtInInvcCrcy = cN_TaxInvcDiscNetAmtInInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDiscTaxAmtInInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcDiscTaxAmtInInvcCrcy
     *            China Tax Invoice Tax Amount in Invoice Currency
     */
    public void setCN_TaxInvcDiscTaxAmtInInvcCrcy( @Nullable final BigDecimal cN_TaxInvcDiscTaxAmtInInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcDiscTaxAmtInInvcCrcy", this.cN_TaxInvcDiscTaxAmtInInvcCrcy);
        this.cN_TaxInvcDiscTaxAmtInInvcCrcy = cN_TaxInvcDiscTaxAmtInInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxRate</b>
     * </p>
     *
     * @param taxRate
     *            VAT Tax Rate
     */
    public void setTaxRate( @Nullable final BigDecimal taxRate )
    {
        rememberChangedField("TaxRate", this.taxRate);
        this.taxRate = taxRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcGldnTxSystSts</b>
     * </p>
     *
     * @param cN_TaxInvcGldnTxSystSts
     *            China Tax Invoice Status in Golden Tax System
     */
    public void setCN_TaxInvcGldnTxSystSts( @Nullable final String cN_TaxInvcGldnTxSystSts )
    {
        rememberChangedField("CN_TaxInvcGldnTxSystSts", this.cN_TaxInvcGldnTxSystSts);
        this.cN_TaxInvcGldnTxSystSts = cN_TaxInvcGldnTxSystSts;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcGldnTxSystStsSyncTme</b>
     * </p>
     *
     * @param cN_TaxInvcGldnTxSystStsSyncTme
     *            China Tax Invoice Last Synchronization Time with GT
     */
    public void setCN_TaxInvcGldnTxSystStsSyncTme( @Nullable final ZonedDateTime cN_TaxInvcGldnTxSystStsSyncTme )
    {
        rememberChangedField("CN_TaxInvcGldnTxSystStsSyncTme", this.cN_TaxInvcGldnTxSystStsSyncTme);
        this.cN_TaxInvcGldnTxSystStsSyncTme = cN_TaxInvcGldnTxSystStsSyncTme;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcInptProcgSts</b>
     * </p>
     *
     * @param cN_TaxInvcInptProcgSts
     *            China Tax Invoice Incoming Invoice Processing Status
     */
    public void setCN_TaxInvcInptProcgSts( @Nullable final String cN_TaxInvcInptProcgSts )
    {
        rememberChangedField("CN_TaxInvcInptProcgSts", this.cN_TaxInvcInptProcgSts);
        this.cN_TaxInvcInptProcgSts = cN_TaxInvcInptProcgSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcDeductionType</b>
     * </p>
     *
     * @param cN_TaxInvcDeductionType
     *            China Tax Invoice Deduction Type
     */
    public void setCN_TaxInvcDeductionType( @Nullable final String cN_TaxInvcDeductionType )
    {
        rememberChangedField("CN_TaxInvcDeductionType", this.cN_TaxInvcDeductionType);
        this.cN_TaxInvcDeductionType = cN_TaxInvcDeductionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxSellerName</b>
     * </p>
     *
     * @param cN_TaxSellerName
     *            China Tax Invoice Seller Name
     */
    public void setCN_TaxSellerName( @Nullable final String cN_TaxSellerName )
    {
        rememberChangedField("CN_TaxSellerName", this.cN_TaxSellerName);
        this.cN_TaxSellerName = cN_TaxSellerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcComment</b>
     * </p>
     *
     * @param cN_TaxInvcComment
     *            China Tax Invoice Comment
     */
    public void setCN_TaxInvcComment( @Nullable final String cN_TaxInvcComment )
    {
        rememberChangedField("CN_TaxInvcComment", this.cN_TaxInvcComment);
        this.cN_TaxInvcComment = cN_TaxInvcComment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceUsage</b>
     * </p>
     *
     * @param cN_TaxInvoiceUsage
     *            China Tax Invoice Usage
     */
    public void setCN_TaxInvoiceUsage( @Nullable final String cN_TaxInvoiceUsage )
    {
        rememberChangedField("CN_TaxInvoiceUsage", this.cN_TaxInvoiceUsage);
        this.cN_TaxInvoiceUsage = cN_TaxInvoiceUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceDataSource</b>
     * </p>
     *
     * @param cN_TaxInvoiceDataSource
     *            China Tax Invoice Data Source
     */
    public void setCN_TaxInvoiceDataSource( @Nullable final String cN_TaxInvoiceDataSource )
    {
        rememberChangedField("CN_TaxInvoiceDataSource", this.cN_TaxInvoiceDataSource);
        this.cN_TaxInvoiceDataSource = cN_TaxInvoiceDataSource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceExpenseReportNmbr</b>
     * </p>
     *
     * @param cN_TaxInvoiceExpenseReportNmbr
     *            China Tax Invoice Expense Report Number
     */
    public void setCN_TaxInvoiceExpenseReportNmbr( @Nullable final String cN_TaxInvoiceExpenseReportNmbr )
    {
        rememberChangedField("CN_TaxInvoiceExpenseReportNmbr", this.cN_TaxInvoiceExpenseReportNmbr);
        this.cN_TaxInvoiceExpenseReportNmbr = cN_TaxInvoiceExpenseReportNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCategory</b>
     * </p>
     *
     * @param taxCategory
     *            China Tax Input VAT Category
     */
    public void setTaxCategory( @Nullable final String taxCategory )
    {
        rememberChangedField("TaxCategory", this.taxCategory);
        this.taxCategory = taxCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxDeclnTime</b>
     * </p>
     *
     * @param cN_TaxDeclnTime
     *            China Tax Declaration Time
     */
    public void setCN_TaxDeclnTime( @Nullable final ZonedDateTime cN_TaxDeclnTime )
    {
        rememberChangedField("CN_TaxDeclnTime", this.cN_TaxDeclnTime);
        this.cN_TaxDeclnTime = cN_TaxDeclnTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxDeclnYear</b>
     * </p>
     *
     * @param cN_TaxDeclnYear
     *            China Tax Declaration Year
     */
    public void setCN_TaxDeclnYear( @Nullable final String cN_TaxDeclnYear )
    {
        rememberChangedField("CN_TaxDeclnYear", this.cN_TaxDeclnYear);
        this.cN_TaxDeclnYear = cN_TaxDeclnYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxDeclnMonth</b>
     * </p>
     *
     * @param cN_TaxDeclnMonth
     *            China Tax Declaration Month
     */
    public void setCN_TaxDeclnMonth( @Nullable final String cN_TaxDeclnMonth )
    {
        rememberChangedField("CN_TaxDeclnMonth", this.cN_TaxDeclnMonth);
        this.cN_TaxDeclnMonth = cN_TaxDeclnMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceBuyerAddressPhone</b>
     * </p>
     *
     * @param taxInvoiceBuyerAddressPhone
     *            China Tax Invoice Buyer Address, Phone
     */
    public void setTaxInvoiceBuyerAddressPhone( @Nullable final String taxInvoiceBuyerAddressPhone )
    {
        rememberChangedField("TaxInvoiceBuyerAddressPhone", this.taxInvoiceBuyerAddressPhone);
        this.taxInvoiceBuyerAddressPhone = taxInvoiceBuyerAddressPhone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceBuyerBankAccount</b>
     * </p>
     *
     * @param taxInvoiceBuyerBankAccount
     *            China Tax Invoice Buyer Bank Account Info
     */
    public void setTaxInvoiceBuyerBankAccount( @Nullable final String taxInvoiceBuyerBankAccount )
    {
        rememberChangedField("TaxInvoiceBuyerBankAccount", this.taxInvoiceBuyerBankAccount);
        this.taxInvoiceBuyerBankAccount = taxInvoiceBuyerBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceSellerAddressPhone</b>
     * </p>
     *
     * @param taxInvoiceSellerAddressPhone
     *            China Tax Invoice Seller Address, Phone
     */
    public void setTaxInvoiceSellerAddressPhone( @Nullable final String taxInvoiceSellerAddressPhone )
    {
        rememberChangedField("TaxInvoiceSellerAddressPhone", this.taxInvoiceSellerAddressPhone);
        this.taxInvoiceSellerAddressPhone = taxInvoiceSellerAddressPhone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceSellerBankAccount</b>
     * </p>
     *
     * @param taxInvoiceSellerBankAccount
     *            China Tax Invoice Seller Bank Account Info
     */
    public void setTaxInvoiceSellerBankAccount( @Nullable final String taxInvoiceSellerBankAccount )
    {
        rememberChangedField("TaxInvoiceSellerBankAccount", this.taxInvoiceSellerBankAccount);
        this.taxInvoiceSellerBankAccount = taxInvoiceSellerBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleType</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehicleType
     *            China Tax Invoice Vehicle Type
     */
    public void setCN_TaxInvoiceVehicleType( @Nullable final String cN_TaxInvoiceVehicleType )
    {
        rememberChangedField("CN_TaxInvoiceVehicleType", this.cN_TaxInvoiceVehicleType);
        this.cN_TaxInvoiceVehicleType = cN_TaxInvoiceVehicleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehFactoryModel</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehFactoryModel
     *            Tax Invoice Vehicle Factory Model
     */
    public void setCN_TaxInvoiceVehFactoryModel( @Nullable final String cN_TaxInvoiceVehFactoryModel )
    {
        rememberChangedField("CN_TaxInvoiceVehFactoryModel", this.cN_TaxInvoiceVehFactoryModel);
        this.cN_TaxInvoiceVehFactoryModel = cN_TaxInvoiceVehFactoryModel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleProdnPlace</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehicleProdnPlace
     *            China Tax Invoice Vehicle Place of Production
     */
    public void setCN_TaxInvoiceVehicleProdnPlace( @Nullable final String cN_TaxInvoiceVehicleProdnPlace )
    {
        rememberChangedField("CN_TaxInvoiceVehicleProdnPlace", this.cN_TaxInvoiceVehicleProdnPlace);
        this.cN_TaxInvoiceVehicleProdnPlace = cN_TaxInvoiceVehicleProdnPlace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleCertNumber</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehicleCertNumber
     *            China Tax Invoice Vehicle Certification Number
     */
    public void setCN_TaxInvoiceVehicleCertNumber( @Nullable final String cN_TaxInvoiceVehicleCertNumber )
    {
        rememberChangedField("CN_TaxInvoiceVehicleCertNumber", this.cN_TaxInvoiceVehicleCertNumber);
        this.cN_TaxInvoiceVehicleCertNumber = cN_TaxInvoiceVehicleCertNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehImportCertNmbr</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehImportCertNmbr
     *            China Tax Invoice Vehicle Import Certification Number
     */
    public void setCN_TaxInvoiceVehImportCertNmbr( @Nullable final String cN_TaxInvoiceVehImportCertNmbr )
    {
        rememberChangedField("CN_TaxInvoiceVehImportCertNmbr", this.cN_TaxInvoiceVehImportCertNmbr);
        this.cN_TaxInvoiceVehImportCertNmbr = cN_TaxInvoiceVehImportCertNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleInspNumber</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehicleInspNumber
     *            China Tax Invoice Vehicle Inspection Number
     */
    public void setCN_TaxInvoiceVehicleInspNumber( @Nullable final String cN_TaxInvoiceVehicleInspNumber )
    {
        rememberChangedField("CN_TaxInvoiceVehicleInspNumber", this.cN_TaxInvoiceVehicleInspNumber);
        this.cN_TaxInvoiceVehicleInspNumber = cN_TaxInvoiceVehicleInspNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleEngineNmbr</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehicleEngineNmbr
     *            China Tax Invoice Vehicle Engine Number
     */
    public void setCN_TaxInvoiceVehicleEngineNmbr( @Nullable final String cN_TaxInvoiceVehicleEngineNmbr )
    {
        rememberChangedField("CN_TaxInvoiceVehicleEngineNmbr", this.cN_TaxInvoiceVehicleEngineNmbr);
        this.cN_TaxInvoiceVehicleEngineNmbr = cN_TaxInvoiceVehicleEngineNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleNumber</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehicleNumber
     *            China Tax Invoice Vehicle Number
     */
    public void setCN_TaxInvoiceVehicleNumber( @Nullable final String cN_TaxInvoiceVehicleNumber )
    {
        rememberChangedField("CN_TaxInvoiceVehicleNumber", this.cN_TaxInvoiceVehicleNumber);
        this.cN_TaxInvoiceVehicleNumber = cN_TaxInvoiceVehicleNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcVehTotAmtInInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcVehTotAmtInInvcCrcy
     *            China Tax Invoice Vehicle Total Amount
     */
    public void setCN_TaxInvcVehTotAmtInInvcCrcy( @Nullable final BigDecimal cN_TaxInvcVehTotAmtInInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcVehTotAmtInInvcCrcy", this.cN_TaxInvcVehTotAmtInInvcCrcy);
        this.cN_TaxInvcVehTotAmtInInvcCrcy = cN_TaxInvcVehTotAmtInInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehTxnRecordNmbr</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehTxnRecordNmbr
     *            China Tax Invoice Vehicle Taxation Record Number
     */
    public void setCN_TaxInvoiceVehTxnRecordNmbr( @Nullable final String cN_TaxInvoiceVehTxnRecordNmbr )
    {
        rememberChangedField("CN_TaxInvoiceVehTxnRecordNmbr", this.cN_TaxInvoiceVehTxnRecordNmbr);
        this.cN_TaxInvoiceVehTxnRecordNmbr = cN_TaxInvoiceVehTxnRecordNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehicleTonnage</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehicleTonnage
     *            China Tax Invoice Vehicle Tonnage
     */
    public void setCN_TaxInvoiceVehicleTonnage( @Nullable final String cN_TaxInvoiceVehicleTonnage )
    {
        rememberChangedField("CN_TaxInvoiceVehicleTonnage", this.cN_TaxInvoiceVehicleTonnage);
        this.cN_TaxInvoiceVehicleTonnage = cN_TaxInvoiceVehicleTonnage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvoiceVehPassengerLimit</b>
     * </p>
     *
     * @param cN_TaxInvoiceVehPassengerLimit
     *            China Tax Invoice Vehicle Limitation on Passengers
     */
    public void setCN_TaxInvoiceVehPassengerLimit( @Nullable final String cN_TaxInvoiceVehPassengerLimit )
    {
        rememberChangedField("CN_TaxInvoiceVehPassengerLimit", this.cN_TaxInvoiceVehPassengerLimit);
        this.cN_TaxInvoiceVehPassengerLimit = cN_TaxInvoiceVehPassengerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CN_TaxInputInvoice";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CN_TaxInvcUUID", getCN_TaxInvcUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CN_TaxInvcUUID", getCN_TaxInvcUUID());
        values.put("CN_TaxInvcCode", getCN_TaxInvcCode());
        values.put("CN_TaxInvcNmbr", getCN_TaxInvcNmbr());
        values.put("CN_TaxSellerRegnNmbr", getCN_TaxSellerRegnNmbr());
        values.put("CN_TaxBuyerRegnNmbr", getCN_TaxBuyerRegnNmbr());
        values.put("CN_TaxInvcType", getCN_TaxInvcType());
        values.put("CN_TaxInvcDate", getCN_TaxInvcDate());
        values.put("CN_TaxInvcCrcy", getCN_TaxInvcCrcy());
        values.put("CN_TaxInvcNetAmtInInvcCrcy", getCN_TaxInvcNetAmtInInvcCrcy());
        values.put("CN_TaxInvcTaxAmtInInvcCrcy", getCN_TaxInvcTaxAmtInInvcCrcy());
        values.put("CN_TaxInvcDeductAmtInInvcCrcy", getCN_TaxInvcDeductAmtInInvcCrcy());
        values.put("BusinessPlace", getBusinessPlace());
        values.put("CN_TaxInvcDiscNetAmtInInvcCrcy", getCN_TaxInvcDiscNetAmtInInvcCrcy());
        values.put("CN_TaxInvcDiscTaxAmtInInvcCrcy", getCN_TaxInvcDiscTaxAmtInInvcCrcy());
        values.put("TaxRate", getTaxRate());
        values.put("CompanyCode", getCompanyCode());
        values.put("CN_TaxInvcGldnTxSystSts", getCN_TaxInvcGldnTxSystSts());
        values.put("CN_TaxInvcGldnTxSystStsSyncTme", getCN_TaxInvcGldnTxSystStsSyncTme());
        values.put("CN_TaxInvcInptProcgSts", getCN_TaxInvcInptProcgSts());
        values.put("CN_TaxInvcDeductionType", getCN_TaxInvcDeductionType());
        values.put("CN_TaxSellerName", getCN_TaxSellerName());
        values.put("CN_TaxInvcComment", getCN_TaxInvcComment());
        values.put("CN_TaxInvoiceUsage", getCN_TaxInvoiceUsage());
        values.put("CN_TaxInvoiceDataSource", getCN_TaxInvoiceDataSource());
        values.put("CN_TaxInvoiceExpenseReportNmbr", getCN_TaxInvoiceExpenseReportNmbr());
        values.put("TaxCategory", getTaxCategory());
        values.put("CN_TaxDeclnTime", getCN_TaxDeclnTime());
        values.put("CN_TaxDeclnYear", getCN_TaxDeclnYear());
        values.put("CN_TaxDeclnMonth", getCN_TaxDeclnMonth());
        values.put("TaxInvoiceBuyerAddressPhone", getTaxInvoiceBuyerAddressPhone());
        values.put("TaxInvoiceBuyerBankAccount", getTaxInvoiceBuyerBankAccount());
        values.put("TaxInvoiceSellerAddressPhone", getTaxInvoiceSellerAddressPhone());
        values.put("TaxInvoiceSellerBankAccount", getTaxInvoiceSellerBankAccount());
        values.put("CN_TaxInvoiceVehicleType", getCN_TaxInvoiceVehicleType());
        values.put("CN_TaxInvoiceVehFactoryModel", getCN_TaxInvoiceVehFactoryModel());
        values.put("CN_TaxInvoiceVehicleProdnPlace", getCN_TaxInvoiceVehicleProdnPlace());
        values.put("CN_TaxInvoiceVehicleCertNumber", getCN_TaxInvoiceVehicleCertNumber());
        values.put("CN_TaxInvoiceVehImportCertNmbr", getCN_TaxInvoiceVehImportCertNmbr());
        values.put("CN_TaxInvoiceVehicleInspNumber", getCN_TaxInvoiceVehicleInspNumber());
        values.put("CN_TaxInvoiceVehicleEngineNmbr", getCN_TaxInvoiceVehicleEngineNmbr());
        values.put("CN_TaxInvoiceVehicleNumber", getCN_TaxInvoiceVehicleNumber());
        values.put("CN_TaxInvcVehTotAmtInInvcCrcy", getCN_TaxInvcVehTotAmtInInvcCrcy());
        values.put("CN_TaxInvoiceVehTxnRecordNmbr", getCN_TaxInvoiceVehTxnRecordNmbr());
        values.put("CN_TaxInvoiceVehicleTonnage", getCN_TaxInvoiceVehicleTonnage());
        values.put("CN_TaxInvoiceVehPassengerLimit", getCN_TaxInvoiceVehPassengerLimit());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Supplier", getSupplier());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CN_TaxInvcUUID") ) {
                final Object value = values.remove("CN_TaxInvcUUID");
                if( (value == null) || (!value.equals(getCN_TaxInvcUUID())) ) {
                    setCN_TaxInvcUUID(((UUID) value));
                }
            }
            if( values.containsKey("CN_TaxInvcCode") ) {
                final Object value = values.remove("CN_TaxInvcCode");
                if( (value == null) || (!value.equals(getCN_TaxInvcCode())) ) {
                    setCN_TaxInvcCode(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcNmbr") ) {
                final Object value = values.remove("CN_TaxInvcNmbr");
                if( (value == null) || (!value.equals(getCN_TaxInvcNmbr())) ) {
                    setCN_TaxInvcNmbr(((String) value));
                }
            }
            if( values.containsKey("CN_TaxSellerRegnNmbr") ) {
                final Object value = values.remove("CN_TaxSellerRegnNmbr");
                if( (value == null) || (!value.equals(getCN_TaxSellerRegnNmbr())) ) {
                    setCN_TaxSellerRegnNmbr(((String) value));
                }
            }
            if( values.containsKey("CN_TaxBuyerRegnNmbr") ) {
                final Object value = values.remove("CN_TaxBuyerRegnNmbr");
                if( (value == null) || (!value.equals(getCN_TaxBuyerRegnNmbr())) ) {
                    setCN_TaxBuyerRegnNmbr(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcType") ) {
                final Object value = values.remove("CN_TaxInvcType");
                if( (value == null) || (!value.equals(getCN_TaxInvcType())) ) {
                    setCN_TaxInvcType(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcDate") ) {
                final Object value = values.remove("CN_TaxInvcDate");
                if( (value == null) || (!value.equals(getCN_TaxInvcDate())) ) {
                    setCN_TaxInvcDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CN_TaxInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcCrcy())) ) {
                    setCN_TaxInvcCrcy(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcNetAmtInInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcNetAmtInInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcNetAmtInInvcCrcy())) ) {
                    setCN_TaxInvcNetAmtInInvcCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CN_TaxInvcTaxAmtInInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcTaxAmtInInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcTaxAmtInInvcCrcy())) ) {
                    setCN_TaxInvcTaxAmtInInvcCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CN_TaxInvcDeductAmtInInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcDeductAmtInInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcDeductAmtInInvcCrcy())) ) {
                    setCN_TaxInvcDeductAmtInInvcCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BusinessPlace") ) {
                final Object value = values.remove("BusinessPlace");
                if( (value == null) || (!value.equals(getBusinessPlace())) ) {
                    setBusinessPlace(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcDiscNetAmtInInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcDiscNetAmtInInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcDiscNetAmtInInvcCrcy())) ) {
                    setCN_TaxInvcDiscNetAmtInInvcCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CN_TaxInvcDiscTaxAmtInInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcDiscTaxAmtInInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcDiscTaxAmtInInvcCrcy())) ) {
                    setCN_TaxInvcDiscTaxAmtInInvcCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxRate") ) {
                final Object value = values.remove("TaxRate");
                if( (value == null) || (!value.equals(getTaxRate())) ) {
                    setTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcGldnTxSystSts") ) {
                final Object value = values.remove("CN_TaxInvcGldnTxSystSts");
                if( (value == null) || (!value.equals(getCN_TaxInvcGldnTxSystSts())) ) {
                    setCN_TaxInvcGldnTxSystSts(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcGldnTxSystStsSyncTme") ) {
                final Object value = values.remove("CN_TaxInvcGldnTxSystStsSyncTme");
                if( (value == null) || (!value.equals(getCN_TaxInvcGldnTxSystStsSyncTme())) ) {
                    setCN_TaxInvcGldnTxSystStsSyncTme(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CN_TaxInvcInptProcgSts") ) {
                final Object value = values.remove("CN_TaxInvcInptProcgSts");
                if( (value == null) || (!value.equals(getCN_TaxInvcInptProcgSts())) ) {
                    setCN_TaxInvcInptProcgSts(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcDeductionType") ) {
                final Object value = values.remove("CN_TaxInvcDeductionType");
                if( (value == null) || (!value.equals(getCN_TaxInvcDeductionType())) ) {
                    setCN_TaxInvcDeductionType(((String) value));
                }
            }
            if( values.containsKey("CN_TaxSellerName") ) {
                final Object value = values.remove("CN_TaxSellerName");
                if( (value == null) || (!value.equals(getCN_TaxSellerName())) ) {
                    setCN_TaxSellerName(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcComment") ) {
                final Object value = values.remove("CN_TaxInvcComment");
                if( (value == null) || (!value.equals(getCN_TaxInvcComment())) ) {
                    setCN_TaxInvcComment(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceUsage") ) {
                final Object value = values.remove("CN_TaxInvoiceUsage");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceUsage())) ) {
                    setCN_TaxInvoiceUsage(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceDataSource") ) {
                final Object value = values.remove("CN_TaxInvoiceDataSource");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceDataSource())) ) {
                    setCN_TaxInvoiceDataSource(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceExpenseReportNmbr") ) {
                final Object value = values.remove("CN_TaxInvoiceExpenseReportNmbr");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceExpenseReportNmbr())) ) {
                    setCN_TaxInvoiceExpenseReportNmbr(((String) value));
                }
            }
            if( values.containsKey("TaxCategory") ) {
                final Object value = values.remove("TaxCategory");
                if( (value == null) || (!value.equals(getTaxCategory())) ) {
                    setTaxCategory(((String) value));
                }
            }
            if( values.containsKey("CN_TaxDeclnTime") ) {
                final Object value = values.remove("CN_TaxDeclnTime");
                if( (value == null) || (!value.equals(getCN_TaxDeclnTime())) ) {
                    setCN_TaxDeclnTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CN_TaxDeclnYear") ) {
                final Object value = values.remove("CN_TaxDeclnYear");
                if( (value == null) || (!value.equals(getCN_TaxDeclnYear())) ) {
                    setCN_TaxDeclnYear(((String) value));
                }
            }
            if( values.containsKey("CN_TaxDeclnMonth") ) {
                final Object value = values.remove("CN_TaxDeclnMonth");
                if( (value == null) || (!value.equals(getCN_TaxDeclnMonth())) ) {
                    setCN_TaxDeclnMonth(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceBuyerAddressPhone") ) {
                final Object value = values.remove("TaxInvoiceBuyerAddressPhone");
                if( (value == null) || (!value.equals(getTaxInvoiceBuyerAddressPhone())) ) {
                    setTaxInvoiceBuyerAddressPhone(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceBuyerBankAccount") ) {
                final Object value = values.remove("TaxInvoiceBuyerBankAccount");
                if( (value == null) || (!value.equals(getTaxInvoiceBuyerBankAccount())) ) {
                    setTaxInvoiceBuyerBankAccount(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceSellerAddressPhone") ) {
                final Object value = values.remove("TaxInvoiceSellerAddressPhone");
                if( (value == null) || (!value.equals(getTaxInvoiceSellerAddressPhone())) ) {
                    setTaxInvoiceSellerAddressPhone(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceSellerBankAccount") ) {
                final Object value = values.remove("TaxInvoiceSellerBankAccount");
                if( (value == null) || (!value.equals(getTaxInvoiceSellerBankAccount())) ) {
                    setTaxInvoiceSellerBankAccount(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehicleType") ) {
                final Object value = values.remove("CN_TaxInvoiceVehicleType");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehicleType())) ) {
                    setCN_TaxInvoiceVehicleType(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehFactoryModel") ) {
                final Object value = values.remove("CN_TaxInvoiceVehFactoryModel");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehFactoryModel())) ) {
                    setCN_TaxInvoiceVehFactoryModel(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehicleProdnPlace") ) {
                final Object value = values.remove("CN_TaxInvoiceVehicleProdnPlace");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehicleProdnPlace())) ) {
                    setCN_TaxInvoiceVehicleProdnPlace(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehicleCertNumber") ) {
                final Object value = values.remove("CN_TaxInvoiceVehicleCertNumber");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehicleCertNumber())) ) {
                    setCN_TaxInvoiceVehicleCertNumber(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehImportCertNmbr") ) {
                final Object value = values.remove("CN_TaxInvoiceVehImportCertNmbr");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehImportCertNmbr())) ) {
                    setCN_TaxInvoiceVehImportCertNmbr(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehicleInspNumber") ) {
                final Object value = values.remove("CN_TaxInvoiceVehicleInspNumber");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehicleInspNumber())) ) {
                    setCN_TaxInvoiceVehicleInspNumber(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehicleEngineNmbr") ) {
                final Object value = values.remove("CN_TaxInvoiceVehicleEngineNmbr");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehicleEngineNmbr())) ) {
                    setCN_TaxInvoiceVehicleEngineNmbr(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehicleNumber") ) {
                final Object value = values.remove("CN_TaxInvoiceVehicleNumber");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehicleNumber())) ) {
                    setCN_TaxInvoiceVehicleNumber(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcVehTotAmtInInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcVehTotAmtInInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcVehTotAmtInInvcCrcy())) ) {
                    setCN_TaxInvcVehTotAmtInInvcCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehTxnRecordNmbr") ) {
                final Object value = values.remove("CN_TaxInvoiceVehTxnRecordNmbr");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehTxnRecordNmbr())) ) {
                    setCN_TaxInvoiceVehTxnRecordNmbr(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehicleTonnage") ) {
                final Object value = values.remove("CN_TaxInvoiceVehicleTonnage");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehicleTonnage())) ) {
                    setCN_TaxInvoiceVehicleTonnage(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvoiceVehPassengerLimit") ) {
                final Object value = values.remove("CN_TaxInvoiceVehPassengerLimit");
                if( (value == null) || (!value.equals(getCN_TaxInvoiceVehPassengerLimit())) ) {
                    setCN_TaxInvoiceVehPassengerLimit(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Binding") ) {
                final Object value = (values).remove("to_Binding");
                if( value instanceof Iterable ) {
                    if( toBinding == null ) {
                        toBinding = Lists.newArrayList();
                    } else {
                        toBinding = Lists.newArrayList(toBinding);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CN_TaxInvoiceBindingRecord entity;
                        if( toBinding.size() > i ) {
                            entity = toBinding.get(i);
                        } else {
                            entity = new CN_TaxInvoiceBindingRecord();
                            toBinding.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CN_TaxInputInvoiceItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new CN_TaxInputInvoiceItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CN_TaxInputInvoiceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CN_TaxInputInvoiceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CN_TaxInputInvoiceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CN_TaxInputInvoiceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBinding != null ) {
            (values).put("to_Binding", toBinding);
        }
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CN_TaxInvoiceBindingRecord</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Binding</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CN_TaxInvoiceBindingRecord</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CN_TaxInvoiceBindingRecord> fetchBinding()
    {
        return fetchFieldAsList("to_Binding", CN_TaxInvoiceBindingRecord.class);
    }

    /**
     * Retrieval of associated <b>CN_TaxInvoiceBindingRecord</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Binding</b>.
     * <p>
     * If the navigation property <b>to_Binding</b> of a queried <b>CN_TaxInputInvoice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CN_TaxInvoiceBindingRecord</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CN_TaxInvoiceBindingRecord> getBindingOrFetch()
    {
        if( toBinding == null ) {
            toBinding = fetchBinding();
        }
        return toBinding;
    }

    /**
     * Retrieval of associated <b>CN_TaxInvoiceBindingRecord</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Binding</b>.
     * <p>
     * If the navigation property for an entity <b>CN_TaxInputInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Binding</b> is already loaded, the result will contain
     *         the <b>CN_TaxInvoiceBindingRecord</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CN_TaxInvoiceBindingRecord>> getBindingIfPresent()
    {
        return Option.of(toBinding);
    }

    /**
     * Overwrites the list of associated <b>CN_TaxInvoiceBindingRecord</b> entities for the loaded navigation property
     * <b>to_Binding</b>.
     * <p>
     * If the navigation property <b>to_Binding</b> of a queried <b>CN_TaxInputInvoice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CN_TaxInvoiceBindingRecord</b> entities.
     */
    public void setBinding( @Nonnull final List<CN_TaxInvoiceBindingRecord> value )
    {
        if( toBinding == null ) {
            toBinding = Lists.newArrayList();
        }
        toBinding.clear();
        toBinding.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CN_TaxInvoiceBindingRecord</b> entities. This corresponds to the OData
     * navigation property <b>to_Binding</b>.
     * <p>
     * If the navigation property <b>to_Binding</b> of a queried <b>CN_TaxInputInvoice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CN_TaxInvoiceBindingRecord</b> entities.
     */
    public void addBinding( CN_TaxInvoiceBindingRecord... entity )
    {
        if( toBinding == null ) {
            toBinding = Lists.newArrayList();
        }
        toBinding.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CN_TaxInputInvoiceItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CN_TaxInputInvoiceItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CN_TaxInputInvoiceItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", CN_TaxInputInvoiceItem.class);
    }

    /**
     * Retrieval of associated <b>CN_TaxInputInvoiceItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CN_TaxInputInvoice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CN_TaxInputInvoiceItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CN_TaxInputInvoiceItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>CN_TaxInputInvoiceItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>CN_TaxInputInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>CN_TaxInputInvoiceItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CN_TaxInputInvoiceItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>CN_TaxInputInvoiceItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CN_TaxInputInvoice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CN_TaxInputInvoiceItem</b> entities.
     */
    public void setItem( @Nonnull final List<CN_TaxInputInvoiceItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CN_TaxInputInvoiceItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CN_TaxInputInvoice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CN_TaxInputInvoiceItem</b> entities.
     */
    public void addItem( CN_TaxInputInvoiceItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CN_TaxInputInvoice instances.
     *
     */
    public final static class CN_TaxInputInvoiceBuilder
    {

        private List<CN_TaxInvoiceBindingRecord> toBinding = Lists.newArrayList();
        private List<CN_TaxInputInvoiceItem> toItem = Lists.newArrayList();

        private CN_TaxInputInvoice.CN_TaxInputInvoiceBuilder toBinding( final List<CN_TaxInvoiceBindingRecord> value )
        {
            toBinding.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Binding</b> for <b>CN_TaxInputInvoice</b> to multiple
         * <b>CN_TaxInvoiceBindingRecord</b>.
         *
         * @param value
         *            The CN_TaxInvoiceBindingRecords to build this CN_TaxInputInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CN_TaxInputInvoice.CN_TaxInputInvoiceBuilder binding( CN_TaxInvoiceBindingRecord... value )
        {
            return toBinding(Lists.newArrayList(value));
        }

        private CN_TaxInputInvoice.CN_TaxInputInvoiceBuilder toItem( final List<CN_TaxInputInvoiceItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>CN_TaxInputInvoice</b> to multiple <b>CN_TaxInputInvoiceItem</b>.
         *
         * @param value
         *            The CN_TaxInputInvoiceItems to build this CN_TaxInputInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CN_TaxInputInvoice.CN_TaxInputInvoiceBuilder item( CN_TaxInputInvoiceItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

    }

}
