/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.field.CN_TaxInputInvoiceItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.link.CN_TaxInputInvoiceItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable.CN_TaxInputInvoiceItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * China Input Tax Invoice Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CN_TaxInputInvoiceItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CN_TaxInputInvoiceItem extends VdmEntity<CN_TaxInputInvoiceItem>
{

    /**
     * Selector for all available fields of CN_TaxInputInvoiceItem.
     *
     */
    public final static CN_TaxInputInvoiceItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemUUID</b>
     * </p>
     *
     * @return Invoice Item UUID
     */
    @Key
    @SerializedName( "TaxInvoiceItemUUID" )
    @JsonProperty( "TaxInvoiceItemUUID" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemUUID" )
    private UUID taxInvoiceItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemUUID</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<UUID> TAX_INVOICE_ITEM_UUID =
        new CN_TaxInputInvoiceItemField<UUID>("TaxInvoiceItemUUID");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     * </p>
     *
     * @return China Tax Invoice UUID
     */
    @Key
    @SerializedName( "CN_TaxInvcUUID" )
    @JsonProperty( "CN_TaxInvcUUID" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcUUID" )
    private UUID cN_TaxInvcUUID;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcUUID</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<UUID> CN_TAX_INVC_UUID =
        new CN_TaxInputInvoiceItemField<UUID>("CN_TaxInvcUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCode</b>
     * </p>
     *
     * @return China Tax Invoice Code
     */
    @SerializedName( "CN_TaxInvcCode" )
    @JsonProperty( "CN_TaxInvcCode" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcCode" )
    private String cN_TaxInvcCode;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcCode</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> CN_TAX_INVC_CODE =
        new CN_TaxInputInvoiceItemField<String>("CN_TaxInvcCode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNmbr</b>
     * </p>
     *
     * @return China Tax Invoice Number
     */
    @SerializedName( "CN_TaxInvcNmbr" )
    @JsonProperty( "CN_TaxInvcNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcNmbr" )
    private String cN_TaxInvcNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> CN_TAX_INVC_NMBR =
        new CN_TaxInputInvoiceItemField<String>("CN_TaxInvcNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItem</b>
     * </p>
     *
     * @return China Tax Invoice Item Number
     */
    @SerializedName( "TaxInvoiceItem" )
    @JsonProperty( "TaxInvoiceItem" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItem" )
    private String taxInvoiceItem;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItem</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItem");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemGoodsServiceName</b>
     * </p>
     *
     * @return China Tax Invoice Item Goods Service Name
     */
    @SerializedName( "TaxInvoiceItemGoodsServiceName" )
    @JsonProperty( "TaxInvoiceItemGoodsServiceName" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemGoodsServiceName" )
    private String taxInvoiceItemGoodsServiceName;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemGoodsServiceName</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_GOODS_SERVICE_NAME =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemGoodsServiceName");
    /**
     * Constraints: Not nullable, Maximum length: 19
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemGoodsNumber</b>
     * </p>
     *
     * @return China Tax Invoice Item Goods Number
     */
    @SerializedName( "TaxInvoiceItemGoodsNumber" )
    @JsonProperty( "TaxInvoiceItemGoodsNumber" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemGoodsNumber" )
    private String taxInvoiceItemGoodsNumber;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemGoodsNumber</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_GOODS_NUMBER =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemGoodsNumber");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemSpecModel</b>
     * </p>
     *
     * @return China Tax Invoice Item Specification Model
     */
    @SerializedName( "TaxInvoiceItemSpecModel" )
    @JsonProperty( "TaxInvoiceItemSpecModel" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemSpecModel" )
    private String taxInvoiceItemSpecModel;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemSpecModel</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_SPEC_MODEL =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemSpecModel");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> UNIT_OF_MEASURE =
        new CN_TaxInputInvoiceItemField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemUnitDescription</b>
     * </p>
     *
     * @return Unit Measurement Desc.
     */
    @SerializedName( "TaxInvoiceItemUnitDescription" )
    @JsonProperty( "TaxInvoiceItemUnitDescription" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemUnitDescription" )
    private String taxInvoiceItemUnitDescription;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemUnitDescription</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_UNIT_DESCRIPTION =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemUnitDescription");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemQuantity</b>
     * </p>
     *
     * @return China Tax Invoice Item Quantity
     */
    @SerializedName( "TaxInvoiceItemQuantity" )
    @JsonProperty( "TaxInvoiceItemQuantity" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemQuantity" )
    private BigDecimal taxInvoiceItemQuantity;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemQuantity</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<BigDecimal> TAX_INVOICE_ITEM_QUANTITY =
        new CN_TaxInputInvoiceItemField<BigDecimal>("TaxInvoiceItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCrcy</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "CN_TaxInvcCrcy" )
    @JsonProperty( "CN_TaxInvcCrcy" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcCrcy" )
    private String cN_TaxInvcCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcCrcy</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> CN_TAX_INVC_CRCY =
        new CN_TaxInputInvoiceItemField<String>("CN_TaxInvcCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemNetUnitPrice</b>
     * </p>
     *
     * @return China Tax Invoice Item Unit Price
     */
    @SerializedName( "TaxInvoiceItemNetUnitPrice" )
    @JsonProperty( "TaxInvoiceItemNetUnitPrice" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemNetUnitPrice" )
    private BigDecimal taxInvoiceItemNetUnitPrice;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemNetUnitPrice</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<BigDecimal> TAX_INVOICE_ITEM_NET_UNIT_PRICE =
        new CN_TaxInputInvoiceItemField<BigDecimal>("TaxInvoiceItemNetUnitPrice");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemNetAmount</b>
     * </p>
     *
     * @return China Tax Invoice Net Amount in Invoice Currency
     */
    @SerializedName( "TaxInvoiceItemNetAmount" )
    @JsonProperty( "TaxInvoiceItemNetAmount" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemNetAmount" )
    private BigDecimal taxInvoiceItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemNetAmount</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<BigDecimal> TAX_INVOICE_ITEM_NET_AMOUNT =
        new CN_TaxInputInvoiceItemField<BigDecimal>("TaxInvoiceItemNetAmount");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTaxRate</b>
     * </p>
     *
     * @return VAT Tax Rate
     */
    @SerializedName( "TaxInvoiceItemTaxRate" )
    @JsonProperty( "TaxInvoiceItemTaxRate" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemTaxRate" )
    private BigDecimal taxInvoiceItemTaxRate;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemTaxRate</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<BigDecimal> TAX_INVOICE_ITEM_TAX_RATE =
        new CN_TaxInputInvoiceItemField<BigDecimal>("TaxInvoiceItemTaxRate");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTaxAmount</b>
     * </p>
     *
     * @return China Tax Invoice Tax Amount in Invoice Currency
     */
    @SerializedName( "TaxInvoiceItemTaxAmount" )
    @JsonProperty( "TaxInvoiceItemTaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemTaxAmount" )
    private BigDecimal taxInvoiceItemTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemTaxAmount</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<BigDecimal> TAX_INVOICE_ITEM_TAX_AMOUNT =
        new CN_TaxInputInvoiceItemField<BigDecimal>("TaxInvoiceItemTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollCarLicPlate</b>
     * </p>
     *
     * @return China Tax Invoice Item Toll Car License Plate
     */
    @SerializedName( "TaxInvoiceItemTollCarLicPlate" )
    @JsonProperty( "TaxInvoiceItemTollCarLicPlate" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemTollCarLicPlate" )
    private String taxInvoiceItemTollCarLicPlate;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemTollCarLicPlate</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_TOLL_CAR_LIC_PLATE =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemTollCarLicPlate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollCarCategory</b>
     * </p>
     *
     * @return China Tax Invoice Item Toll Car Category
     */
    @SerializedName( "TaxInvoiceItemTollCarCategory" )
    @JsonProperty( "TaxInvoiceItemTollCarCategory" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemTollCarCategory" )
    private String taxInvoiceItemTollCarCategory;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemTollCarCategory</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_TOLL_CAR_CATEGORY =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemTollCarCategory");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollStrtDateTime</b>
     * </p>
     *
     * @return China Tax Invoice Item Toll Start Date Time
     */
    @SerializedName( "TaxInvoiceItemTollStrtDateTime" )
    @JsonProperty( "TaxInvoiceItemTollStrtDateTime" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemTollStrtDateTime" )
    private String taxInvoiceItemTollStrtDateTime;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemTollStrtDateTime</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_TOLL_STRT_DATE_TIME =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemTollStrtDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollEndDateTime</b>
     * </p>
     *
     * @return China Tax Invoice Item Toll Start Date Time
     */
    @SerializedName( "TaxInvoiceItemTollEndDateTime" )
    @JsonProperty( "TaxInvoiceItemTollEndDateTime" )
    @Nullable
    @ODataField( odataName = "TaxInvoiceItemTollEndDateTime" )
    private String taxInvoiceItemTollEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>TaxInvoiceItemTollEndDateTime</b> field to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemField<String> TAX_INVOICE_ITEM_TOLL_END_DATE_TIME =
        new CN_TaxInputInvoiceItemField<String>("TaxInvoiceItemTollEndDateTime");
    /**
     * Navigation property <b>to_Invoice</b> for <b>CN_TaxInputInvoiceItem</b> to single <b>CN_TaxInputInvoice</b>.
     *
     */
    @SerializedName( "to_Invoice" )
    @JsonProperty( "to_Invoice" )
    @ODataField( odataName = "to_Invoice" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CN_TaxInputInvoice toInvoice;
    /**
     * Use with available fluent helpers to apply the <b>to_Invoice</b> navigation property to query operations.
     *
     */
    public final static CN_TaxInputInvoiceItemOneToOneLink<CN_TaxInputInvoice> TO_INVOICE =
        new CN_TaxInputInvoiceItemOneToOneLink<CN_TaxInputInvoice>("to_Invoice");

    @Nonnull
    @Override
    public Class<CN_TaxInputInvoiceItem> getType()
    {
        return CN_TaxInputInvoiceItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemUUID</b>
     * </p>
     *
     * @param taxInvoiceItemUUID
     *            Invoice Item UUID
     */
    public void setTaxInvoiceItemUUID( @Nullable final UUID taxInvoiceItemUUID )
    {
        rememberChangedField("TaxInvoiceItemUUID", this.taxInvoiceItemUUID);
        this.taxInvoiceItemUUID = taxInvoiceItemUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     * </p>
     *
     * @param cN_TaxInvcUUID
     *            China Tax Invoice UUID
     */
    public void setCN_TaxInvcUUID( @Nullable final UUID cN_TaxInvcUUID )
    {
        rememberChangedField("CN_TaxInvcUUID", this.cN_TaxInvcUUID);
        this.cN_TaxInvcUUID = cN_TaxInvcUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCode</b>
     * </p>
     *
     * @param cN_TaxInvcCode
     *            China Tax Invoice Code
     */
    public void setCN_TaxInvcCode( @Nullable final String cN_TaxInvcCode )
    {
        rememberChangedField("CN_TaxInvcCode", this.cN_TaxInvcCode);
        this.cN_TaxInvcCode = cN_TaxInvcCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNmbr</b>
     * </p>
     *
     * @param cN_TaxInvcNmbr
     *            China Tax Invoice Number
     */
    public void setCN_TaxInvcNmbr( @Nullable final String cN_TaxInvcNmbr )
    {
        rememberChangedField("CN_TaxInvcNmbr", this.cN_TaxInvcNmbr);
        this.cN_TaxInvcNmbr = cN_TaxInvcNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItem</b>
     * </p>
     *
     * @param taxInvoiceItem
     *            China Tax Invoice Item Number
     */
    public void setTaxInvoiceItem( @Nullable final String taxInvoiceItem )
    {
        rememberChangedField("TaxInvoiceItem", this.taxInvoiceItem);
        this.taxInvoiceItem = taxInvoiceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemGoodsServiceName</b>
     * </p>
     *
     * @param taxInvoiceItemGoodsServiceName
     *            China Tax Invoice Item Goods Service Name
     */
    public void setTaxInvoiceItemGoodsServiceName( @Nullable final String taxInvoiceItemGoodsServiceName )
    {
        rememberChangedField("TaxInvoiceItemGoodsServiceName", this.taxInvoiceItemGoodsServiceName);
        this.taxInvoiceItemGoodsServiceName = taxInvoiceItemGoodsServiceName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 19
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemGoodsNumber</b>
     * </p>
     *
     * @param taxInvoiceItemGoodsNumber
     *            China Tax Invoice Item Goods Number
     */
    public void setTaxInvoiceItemGoodsNumber( @Nullable final String taxInvoiceItemGoodsNumber )
    {
        rememberChangedField("TaxInvoiceItemGoodsNumber", this.taxInvoiceItemGoodsNumber);
        this.taxInvoiceItemGoodsNumber = taxInvoiceItemGoodsNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemSpecModel</b>
     * </p>
     *
     * @param taxInvoiceItemSpecModel
     *            China Tax Invoice Item Specification Model
     */
    public void setTaxInvoiceItemSpecModel( @Nullable final String taxInvoiceItemSpecModel )
    {
        rememberChangedField("TaxInvoiceItemSpecModel", this.taxInvoiceItemSpecModel);
        this.taxInvoiceItemSpecModel = taxInvoiceItemSpecModel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Base Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemUnitDescription</b>
     * </p>
     *
     * @param taxInvoiceItemUnitDescription
     *            Unit Measurement Desc.
     */
    public void setTaxInvoiceItemUnitDescription( @Nullable final String taxInvoiceItemUnitDescription )
    {
        rememberChangedField("TaxInvoiceItemUnitDescription", this.taxInvoiceItemUnitDescription);
        this.taxInvoiceItemUnitDescription = taxInvoiceItemUnitDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemQuantity</b>
     * </p>
     *
     * @param taxInvoiceItemQuantity
     *            China Tax Invoice Item Quantity
     */
    public void setTaxInvoiceItemQuantity( @Nullable final BigDecimal taxInvoiceItemQuantity )
    {
        rememberChangedField("TaxInvoiceItemQuantity", this.taxInvoiceItemQuantity);
        this.taxInvoiceItemQuantity = taxInvoiceItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCrcy</b>
     * </p>
     *
     * @param cN_TaxInvcCrcy
     *            Currency Key
     */
    public void setCN_TaxInvcCrcy( @Nullable final String cN_TaxInvcCrcy )
    {
        rememberChangedField("CN_TaxInvcCrcy", this.cN_TaxInvcCrcy);
        this.cN_TaxInvcCrcy = cN_TaxInvcCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemNetUnitPrice</b>
     * </p>
     *
     * @param taxInvoiceItemNetUnitPrice
     *            China Tax Invoice Item Unit Price
     */
    public void setTaxInvoiceItemNetUnitPrice( @Nullable final BigDecimal taxInvoiceItemNetUnitPrice )
    {
        rememberChangedField("TaxInvoiceItemNetUnitPrice", this.taxInvoiceItemNetUnitPrice);
        this.taxInvoiceItemNetUnitPrice = taxInvoiceItemNetUnitPrice;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemNetAmount</b>
     * </p>
     *
     * @param taxInvoiceItemNetAmount
     *            China Tax Invoice Net Amount in Invoice Currency
     */
    public void setTaxInvoiceItemNetAmount( @Nullable final BigDecimal taxInvoiceItemNetAmount )
    {
        rememberChangedField("TaxInvoiceItemNetAmount", this.taxInvoiceItemNetAmount);
        this.taxInvoiceItemNetAmount = taxInvoiceItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTaxRate</b>
     * </p>
     *
     * @param taxInvoiceItemTaxRate
     *            VAT Tax Rate
     */
    public void setTaxInvoiceItemTaxRate( @Nullable final BigDecimal taxInvoiceItemTaxRate )
    {
        rememberChangedField("TaxInvoiceItemTaxRate", this.taxInvoiceItemTaxRate);
        this.taxInvoiceItemTaxRate = taxInvoiceItemTaxRate;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTaxAmount</b>
     * </p>
     *
     * @param taxInvoiceItemTaxAmount
     *            China Tax Invoice Tax Amount in Invoice Currency
     */
    public void setTaxInvoiceItemTaxAmount( @Nullable final BigDecimal taxInvoiceItemTaxAmount )
    {
        rememberChangedField("TaxInvoiceItemTaxAmount", this.taxInvoiceItemTaxAmount);
        this.taxInvoiceItemTaxAmount = taxInvoiceItemTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollCarLicPlate</b>
     * </p>
     *
     * @param taxInvoiceItemTollCarLicPlate
     *            China Tax Invoice Item Toll Car License Plate
     */
    public void setTaxInvoiceItemTollCarLicPlate( @Nullable final String taxInvoiceItemTollCarLicPlate )
    {
        rememberChangedField("TaxInvoiceItemTollCarLicPlate", this.taxInvoiceItemTollCarLicPlate);
        this.taxInvoiceItemTollCarLicPlate = taxInvoiceItemTollCarLicPlate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollCarCategory</b>
     * </p>
     *
     * @param taxInvoiceItemTollCarCategory
     *            China Tax Invoice Item Toll Car Category
     */
    public void setTaxInvoiceItemTollCarCategory( @Nullable final String taxInvoiceItemTollCarCategory )
    {
        rememberChangedField("TaxInvoiceItemTollCarCategory", this.taxInvoiceItemTollCarCategory);
        this.taxInvoiceItemTollCarCategory = taxInvoiceItemTollCarCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollStrtDateTime</b>
     * </p>
     *
     * @param taxInvoiceItemTollStrtDateTime
     *            China Tax Invoice Item Toll Start Date Time
     */
    public void setTaxInvoiceItemTollStrtDateTime( @Nullable final String taxInvoiceItemTollStrtDateTime )
    {
        rememberChangedField("TaxInvoiceItemTollStrtDateTime", this.taxInvoiceItemTollStrtDateTime);
        this.taxInvoiceItemTollStrtDateTime = taxInvoiceItemTollStrtDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>TaxInvoiceItemTollEndDateTime</b>
     * </p>
     *
     * @param taxInvoiceItemTollEndDateTime
     *            China Tax Invoice Item Toll Start Date Time
     */
    public void setTaxInvoiceItemTollEndDateTime( @Nullable final String taxInvoiceItemTollEndDateTime )
    {
        rememberChangedField("TaxInvoiceItemTollEndDateTime", this.taxInvoiceItemTollEndDateTime);
        this.taxInvoiceItemTollEndDateTime = taxInvoiceItemTollEndDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CN_TaxInputInvoiceItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("TaxInvoiceItemUUID", getTaxInvoiceItemUUID());
        result.put("CN_TaxInvcUUID", getCN_TaxInvcUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("TaxInvoiceItemUUID", getTaxInvoiceItemUUID());
        values.put("CN_TaxInvcUUID", getCN_TaxInvcUUID());
        values.put("CN_TaxInvcCode", getCN_TaxInvcCode());
        values.put("CN_TaxInvcNmbr", getCN_TaxInvcNmbr());
        values.put("TaxInvoiceItem", getTaxInvoiceItem());
        values.put("TaxInvoiceItemGoodsServiceName", getTaxInvoiceItemGoodsServiceName());
        values.put("TaxInvoiceItemGoodsNumber", getTaxInvoiceItemGoodsNumber());
        values.put("TaxInvoiceItemSpecModel", getTaxInvoiceItemSpecModel());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("TaxInvoiceItemUnitDescription", getTaxInvoiceItemUnitDescription());
        values.put("TaxInvoiceItemQuantity", getTaxInvoiceItemQuantity());
        values.put("CN_TaxInvcCrcy", getCN_TaxInvcCrcy());
        values.put("TaxInvoiceItemNetUnitPrice", getTaxInvoiceItemNetUnitPrice());
        values.put("TaxInvoiceItemNetAmount", getTaxInvoiceItemNetAmount());
        values.put("TaxInvoiceItemTaxRate", getTaxInvoiceItemTaxRate());
        values.put("TaxInvoiceItemTaxAmount", getTaxInvoiceItemTaxAmount());
        values.put("TaxInvoiceItemTollCarLicPlate", getTaxInvoiceItemTollCarLicPlate());
        values.put("TaxInvoiceItemTollCarCategory", getTaxInvoiceItemTollCarCategory());
        values.put("TaxInvoiceItemTollStrtDateTime", getTaxInvoiceItemTollStrtDateTime());
        values.put("TaxInvoiceItemTollEndDateTime", getTaxInvoiceItemTollEndDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaxInvoiceItemUUID") ) {
                final Object value = values.remove("TaxInvoiceItemUUID");
                if( (value == null) || (!value.equals(getTaxInvoiceItemUUID())) ) {
                    setTaxInvoiceItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("CN_TaxInvcUUID") ) {
                final Object value = values.remove("CN_TaxInvcUUID");
                if( (value == null) || (!value.equals(getCN_TaxInvcUUID())) ) {
                    setCN_TaxInvcUUID(((UUID) value));
                }
            }
            if( values.containsKey("CN_TaxInvcCode") ) {
                final Object value = values.remove("CN_TaxInvcCode");
                if( (value == null) || (!value.equals(getCN_TaxInvcCode())) ) {
                    setCN_TaxInvcCode(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcNmbr") ) {
                final Object value = values.remove("CN_TaxInvcNmbr");
                if( (value == null) || (!value.equals(getCN_TaxInvcNmbr())) ) {
                    setCN_TaxInvcNmbr(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItem") ) {
                final Object value = values.remove("TaxInvoiceItem");
                if( (value == null) || (!value.equals(getTaxInvoiceItem())) ) {
                    setTaxInvoiceItem(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemGoodsServiceName") ) {
                final Object value = values.remove("TaxInvoiceItemGoodsServiceName");
                if( (value == null) || (!value.equals(getTaxInvoiceItemGoodsServiceName())) ) {
                    setTaxInvoiceItemGoodsServiceName(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemGoodsNumber") ) {
                final Object value = values.remove("TaxInvoiceItemGoodsNumber");
                if( (value == null) || (!value.equals(getTaxInvoiceItemGoodsNumber())) ) {
                    setTaxInvoiceItemGoodsNumber(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemSpecModel") ) {
                final Object value = values.remove("TaxInvoiceItemSpecModel");
                if( (value == null) || (!value.equals(getTaxInvoiceItemSpecModel())) ) {
                    setTaxInvoiceItemSpecModel(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemUnitDescription") ) {
                final Object value = values.remove("TaxInvoiceItemUnitDescription");
                if( (value == null) || (!value.equals(getTaxInvoiceItemUnitDescription())) ) {
                    setTaxInvoiceItemUnitDescription(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemQuantity") ) {
                final Object value = values.remove("TaxInvoiceItemQuantity");
                if( (value == null) || (!value.equals(getTaxInvoiceItemQuantity())) ) {
                    setTaxInvoiceItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CN_TaxInvcCrcy") ) {
                final Object value = values.remove("CN_TaxInvcCrcy");
                if( (value == null) || (!value.equals(getCN_TaxInvcCrcy())) ) {
                    setCN_TaxInvcCrcy(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemNetUnitPrice") ) {
                final Object value = values.remove("TaxInvoiceItemNetUnitPrice");
                if( (value == null) || (!value.equals(getTaxInvoiceItemNetUnitPrice())) ) {
                    setTaxInvoiceItemNetUnitPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemNetAmount") ) {
                final Object value = values.remove("TaxInvoiceItemNetAmount");
                if( (value == null) || (!value.equals(getTaxInvoiceItemNetAmount())) ) {
                    setTaxInvoiceItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemTaxRate") ) {
                final Object value = values.remove("TaxInvoiceItemTaxRate");
                if( (value == null) || (!value.equals(getTaxInvoiceItemTaxRate())) ) {
                    setTaxInvoiceItemTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemTaxAmount") ) {
                final Object value = values.remove("TaxInvoiceItemTaxAmount");
                if( (value == null) || (!value.equals(getTaxInvoiceItemTaxAmount())) ) {
                    setTaxInvoiceItemTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemTollCarLicPlate") ) {
                final Object value = values.remove("TaxInvoiceItemTollCarLicPlate");
                if( (value == null) || (!value.equals(getTaxInvoiceItemTollCarLicPlate())) ) {
                    setTaxInvoiceItemTollCarLicPlate(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemTollCarCategory") ) {
                final Object value = values.remove("TaxInvoiceItemTollCarCategory");
                if( (value == null) || (!value.equals(getTaxInvoiceItemTollCarCategory())) ) {
                    setTaxInvoiceItemTollCarCategory(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemTollStrtDateTime") ) {
                final Object value = values.remove("TaxInvoiceItemTollStrtDateTime");
                if( (value == null) || (!value.equals(getTaxInvoiceItemTollStrtDateTime())) ) {
                    setTaxInvoiceItemTollStrtDateTime(((String) value));
                }
            }
            if( values.containsKey("TaxInvoiceItemTollEndDateTime") ) {
                final Object value = values.remove("TaxInvoiceItemTollEndDateTime");
                if( (value == null) || (!value.equals(getTaxInvoiceItemTollEndDateTime())) ) {
                    setTaxInvoiceItemTollEndDateTime(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Invoice") ) {
                final Object value = (values).remove("to_Invoice");
                if( value instanceof Map ) {
                    if( toInvoice == null ) {
                        toInvoice = new CN_TaxInputInvoice();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toInvoice.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CN_TaxInputInvoiceItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CN_TaxInputInvoiceItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CN_TaxInputInvoiceItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CN_TaxInputInvoiceItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInvoice != null ) {
            (values).put("to_Invoice", toInvoice);
        }
        return values;
    }

    /**
     * Fetches the <b>CN_TaxInputInvoice</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Invoice</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CN_TaxInputInvoice</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CN_TaxInputInvoice fetchInvoice()
    {
        return fetchFieldAsSingle("to_Invoice", CN_TaxInputInvoice.class);
    }

    /**
     * Retrieval of associated <b>CN_TaxInputInvoice</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Invoice</b>.
     * <p>
     * If the navigation property <b>to_Invoice</b> of a queried <b>CN_TaxInputInvoiceItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CN_TaxInputInvoice</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CN_TaxInputInvoice getInvoiceOrFetch()
    {
        if( toInvoice == null ) {
            toInvoice = fetchInvoice();
        }
        return toInvoice;
    }

    /**
     * Retrieval of associated <b>CN_TaxInputInvoice</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Invoice</b>.
     * <p>
     * If the navigation property for an entity <b>CN_TaxInputInvoiceItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Invoice</b> is already loaded, the result will contain
     *         the <b>CN_TaxInputInvoice</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<CN_TaxInputInvoice> getInvoiceIfPresent()
    {
        return Option.of(toInvoice);
    }

    /**
     * Overwrites the associated <b>CN_TaxInputInvoice</b> entity for the loaded navigation property <b>to_Invoice</b>.
     *
     * @param value
     *            New <b>CN_TaxInputInvoice</b> entity.
     */
    public void setInvoice( final CN_TaxInputInvoice value )
    {
        toInvoice = value;
    }

    /**
     * Helper class to allow for fluent creation of CN_TaxInputInvoiceItem instances.
     *
     */
    public final static class CN_TaxInputInvoiceItemBuilder
    {

        private CN_TaxInputInvoice toInvoice;

        private CN_TaxInputInvoiceItem.CN_TaxInputInvoiceItemBuilder toInvoice( final CN_TaxInputInvoice value )
        {
            toInvoice = value;
            return this;
        }

        /**
         * Navigation property <b>to_Invoice</b> for <b>CN_TaxInputInvoiceItem</b> to single <b>CN_TaxInputInvoice</b>.
         *
         * @param value
         *            The CN_TaxInputInvoice to build this CN_TaxInputInvoiceItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CN_TaxInputInvoiceItem.CN_TaxInputInvoiceItemBuilder invoice( final CN_TaxInputInvoice value )
        {
            return toInvoice(value);
        }

    }

}
