/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable.CN_TaxInputInvoiceItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
 * CN_TaxInputInvoiceItem} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CN_TaxInputInvoiceItemByKeyFluentHelper
    extends
    FluentHelperByKey<CN_TaxInputInvoiceItemByKeyFluentHelper, CN_TaxInputInvoiceItem, CN_TaxInputInvoiceItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     * CN_TaxInputInvoiceItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CN_TaxInputInvoiceItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CN_TaxInputInvoiceItem}
     * @param cN_TaxInvcUUID
     *            China Tax Invoice UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param taxInvoiceItemUUID
     *            Invoice Item UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public CN_TaxInputInvoiceItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID taxInvoiceItemUUID,
        final UUID cN_TaxInvcUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("TaxInvoiceItemUUID", taxInvoiceItemUUID);
        this.key.put("CN_TaxInvcUUID", cN_TaxInvcUUID);
    }

    @Override
    @Nonnull
    protected Class<CN_TaxInputInvoiceItem> getEntityClass()
    {
        return CN_TaxInputInvoiceItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
