/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable.CN_TaxInputInvoiceItemSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
 * CN_TaxInputInvoiceItem} entities. This fluent helper allows methods which modify the underlying query to be called
 * before executing the query itself.
 *
 */
public class CN_TaxInputInvoiceItemFluentHelper
    extends
    FluentHelperRead<CN_TaxInputInvoiceItemFluentHelper, CN_TaxInputInvoiceItem, CN_TaxInputInvoiceItemSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public CN_TaxInputInvoiceItemFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<CN_TaxInputInvoiceItem> getEntityClass()
    {
        return CN_TaxInputInvoiceItem.class;
    }

}
