/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.field.CN_TaxInvoiceBindingRecordField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.link.CN_TaxInvoiceBindingRecordOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable.CN_TaxInvoiceBindingRecordSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * China Input Tax Invoice Binding Record
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CN_TaxInvoiceBindingRecordType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CN_TaxInvoiceBindingRecord extends VdmEntity<CN_TaxInvoiceBindingRecord>
{

    /**
     * Selector for all available fields of CN_TaxInvoiceBindingRecord.
     *
     */
    public final static CN_TaxInvoiceBindingRecordSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgUUID</b>
     * </p>
     *
     * @return China Tax Invoice Binding UUID
     */
    @Key
    @SerializedName( "CN_TaxInvcBindgUUID" )
    @JsonProperty( "CN_TaxInvcBindgUUID" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcBindgUUID" )
    private UUID cN_TaxInvcBindgUUID;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcBindgUUID</b> field to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordField<UUID> CN_TAX_INVC_BINDG_UUID =
        new CN_TaxInvoiceBindingRecordField<UUID>("CN_TaxInvcBindgUUID");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgItmUUID</b>
     * </p>
     *
     * @return China Tax Invoice Binding Item UUID
     */
    @Key
    @SerializedName( "CN_TaxInvcBindgItmUUID" )
    @JsonProperty( "CN_TaxInvcBindgItmUUID" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcBindgItmUUID" )
    private UUID cN_TaxInvcBindgItmUUID;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcBindgItmUUID</b> field to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordField<UUID> CN_TAX_INVC_BINDG_ITM_UUID =
        new CN_TaxInvoiceBindingRecordField<UUID>("CN_TaxInvcBindgItmUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     * </p>
     *
     * @return China Tax Invoice UUID
     */
    @SerializedName( "CN_TaxInvcUUID" )
    @JsonProperty( "CN_TaxInvcUUID" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcUUID" )
    private UUID cN_TaxInvcUUID;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcUUID</b> field to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordField<UUID> CN_TAX_INVC_UUID =
        new CN_TaxInvoiceBindingRecordField<UUID>("CN_TaxInvcUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCode</b>
     * </p>
     *
     * @return China Tax Invoice Code
     */
    @SerializedName( "CN_TaxInvcCode" )
    @JsonProperty( "CN_TaxInvcCode" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcCode" )
    private String cN_TaxInvcCode;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcCode</b> field to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordField<String> CN_TAX_INVC_CODE =
        new CN_TaxInvoiceBindingRecordField<String>("CN_TaxInvcCode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNmbr</b>
     * </p>
     *
     * @return China Tax Invoice Number
     */
    @SerializedName( "CN_TaxInvcNmbr" )
    @JsonProperty( "CN_TaxInvcNmbr" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcNmbr" )
    private String cN_TaxInvcNmbr;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcNmbr</b> field to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordField<String> CN_TAX_INVC_NMBR =
        new CN_TaxInvoiceBindingRecordField<String>("CN_TaxInvcNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgSrceBusObjType</b>
     * </p>
     *
     * @return China Tax Invoice Binding Source BO Type
     */
    @SerializedName( "CN_TaxInvcBindgSrceBusObjType" )
    @JsonProperty( "CN_TaxInvcBindgSrceBusObjType" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcBindgSrceBusObjType" )
    private String cN_TaxInvcBindgSrceBusObjType;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcBindgSrceBusObjType</b> field to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordField<String> CN_TAX_INVC_BINDG_SRCE_BUS_OBJ_TYPE =
        new CN_TaxInvoiceBindingRecordField<String>("CN_TaxInvcBindgSrceBusObjType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgSrceBusObjKey</b>
     * </p>
     *
     * @return China Tax Invoice Binding Source BO Key
     */
    @SerializedName( "CN_TaxInvcBindgSrceBusObjKey" )
    @JsonProperty( "CN_TaxInvcBindgSrceBusObjKey" )
    @Nullable
    @ODataField( odataName = "CN_TaxInvcBindgSrceBusObjKey" )
    private String cN_TaxInvcBindgSrceBusObjKey;
    /**
     * Use with available fluent helpers to apply the <b>CN_TaxInvcBindgSrceBusObjKey</b> field to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordField<String> CN_TAX_INVC_BINDG_SRCE_BUS_OBJ_KEY =
        new CN_TaxInvoiceBindingRecordField<String>("CN_TaxInvcBindgSrceBusObjKey");
    /**
     * Navigation property <b>to_Invoice</b> for <b>CN_TaxInvoiceBindingRecord</b> to single <b>CN_TaxInputInvoice</b>.
     *
     */
    @SerializedName( "to_Invoice" )
    @JsonProperty( "to_Invoice" )
    @ODataField( odataName = "to_Invoice" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CN_TaxInputInvoice toInvoice;
    /**
     * Use with available fluent helpers to apply the <b>to_Invoice</b> navigation property to query operations.
     *
     */
    public final static CN_TaxInvoiceBindingRecordOneToOneLink<CN_TaxInputInvoice> TO_INVOICE =
        new CN_TaxInvoiceBindingRecordOneToOneLink<CN_TaxInputInvoice>("to_Invoice");

    @Nonnull
    @Override
    public Class<CN_TaxInvoiceBindingRecord> getType()
    {
        return CN_TaxInvoiceBindingRecord.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgUUID</b>
     * </p>
     *
     * @param cN_TaxInvcBindgUUID
     *            China Tax Invoice Binding UUID
     */
    public void setCN_TaxInvcBindgUUID( @Nullable final UUID cN_TaxInvcBindgUUID )
    {
        rememberChangedField("CN_TaxInvcBindgUUID", this.cN_TaxInvcBindgUUID);
        this.cN_TaxInvcBindgUUID = cN_TaxInvcBindgUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgItmUUID</b>
     * </p>
     *
     * @param cN_TaxInvcBindgItmUUID
     *            China Tax Invoice Binding Item UUID
     */
    public void setCN_TaxInvcBindgItmUUID( @Nullable final UUID cN_TaxInvcBindgItmUUID )
    {
        rememberChangedField("CN_TaxInvcBindgItmUUID", this.cN_TaxInvcBindgItmUUID);
        this.cN_TaxInvcBindgItmUUID = cN_TaxInvcBindgItmUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     * </p>
     *
     * @param cN_TaxInvcUUID
     *            China Tax Invoice UUID
     */
    public void setCN_TaxInvcUUID( @Nullable final UUID cN_TaxInvcUUID )
    {
        rememberChangedField("CN_TaxInvcUUID", this.cN_TaxInvcUUID);
        this.cN_TaxInvcUUID = cN_TaxInvcUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcCode</b>
     * </p>
     *
     * @param cN_TaxInvcCode
     *            China Tax Invoice Code
     */
    public void setCN_TaxInvcCode( @Nullable final String cN_TaxInvcCode )
    {
        rememberChangedField("CN_TaxInvcCode", this.cN_TaxInvcCode);
        this.cN_TaxInvcCode = cN_TaxInvcCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcNmbr</b>
     * </p>
     *
     * @param cN_TaxInvcNmbr
     *            China Tax Invoice Number
     */
    public void setCN_TaxInvcNmbr( @Nullable final String cN_TaxInvcNmbr )
    {
        rememberChangedField("CN_TaxInvcNmbr", this.cN_TaxInvcNmbr);
        this.cN_TaxInvcNmbr = cN_TaxInvcNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgSrceBusObjType</b>
     * </p>
     *
     * @param cN_TaxInvcBindgSrceBusObjType
     *            China Tax Invoice Binding Source BO Type
     */
    public void setCN_TaxInvcBindgSrceBusObjType( @Nullable final String cN_TaxInvcBindgSrceBusObjType )
    {
        rememberChangedField("CN_TaxInvcBindgSrceBusObjType", this.cN_TaxInvcBindgSrceBusObjType);
        this.cN_TaxInvcBindgSrceBusObjType = cN_TaxInvcBindgSrceBusObjType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CN_TaxInvcBindgSrceBusObjKey</b>
     * </p>
     *
     * @param cN_TaxInvcBindgSrceBusObjKey
     *            China Tax Invoice Binding Source BO Key
     */
    public void setCN_TaxInvcBindgSrceBusObjKey( @Nullable final String cN_TaxInvcBindgSrceBusObjKey )
    {
        rememberChangedField("CN_TaxInvcBindgSrceBusObjKey", this.cN_TaxInvcBindgSrceBusObjKey);
        this.cN_TaxInvcBindgSrceBusObjKey = cN_TaxInvcBindgSrceBusObjKey;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CN_TaxInvoiceBindingRecord";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CN_TaxInvcBindgUUID", getCN_TaxInvcBindgUUID());
        result.put("CN_TaxInvcBindgItmUUID", getCN_TaxInvcBindgItmUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CN_TaxInvcBindgUUID", getCN_TaxInvcBindgUUID());
        values.put("CN_TaxInvcBindgItmUUID", getCN_TaxInvcBindgItmUUID());
        values.put("CN_TaxInvcUUID", getCN_TaxInvcUUID());
        values.put("CN_TaxInvcCode", getCN_TaxInvcCode());
        values.put("CN_TaxInvcNmbr", getCN_TaxInvcNmbr());
        values.put("CN_TaxInvcBindgSrceBusObjType", getCN_TaxInvcBindgSrceBusObjType());
        values.put("CN_TaxInvcBindgSrceBusObjKey", getCN_TaxInvcBindgSrceBusObjKey());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CN_TaxInvcBindgUUID") ) {
                final Object value = values.remove("CN_TaxInvcBindgUUID");
                if( (value == null) || (!value.equals(getCN_TaxInvcBindgUUID())) ) {
                    setCN_TaxInvcBindgUUID(((UUID) value));
                }
            }
            if( values.containsKey("CN_TaxInvcBindgItmUUID") ) {
                final Object value = values.remove("CN_TaxInvcBindgItmUUID");
                if( (value == null) || (!value.equals(getCN_TaxInvcBindgItmUUID())) ) {
                    setCN_TaxInvcBindgItmUUID(((UUID) value));
                }
            }
            if( values.containsKey("CN_TaxInvcUUID") ) {
                final Object value = values.remove("CN_TaxInvcUUID");
                if( (value == null) || (!value.equals(getCN_TaxInvcUUID())) ) {
                    setCN_TaxInvcUUID(((UUID) value));
                }
            }
            if( values.containsKey("CN_TaxInvcCode") ) {
                final Object value = values.remove("CN_TaxInvcCode");
                if( (value == null) || (!value.equals(getCN_TaxInvcCode())) ) {
                    setCN_TaxInvcCode(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcNmbr") ) {
                final Object value = values.remove("CN_TaxInvcNmbr");
                if( (value == null) || (!value.equals(getCN_TaxInvcNmbr())) ) {
                    setCN_TaxInvcNmbr(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcBindgSrceBusObjType") ) {
                final Object value = values.remove("CN_TaxInvcBindgSrceBusObjType");
                if( (value == null) || (!value.equals(getCN_TaxInvcBindgSrceBusObjType())) ) {
                    setCN_TaxInvcBindgSrceBusObjType(((String) value));
                }
            }
            if( values.containsKey("CN_TaxInvcBindgSrceBusObjKey") ) {
                final Object value = values.remove("CN_TaxInvcBindgSrceBusObjKey");
                if( (value == null) || (!value.equals(getCN_TaxInvcBindgSrceBusObjKey())) ) {
                    setCN_TaxInvcBindgSrceBusObjKey(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Invoice") ) {
                final Object value = (values).remove("to_Invoice");
                if( value instanceof Map ) {
                    if( toInvoice == null ) {
                        toInvoice = new CN_TaxInputInvoice();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toInvoice.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CN_TaxInvoiceBindingRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CN_TaxInvoiceBindingRecordField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CN_TaxInvoiceBindingRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CN_TaxInvoiceBindingRecordField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInvoice != null ) {
            (values).put("to_Invoice", toInvoice);
        }
        return values;
    }

    /**
     * Fetches the <b>CN_TaxInputInvoice</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Invoice</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CN_TaxInputInvoice</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CN_TaxInputInvoice fetchInvoice()
    {
        return fetchFieldAsSingle("to_Invoice", CN_TaxInputInvoice.class);
    }

    /**
     * Retrieval of associated <b>CN_TaxInputInvoice</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Invoice</b>.
     * <p>
     * If the navigation property <b>to_Invoice</b> of a queried <b>CN_TaxInvoiceBindingRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CN_TaxInputInvoice</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CN_TaxInputInvoice getInvoiceOrFetch()
    {
        if( toInvoice == null ) {
            toInvoice = fetchInvoice();
        }
        return toInvoice;
    }

    /**
     * Retrieval of associated <b>CN_TaxInputInvoice</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Invoice</b>.
     * <p>
     * If the navigation property for an entity <b>CN_TaxInvoiceBindingRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Invoice</b> is already loaded, the result will contain
     *         the <b>CN_TaxInputInvoice</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<CN_TaxInputInvoice> getInvoiceIfPresent()
    {
        return Option.of(toInvoice);
    }

    /**
     * Overwrites the associated <b>CN_TaxInputInvoice</b> entity for the loaded navigation property <b>to_Invoice</b>.
     *
     * @param value
     *            New <b>CN_TaxInputInvoice</b> entity.
     */
    public void setInvoice( final CN_TaxInputInvoice value )
    {
        toInvoice = value;
    }

    /**
     * Helper class to allow for fluent creation of CN_TaxInvoiceBindingRecord instances.
     *
     */
    public final static class CN_TaxInvoiceBindingRecordBuilder
    {

        private CN_TaxInputInvoice toInvoice;

        private CN_TaxInvoiceBindingRecord.CN_TaxInvoiceBindingRecordBuilder toInvoice( final CN_TaxInputInvoice value )
        {
            toInvoice = value;
            return this;
        }

        /**
         * Navigation property <b>to_Invoice</b> for <b>CN_TaxInvoiceBindingRecord</b> to single
         * <b>CN_TaxInputInvoice</b>.
         *
         * @param value
         *            The CN_TaxInputInvoice to build this CN_TaxInvoiceBindingRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CN_TaxInvoiceBindingRecord.CN_TaxInvoiceBindingRecordBuilder invoice( final CN_TaxInputInvoice value )
        {
            return toInvoice(value);
        }

    }

}
