/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable.CN_TaxInvoiceBindingRecordSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
 * CN_TaxInvoiceBindingRecord} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CN_TaxInvoiceBindingRecordByKeyFluentHelper
    extends
    FluentHelperByKey<CN_TaxInvoiceBindingRecordByKeyFluentHelper, CN_TaxInvoiceBindingRecord, CN_TaxInvoiceBindingRecordSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     * CN_TaxInvoiceBindingRecord} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CN_TaxInvoiceBindingRecord}
     * @param cN_TaxInvcBindgUUID
     *            China Tax Invoice Binding UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CN_TaxInvoiceBindingRecord}
     * @param cN_TaxInvcBindgItmUUID
     *            China Tax Invoice Binding Item UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public CN_TaxInvoiceBindingRecordByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID cN_TaxInvcBindgUUID,
        final UUID cN_TaxInvcBindgItmUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("CN_TaxInvcBindgUUID", cN_TaxInvcBindgUUID);
        this.key.put("CN_TaxInvcBindgItmUUID", cN_TaxInvcBindgItmUUID);
    }

    @Override
    @Nonnull
    protected Class<CN_TaxInvoiceBindingRecord> getEntityClass()
    {
        return CN_TaxInvoiceBindingRecord.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
