/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina;

import java.net.URI;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>declareInvoice</b> OData function import.
 *
 */
public class DeclareInvoiceFluentHelper
    extends
    SingleValuedFluentHelperFunction<DeclareInvoiceFluentHelper, OperationMessage, OperationMessage>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>declareInvoice</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param declnMonth
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeclnMonth</b>
     *            </p>
     * @param cN_TaxInvcUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     *            </p>
     * @param declnYear
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeclnYear</b>
     *            </p>
     */
    public DeclareInvoiceFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final UUID cN_TaxInvcUUID,
        @Nonnull final String declnMonth,
        @Nonnull final String declnYear )
    {
        super(servicePath);
        values.put("CN_TaxInvcUUID", cN_TaxInvcUUID);
        values.put("DeclnMonth", declnMonth);
        values.put("DeclnYear", declnYear);
    }

    @Override
    @Nonnull
    protected Class<OperationMessage> getEntityClass()
    {
        return OperationMessage.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "declareInvoice";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public OperationMessage executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
