/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link IncomingVATInvoiceChinaServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService
 * IncomingVATInvoiceChinaService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultIncomingVATInvoiceChinaServiceBatch
    extends
    BatchFluentHelperBasic<IncomingVATInvoiceChinaServiceBatch, IncomingVATInvoiceChinaServiceBatchChangeSet>
    implements
    IncomingVATInvoiceChinaServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultIncomingVATInvoiceChinaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultIncomingVATInvoiceChinaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultIncomingVATInvoiceChinaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultIncomingVATInvoiceChinaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultIncomingVATInvoiceChinaServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public IncomingVATInvoiceChinaServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultIncomingVATInvoiceChinaServiceBatchChangeSet(this, service);
    }

}
