/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord;

/**
 * Implementation of the {@link IncomingVATInvoiceChinaServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService
 * IncomingVATInvoiceChinaService}.
 *
 */
public class DefaultIncomingVATInvoiceChinaServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<IncomingVATInvoiceChinaServiceBatch, IncomingVATInvoiceChinaServiceBatchChangeSet>
    implements
    IncomingVATInvoiceChinaServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService service;

    @SuppressWarnings( "deprecation" )
    DefaultIncomingVATInvoiceChinaServiceBatchChangeSet(
        @Nonnull final DefaultIncomingVATInvoiceChinaServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultIncomingVATInvoiceChinaServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public IncomingVATInvoiceChinaServiceBatchChangeSet createCN_TaxInputInvoice(
        @Nonnull final CN_TaxInputInvoice cN_TaxInputInvoice )
    {
        return addRequestCreate(service::createCN_TaxInputInvoice, cN_TaxInputInvoice);
    }

    @Nonnull
    @Override
    public IncomingVATInvoiceChinaServiceBatchChangeSet createCN_TaxInputInvoiceItem(
        @Nonnull final CN_TaxInputInvoiceItem cN_TaxInputInvoiceItem )
    {
        return addRequestCreate(service::createCN_TaxInputInvoiceItem, cN_TaxInputInvoiceItem);
    }

    @Nonnull
    @Override
    public IncomingVATInvoiceChinaServiceBatchChangeSet createCN_TaxInvoiceBindingRecord(
        @Nonnull final CN_TaxInvoiceBindingRecord cN_TaxInvoiceBindingRecord )
    {
        return addRequestCreate(service::createCN_TaxInvoiceBindingRecord, cN_TaxInvoiceBindingRecord);
    }

}
