/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncomingVATInvoiceChinaService
 * IncomingVATInvoiceChinaService}.
 *
 */
public interface IncomingVATInvoiceChinaServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<IncomingVATInvoiceChinaServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<IncomingVATInvoiceChinaServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     * CN_TaxInputInvoice} entity and save it to the S/4HANA system.
     *
     * @param cN_TaxInputInvoice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     *            CN_TaxInputInvoice} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    IncomingVATInvoiceChinaServiceBatchChangeSet
        createCN_TaxInputInvoice( @Nonnull final CN_TaxInputInvoice cN_TaxInputInvoice );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     * CN_TaxInputInvoiceItem} entity and save it to the S/4HANA system.
     *
     * @param cN_TaxInputInvoiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     *            CN_TaxInputInvoiceItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    IncomingVATInvoiceChinaServiceBatchChangeSet
        createCN_TaxInputInvoiceItem( @Nonnull final CN_TaxInputInvoiceItem cN_TaxInputInvoiceItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     * CN_TaxInvoiceBindingRecord} entity and save it to the S/4HANA system.
     *
     * @param cN_TaxInvoiceBindingRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     *            CN_TaxInvoiceBindingRecord} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    IncomingVATInvoiceChinaServiceBatchChangeSet
        createCN_TaxInvoiceBindingRecord( @Nonnull final CN_TaxInvoiceBindingRecord cN_TaxInvoiceBindingRecord );

}
