/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable.CN_TaxInputInvoiceSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
 * CN_TaxInputInvoice} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class CN_TaxInputInvoiceLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<CN_TaxInputInvoiceLink<ObjectT>, CN_TaxInputInvoice, ObjectT>
    implements
    CN_TaxInputInvoiceSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public CN_TaxInputInvoiceLink( final String fieldName )
    {
        super(fieldName);
    }

    private CN_TaxInputInvoiceLink(
        final EntityLink<CN_TaxInputInvoiceLink<ObjectT>, CN_TaxInputInvoice, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected CN_TaxInputInvoiceLink<ObjectT> translateLinkType(
        final EntityLink<CN_TaxInputInvoiceLink<ObjectT>, CN_TaxInputInvoice, ObjectT> link )
    {
        return new CN_TaxInputInvoiceLink<ObjectT>(link);
    }

}
