/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
 * CN_TaxInputInvoiceItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.field.CN_TaxInputInvoiceItemField
 * CN_TaxInputInvoiceItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.link.CN_TaxInputInvoiceItemLink
 * CN_TaxInputInvoiceItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_UUID
 * TAX_INVOICE_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#CN_TAX_INVC_UUID
 * CN_TAX_INVC_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#CN_TAX_INVC_CODE
 * CN_TAX_INVC_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#CN_TAX_INVC_NMBR
 * CN_TAX_INVC_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM
 * TAX_INVOICE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_GOODS_SERVICE_NAME
 * TAX_INVOICE_ITEM_GOODS_SERVICE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_GOODS_NUMBER
 * TAX_INVOICE_ITEM_GOODS_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_SPEC_MODEL
 * TAX_INVOICE_ITEM_SPEC_MODEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#UNIT_OF_MEASURE
 * UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_UNIT_DESCRIPTION
 * TAX_INVOICE_ITEM_UNIT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_QUANTITY
 * TAX_INVOICE_ITEM_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#CN_TAX_INVC_CRCY
 * CN_TAX_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_NET_UNIT_PRICE
 * TAX_INVOICE_ITEM_NET_UNIT_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_NET_AMOUNT
 * TAX_INVOICE_ITEM_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_TAX_RATE
 * TAX_INVOICE_ITEM_TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_TAX_AMOUNT
 * TAX_INVOICE_ITEM_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_TOLL_CAR_LIC_PLATE
 * TAX_INVOICE_ITEM_TOLL_CAR_LIC_PLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_TOLL_CAR_CATEGORY
 * TAX_INVOICE_ITEM_TOLL_CAR_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_TOLL_STRT_DATE_TIME
 * TAX_INVOICE_ITEM_TOLL_STRT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TAX_INVOICE_ITEM_TOLL_END_DATE_TIME
 * TAX_INVOICE_ITEM_TOLL_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem#TO_INVOICE
 * TO_INVOICE}</li>
 * </ul>
 *
 */
public interface CN_TaxInputInvoiceItemSelectable extends EntitySelectable<CN_TaxInputInvoiceItem>
{

}
