/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
 * CN_TaxInputInvoice}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.field.CN_TaxInputInvoiceField
 * CN_TaxInputInvoiceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.link.CN_TaxInputInvoiceLink
 * CN_TaxInputInvoiceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_UUID
 * CN_TAX_INVC_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_CODE
 * CN_TAX_INVC_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_NMBR
 * CN_TAX_INVC_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_SELLER_REGN_NMBR
 * CN_TAX_SELLER_REGN_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_BUYER_REGN_NMBR
 * CN_TAX_BUYER_REGN_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_TYPE
 * CN_TAX_INVC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_DATE
 * CN_TAX_INVC_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_CRCY
 * CN_TAX_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_NET_AMT_IN_INVC_CRCY
 * CN_TAX_INVC_NET_AMT_IN_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_TAX_AMT_IN_INVC_CRCY
 * CN_TAX_INVC_TAX_AMT_IN_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_DEDUCT_AMT_IN_INVC_CRCY
 * CN_TAX_INVC_DEDUCT_AMT_IN_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#BUSINESS_PLACE
 * BUSINESS_PLACE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_DISC_NET_AMT_IN_INVC_CRCY
 * CN_TAX_INVC_DISC_NET_AMT_IN_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_DISC_TAX_AMT_IN_INVC_CRCY
 * CN_TAX_INVC_DISC_TAX_AMT_IN_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TAX_RATE
 * TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_GLDN_TX_SYST_STS
 * CN_TAX_INVC_GLDN_TX_SYST_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_GLDN_TX_SYST_STS_SYNC_TME
 * CN_TAX_INVC_GLDN_TX_SYST_STS_SYNC_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_INPT_PROCG_STS
 * CN_TAX_INVC_INPT_PROCG_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_DEDUCTION_TYPE
 * CN_TAX_INVC_DEDUCTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_SELLER_NAME
 * CN_TAX_SELLER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_COMMENT
 * CN_TAX_INVC_COMMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_USAGE
 * CN_TAX_INVOICE_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_DATA_SOURCE
 * CN_TAX_INVOICE_DATA_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_EXPENSE_REPORT_NMBR
 * CN_TAX_INVOICE_EXPENSE_REPORT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TAX_CATEGORY
 * TAX_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_DECLN_TIME
 * CN_TAX_DECLN_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_DECLN_YEAR
 * CN_TAX_DECLN_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_DECLN_MONTH
 * CN_TAX_DECLN_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TAX_INVOICE_BUYER_ADDRESS_PHONE
 * TAX_INVOICE_BUYER_ADDRESS_PHONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TAX_INVOICE_BUYER_BANK_ACCOUNT
 * TAX_INVOICE_BUYER_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TAX_INVOICE_SELLER_ADDRESS_PHONE
 * TAX_INVOICE_SELLER_ADDRESS_PHONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TAX_INVOICE_SELLER_BANK_ACCOUNT
 * TAX_INVOICE_SELLER_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEHICLE_TYPE
 * CN_TAX_INVOICE_VEHICLE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEH_FACTORY_MODEL
 * CN_TAX_INVOICE_VEH_FACTORY_MODEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEHICLE_PRODN_PLACE
 * CN_TAX_INVOICE_VEHICLE_PRODN_PLACE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEHICLE_CERT_NUMBER
 * CN_TAX_INVOICE_VEHICLE_CERT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEH_IMPORT_CERT_NMBR
 * CN_TAX_INVOICE_VEH_IMPORT_CERT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEHICLE_INSP_NUMBER
 * CN_TAX_INVOICE_VEHICLE_INSP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEHICLE_ENGINE_NMBR
 * CN_TAX_INVOICE_VEHICLE_ENGINE_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEHICLE_NUMBER
 * CN_TAX_INVOICE_VEHICLE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVC_VEH_TOT_AMT_IN_INVC_CRCY
 * CN_TAX_INVC_VEH_TOT_AMT_IN_INVC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEH_TXN_RECORD_NMBR
 * CN_TAX_INVOICE_VEH_TXN_RECORD_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEHICLE_TONNAGE
 * CN_TAX_INVOICE_VEHICLE_TONNAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#CN_TAX_INVOICE_VEH_PASSENGER_LIMIT
 * CN_TAX_INVOICE_VEH_PASSENGER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TO_BINDING
 * TO_BINDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice#TO_ITEM
 * TO_ITEM}</li>
 * </ul>
 *
 */
public interface CN_TaxInputInvoiceSelectable extends EntitySelectable<CN_TaxInputInvoice>
{

}
