/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
 * CN_TaxInvoiceBindingRecord}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.field.CN_TaxInvoiceBindingRecordField
 * CN_TaxInvoiceBindingRecordField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.link.CN_TaxInvoiceBindingRecordLink
 * CN_TaxInvoiceBindingRecordLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#CN_TAX_INVC_BINDG_UUID
 * CN_TAX_INVC_BINDG_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#CN_TAX_INVC_BINDG_ITM_UUID
 * CN_TAX_INVC_BINDG_ITM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#CN_TAX_INVC_UUID
 * CN_TAX_INVC_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#CN_TAX_INVC_CODE
 * CN_TAX_INVC_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#CN_TAX_INVC_NMBR
 * CN_TAX_INVC_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#CN_TAX_INVC_BINDG_SRCE_BUS_OBJ_TYPE
 * CN_TAX_INVC_BINDG_SRCE_BUS_OBJ_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#CN_TAX_INVC_BINDG_SRCE_BUS_OBJ_KEY
 * CN_TAX_INVC_BINDG_SRCE_BUS_OBJ_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord#TO_INVOICE
 * TO_INVOICE}</li>
 * </ul>
 *
 */
public interface CN_TaxInvoiceBindingRecordSelectable extends EntitySelectable<CN_TaxInvoiceBindingRecord>
{

}
