/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.field.IncotermsClassificationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.link.IncotermsClassificationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable.IncotermsClassificationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Incoterms
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_IncotermsClassificationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IncotermsClassification extends VdmEntity<IncotermsClassification>
{

    /**
     * Selector for all available fields of IncotermsClassification.
     *
     */
    public final static IncotermsClassificationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @Key
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static IncotermsClassificationField<String> INCOTERMS_CLASSIFICATION =
        new IncotermsClassificationField<String>("IncotermsClassification");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LocationIsMandatory</b>
     * </p>
     *
     * @return Location is mandatory
     */
    @SerializedName( "LocationIsMandatory" )
    @JsonProperty( "LocationIsMandatory" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LocationIsMandatory" )
    private Boolean locationIsMandatory;
    /**
     * Use with available fluent helpers to apply the <b>LocationIsMandatory</b> field to query operations.
     *
     */
    public final static IncotermsClassificationField<Boolean> LOCATION_IS_MANDATORY =
        new IncotermsClassificationField<Boolean>("LocationIsMandatory");
    /**
     * Navigation property <b>to_IncotermsClassificationText</b> for <b>IncotermsClassification</b> to multiple
     * <b>IncotermsClassificationText</b>.
     *
     */
    @SerializedName( "to_IncotermsClassificationText" )
    @JsonProperty( "to_IncotermsClassificationText" )
    @ODataField( odataName = "to_IncotermsClassificationText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<IncotermsClassificationText> toIncotermsClassificationText;
    /**
     * Use with available fluent helpers to apply the <b>to_IncotermsClassificationText</b> navigation property to query
     * operations.
     *
     */
    public final static IncotermsClassificationLink<IncotermsClassificationText> TO_INCOTERMS_CLASSIFICATION_TEXT =
        new IncotermsClassificationLink<IncotermsClassificationText>("to_IncotermsClassificationText");

    @Nonnull
    @Override
    public Class<IncotermsClassification> getType()
    {
        return IncotermsClassification.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LocationIsMandatory</b>
     * </p>
     *
     * @param locationIsMandatory
     *            Location is mandatory
     */
    public void setLocationIsMandatory( @Nullable final Boolean locationIsMandatory )
    {
        rememberChangedField("LocationIsMandatory", this.locationIsMandatory);
        this.locationIsMandatory = locationIsMandatory;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_IncotermsClassification";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IncotermsClassification", getIncotermsClassification());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("LocationIsMandatory", getLocationIsMandatory());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("LocationIsMandatory") ) {
                final Object value = values.remove("LocationIsMandatory");
                if( (value == null) || (!value.equals(getLocationIsMandatory())) ) {
                    setLocationIsMandatory(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_IncotermsClassificationText") ) {
                final Object value = (values).remove("to_IncotermsClassificationText");
                if( value instanceof Iterable ) {
                    if( toIncotermsClassificationText == null ) {
                        toIncotermsClassificationText = Lists.newArrayList();
                    } else {
                        toIncotermsClassificationText = Lists.newArrayList(toIncotermsClassificationText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        IncotermsClassificationText entity;
                        if( toIncotermsClassificationText.size() > i ) {
                            entity = toIncotermsClassificationText.get(i);
                        } else {
                            entity = new IncotermsClassificationText();
                            toIncotermsClassificationText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> IncotermsClassificationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IncotermsClassificationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IncotermsClassificationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IncotermsClassificationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toIncotermsClassificationText != null ) {
            (values).put("to_IncotermsClassificationText", toIncotermsClassificationText);
        }
        return values;
    }

    /**
     * Fetches the <b>IncotermsClassificationText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_IncotermsClassificationText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>IncotermsClassificationText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<IncotermsClassificationText> fetchIncotermsClassificationText()
    {
        return fetchFieldAsList("to_IncotermsClassificationText", IncotermsClassificationText.class);
    }

    /**
     * Retrieval of associated <b>IncotermsClassificationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_IncotermsClassificationText</b>.
     * <p>
     * If the navigation property <b>to_IncotermsClassificationText</b> of a queried <b>IncotermsClassification</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>IncotermsClassificationText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<IncotermsClassificationText> getIncotermsClassificationTextOrFetch()
    {
        if( toIncotermsClassificationText == null ) {
            toIncotermsClassificationText = fetchIncotermsClassificationText();
        }
        return toIncotermsClassificationText;
    }

    /**
     * Retrieval of associated <b>IncotermsClassificationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_IncotermsClassificationText</b>.
     * <p>
     * If the navigation property for an entity <b>IncotermsClassification</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_IncotermsClassificationText</b> is already loaded, the
     *         result will contain the <b>IncotermsClassificationText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<IncotermsClassificationText>> getIncotermsClassificationTextIfPresent()
    {
        return Option.of(toIncotermsClassificationText);
    }

    /**
     * Overwrites the list of associated <b>IncotermsClassificationText</b> entities for the loaded navigation property
     * <b>to_IncotermsClassificationText</b>.
     * <p>
     * If the navigation property <b>to_IncotermsClassificationText</b> of a queried <b>IncotermsClassification</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>IncotermsClassificationText</b> entities.
     */
    public void setIncotermsClassificationText( @Nonnull final List<IncotermsClassificationText> value )
    {
        if( toIncotermsClassificationText == null ) {
            toIncotermsClassificationText = Lists.newArrayList();
        }
        toIncotermsClassificationText.clear();
        toIncotermsClassificationText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>IncotermsClassificationText</b> entities. This corresponds to the
     * OData navigation property <b>to_IncotermsClassificationText</b>.
     * <p>
     * If the navigation property <b>to_IncotermsClassificationText</b> of a queried <b>IncotermsClassification</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>IncotermsClassificationText</b> entities.
     */
    public void addIncotermsClassificationText( IncotermsClassificationText... entity )
    {
        if( toIncotermsClassificationText == null ) {
            toIncotermsClassificationText = Lists.newArrayList();
        }
        toIncotermsClassificationText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of IncotermsClassification instances.
     *
     */
    public final static class IncotermsClassificationBuilder
    {

        private List<IncotermsClassificationText> toIncotermsClassificationText = Lists.newArrayList();

        private IncotermsClassification.IncotermsClassificationBuilder toIncotermsClassificationText(
            final List<IncotermsClassificationText> value )
        {
            toIncotermsClassificationText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_IncotermsClassificationText</b> for <b>IncotermsClassification</b> to multiple
         * <b>IncotermsClassificationText</b>.
         *
         * @param value
         *            The IncotermsClassificationTexts to build this IncotermsClassification with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public IncotermsClassification.IncotermsClassificationBuilder incotermsClassificationText(
            IncotermsClassificationText... value )
        {
            return toIncotermsClassificationText(Lists.newArrayList(value));
        }

    }

}
