/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable.IncotermsClassificationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassification IncotermsClassification}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class IncotermsClassificationByKeyFluentHelper
    extends
    FluentHelperByKey<IncotermsClassificationByKeyFluentHelper, IncotermsClassification, IncotermsClassificationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassification
     * IncotermsClassification} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code IncotermsClassification}
     * @param servicePath
     *            Service path to be used to fetch a single {@code IncotermsClassification}
     * @param incotermsClassification
     *            Incoterms (Part 1)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public IncotermsClassificationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String incotermsClassification )
    {
        super(servicePath, entityCollection);
        this.key.put("IncotermsClassification", incotermsClassification);
    }

    @Override
    @Nonnull
    protected Class<IncotermsClassification> getEntityClass()
    {
        return IncotermsClassification.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
