/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable.IncotermsClassificationTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationText
 * IncotermsClassificationText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class IncotermsClassificationTextByKeyFluentHelper
    extends
    FluentHelperByKey<IncotermsClassificationTextByKeyFluentHelper, IncotermsClassificationText, IncotermsClassificationTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationText
     * IncotermsClassificationText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code IncotermsClassificationText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code IncotermsClassificationText}
     * @param incotermsClassification
     *            Incoterms (Part 1)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public IncotermsClassificationTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String incotermsClassification,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("IncotermsClassification", incotermsClassification);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<IncotermsClassificationText> getEntityClass()
    {
        return IncotermsClassificationText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
