/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.field.IncotermsVersionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.link.IncotermsVersionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable.IncotermsVersionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Incoterms Version
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_IncotermsVersionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IncotermsVersion extends VdmEntity<IncotermsVersion>
{

    /**
     * Selector for all available fields of IncotermsVersion.
     *
     */
    public final static IncotermsVersionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @Key
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static IncotermsVersionField<String> INCOTERMS_VERSION =
        new IncotermsVersionField<String>("IncotermsVersion");
    /**
     * Navigation property <b>to_IncotermsVersionText</b> for <b>IncotermsVersion</b> to multiple
     * <b>IncotermsVersionText</b>.
     *
     */
    @SerializedName( "to_IncotermsVersionText" )
    @JsonProperty( "to_IncotermsVersionText" )
    @ODataField( odataName = "to_IncotermsVersionText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<IncotermsVersionText> toIncotermsVersionText;
    /**
     * Use with available fluent helpers to apply the <b>to_IncotermsVersionText</b> navigation property to query
     * operations.
     *
     */
    public final static IncotermsVersionLink<IncotermsVersionText> TO_INCOTERMS_VERSION_TEXT =
        new IncotermsVersionLink<IncotermsVersionText>("to_IncotermsVersionText");

    @Nonnull
    @Override
    public Class<IncotermsVersion> getType()
    {
        return IncotermsVersion.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_IncotermsVersion";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IncotermsVersion", getIncotermsVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IncotermsVersion", getIncotermsVersion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_IncotermsVersionText") ) {
                final Object value = (values).remove("to_IncotermsVersionText");
                if( value instanceof Iterable ) {
                    if( toIncotermsVersionText == null ) {
                        toIncotermsVersionText = Lists.newArrayList();
                    } else {
                        toIncotermsVersionText = Lists.newArrayList(toIncotermsVersionText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        IncotermsVersionText entity;
                        if( toIncotermsVersionText.size() > i ) {
                            entity = toIncotermsVersionText.get(i);
                        } else {
                            entity = new IncotermsVersionText();
                            toIncotermsVersionText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> IncotermsVersionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IncotermsVersionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IncotermsVersionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IncotermsVersionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toIncotermsVersionText != null ) {
            (values).put("to_IncotermsVersionText", toIncotermsVersionText);
        }
        return values;
    }

    /**
     * Fetches the <b>IncotermsVersionText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_IncotermsVersionText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>IncotermsVersionText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<IncotermsVersionText> fetchIncotermsVersionText()
    {
        return fetchFieldAsList("to_IncotermsVersionText", IncotermsVersionText.class);
    }

    /**
     * Retrieval of associated <b>IncotermsVersionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_IncotermsVersionText</b>.
     * <p>
     * If the navigation property <b>to_IncotermsVersionText</b> of a queried <b>IncotermsVersion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>IncotermsVersionText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<IncotermsVersionText> getIncotermsVersionTextOrFetch()
    {
        if( toIncotermsVersionText == null ) {
            toIncotermsVersionText = fetchIncotermsVersionText();
        }
        return toIncotermsVersionText;
    }

    /**
     * Retrieval of associated <b>IncotermsVersionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_IncotermsVersionText</b>.
     * <p>
     * If the navigation property for an entity <b>IncotermsVersion</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_IncotermsVersionText</b> is already loaded, the result
     *         will contain the <b>IncotermsVersionText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<IncotermsVersionText>> getIncotermsVersionTextIfPresent()
    {
        return Option.of(toIncotermsVersionText);
    }

    /**
     * Overwrites the list of associated <b>IncotermsVersionText</b> entities for the loaded navigation property
     * <b>to_IncotermsVersionText</b>.
     * <p>
     * If the navigation property <b>to_IncotermsVersionText</b> of a queried <b>IncotermsVersion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>IncotermsVersionText</b> entities.
     */
    public void setIncotermsVersionText( @Nonnull final List<IncotermsVersionText> value )
    {
        if( toIncotermsVersionText == null ) {
            toIncotermsVersionText = Lists.newArrayList();
        }
        toIncotermsVersionText.clear();
        toIncotermsVersionText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>IncotermsVersionText</b> entities. This corresponds to the OData
     * navigation property <b>to_IncotermsVersionText</b>.
     * <p>
     * If the navigation property <b>to_IncotermsVersionText</b> of a queried <b>IncotermsVersion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>IncotermsVersionText</b> entities.
     */
    public void addIncotermsVersionText( IncotermsVersionText... entity )
    {
        if( toIncotermsVersionText == null ) {
            toIncotermsVersionText = Lists.newArrayList();
        }
        toIncotermsVersionText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of IncotermsVersion instances.
     *
     */
    public final static class IncotermsVersionBuilder
    {

        private List<IncotermsVersionText> toIncotermsVersionText = Lists.newArrayList();

        private IncotermsVersion.IncotermsVersionBuilder toIncotermsVersionText(
            final List<IncotermsVersionText> value )
        {
            toIncotermsVersionText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_IncotermsVersionText</b> for <b>IncotermsVersion</b> to multiple
         * <b>IncotermsVersionText</b>.
         *
         * @param value
         *            The IncotermsVersionTexts to build this IncotermsVersion with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public IncotermsVersion.IncotermsVersionBuilder incotermsVersionText( IncotermsVersionText... value )
        {
            return toIncotermsVersionText(Lists.newArrayList(value));
        }

    }

}
