/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link IncotermServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService IncotermService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultIncotermServiceBatch
    extends
    BatchFluentHelperBasic<IncotermServiceBatch, IncotermServiceBatchChangeSet>
    implements
    IncotermServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultIncotermServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultIncotermServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultIncotermServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultIncotermServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultIncotermServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public IncotermServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultIncotermServiceBatchChangeSet(this, service);
    }

}
