/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link IncotermServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService IncotermService}.
 *
 */
public class DefaultIncotermServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<IncotermServiceBatch, IncotermServiceBatchChangeSet>
    implements
    IncotermServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService service;

    @SuppressWarnings( "deprecation" )
    DefaultIncotermServiceBatchChangeSet(
        @Nonnull final DefaultIncotermServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IncotermService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultIncotermServiceBatchChangeSet getThis()
    {
        return this;
    }

}
