/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassification;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassification IncotermsClassification}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.field.IncotermsClassificationField
 * IncotermsClassificationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.link.IncotermsClassificationLink
 * IncotermsClassificationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassification#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassification#LOCATION_IS_MANDATORY
 * LOCATION_IS_MANDATORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassification#TO_INCOTERMS_CLASSIFICATION_TEXT
 * TO_INCOTERMS_CLASSIFICATION_TEXT}</li>
 * </ul>
 *
 */
public interface IncotermsClassificationSelectable extends EntitySelectable<IncotermsClassification>
{

}
