/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationText
 * IncotermsClassificationText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.field.IncotermsClassificationTextField
 * IncotermsClassificationTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.link.IncotermsClassificationTextLink
 * IncotermsClassificationTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationText#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsClassificationText#INCOTERMS_CLASSIFICATION_NAME
 * INCOTERMS_CLASSIFICATION_NAME}</li>
 * </ul>
 *
 */
public interface IncotermsClassificationTextSelectable extends EntitySelectable<IncotermsClassificationText>
{

}
