/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersion;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersion IncotermsVersion}. This
 * interface is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.field.IncotermsVersionField
 * IncotermsVersionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.link.IncotermsVersionLink IncotermsVersionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersion#INCOTERMS_VERSION
 * INCOTERMS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersion#TO_INCOTERMS_VERSION_TEXT
 * TO_INCOTERMS_VERSION_TEXT}</li>
 * </ul>
 *
 */
public interface IncotermsVersionSelectable extends EntitySelectable<IncotermsVersion>
{

}
