/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionText IncotermsVersionText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.field.IncotermsVersionTextField
 * IncotermsVersionTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.link.IncotermsVersionTextLink
 * IncotermsVersionTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionText#INCOTERMS_VERSION
 * INCOTERMS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incoterm.IncotermsVersionText#INCOTERMS_VERSION_NAME
 * INCOTERMS_VERSION_NAME}</li>
 * </ul>
 *
 */
public interface IncotermsVersionTextSelectable extends EntitySelectable<IncotermsVersionText>
{

}
