/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.field.InspectionMethodField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.link.InspectionMethodLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.selectable.InspectionMethodSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Inspection Methods
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionMethodType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionMethod extends VdmEntity<InspectionMethod>
{

    /**
     * Selector for all available fields of InspectionMethod.
     *
     */
    public final static InspectionMethodSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @return Inspection Method
     */
    @Key
    @SerializedName( "InspectionMethod" )
    @JsonProperty( "InspectionMethod" )
    @Nullable
    @ODataField( odataName = "InspectionMethod" )
    private String inspectionMethod;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethod</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSPECTION_METHOD =
        new InspectionMethodField<String>("InspectionMethod");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @return Version Number of Inspection Method
     */
    @Key
    @SerializedName( "InspectionMethodVersion" )
    @JsonProperty( "InspectionMethodVersion" )
    @Nullable
    @ODataField( odataName = "InspectionMethodVersion" )
    private String inspectionMethodVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodVersion</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSPECTION_METHOD_VERSION =
        new InspectionMethodField<String>("InspectionMethodVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @return Plant for Inspection Method
     */
    @Key
    @SerializedName( "InspectionMethodPlant" )
    @JsonProperty( "InspectionMethodPlant" )
    @Nullable
    @ODataField( odataName = "InspectionMethodPlant" )
    private String inspectionMethodPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodPlant</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSPECTION_METHOD_PLANT =
        new InspectionMethodField<String>("InspectionMethodPlant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodValidFromDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "InspectionMethodValidFromDate" )
    @JsonProperty( "InspectionMethodValidFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionMethodValidFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionMethodValidFromDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodValidFromDate</b> field to query operations.
     *
     */
    public final static InspectionMethodField<LocalDateTime> INSPECTION_METHOD_VALID_FROM_DATE =
        new InspectionMethodField<LocalDateTime>("InspectionMethodValidFromDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodSearchField</b>
     * </p>
     *
     * @return Search Field
     */
    @SerializedName( "InspectionMethodSearchField" )
    @JsonProperty( "InspectionMethodSearchField" )
    @Nullable
    @ODataField( odataName = "InspectionMethodSearchField" )
    private String inspectionMethodSearchField;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodSearchField</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSPECTION_METHOD_SEARCH_FIELD =
        new InspectionMethodField<String>("InspectionMethodSearchField");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodStatus</b>
     * </p>
     *
     * @return Status of Master Record
     */
    @SerializedName( "InspectionMethodStatus" )
    @JsonProperty( "InspectionMethodStatus" )
    @Nullable
    @ODataField( odataName = "InspectionMethodStatus" )
    private String inspectionMethodStatus;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodStatus</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSPECTION_METHOD_STATUS =
        new InspectionMethodField<String>("InspectionMethodStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspMethInformationField1</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspMethInformationField1" )
    @JsonProperty( "InspMethInformationField1" )
    @Nullable
    @ODataField( odataName = "InspMethInformationField1" )
    private String inspMethInformationField1;
    /**
     * Use with available fluent helpers to apply the <b>InspMethInformationField1</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSP_METH_INFORMATION_FIELD1 =
        new InspectionMethodField<String>("InspMethInformationField1");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspMethInformationField2</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspMethInformationField2" )
    @JsonProperty( "InspMethInformationField2" )
    @Nullable
    @ODataField( odataName = "InspMethInformationField2" )
    private String inspMethInformationField2;
    /**
     * Use with available fluent helpers to apply the <b>InspMethInformationField2</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSP_METH_INFORMATION_FIELD2 =
        new InspectionMethodField<String>("InspMethInformationField2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspMethInformationField3</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspMethInformationField3" )
    @JsonProperty( "InspMethInformationField3" )
    @Nullable
    @ODataField( odataName = "InspMethInformationField3" )
    private String inspMethInformationField3;
    /**
     * Use with available fluent helpers to apply the <b>InspMethInformationField3</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSP_METH_INFORMATION_FIELD3 =
        new InspectionMethodField<String>("InspMethInformationField3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QltyMstrDataAuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group QM Master Data
     */
    @SerializedName( "QltyMstrDataAuthorizationGroup" )
    @JsonProperty( "QltyMstrDataAuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "QltyMstrDataAuthorizationGroup" )
    private String qltyMstrDataAuthorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>QltyMstrDataAuthorizationGroup</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> QLTY_MSTR_DATA_AUTHORIZATION_GROUP =
        new InspectionMethodField<String>("QltyMstrDataAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @return Inspector Qualification
     */
    @SerializedName( "InspectorQualification" )
    @JsonProperty( "InspectorQualification" )
    @Nullable
    @ODataField( odataName = "InspectorQualification" )
    private String inspectorQualification;
    /**
     * Use with available fluent helpers to apply the <b>InspectorQualification</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> INSPECTOR_QUALIFICATION =
        new InspectionMethodField<String>("InspectorQualification");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of User Who Created the Data Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> CREATED_BY_USER =
        new InspectionMethodField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspectionMethodField<LocalDateTime> CREATION_DATE =
        new InspectionMethodField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> LAST_CHANGED_BY_USER =
        new InspectionMethodField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspectionMethodField<LocalDateTime> LAST_CHANGE_DATE =
        new InspectionMethodField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @return The linkedSAPObjectKey contained in this entity.
     */
    @SerializedName( "LinkedSAPObjectKey" )
    @JsonProperty( "LinkedSAPObjectKey" )
    @Nullable
    @ODataField( odataName = "LinkedSAPObjectKey" )
    private String linkedSAPObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>LinkedSAPObjectKey</b> field to query operations.
     *
     */
    public final static InspectionMethodField<String> LINKED_SAP_OBJECT_KEY =
        new InspectionMethodField<String>("LinkedSAPObjectKey");
    /**
     * Navigation property <b>to_Text</b> for <b>InspectionMethod</b> to multiple <b>InspectionMethodText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InspectionMethodText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static InspectionMethodLink<InspectionMethodText> TO_TEXT =
        new InspectionMethodLink<InspectionMethodText>("to_Text");

    @Nonnull
    @Override
    public Class<InspectionMethod> getType()
    {
        return InspectionMethod.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @param inspectionMethod
     *            Inspection Method
     */
    public void setInspectionMethod( @Nullable final String inspectionMethod )
    {
        rememberChangedField("InspectionMethod", this.inspectionMethod);
        this.inspectionMethod = inspectionMethod;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @param inspectionMethodVersion
     *            Version Number of Inspection Method
     */
    public void setInspectionMethodVersion( @Nullable final String inspectionMethodVersion )
    {
        rememberChangedField("InspectionMethodVersion", this.inspectionMethodVersion);
        this.inspectionMethodVersion = inspectionMethodVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @param inspectionMethodPlant
     *            Plant for Inspection Method
     */
    public void setInspectionMethodPlant( @Nullable final String inspectionMethodPlant )
    {
        rememberChangedField("InspectionMethodPlant", this.inspectionMethodPlant);
        this.inspectionMethodPlant = inspectionMethodPlant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodValidFromDate</b>
     * </p>
     *
     * @param inspectionMethodValidFromDate
     *            Valid-From Date
     */
    public void setInspectionMethodValidFromDate( @Nullable final LocalDateTime inspectionMethodValidFromDate )
    {
        rememberChangedField("InspectionMethodValidFromDate", this.inspectionMethodValidFromDate);
        this.inspectionMethodValidFromDate = inspectionMethodValidFromDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodSearchField</b>
     * </p>
     *
     * @param inspectionMethodSearchField
     *            Search Field
     */
    public void setInspectionMethodSearchField( @Nullable final String inspectionMethodSearchField )
    {
        rememberChangedField("InspectionMethodSearchField", this.inspectionMethodSearchField);
        this.inspectionMethodSearchField = inspectionMethodSearchField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodStatus</b>
     * </p>
     *
     * @param inspectionMethodStatus
     *            Status of Master Record
     */
    public void setInspectionMethodStatus( @Nullable final String inspectionMethodStatus )
    {
        rememberChangedField("InspectionMethodStatus", this.inspectionMethodStatus);
        this.inspectionMethodStatus = inspectionMethodStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspMethInformationField1</b>
     * </p>
     *
     * @param inspMethInformationField1
     *            Text Line for Additional Information
     */
    public void setInspMethInformationField1( @Nullable final String inspMethInformationField1 )
    {
        rememberChangedField("InspMethInformationField1", this.inspMethInformationField1);
        this.inspMethInformationField1 = inspMethInformationField1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspMethInformationField2</b>
     * </p>
     *
     * @param inspMethInformationField2
     *            Text Line for Additional Information
     */
    public void setInspMethInformationField2( @Nullable final String inspMethInformationField2 )
    {
        rememberChangedField("InspMethInformationField2", this.inspMethInformationField2);
        this.inspMethInformationField2 = inspMethInformationField2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspMethInformationField3</b>
     * </p>
     *
     * @param inspMethInformationField3
     *            Text Line for Additional Information
     */
    public void setInspMethInformationField3( @Nullable final String inspMethInformationField3 )
    {
        rememberChangedField("InspMethInformationField3", this.inspMethInformationField3);
        this.inspMethInformationField3 = inspMethInformationField3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QltyMstrDataAuthorizationGroup</b>
     * </p>
     *
     * @param qltyMstrDataAuthorizationGroup
     *            Authorization Group QM Master Data
     */
    public void setQltyMstrDataAuthorizationGroup( @Nullable final String qltyMstrDataAuthorizationGroup )
    {
        rememberChangedField("QltyMstrDataAuthorizationGroup", this.qltyMstrDataAuthorizationGroup);
        this.qltyMstrDataAuthorizationGroup = qltyMstrDataAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @param inspectorQualification
     *            Inspector Qualification
     */
    public void setInspectorQualification( @Nullable final String inspectorQualification )
    {
        rememberChangedField("InspectorQualification", this.inspectorQualification);
        this.inspectorQualification = inspectorQualification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of User Who Created the Data Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            System Date on Which Data Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of User Who Last Changed Data Record
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @param linkedSAPObjectKey
     *            The linkedSAPObjectKey to set.
     */
    public void setLinkedSAPObjectKey( @Nullable final String linkedSAPObjectKey )
    {
        rememberChangedField("LinkedSAPObjectKey", this.linkedSAPObjectKey);
        this.linkedSAPObjectKey = linkedSAPObjectKey;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionMethod";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionMethod", getInspectionMethod());
        result.put("InspectionMethodVersion", getInspectionMethodVersion());
        result.put("InspectionMethodPlant", getInspectionMethodPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionMethod", getInspectionMethod());
        values.put("InspectionMethodVersion", getInspectionMethodVersion());
        values.put("InspectionMethodPlant", getInspectionMethodPlant());
        values.put("InspectionMethodValidFromDate", getInspectionMethodValidFromDate());
        values.put("InspectionMethodSearchField", getInspectionMethodSearchField());
        values.put("InspectionMethodStatus", getInspectionMethodStatus());
        values.put("InspMethInformationField1", getInspMethInformationField1());
        values.put("InspMethInformationField2", getInspMethInformationField2());
        values.put("InspMethInformationField3", getInspMethInformationField3());
        values.put("QltyMstrDataAuthorizationGroup", getQltyMstrDataAuthorizationGroup());
        values.put("InspectorQualification", getInspectorQualification());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionMethod") ) {
                final Object value = values.remove("InspectionMethod");
                if( (value == null) || (!value.equals(getInspectionMethod())) ) {
                    setInspectionMethod(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodVersion") ) {
                final Object value = values.remove("InspectionMethodVersion");
                if( (value == null) || (!value.equals(getInspectionMethodVersion())) ) {
                    setInspectionMethodVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodPlant") ) {
                final Object value = values.remove("InspectionMethodPlant");
                if( (value == null) || (!value.equals(getInspectionMethodPlant())) ) {
                    setInspectionMethodPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodValidFromDate") ) {
                final Object value = values.remove("InspectionMethodValidFromDate");
                if( (value == null) || (!value.equals(getInspectionMethodValidFromDate())) ) {
                    setInspectionMethodValidFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionMethodSearchField") ) {
                final Object value = values.remove("InspectionMethodSearchField");
                if( (value == null) || (!value.equals(getInspectionMethodSearchField())) ) {
                    setInspectionMethodSearchField(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodStatus") ) {
                final Object value = values.remove("InspectionMethodStatus");
                if( (value == null) || (!value.equals(getInspectionMethodStatus())) ) {
                    setInspectionMethodStatus(((String) value));
                }
            }
            if( values.containsKey("InspMethInformationField1") ) {
                final Object value = values.remove("InspMethInformationField1");
                if( (value == null) || (!value.equals(getInspMethInformationField1())) ) {
                    setInspMethInformationField1(((String) value));
                }
            }
            if( values.containsKey("InspMethInformationField2") ) {
                final Object value = values.remove("InspMethInformationField2");
                if( (value == null) || (!value.equals(getInspMethInformationField2())) ) {
                    setInspMethInformationField2(((String) value));
                }
            }
            if( values.containsKey("InspMethInformationField3") ) {
                final Object value = values.remove("InspMethInformationField3");
                if( (value == null) || (!value.equals(getInspMethInformationField3())) ) {
                    setInspMethInformationField3(((String) value));
                }
            }
            if( values.containsKey("QltyMstrDataAuthorizationGroup") ) {
                final Object value = values.remove("QltyMstrDataAuthorizationGroup");
                if( (value == null) || (!value.equals(getQltyMstrDataAuthorizationGroup())) ) {
                    setQltyMstrDataAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("InspectorQualification") ) {
                final Object value = values.remove("InspectorQualification");
                if( (value == null) || (!value.equals(getInspectorQualification())) ) {
                    setInspectorQualification(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LinkedSAPObjectKey") ) {
                final Object value = values.remove("LinkedSAPObjectKey");
                if( (value == null) || (!value.equals(getLinkedSAPObjectKey())) ) {
                    setLinkedSAPObjectKey(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InspectionMethodText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new InspectionMethodText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionMethodField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionMethodField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionMethodField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionMethodField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>InspectionMethodText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InspectionMethodText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspectionMethodText> fetchText()
    {
        return fetchFieldAsList("to_Text", InspectionMethodText.class);
    }

    /**
     * Retrieval of associated <b>InspectionMethodText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>InspectionMethod</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspectionMethodText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspectionMethodText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>InspectionMethodText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>InspectionMethod</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>InspectionMethodText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<InspectionMethodText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>InspectionMethodText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>InspectionMethod</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InspectionMethodText</b> entities.
     */
    public void setText( @Nonnull final List<InspectionMethodText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InspectionMethodText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>InspectionMethod</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InspectionMethodText</b> entities.
     */
    public void addText( InspectionMethodText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of InspectionMethod instances.
     *
     */
    public final static class InspectionMethodBuilder
    {

        private List<InspectionMethodText> toText = Lists.newArrayList();

        private InspectionMethod.InspectionMethodBuilder toText( final List<InspectionMethodText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>InspectionMethod</b> to multiple <b>InspectionMethodText</b>.
         *
         * @param value
         *            The InspectionMethodTexts to build this InspectionMethod with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionMethod.InspectionMethodBuilder text( InspectionMethodText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
