/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.field.InspectionMethodTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.link.InspectionMethodTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.selectable.InspectionMethodTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Inspection Method Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionMethodTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionMethodText extends VdmEntity<InspectionMethodText>
{

    /**
     * Selector for all available fields of InspectionMethodText.
     *
     */
    public final static InspectionMethodTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @return Plant for Inspection Method
     */
    @Key
    @SerializedName( "InspectionMethodPlant" )
    @JsonProperty( "InspectionMethodPlant" )
    @Nullable
    @ODataField( odataName = "InspectionMethodPlant" )
    private String inspectionMethodPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodPlant</b> field to query operations.
     *
     */
    public final static InspectionMethodTextField<String> INSPECTION_METHOD_PLANT =
        new InspectionMethodTextField<String>("InspectionMethodPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @return Inspection Method
     */
    @Key
    @SerializedName( "InspectionMethod" )
    @JsonProperty( "InspectionMethod" )
    @Nullable
    @ODataField( odataName = "InspectionMethod" )
    private String inspectionMethod;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethod</b> field to query operations.
     *
     */
    public final static InspectionMethodTextField<String> INSPECTION_METHOD =
        new InspectionMethodTextField<String>("InspectionMethod");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @return Version Number for the Inspection Method Text (QM)
     */
    @Key
    @SerializedName( "InspectionMethodVersion" )
    @JsonProperty( "InspectionMethodVersion" )
    @Nullable
    @ODataField( odataName = "InspectionMethodVersion" )
    private String inspectionMethodVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodVersion</b> field to query operations.
     *
     */
    public final static InspectionMethodTextField<String> INSPECTION_METHOD_VERSION =
        new InspectionMethodTextField<String>("InspectionMethodVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static InspectionMethodTextField<String> LANGUAGE = new InspectionMethodTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodText</b>
     * </p>
     *
     * @return Text for Inspection Method
     */
    @SerializedName( "InspectionMethodText" )
    @JsonProperty( "InspectionMethodText" )
    @Nullable
    @ODataField( odataName = "InspectionMethodText" )
    private String inspectionMethodText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodText</b> field to query operations.
     *
     */
    public final static InspectionMethodTextField<String> INSPECTION_METHOD_TEXT =
        new InspectionMethodTextField<String>("InspectionMethodText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspMethodHasLongText</b>
     * </p>
     *
     * @return Inspection Method Has Long Text
     */
    @SerializedName( "InspMethodHasLongText" )
    @JsonProperty( "InspMethodHasLongText" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspMethodHasLongText" )
    private Boolean inspMethodHasLongText;
    /**
     * Use with available fluent helpers to apply the <b>InspMethodHasLongText</b> field to query operations.
     *
     */
    public final static InspectionMethodTextField<Boolean> INSP_METHOD_HAS_LONG_TEXT =
        new InspectionMethodTextField<Boolean>("InspMethodHasLongText");
    /**
     * Navigation property <b>to_InspectionMethod</b> for <b>InspectionMethodText</b> to single <b>InspectionMethod</b>.
     *
     */
    @SerializedName( "to_InspectionMethod" )
    @JsonProperty( "to_InspectionMethod" )
    @ODataField( odataName = "to_InspectionMethod" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private InspectionMethod toInspectionMethod;
    /**
     * Use with available fluent helpers to apply the <b>to_InspectionMethod</b> navigation property to query
     * operations.
     *
     */
    public final static InspectionMethodTextOneToOneLink<InspectionMethod> TO_INSPECTION_METHOD =
        new InspectionMethodTextOneToOneLink<InspectionMethod>("to_InspectionMethod");

    @Nonnull
    @Override
    public Class<InspectionMethodText> getType()
    {
        return InspectionMethodText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @param inspectionMethodPlant
     *            Plant for Inspection Method
     */
    public void setInspectionMethodPlant( @Nullable final String inspectionMethodPlant )
    {
        rememberChangedField("InspectionMethodPlant", this.inspectionMethodPlant);
        this.inspectionMethodPlant = inspectionMethodPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @param inspectionMethod
     *            Inspection Method
     */
    public void setInspectionMethod( @Nullable final String inspectionMethod )
    {
        rememberChangedField("InspectionMethod", this.inspectionMethod);
        this.inspectionMethod = inspectionMethod;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @param inspectionMethodVersion
     *            Version Number for the Inspection Method Text (QM)
     */
    public void setInspectionMethodVersion( @Nullable final String inspectionMethodVersion )
    {
        rememberChangedField("InspectionMethodVersion", this.inspectionMethodVersion);
        this.inspectionMethodVersion = inspectionMethodVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodText</b>
     * </p>
     *
     * @param inspectionMethodText
     *            Text for Inspection Method
     */
    public void setInspectionMethodText( @Nullable final String inspectionMethodText )
    {
        rememberChangedField("InspectionMethodText", this.inspectionMethodText);
        this.inspectionMethodText = inspectionMethodText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspMethodHasLongText</b>
     * </p>
     *
     * @param inspMethodHasLongText
     *            Inspection Method Has Long Text
     */
    public void setInspMethodHasLongText( @Nullable final Boolean inspMethodHasLongText )
    {
        rememberChangedField("InspMethodHasLongText", this.inspMethodHasLongText);
        this.inspMethodHasLongText = inspMethodHasLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionMethodText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionMethodPlant", getInspectionMethodPlant());
        result.put("InspectionMethod", getInspectionMethod());
        result.put("InspectionMethodVersion", getInspectionMethodVersion());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionMethodPlant", getInspectionMethodPlant());
        values.put("InspectionMethod", getInspectionMethod());
        values.put("InspectionMethodVersion", getInspectionMethodVersion());
        values.put("Language", getLanguage());
        values.put("InspectionMethodText", getInspectionMethodText());
        values.put("InspMethodHasLongText", getInspMethodHasLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionMethodPlant") ) {
                final Object value = values.remove("InspectionMethodPlant");
                if( (value == null) || (!value.equals(getInspectionMethodPlant())) ) {
                    setInspectionMethodPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionMethod") ) {
                final Object value = values.remove("InspectionMethod");
                if( (value == null) || (!value.equals(getInspectionMethod())) ) {
                    setInspectionMethod(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodVersion") ) {
                final Object value = values.remove("InspectionMethodVersion");
                if( (value == null) || (!value.equals(getInspectionMethodVersion())) ) {
                    setInspectionMethodVersion(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodText") ) {
                final Object value = values.remove("InspectionMethodText");
                if( (value == null) || (!value.equals(getInspectionMethodText())) ) {
                    setInspectionMethodText(((String) value));
                }
            }
            if( values.containsKey("InspMethodHasLongText") ) {
                final Object value = values.remove("InspMethodHasLongText");
                if( (value == null) || (!value.equals(getInspMethodHasLongText())) ) {
                    setInspMethodHasLongText(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_InspectionMethod") ) {
                final Object value = (values).remove("to_InspectionMethod");
                if( value instanceof Map ) {
                    if( toInspectionMethod == null ) {
                        toInspectionMethod = new InspectionMethod();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toInspectionMethod.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionMethodTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionMethodTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionMethodTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionMethodTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInspectionMethod != null ) {
            (values).put("to_InspectionMethod", toInspectionMethod);
        }
        return values;
    }

    /**
     * Fetches the <b>InspectionMethod</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_InspectionMethod</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>InspectionMethod</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InspectionMethod fetchInspectionMethod()
    {
        return fetchFieldAsSingle("to_InspectionMethod", InspectionMethod.class);
    }

    /**
     * Retrieval of associated <b>InspectionMethod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_InspectionMethod</b>.
     * <p>
     * If the navigation property <b>to_InspectionMethod</b> of a queried <b>InspectionMethodText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspectionMethod</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InspectionMethod getInspectionMethodOrFetch()
    {
        if( toInspectionMethod == null ) {
            toInspectionMethod = fetchInspectionMethod();
        }
        return toInspectionMethod;
    }

    /**
     * Retrieval of associated <b>InspectionMethod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_InspectionMethod</b>.
     * <p>
     * If the navigation property for an entity <b>InspectionMethodText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_InspectionMethod</b> is already loaded, the result will
     *         contain the <b>InspectionMethod</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<InspectionMethod> getInspectionMethodIfPresent()
    {
        return Option.of(toInspectionMethod);
    }

    /**
     * Overwrites the associated <b>InspectionMethod</b> entity for the loaded navigation property
     * <b>to_InspectionMethod</b>.
     *
     * @param value
     *            New <b>InspectionMethod</b> entity.
     */
    public void setInspectionMethod( final InspectionMethod value )
    {
        toInspectionMethod = value;
    }

    /**
     * Helper class to allow for fluent creation of InspectionMethodText instances.
     *
     */
    public final static class InspectionMethodTextBuilder
    {

        private InspectionMethod toInspectionMethod;
        private String inspectionMethod = null;

        private InspectionMethodText.InspectionMethodTextBuilder toInspectionMethod( final InspectionMethod value )
        {
            toInspectionMethod = value;
            return this;
        }

        /**
         * Navigation property <b>to_InspectionMethod</b> for <b>InspectionMethodText</b> to single
         * <b>InspectionMethod</b>.
         *
         * @param value
         *            The InspectionMethod to build this InspectionMethodText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionMethodText.InspectionMethodTextBuilder inspectionMethod( final InspectionMethod value )
        {
            return toInspectionMethod(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 8
         * <p>
         * Original property name from the Odata EDM: <b>InspectionMethod</b>
         * </p>
         *
         * @param value
         *            The inspectionMethod to build this InspectionMethodText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionMethodText.InspectionMethodTextBuilder inspectionMethod( final String value )
        {
            inspectionMethod = value;
            return this;
        }

    }

}
