/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.selectable.InspectionMethodTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText
 * InspectionMethodText} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class InspectionMethodTextByKeyFluentHelper
    extends
    FluentHelperByKey<InspectionMethodTextByKeyFluentHelper, InspectionMethodText, InspectionMethodTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText
     * InspectionMethodText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InspectionMethodText}
     * @param inspectionMethodVersion
     *            Version Number for the Inspection Method Text (QM)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code InspectionMethodText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionMethodPlant
     *            Plant for Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionMethod
     *            Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public InspectionMethodTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inspectionMethodPlant,
        final String inspectionMethod,
        final String inspectionMethodVersion,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("InspectionMethodPlant", inspectionMethodPlant);
        this.key.put("InspectionMethod", inspectionMethod);
        this.key.put("InspectionMethodVersion", inspectionMethodVersion);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<InspectionMethodText> getEntityClass()
    {
        return InspectionMethodText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
