/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link InspectionMethodServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService InspectionMethodService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultInspectionMethodServiceBatch
    extends
    BatchFluentHelperBasic<InspectionMethodServiceBatch, InspectionMethodServiceBatchChangeSet>
    implements
    InspectionMethodServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultInspectionMethodServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultInspectionMethodServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultInspectionMethodServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultInspectionMethodServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultInspectionMethodServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public InspectionMethodServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultInspectionMethodServiceBatchChangeSet(this, service);
    }

}
