/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link InspectionMethodServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService InspectionMethodService}.
 *
 */
public class DefaultInspectionMethodServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<InspectionMethodServiceBatch, InspectionMethodServiceBatchChangeSet>
    implements
    InspectionMethodServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService service;

    @SuppressWarnings( "deprecation" )
    DefaultInspectionMethodServiceBatchChangeSet(
        @Nonnull final DefaultInspectionMethodServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionMethodService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultInspectionMethodServiceBatchChangeSet getThis()
    {
        return this;
    }

}
