/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod InspectionMethod}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.field.InspectionMethodField
 * InspectionMethodField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.link.InspectionMethodLink
 * InspectionMethodLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSPECTION_METHOD
 * INSPECTION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSPECTION_METHOD_VERSION
 * INSPECTION_METHOD_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSPECTION_METHOD_PLANT
 * INSPECTION_METHOD_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSPECTION_METHOD_VALID_FROM_DATE
 * INSPECTION_METHOD_VALID_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSPECTION_METHOD_SEARCH_FIELD
 * INSPECTION_METHOD_SEARCH_FIELD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSPECTION_METHOD_STATUS
 * INSPECTION_METHOD_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSP_METH_INFORMATION_FIELD1
 * INSP_METH_INFORMATION_FIELD1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSP_METH_INFORMATION_FIELD2
 * INSP_METH_INFORMATION_FIELD2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSP_METH_INFORMATION_FIELD3
 * INSP_METH_INFORMATION_FIELD3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#QLTY_MSTR_DATA_AUTHORIZATION_GROUP
 * QLTY_MSTR_DATA_AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#INSPECTOR_QUALIFICATION
 * INSPECTOR_QUALIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#LINKED_SAP_OBJECT_KEY
 * LINKED_SAP_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface InspectionMethodSelectable extends EntitySelectable<InspectionMethod>
{

}
