/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText
 * InspectionMethodText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.field.InspectionMethodTextField
 * InspectionMethodTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.link.InspectionMethodTextLink
 * InspectionMethodTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText#INSPECTION_METHOD_PLANT
 * INSPECTION_METHOD_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText#INSPECTION_METHOD
 * INSPECTION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText#INSPECTION_METHOD_VERSION
 * INSPECTION_METHOD_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText#INSPECTION_METHOD_TEXT
 * INSPECTION_METHOD_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText#INSP_METHOD_HAS_LONG_TEXT
 * INSP_METHOD_HAS_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText#TO_INSPECTION_METHOD
 * TO_INSPECTION_METHOD}</li>
 * </ul>
 *
 */
public interface InspectionMethodTextSelectable extends EntitySelectable<InspectionMethodText>
{

}
