/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanDepdntCharcField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspPlanDepdntCharcSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Dependent Charc Spec Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspPlanDepdntCharcType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspPlanDepdntCharc extends VdmEntity<InspPlanDepdntCharc>
{

    /**
     * Selector for all available fields of InspPlanDepdntCharc.
     *
     */
    public final static InspPlanDepdntCharcSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Boolean> DELETE_MC =
        new InspPlanDepdntCharcField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Boolean> UPDATE_MC =
        new InspPlanDepdntCharcField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "InspectionPlanGroup" )
    @JsonProperty( "InspectionPlanGroup" )
    @Nullable
    @ODataField( odataName = "InspectionPlanGroup" )
    private String inspectionPlanGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanGroup</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSPECTION_PLAN_GROUP =
        new InspPlanDepdntCharcField<String>("InspectionPlanGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "InspectionPlan" )
    @JsonProperty( "InspectionPlan" )
    @Nullable
    @ODataField( odataName = "InspectionPlan" )
    private String inspectionPlan;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlan</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSPECTION_PLAN =
        new InspPlanDepdntCharcField<String>("InspectionPlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "InspectionPlanInternalVersion" )
    @JsonProperty( "InspectionPlanInternalVersion" )
    @Nullable
    @ODataField( odataName = "InspectionPlanInternalVersion" )
    private String inspectionPlanInternalVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanInternalVersion</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSPECTION_PLAN_INTERNAL_VERSION =
        new InspPlanDepdntCharcField<String>("InspectionPlanInternalVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "BOOOperationInternalID" )
    @JsonProperty( "BOOOperationInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationInternalID" )
    private String bOOOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationInternalID</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_OPERATION_INTERNAL_ID =
        new InspPlanDepdntCharcField<String>("BOOOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOOOpInternalVersionCounter" )
    @JsonProperty( "BOOOpInternalVersionCounter" )
    @Nullable
    @ODataField( odataName = "BOOOpInternalVersionCounter" )
    private String bOOOpInternalVersionCounter;
    /**
     * Use with available fluent helpers to apply the <b>BOOOpInternalVersionCounter</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_OP_INTERNAL_VERSION_COUNTER =
        new InspPlanDepdntCharcField<String>("BOOOpInternalVersionCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristic</b>
     * </p>
     *
     * @return Inspection Characteristic Number
     */
    @Key
    @SerializedName( "BOOCharacteristic" )
    @JsonProperty( "BOOCharacteristic" )
    @Nullable
    @ODataField( odataName = "BOOCharacteristic" )
    private String bOOCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>BOOCharacteristic</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_CHARACTERISTIC =
        new InspPlanDepdntCharcField<String>("BOOCharacteristic");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristicVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOOCharacteristicVersion" )
    @JsonProperty( "BOOCharacteristicVersion" )
    @Nullable
    @ODataField( odataName = "BOOCharacteristicVersion" )
    private String bOOCharacteristicVersion;
    /**
     * Use with available fluent helpers to apply the <b>BOOCharacteristicVersion</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_CHARACTERISTIC_VERSION =
        new InspPlanDepdntCharcField<String>("BOOCharacteristicVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOODpndantCharcSpec</b>
     * </p>
     *
     * @return Number for Dependent Characteristic Specifications
     */
    @Key
    @SerializedName( "BOODpndantCharcSpec" )
    @JsonProperty( "BOODpndantCharcSpec" )
    @Nullable
    @ODataField( odataName = "BOODpndantCharcSpec" )
    private String bOODpndantCharcSpec;
    /**
     * Use with available fluent helpers to apply the <b>BOODpndantCharcSpec</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_DPNDANT_CHARC_SPEC =
        new InspPlanDepdntCharcField<String>("BOODpndantCharcSpec");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOODpndantCharcSpecVers</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOODpndantCharcSpecVers" )
    @JsonProperty( "BOODpndantCharcSpecVers" )
    @Nullable
    @ODataField( odataName = "BOODpndantCharcSpecVers" )
    private String bOODpndantCharcSpecVers;
    /**
     * Use with available fluent helpers to apply the <b>BOODpndantCharcSpecVers</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_DPNDANT_CHARC_SPEC_VERS =
        new InspPlanDepdntCharcField<String>("BOODpndantCharcSpecVers");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @return Quantitative Characteristic
     */
    @SerializedName( "InspSpecIsQuantitative" )
    @JsonProperty( "InspSpecIsQuantitative" )
    @Nullable
    @ODataField( odataName = "InspSpecIsQuantitative" )
    private String inspSpecIsQuantitative;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsQuantitative</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_IS_QUANTITATIVE =
        new InspPlanDepdntCharcField<String>("InspSpecIsQuantitative");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectsRecgAutomatic</b>
     * </p>
     *
     * @return Defects Recording Automatically Called Up
     */
    @SerializedName( "InspSpecIsDefectsRecgAutomatic" )
    @JsonProperty( "InspSpecIsDefectsRecgAutomatic" )
    @Nullable
    @ODataField( odataName = "InspSpecIsDefectsRecgAutomatic" )
    private String inspSpecIsDefectsRecgAutomatic;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsDefectsRecgAutomatic</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC =
        new InspPlanDepdntCharcField<String>("InspSpecIsDefectsRecgAutomatic");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @return Reference to Characteristic Attribute Required
     */
    @SerializedName( "InspSpecIsSelectedSetRequired" )
    @JsonProperty( "InspSpecIsSelectedSetRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSelectedSetRequired" )
    private String inspSpecIsSelectedSetRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSelectedSetRequired</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_IS_SELECTED_SET_REQUIRED =
        new InspPlanDepdntCharcField<String>("InspSpecIsSelectedSetRequired");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @return Short Text for Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationText" )
    @JsonProperty( "InspectionSpecificationText" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationText" )
    private String inspectionSpecificationText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationText</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSPECTION_SPECIFICATION_TEXT =
        new InspPlanDepdntCharcField<String>("InspectionSpecificationText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectRecordingRqd</b>
     * </p>
     *
     * @return Recording the Number of Defects
     */
    @SerializedName( "InspSpecIsDefectRecordingRqd" )
    @JsonProperty( "InspSpecIsDefectRecordingRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsDefectRecordingRqd" )
    private String inspSpecIsDefectRecordingRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsDefectRecordingRqd</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_IS_DEFECT_RECORDING_RQD =
        new InspPlanDepdntCharcField<String>("InspSpecIsDefectRecordingRqd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @return Item Number for Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolItemNumber" )
    @JsonProperty( "ProdnRsceToolItemNumber" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolItemNumber" )
    private String prodnRsceToolItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolItemNumber</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> PRODN_RSCE_TOOL_ITEM_NUMBER =
        new InspPlanDepdntCharcField<String>("ProdnRsceToolItemNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<LocalDateTime> VALIDITY_START_DATE =
        new InspPlanDepdntCharcField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<LocalDateTime> VALIDITY_END_DATE =
        new InspPlanDepdntCharcField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> CHANGE_NUMBER =
        new InspPlanDepdntCharcField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> SUPPLIER = new InspPlanDepdntCharcField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Account number of customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> CUSTOMER = new InspPlanDepdntCharcField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BOOSearchText</b>
     * </p>
     *
     * @return Search Field for Customer-Specific Task List Selection
     */
    @SerializedName( "BOOSearchText" )
    @JsonProperty( "BOOSearchText" )
    @Nullable
    @ODataField( odataName = "BOOSearchText" )
    private String bOOSearchText;
    /**
     * Use with available fluent helpers to apply the <b>BOOSearchText</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_SEARCH_TEXT =
        new InspPlanDepdntCharcField<String>("BOOSearchText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObject</b>
     * </p>
     *
     * @return Object for Multiple Specifications
     */
    @SerializedName( "MultipleSpecificationObject" )
    @JsonProperty( "MultipleSpecificationObject" )
    @Nullable
    @ODataField( odataName = "MultipleSpecificationObject" )
    private String multipleSpecificationObject;
    /**
     * Use with available fluent helpers to apply the <b>MultipleSpecificationObject</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> MULTIPLE_SPECIFICATION_OBJECT =
        new InspPlanDepdntCharcField<String>("MultipleSpecificationObject");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObjType</b>
     * </p>
     *
     * @return Type of Object for Multiple Specifications
     */
    @SerializedName( "MultipleSpecificationObjType" )
    @JsonProperty( "MultipleSpecificationObjType" )
    @Nullable
    @ODataField( odataName = "MultipleSpecificationObjType" )
    private String multipleSpecificationObjType;
    /**
     * Use with available fluent helpers to apply the <b>MultipleSpecificationObjType</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> MULTIPLE_SPECIFICATION_OBJ_TYPE =
        new InspPlanDepdntCharcField<String>("MultipleSpecificationObjType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Boolean> IS_DELETED =
        new InspPlanDepdntCharcField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @return Assigned Test Equipment
     */
    @SerializedName( "BOOOperationPRTInternalID" )
    @JsonProperty( "BOOOperationPRTInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationPRTInternalID" )
    private String bOOOperationPRTInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationPRTInternalID</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_OPERATION_PRT_INTERNAL_ID =
        new InspPlanDepdntCharcField<String>("BOOOperationPRTInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number of the Dependent Characteristic Specs
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> MATERIAL = new InspPlanDepdntCharcField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> PLANT = new InspPlanDepdntCharcField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVariant</b>
     * </p>
     *
     * @return Group Counter
     */
    @SerializedName( "BillOfOperationsVariant" )
    @JsonProperty( "BillOfOperationsVariant" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsVariant" )
    private String billOfOperationsVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsVariant</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BILL_OF_OPERATIONS_VARIANT =
        new InspPlanDepdntCharcField<String>("BillOfOperationsVariant");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BOOToMaterialInternalID</b>
     * </p>
     *
     * @return Counter for Additional Criteria
     */
    @SerializedName( "BOOToMaterialInternalID" )
    @JsonProperty( "BOOToMaterialInternalID" )
    @Nullable
    @ODataField( odataName = "BOOToMaterialInternalID" )
    private String bOOToMaterialInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOToMaterialInternalID</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BOO_TO_MATERIAL_INTERNAL_ID =
        new InspPlanDepdntCharcField<String>("BOOToMaterialInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @return Number of Places to the Right of a Decimal Point (Accuracy)
     */
    @SerializedName( "InspSpecDecimalPlaces" )
    @JsonProperty( "InspSpecDecimalPlaces" )
    @Nullable
    @ODataField( odataName = "InspSpecDecimalPlaces" )
    private Short inspSpecDecimalPlaces;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDecimalPlaces</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Short> INSP_SPEC_DECIMAL_PLACES =
        new InspPlanDepdntCharcField<Short>("InspSpecDecimalPlaces");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @return Unit of Measurement in Which Quantitative Data Is Stored
     */
    @SerializedName( "InspectionSpecificationUnit" )
    @JsonProperty( "InspectionSpecificationUnit" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationUnit" )
    private String inspectionSpecificationUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationUnit</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSPECTION_SPECIFICATION_UNIT =
        new InspPlanDepdntCharcField<String>("InspectionSpecificationUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @return Target Value for a Quantitative Characteristic
     */
    @SerializedName( "InspSpecTargetValue" )
    @JsonProperty( "InspSpecTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecTargetValue" )
    private Double inspSpecTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecTargetValue</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Double> INSP_SPEC_TARGET_VALUE =
        new InspPlanDepdntCharcField<Double>("InspSpecTargetValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasTargetValue" )
    @JsonProperty( "InspSpecHasTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecHasTargetValue" )
    private String inspSpecHasTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasTargetValue</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_HAS_TARGET_VALUE =
        new InspPlanDepdntCharcField<String>("InspSpecHasTargetValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @return Upper Specification Limit
     */
    @SerializedName( "InspSpecUpperLimit" )
    @JsonProperty( "InspSpecUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecUpperLimit" )
    private Double inspSpecUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecUpperLimit</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Double> INSP_SPEC_UPPER_LIMIT =
        new InspPlanDepdntCharcField<Double>("InspSpecUpperLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @return Lower Specification Limit
     */
    @SerializedName( "InspSpecLowerLimit" )
    @JsonProperty( "InspSpecLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecLowerLimit" )
    private Double inspSpecLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecLowerLimit</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Double> INSP_SPEC_LOWER_LIMIT =
        new InspPlanDepdntCharcField<Double>("InspSpecLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasUpperLimit" )
    @JsonProperty( "InspSpecHasUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasUpperLimit" )
    private String inspSpecHasUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasUpperLimit</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_HAS_UPPER_LIMIT =
        new InspPlanDepdntCharcField<String>("InspSpecHasUpperLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasLowerLimit" )
    @JsonProperty( "InspSpecHasLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasLowerLimit" )
    private String inspSpecHasLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasLowerLimit</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_HAS_LOWER_LIMIT =
        new InspPlanDepdntCharcField<String>("InspSpecHasLowerLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecNumberOfClasses</b>
     * </p>
     *
     * @return Number of Value Classes for Inspection Results
     */
    @SerializedName( "InspSpecNumberOfClasses" )
    @JsonProperty( "InspSpecNumberOfClasses" )
    @Nullable
    @ODataField( odataName = "InspSpecNumberOfClasses" )
    private Short inspSpecNumberOfClasses;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecNumberOfClasses</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Short> INSP_SPEC_NUMBER_OF_CLASSES =
        new InspPlanDepdntCharcField<Short>("InspSpecNumberOfClasses");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassWidthQty</b>
     * </p>
     *
     * @return Class Width
     */
    @SerializedName( "InspSpecClassWidthQty" )
    @JsonProperty( "InspSpecClassWidthQty" )
    @Nullable
    @ODataField( odataName = "InspSpecClassWidthQty" )
    private Double inspSpecClassWidthQty;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecClassWidthQty</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Double> INSP_SPEC_CLASS_WIDTH_QTY =
        new InspPlanDepdntCharcField<Double>("InspSpecClassWidthQty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassWidth</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasClassWidth" )
    @JsonProperty( "InspSpecHasClassWidth" )
    @Nullable
    @ODataField( odataName = "InspSpecHasClassWidth" )
    private String inspSpecHasClassWidth;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasClassWidth</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_HAS_CLASS_WIDTH =
        new InspPlanDepdntCharcField<String>("InspSpecHasClassWidth");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassMidpointQty</b>
     * </p>
     *
     * @return Class Midpoint
     */
    @SerializedName( "InspSpecClassMidpointQty" )
    @JsonProperty( "InspSpecClassMidpointQty" )
    @Nullable
    @ODataField( odataName = "InspSpecClassMidpointQty" )
    private Double inspSpecClassMidpointQty;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecClassMidpointQty</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<Double> INSP_SPEC_CLASS_MIDPOINT_QTY =
        new InspPlanDepdntCharcField<Double>("InspSpecClassMidpointQty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassMidpoint</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasClassMidpoint" )
    @JsonProperty( "InspSpecHasClassMidpoint" )
    @Nullable
    @ODataField( odataName = "InspSpecHasClassMidpoint" )
    private String inspSpecHasClassMidpoint;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasClassMidpoint</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_HAS_CLASS_MIDPOINT =
        new InspPlanDepdntCharcField<String>("InspSpecHasClassMidpoint");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> SELECTED_CODE_SET =
        new InspPlanDepdntCharcField<String>("SelectedCodeSet");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> SELECTED_CODE_SET_PLANT =
        new InspPlanDepdntCharcField<String>("SelectedCodeSetPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog2</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog2" )
    @JsonProperty( "InspSpecAdditionalCatalog2" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog2" )
    private String inspSpecAdditionalCatalog2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog2</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CATALOG2 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCatalog2");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet2</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet2" )
    @JsonProperty( "InspSpecAdditionalSelectedSet2" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet2" )
    private String inspSpecAdditionalSelectedSet2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet2</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET2 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalSelectedSet2");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup2</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup2" )
    @JsonProperty( "InspSpecAdditionalCodeGroup2" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup2" )
    private String inspSpecAdditionalCodeGroup2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup2</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP2 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCodeGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant2</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant2" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant2" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant2" )
    private String inspSpecAddlSeldCodeSetPlant2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant2</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT2 =
        new InspPlanDepdntCharcField<String>("InspSpecAddlSeldCodeSetPlant2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog3</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog3" )
    @JsonProperty( "InspSpecAdditionalCatalog3" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog3" )
    private String inspSpecAdditionalCatalog3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog3</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CATALOG3 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCatalog3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet3</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet3" )
    @JsonProperty( "InspSpecAdditionalSelectedSet3" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet3" )
    private String inspSpecAdditionalSelectedSet3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet3</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET3 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalSelectedSet3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup3</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup3" )
    @JsonProperty( "InspSpecAdditionalCodeGroup3" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup3" )
    private String inspSpecAdditionalCodeGroup3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup3</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP3 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCodeGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant3</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant3" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant3" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant3" )
    private String inspSpecAddlSeldCodeSetPlant3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant3</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT3 =
        new InspPlanDepdntCharcField<String>("InspSpecAddlSeldCodeSetPlant3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog4</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog4" )
    @JsonProperty( "InspSpecAdditionalCatalog4" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog4" )
    private String inspSpecAdditionalCatalog4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog4</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CATALOG4 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCatalog4");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet4</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet4" )
    @JsonProperty( "InspSpecAdditionalSelectedSet4" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet4" )
    private String inspSpecAdditionalSelectedSet4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet4</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET4 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalSelectedSet4");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup4</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup4" )
    @JsonProperty( "InspSpecAdditionalCodeGroup4" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup4" )
    private String inspSpecAdditionalCodeGroup4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup4</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP4 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCodeGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant4</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant4" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant4" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant4" )
    private String inspSpecAddlSeldCodeSetPlant4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant4</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT4 =
        new InspPlanDepdntCharcField<String>("InspSpecAddlSeldCodeSetPlant4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog5</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog5" )
    @JsonProperty( "InspSpecAdditionalCatalog5" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog5" )
    private String inspSpecAdditionalCatalog5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog5</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CATALOG5 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCatalog5");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet5</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet5" )
    @JsonProperty( "InspSpecAdditionalSelectedSet5" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet5" )
    private String inspSpecAdditionalSelectedSet5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet5</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET5 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalSelectedSet5");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup5</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup5" )
    @JsonProperty( "InspSpecAdditionalCodeGroup5" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup5" )
    private String inspSpecAdditionalCodeGroup5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup5</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP5 =
        new InspPlanDepdntCharcField<String>("InspSpecAdditionalCodeGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant5</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant5" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant5" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant5" )
    private String inspSpecAddlSeldCodeSetPlant5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant5</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT5 =
        new InspPlanDepdntCharcField<String>("InspSpecAddlSeldCodeSetPlant5");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Who Created Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> CREATED_BY_USER =
        new InspPlanDepdntCharcField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<LocalDateTime> CREATION_DATE =
        new InspPlanDepdntCharcField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> LAST_CHANGED_BY_USER =
        new InspPlanDepdntCharcField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<LocalDateTime> LAST_CHANGE_DATE =
        new InspPlanDepdntCharcField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVersion</b>
     * </p>
     *
     * @return Routing Version
     */
    @SerializedName( "BillOfOperationsVersion" )
    @JsonProperty( "BillOfOperationsVersion" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsVersion" )
    private String billOfOperationsVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsVersion</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<String> BILL_OF_OPERATIONS_VERSION =
        new InspPlanDepdntCharcField<String>("BillOfOperationsVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspPlanDepdntCharcField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspPlanDepdntCharcField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspPlanDepdntCharc> getType()
    {
        return InspPlanDepdntCharc.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @param inspectionPlanGroup
     *            Key for Task List Group
     */
    public void setInspectionPlanGroup( @Nullable final String inspectionPlanGroup )
    {
        rememberChangedField("InspectionPlanGroup", this.inspectionPlanGroup);
        this.inspectionPlanGroup = inspectionPlanGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @param inspectionPlan
     *            Group Counter
     */
    public void setInspectionPlan( @Nullable final String inspectionPlan )
    {
        rememberChangedField("InspectionPlan", this.inspectionPlan);
        this.inspectionPlan = inspectionPlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @param inspectionPlanInternalVersion
     *            Internal counter
     */
    public void setInspectionPlanInternalVersion( @Nullable final String inspectionPlanInternalVersion )
    {
        rememberChangedField("InspectionPlanInternalVersion", this.inspectionPlanInternalVersion);
        this.inspectionPlanInternalVersion = inspectionPlanInternalVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     */
    public void setBOOOperationInternalID( @Nullable final String bOOOperationInternalID )
    {
        rememberChangedField("BOOOperationInternalID", this.bOOOperationInternalID);
        this.bOOOperationInternalID = bOOOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     */
    public void setBOOOpInternalVersionCounter( @Nullable final String bOOOpInternalVersionCounter )
    {
        rememberChangedField("BOOOpInternalVersionCounter", this.bOOOpInternalVersionCounter);
        this.bOOOpInternalVersionCounter = bOOOpInternalVersionCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristic</b>
     * </p>
     *
     * @param bOOCharacteristic
     *            Inspection Characteristic Number
     */
    public void setBOOCharacteristic( @Nullable final String bOOCharacteristic )
    {
        rememberChangedField("BOOCharacteristic", this.bOOCharacteristic);
        this.bOOCharacteristic = bOOCharacteristic;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristicVersion</b>
     * </p>
     *
     * @param bOOCharacteristicVersion
     *            Internal counter
     */
    public void setBOOCharacteristicVersion( @Nullable final String bOOCharacteristicVersion )
    {
        rememberChangedField("BOOCharacteristicVersion", this.bOOCharacteristicVersion);
        this.bOOCharacteristicVersion = bOOCharacteristicVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOODpndantCharcSpec</b>
     * </p>
     *
     * @param bOODpndantCharcSpec
     *            Number for Dependent Characteristic Specifications
     */
    public void setBOODpndantCharcSpec( @Nullable final String bOODpndantCharcSpec )
    {
        rememberChangedField("BOODpndantCharcSpec", this.bOODpndantCharcSpec);
        this.bOODpndantCharcSpec = bOODpndantCharcSpec;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOODpndantCharcSpecVers</b>
     * </p>
     *
     * @param bOODpndantCharcSpecVers
     *            Internal counter
     */
    public void setBOODpndantCharcSpecVers( @Nullable final String bOODpndantCharcSpecVers )
    {
        rememberChangedField("BOODpndantCharcSpecVers", this.bOODpndantCharcSpecVers);
        this.bOODpndantCharcSpecVers = bOODpndantCharcSpecVers;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @param inspSpecIsQuantitative
     *            Quantitative Characteristic
     */
    public void setInspSpecIsQuantitative( @Nullable final String inspSpecIsQuantitative )
    {
        rememberChangedField("InspSpecIsQuantitative", this.inspSpecIsQuantitative);
        this.inspSpecIsQuantitative = inspSpecIsQuantitative;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectsRecgAutomatic</b>
     * </p>
     *
     * @param inspSpecIsDefectsRecgAutomatic
     *            Defects Recording Automatically Called Up
     */
    public void setInspSpecIsDefectsRecgAutomatic( @Nullable final String inspSpecIsDefectsRecgAutomatic )
    {
        rememberChangedField("InspSpecIsDefectsRecgAutomatic", this.inspSpecIsDefectsRecgAutomatic);
        this.inspSpecIsDefectsRecgAutomatic = inspSpecIsDefectsRecgAutomatic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @param inspSpecIsSelectedSetRequired
     *            Reference to Characteristic Attribute Required
     */
    public void setInspSpecIsSelectedSetRequired( @Nullable final String inspSpecIsSelectedSetRequired )
    {
        rememberChangedField("InspSpecIsSelectedSetRequired", this.inspSpecIsSelectedSetRequired);
        this.inspSpecIsSelectedSetRequired = inspSpecIsSelectedSetRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @param inspectionSpecificationText
     *            Short Text for Inspection Characteristic
     */
    public void setInspectionSpecificationText( @Nullable final String inspectionSpecificationText )
    {
        rememberChangedField("InspectionSpecificationText", this.inspectionSpecificationText);
        this.inspectionSpecificationText = inspectionSpecificationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectRecordingRqd</b>
     * </p>
     *
     * @param inspSpecIsDefectRecordingRqd
     *            Recording the Number of Defects
     */
    public void setInspSpecIsDefectRecordingRqd( @Nullable final String inspSpecIsDefectRecordingRqd )
    {
        rememberChangedField("InspSpecIsDefectRecordingRqd", this.inspSpecIsDefectRecordingRqd);
        this.inspSpecIsDefectRecordingRqd = inspSpecIsDefectRecordingRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @param prodnRsceToolItemNumber
     *            Item Number for Production Resource/Tool
     */
    public void setProdnRsceToolItemNumber( @Nullable final String prodnRsceToolItemNumber )
    {
        rememberChangedField("ProdnRsceToolItemNumber", this.prodnRsceToolItemNumber);
        this.prodnRsceToolItemNumber = prodnRsceToolItemNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Account number of customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BOOSearchText</b>
     * </p>
     *
     * @param bOOSearchText
     *            Search Field for Customer-Specific Task List Selection
     */
    public void setBOOSearchText( @Nullable final String bOOSearchText )
    {
        rememberChangedField("BOOSearchText", this.bOOSearchText);
        this.bOOSearchText = bOOSearchText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObject</b>
     * </p>
     *
     * @param multipleSpecificationObject
     *            Object for Multiple Specifications
     */
    public void setMultipleSpecificationObject( @Nullable final String multipleSpecificationObject )
    {
        rememberChangedField("MultipleSpecificationObject", this.multipleSpecificationObject);
        this.multipleSpecificationObject = multipleSpecificationObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObjType</b>
     * </p>
     *
     * @param multipleSpecificationObjType
     *            Type of Object for Multiple Specifications
     */
    public void setMultipleSpecificationObjType( @Nullable final String multipleSpecificationObjType )
    {
        rememberChangedField("MultipleSpecificationObjType", this.multipleSpecificationObjType);
        this.multipleSpecificationObjType = multipleSpecificationObjType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @param bOOOperationPRTInternalID
     *            Assigned Test Equipment
     */
    public void setBOOOperationPRTInternalID( @Nullable final String bOOOperationPRTInternalID )
    {
        rememberChangedField("BOOOperationPRTInternalID", this.bOOOperationPRTInternalID);
        this.bOOOperationPRTInternalID = bOOOperationPRTInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number of the Dependent Characteristic Specs
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVariant</b>
     * </p>
     *
     * @param billOfOperationsVariant
     *            Group Counter
     */
    public void setBillOfOperationsVariant( @Nullable final String billOfOperationsVariant )
    {
        rememberChangedField("BillOfOperationsVariant", this.billOfOperationsVariant);
        this.billOfOperationsVariant = billOfOperationsVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BOOToMaterialInternalID</b>
     * </p>
     *
     * @param bOOToMaterialInternalID
     *            Counter for Additional Criteria
     */
    public void setBOOToMaterialInternalID( @Nullable final String bOOToMaterialInternalID )
    {
        rememberChangedField("BOOToMaterialInternalID", this.bOOToMaterialInternalID);
        this.bOOToMaterialInternalID = bOOToMaterialInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @param inspSpecDecimalPlaces
     *            Number of Places to the Right of a Decimal Point (Accuracy)
     */
    public void setInspSpecDecimalPlaces( @Nullable final Short inspSpecDecimalPlaces )
    {
        rememberChangedField("InspSpecDecimalPlaces", this.inspSpecDecimalPlaces);
        this.inspSpecDecimalPlaces = inspSpecDecimalPlaces;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @param inspectionSpecificationUnit
     *            Unit of Measurement in Which Quantitative Data Is Stored
     */
    public void setInspectionSpecificationUnit( @Nullable final String inspectionSpecificationUnit )
    {
        rememberChangedField("InspectionSpecificationUnit", this.inspectionSpecificationUnit);
        this.inspectionSpecificationUnit = inspectionSpecificationUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @param inspSpecTargetValue
     *            Target Value for a Quantitative Characteristic
     */
    public void setInspSpecTargetValue( @Nullable final Double inspSpecTargetValue )
    {
        rememberChangedField("InspSpecTargetValue", this.inspSpecTargetValue);
        this.inspSpecTargetValue = inspSpecTargetValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @param inspSpecHasTargetValue
     *            Value Not Initial If Set
     */
    public void setInspSpecHasTargetValue( @Nullable final String inspSpecHasTargetValue )
    {
        rememberChangedField("InspSpecHasTargetValue", this.inspSpecHasTargetValue);
        this.inspSpecHasTargetValue = inspSpecHasTargetValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @param inspSpecUpperLimit
     *            Upper Specification Limit
     */
    public void setInspSpecUpperLimit( @Nullable final Double inspSpecUpperLimit )
    {
        rememberChangedField("InspSpecUpperLimit", this.inspSpecUpperLimit);
        this.inspSpecUpperLimit = inspSpecUpperLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @param inspSpecLowerLimit
     *            Lower Specification Limit
     */
    public void setInspSpecLowerLimit( @Nullable final Double inspSpecLowerLimit )
    {
        rememberChangedField("InspSpecLowerLimit", this.inspSpecLowerLimit);
        this.inspSpecLowerLimit = inspSpecLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @param inspSpecHasUpperLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasUpperLimit( @Nullable final String inspSpecHasUpperLimit )
    {
        rememberChangedField("InspSpecHasUpperLimit", this.inspSpecHasUpperLimit);
        this.inspSpecHasUpperLimit = inspSpecHasUpperLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @param inspSpecHasLowerLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasLowerLimit( @Nullable final String inspSpecHasLowerLimit )
    {
        rememberChangedField("InspSpecHasLowerLimit", this.inspSpecHasLowerLimit);
        this.inspSpecHasLowerLimit = inspSpecHasLowerLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecNumberOfClasses</b>
     * </p>
     *
     * @param inspSpecNumberOfClasses
     *            Number of Value Classes for Inspection Results
     */
    public void setInspSpecNumberOfClasses( @Nullable final Short inspSpecNumberOfClasses )
    {
        rememberChangedField("InspSpecNumberOfClasses", this.inspSpecNumberOfClasses);
        this.inspSpecNumberOfClasses = inspSpecNumberOfClasses;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassWidthQty</b>
     * </p>
     *
     * @param inspSpecClassWidthQty
     *            Class Width
     */
    public void setInspSpecClassWidthQty( @Nullable final Double inspSpecClassWidthQty )
    {
        rememberChangedField("InspSpecClassWidthQty", this.inspSpecClassWidthQty);
        this.inspSpecClassWidthQty = inspSpecClassWidthQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassWidth</b>
     * </p>
     *
     * @param inspSpecHasClassWidth
     *            Value Not Initial If Set
     */
    public void setInspSpecHasClassWidth( @Nullable final String inspSpecHasClassWidth )
    {
        rememberChangedField("InspSpecHasClassWidth", this.inspSpecHasClassWidth);
        this.inspSpecHasClassWidth = inspSpecHasClassWidth;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassMidpointQty</b>
     * </p>
     *
     * @param inspSpecClassMidpointQty
     *            Class Midpoint
     */
    public void setInspSpecClassMidpointQty( @Nullable final Double inspSpecClassMidpointQty )
    {
        rememberChangedField("InspSpecClassMidpointQty", this.inspSpecClassMidpointQty);
        this.inspSpecClassMidpointQty = inspSpecClassMidpointQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassMidpoint</b>
     * </p>
     *
     * @param inspSpecHasClassMidpoint
     *            Value Not Initial If Set
     */
    public void setInspSpecHasClassMidpoint( @Nullable final String inspSpecHasClassMidpoint )
    {
        rememberChangedField("InspSpecHasClassMidpoint", this.inspSpecHasClassMidpoint);
        this.inspSpecHasClassMidpoint = inspSpecHasClassMidpoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Assigned Code Group or Selected Set
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant of the Assigned Selected Set
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog2</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog2
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog2( @Nullable final String inspSpecAdditionalCatalog2 )
    {
        rememberChangedField("InspSpecAdditionalCatalog2", this.inspSpecAdditionalCatalog2);
        this.inspSpecAdditionalCatalog2 = inspSpecAdditionalCatalog2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet2</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet2
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet2( @Nullable final String inspSpecAdditionalSelectedSet2 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet2", this.inspSpecAdditionalSelectedSet2);
        this.inspSpecAdditionalSelectedSet2 = inspSpecAdditionalSelectedSet2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup2</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup2
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup2( @Nullable final String inspSpecAdditionalCodeGroup2 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup2", this.inspSpecAdditionalCodeGroup2);
        this.inspSpecAdditionalCodeGroup2 = inspSpecAdditionalCodeGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant2</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant2
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant2( @Nullable final String inspSpecAddlSeldCodeSetPlant2 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant2", this.inspSpecAddlSeldCodeSetPlant2);
        this.inspSpecAddlSeldCodeSetPlant2 = inspSpecAddlSeldCodeSetPlant2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog3</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog3
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog3( @Nullable final String inspSpecAdditionalCatalog3 )
    {
        rememberChangedField("InspSpecAdditionalCatalog3", this.inspSpecAdditionalCatalog3);
        this.inspSpecAdditionalCatalog3 = inspSpecAdditionalCatalog3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet3</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet3
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet3( @Nullable final String inspSpecAdditionalSelectedSet3 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet3", this.inspSpecAdditionalSelectedSet3);
        this.inspSpecAdditionalSelectedSet3 = inspSpecAdditionalSelectedSet3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup3</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup3
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup3( @Nullable final String inspSpecAdditionalCodeGroup3 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup3", this.inspSpecAdditionalCodeGroup3);
        this.inspSpecAdditionalCodeGroup3 = inspSpecAdditionalCodeGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant3</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant3
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant3( @Nullable final String inspSpecAddlSeldCodeSetPlant3 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant3", this.inspSpecAddlSeldCodeSetPlant3);
        this.inspSpecAddlSeldCodeSetPlant3 = inspSpecAddlSeldCodeSetPlant3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog4</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog4
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog4( @Nullable final String inspSpecAdditionalCatalog4 )
    {
        rememberChangedField("InspSpecAdditionalCatalog4", this.inspSpecAdditionalCatalog4);
        this.inspSpecAdditionalCatalog4 = inspSpecAdditionalCatalog4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet4</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet4
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet4( @Nullable final String inspSpecAdditionalSelectedSet4 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet4", this.inspSpecAdditionalSelectedSet4);
        this.inspSpecAdditionalSelectedSet4 = inspSpecAdditionalSelectedSet4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup4</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup4
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup4( @Nullable final String inspSpecAdditionalCodeGroup4 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup4", this.inspSpecAdditionalCodeGroup4);
        this.inspSpecAdditionalCodeGroup4 = inspSpecAdditionalCodeGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant4</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant4
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant4( @Nullable final String inspSpecAddlSeldCodeSetPlant4 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant4", this.inspSpecAddlSeldCodeSetPlant4);
        this.inspSpecAddlSeldCodeSetPlant4 = inspSpecAddlSeldCodeSetPlant4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog5</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog5
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog5( @Nullable final String inspSpecAdditionalCatalog5 )
    {
        rememberChangedField("InspSpecAdditionalCatalog5", this.inspSpecAdditionalCatalog5);
        this.inspSpecAdditionalCatalog5 = inspSpecAdditionalCatalog5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet5</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet5
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet5( @Nullable final String inspSpecAdditionalSelectedSet5 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet5", this.inspSpecAdditionalSelectedSet5);
        this.inspSpecAdditionalSelectedSet5 = inspSpecAdditionalSelectedSet5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup5</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup5
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup5( @Nullable final String inspSpecAdditionalCodeGroup5 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup5", this.inspSpecAdditionalCodeGroup5);
        this.inspSpecAdditionalCodeGroup5 = inspSpecAdditionalCodeGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant5</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant5
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant5( @Nullable final String inspSpecAddlSeldCodeSetPlant5 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant5", this.inspSpecAddlSeldCodeSetPlant5);
        this.inspSpecAddlSeldCodeSetPlant5 = inspSpecAddlSeldCodeSetPlant5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Who Created Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            System Date on Which Data Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of User Who Last Changed Data Record
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVersion</b>
     * </p>
     *
     * @param billOfOperationsVersion
     *            Routing Version
     */
    public void setBillOfOperationsVersion( @Nullable final String billOfOperationsVersion )
    {
        rememberChangedField("BillOfOperationsVersion", this.billOfOperationsVersion);
        this.billOfOperationsVersion = billOfOperationsVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspPlanDepdntCharc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionPlanGroup", getInspectionPlanGroup());
        result.put("InspectionPlan", getInspectionPlan());
        result.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        result.put("BOOOperationInternalID", getBOOOperationInternalID());
        result.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        result.put("BOOCharacteristic", getBOOCharacteristic());
        result.put("BOOCharacteristicVersion", getBOOCharacteristicVersion());
        result.put("BOODpndantCharcSpec", getBOODpndantCharcSpec());
        result.put("BOODpndantCharcSpecVers", getBOODpndantCharcSpecVers());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("InspectionPlanGroup", getInspectionPlanGroup());
        values.put("InspectionPlan", getInspectionPlan());
        values.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        values.put("BOOOperationInternalID", getBOOOperationInternalID());
        values.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        values.put("BOOCharacteristic", getBOOCharacteristic());
        values.put("BOOCharacteristicVersion", getBOOCharacteristicVersion());
        values.put("BOODpndantCharcSpec", getBOODpndantCharcSpec());
        values.put("BOODpndantCharcSpecVers", getBOODpndantCharcSpecVers());
        values.put("InspSpecIsQuantitative", getInspSpecIsQuantitative());
        values.put("InspSpecIsDefectsRecgAutomatic", getInspSpecIsDefectsRecgAutomatic());
        values.put("InspSpecIsSelectedSetRequired", getInspSpecIsSelectedSetRequired());
        values.put("InspectionSpecificationText", getInspectionSpecificationText());
        values.put("InspSpecIsDefectRecordingRqd", getInspSpecIsDefectRecordingRqd());
        values.put("ProdnRsceToolItemNumber", getProdnRsceToolItemNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("BOOSearchText", getBOOSearchText());
        values.put("MultipleSpecificationObject", getMultipleSpecificationObject());
        values.put("MultipleSpecificationObjType", getMultipleSpecificationObjType());
        values.put("IsDeleted", getIsDeleted());
        values.put("BOOOperationPRTInternalID", getBOOOperationPRTInternalID());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("BillOfOperationsVariant", getBillOfOperationsVariant());
        values.put("BOOToMaterialInternalID", getBOOToMaterialInternalID());
        values.put("InspSpecDecimalPlaces", getInspSpecDecimalPlaces());
        values.put("InspectionSpecificationUnit", getInspectionSpecificationUnit());
        values.put("InspSpecTargetValue", getInspSpecTargetValue());
        values.put("InspSpecHasTargetValue", getInspSpecHasTargetValue());
        values.put("InspSpecUpperLimit", getInspSpecUpperLimit());
        values.put("InspSpecLowerLimit", getInspSpecLowerLimit());
        values.put("InspSpecHasUpperLimit", getInspSpecHasUpperLimit());
        values.put("InspSpecHasLowerLimit", getInspSpecHasLowerLimit());
        values.put("InspSpecNumberOfClasses", getInspSpecNumberOfClasses());
        values.put("InspSpecClassWidthQty", getInspSpecClassWidthQty());
        values.put("InspSpecHasClassWidth", getInspSpecHasClassWidth());
        values.put("InspSpecClassMidpointQty", getInspSpecClassMidpointQty());
        values.put("InspSpecHasClassMidpoint", getInspSpecHasClassMidpoint());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("InspSpecAdditionalCatalog2", getInspSpecAdditionalCatalog2());
        values.put("InspSpecAdditionalSelectedSet2", getInspSpecAdditionalSelectedSet2());
        values.put("InspSpecAdditionalCodeGroup2", getInspSpecAdditionalCodeGroup2());
        values.put("InspSpecAddlSeldCodeSetPlant2", getInspSpecAddlSeldCodeSetPlant2());
        values.put("InspSpecAdditionalCatalog3", getInspSpecAdditionalCatalog3());
        values.put("InspSpecAdditionalSelectedSet3", getInspSpecAdditionalSelectedSet3());
        values.put("InspSpecAdditionalCodeGroup3", getInspSpecAdditionalCodeGroup3());
        values.put("InspSpecAddlSeldCodeSetPlant3", getInspSpecAddlSeldCodeSetPlant3());
        values.put("InspSpecAdditionalCatalog4", getInspSpecAdditionalCatalog4());
        values.put("InspSpecAdditionalSelectedSet4", getInspSpecAdditionalSelectedSet4());
        values.put("InspSpecAdditionalCodeGroup4", getInspSpecAdditionalCodeGroup4());
        values.put("InspSpecAddlSeldCodeSetPlant4", getInspSpecAddlSeldCodeSetPlant4());
        values.put("InspSpecAdditionalCatalog5", getInspSpecAdditionalCatalog5());
        values.put("InspSpecAdditionalSelectedSet5", getInspSpecAdditionalSelectedSet5());
        values.put("InspSpecAdditionalCodeGroup5", getInspSpecAdditionalCodeGroup5());
        values.put("InspSpecAddlSeldCodeSetPlant5", getInspSpecAddlSeldCodeSetPlant5());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("BillOfOperationsVersion", getBillOfOperationsVersion());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionPlanGroup") ) {
                final Object value = values.remove("InspectionPlanGroup");
                if( (value == null) || (!value.equals(getInspectionPlanGroup())) ) {
                    setInspectionPlanGroup(((String) value));
                }
            }
            if( values.containsKey("InspectionPlan") ) {
                final Object value = values.remove("InspectionPlan");
                if( (value == null) || (!value.equals(getInspectionPlan())) ) {
                    setInspectionPlan(((String) value));
                }
            }
            if( values.containsKey("InspectionPlanInternalVersion") ) {
                final Object value = values.remove("InspectionPlanInternalVersion");
                if( (value == null) || (!value.equals(getInspectionPlanInternalVersion())) ) {
                    setInspectionPlanInternalVersion(((String) value));
                }
            }
            if( values.containsKey("BOOOperationInternalID") ) {
                final Object value = values.remove("BOOOperationInternalID");
                if( (value == null) || (!value.equals(getBOOOperationInternalID())) ) {
                    setBOOOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("BOOOpInternalVersionCounter") ) {
                final Object value = values.remove("BOOOpInternalVersionCounter");
                if( (value == null) || (!value.equals(getBOOOpInternalVersionCounter())) ) {
                    setBOOOpInternalVersionCounter(((String) value));
                }
            }
            if( values.containsKey("BOOCharacteristic") ) {
                final Object value = values.remove("BOOCharacteristic");
                if( (value == null) || (!value.equals(getBOOCharacteristic())) ) {
                    setBOOCharacteristic(((String) value));
                }
            }
            if( values.containsKey("BOOCharacteristicVersion") ) {
                final Object value = values.remove("BOOCharacteristicVersion");
                if( (value == null) || (!value.equals(getBOOCharacteristicVersion())) ) {
                    setBOOCharacteristicVersion(((String) value));
                }
            }
            if( values.containsKey("BOODpndantCharcSpec") ) {
                final Object value = values.remove("BOODpndantCharcSpec");
                if( (value == null) || (!value.equals(getBOODpndantCharcSpec())) ) {
                    setBOODpndantCharcSpec(((String) value));
                }
            }
            if( values.containsKey("BOODpndantCharcSpecVers") ) {
                final Object value = values.remove("BOODpndantCharcSpecVers");
                if( (value == null) || (!value.equals(getBOODpndantCharcSpecVers())) ) {
                    setBOODpndantCharcSpecVers(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsQuantitative") ) {
                final Object value = values.remove("InspSpecIsQuantitative");
                if( (value == null) || (!value.equals(getInspSpecIsQuantitative())) ) {
                    setInspSpecIsQuantitative(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsDefectsRecgAutomatic") ) {
                final Object value = values.remove("InspSpecIsDefectsRecgAutomatic");
                if( (value == null) || (!value.equals(getInspSpecIsDefectsRecgAutomatic())) ) {
                    setInspSpecIsDefectsRecgAutomatic(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSelectedSetRequired") ) {
                final Object value = values.remove("InspSpecIsSelectedSetRequired");
                if( (value == null) || (!value.equals(getInspSpecIsSelectedSetRequired())) ) {
                    setInspSpecIsSelectedSetRequired(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationText") ) {
                final Object value = values.remove("InspectionSpecificationText");
                if( (value == null) || (!value.equals(getInspectionSpecificationText())) ) {
                    setInspectionSpecificationText(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsDefectRecordingRqd") ) {
                final Object value = values.remove("InspSpecIsDefectRecordingRqd");
                if( (value == null) || (!value.equals(getInspSpecIsDefectRecordingRqd())) ) {
                    setInspSpecIsDefectRecordingRqd(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolItemNumber") ) {
                final Object value = values.remove("ProdnRsceToolItemNumber");
                if( (value == null) || (!value.equals(getProdnRsceToolItemNumber())) ) {
                    setProdnRsceToolItemNumber(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("BOOSearchText") ) {
                final Object value = values.remove("BOOSearchText");
                if( (value == null) || (!value.equals(getBOOSearchText())) ) {
                    setBOOSearchText(((String) value));
                }
            }
            if( values.containsKey("MultipleSpecificationObject") ) {
                final Object value = values.remove("MultipleSpecificationObject");
                if( (value == null) || (!value.equals(getMultipleSpecificationObject())) ) {
                    setMultipleSpecificationObject(((String) value));
                }
            }
            if( values.containsKey("MultipleSpecificationObjType") ) {
                final Object value = values.remove("MultipleSpecificationObjType");
                if( (value == null) || (!value.equals(getMultipleSpecificationObjType())) ) {
                    setMultipleSpecificationObjType(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("BOOOperationPRTInternalID") ) {
                final Object value = values.remove("BOOOperationPRTInternalID");
                if( (value == null) || (!value.equals(getBOOOperationPRTInternalID())) ) {
                    setBOOOperationPRTInternalID(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsVariant") ) {
                final Object value = values.remove("BillOfOperationsVariant");
                if( (value == null) || (!value.equals(getBillOfOperationsVariant())) ) {
                    setBillOfOperationsVariant(((String) value));
                }
            }
            if( values.containsKey("BOOToMaterialInternalID") ) {
                final Object value = values.remove("BOOToMaterialInternalID");
                if( (value == null) || (!value.equals(getBOOToMaterialInternalID())) ) {
                    setBOOToMaterialInternalID(((String) value));
                }
            }
            if( values.containsKey("InspSpecDecimalPlaces") ) {
                final Object value = values.remove("InspSpecDecimalPlaces");
                if( (value == null) || (!value.equals(getInspSpecDecimalPlaces())) ) {
                    setInspSpecDecimalPlaces(((Short) value));
                }
            }
            if( values.containsKey("InspectionSpecificationUnit") ) {
                final Object value = values.remove("InspectionSpecificationUnit");
                if( (value == null) || (!value.equals(getInspectionSpecificationUnit())) ) {
                    setInspectionSpecificationUnit(((String) value));
                }
            }
            if( values.containsKey("InspSpecTargetValue") ) {
                final Object value = values.remove("InspSpecTargetValue");
                if( (value == null) || (!value.equals(getInspSpecTargetValue())) ) {
                    setInspSpecTargetValue(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasTargetValue") ) {
                final Object value = values.remove("InspSpecHasTargetValue");
                if( (value == null) || (!value.equals(getInspSpecHasTargetValue())) ) {
                    setInspSpecHasTargetValue(((String) value));
                }
            }
            if( values.containsKey("InspSpecUpperLimit") ) {
                final Object value = values.remove("InspSpecUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecUpperLimit())) ) {
                    setInspSpecUpperLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecLowerLimit") ) {
                final Object value = values.remove("InspSpecLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecLowerLimit())) ) {
                    setInspSpecLowerLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasUpperLimit") ) {
                final Object value = values.remove("InspSpecHasUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecHasUpperLimit())) ) {
                    setInspSpecHasUpperLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecHasLowerLimit") ) {
                final Object value = values.remove("InspSpecHasLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecHasLowerLimit())) ) {
                    setInspSpecHasLowerLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecNumberOfClasses") ) {
                final Object value = values.remove("InspSpecNumberOfClasses");
                if( (value == null) || (!value.equals(getInspSpecNumberOfClasses())) ) {
                    setInspSpecNumberOfClasses(((Short) value));
                }
            }
            if( values.containsKey("InspSpecClassWidthQty") ) {
                final Object value = values.remove("InspSpecClassWidthQty");
                if( (value == null) || (!value.equals(getInspSpecClassWidthQty())) ) {
                    setInspSpecClassWidthQty(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasClassWidth") ) {
                final Object value = values.remove("InspSpecHasClassWidth");
                if( (value == null) || (!value.equals(getInspSpecHasClassWidth())) ) {
                    setInspSpecHasClassWidth(((String) value));
                }
            }
            if( values.containsKey("InspSpecClassMidpointQty") ) {
                final Object value = values.remove("InspSpecClassMidpointQty");
                if( (value == null) || (!value.equals(getInspSpecClassMidpointQty())) ) {
                    setInspSpecClassMidpointQty(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasClassMidpoint") ) {
                final Object value = values.remove("InspSpecHasClassMidpoint");
                if( (value == null) || (!value.equals(getInspSpecHasClassMidpoint())) ) {
                    setInspSpecHasClassMidpoint(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog2") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog2");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog2())) ) {
                    setInspSpecAdditionalCatalog2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet2") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet2");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet2())) ) {
                    setInspSpecAdditionalSelectedSet2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup2") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup2");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup2())) ) {
                    setInspSpecAdditionalCodeGroup2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant2") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant2");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant2())) ) {
                    setInspSpecAddlSeldCodeSetPlant2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog3") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog3");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog3())) ) {
                    setInspSpecAdditionalCatalog3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet3") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet3");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet3())) ) {
                    setInspSpecAdditionalSelectedSet3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup3") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup3");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup3())) ) {
                    setInspSpecAdditionalCodeGroup3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant3") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant3");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant3())) ) {
                    setInspSpecAddlSeldCodeSetPlant3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog4") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog4");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog4())) ) {
                    setInspSpecAdditionalCatalog4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet4") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet4");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet4())) ) {
                    setInspSpecAdditionalSelectedSet4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup4") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup4");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup4())) ) {
                    setInspSpecAdditionalCodeGroup4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant4") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant4");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant4())) ) {
                    setInspSpecAddlSeldCodeSetPlant4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog5") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog5");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog5())) ) {
                    setInspSpecAdditionalCatalog5(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet5") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet5");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet5())) ) {
                    setInspSpecAdditionalSelectedSet5(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup5") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup5");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup5())) ) {
                    setInspSpecAdditionalCodeGroup5(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant5") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant5");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant5())) ) {
                    setInspSpecAddlSeldCodeSetPlant5(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillOfOperationsVersion") ) {
                final Object value = values.remove("BillOfOperationsVersion");
                if( (value == null) || (!value.equals(getBillOfOperationsVersion())) ) {
                    setBillOfOperationsVersion(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspPlanDepdntCharcField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspPlanDepdntCharcField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspPlanDepdntCharcField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspPlanDepdntCharcField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService.DEFAULT_SERVICE_PATH);
    }

}
