/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanMaterialAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspPlanMaterialAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Material Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspPlanMaterialAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspPlanMaterialAssgmt extends VdmEntity<InspPlanMaterialAssgmt>
{

    /**
     * Selector for all available fields of InspPlanMaterialAssgmt.
     *
     */
    public final static InspPlanMaterialAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<Boolean> DELETE_MC =
        new InspPlanMaterialAssgmtField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<Boolean> UPDATE_MC =
        new InspPlanMaterialAssgmtField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> MATERIAL =
        new InspPlanMaterialAssgmtField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> PLANT = new InspPlanMaterialAssgmtField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "InspectionPlanGroup" )
    @JsonProperty( "InspectionPlanGroup" )
    @Nullable
    @ODataField( odataName = "InspectionPlanGroup" )
    private String inspectionPlanGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanGroup</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> INSPECTION_PLAN_GROUP =
        new InspPlanMaterialAssgmtField<String>("InspectionPlanGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "InspectionPlan" )
    @JsonProperty( "InspectionPlan" )
    @Nullable
    @ODataField( odataName = "InspectionPlan" )
    private String inspectionPlan;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlan</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> INSPECTION_PLAN =
        new InspPlanMaterialAssgmtField<String>("InspectionPlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanMatlAssignment</b>
     * </p>
     *
     * @return Counter for Additional Criteria
     */
    @Key
    @SerializedName( "InspPlanMatlAssignment" )
    @JsonProperty( "InspPlanMatlAssignment" )
    @Nullable
    @ODataField( odataName = "InspPlanMatlAssignment" )
    private String inspPlanMatlAssignment;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanMatlAssignment</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> INSP_PLAN_MATL_ASSIGNMENT =
        new InspPlanMaterialAssgmtField<String>("InspPlanMatlAssignment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanMatlAssgmtIntVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "InspPlanMatlAssgmtIntVersion" )
    @JsonProperty( "InspPlanMatlAssgmtIntVersion" )
    @Nullable
    @ODataField( odataName = "InspPlanMatlAssgmtIntVersion" )
    private String inspPlanMatlAssgmtIntVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanMatlAssgmtIntVersion</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> INSP_PLAN_MATL_ASSGMT_INT_VERSION =
        new InspPlanMaterialAssgmtField<String>("InspPlanMatlAssgmtIntVersion");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "InspectionPlanInternalVersion" )
    @JsonProperty( "InspectionPlanInternalVersion" )
    @Nullable
    @ODataField( odataName = "InspectionPlanInternalVersion" )
    private String inspectionPlanInternalVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanInternalVersion</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> INSPECTION_PLAN_INTERNAL_VERSION =
        new InspPlanMaterialAssgmtField<String>("InspectionPlanInternalVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<LocalDateTime> VALIDITY_START_DATE =
        new InspPlanMaterialAssgmtField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<LocalDateTime> VALIDITY_END_DATE =
        new InspPlanMaterialAssgmtField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> CHANGE_NUMBER =
        new InspPlanMaterialAssgmtField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<LocalDateTime> CREATION_DATE =
        new InspPlanMaterialAssgmtField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> CREATED_BY_USER =
        new InspPlanMaterialAssgmtField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<LocalDateTime> LAST_CHANGE_DATE =
        new InspPlanMaterialAssgmtField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> LAST_CHANGED_BY_USER =
        new InspPlanMaterialAssgmtField<String>("LastChangedByUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<Boolean> IS_DELETED =
        new InspPlanMaterialAssgmtField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> SUPPLIER =
        new InspPlanMaterialAssgmtField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Account number of customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> CUSTOMER =
        new InspPlanMaterialAssgmtField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObject</b>
     * </p>
     *
     * @return Object for Multiple Specifications
     */
    @SerializedName( "MultipleSpecificationObject" )
    @JsonProperty( "MultipleSpecificationObject" )
    @Nullable
    @ODataField( odataName = "MultipleSpecificationObject" )
    private String multipleSpecificationObject;
    /**
     * Use with available fluent helpers to apply the <b>MultipleSpecificationObject</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> MULTIPLE_SPECIFICATION_OBJECT =
        new InspPlanMaterialAssgmtField<String>("MultipleSpecificationObject");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObjType</b>
     * </p>
     *
     * @return Type of Object for Multiple Specifications
     */
    @SerializedName( "MultipleSpecificationObjType" )
    @JsonProperty( "MultipleSpecificationObjType" )
    @Nullable
    @ODataField( odataName = "MultipleSpecificationObjType" )
    private String multipleSpecificationObjType;
    /**
     * Use with available fluent helpers to apply the <b>MultipleSpecificationObjType</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> MULTIPLE_SPECIFICATION_OBJ_TYPE =
        new InspPlanMaterialAssgmtField<String>("MultipleSpecificationObjType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BOOSearchText</b>
     * </p>
     *
     * @return Search Field for Customer-Specific Task List Selection
     */
    @SerializedName( "BOOSearchText" )
    @JsonProperty( "BOOSearchText" )
    @Nullable
    @ODataField( odataName = "BOOSearchText" )
    private String bOOSearchText;
    /**
     * Use with available fluent helpers to apply the <b>BOOSearchText</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<String> BOO_SEARCH_TEXT =
        new InspPlanMaterialAssgmtField<String>("BOOSearchText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspPlanMaterialAssgmtField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspPlanMaterialAssgmtField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspPlanMaterialAssgmt> getType()
    {
        return InspPlanMaterialAssgmt.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @param inspectionPlanGroup
     *            Key for Task List Group
     */
    public void setInspectionPlanGroup( @Nullable final String inspectionPlanGroup )
    {
        rememberChangedField("InspectionPlanGroup", this.inspectionPlanGroup);
        this.inspectionPlanGroup = inspectionPlanGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @param inspectionPlan
     *            Group Counter
     */
    public void setInspectionPlan( @Nullable final String inspectionPlan )
    {
        rememberChangedField("InspectionPlan", this.inspectionPlan);
        this.inspectionPlan = inspectionPlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanMatlAssignment</b>
     * </p>
     *
     * @param inspPlanMatlAssignment
     *            Counter for Additional Criteria
     */
    public void setInspPlanMatlAssignment( @Nullable final String inspPlanMatlAssignment )
    {
        rememberChangedField("InspPlanMatlAssignment", this.inspPlanMatlAssignment);
        this.inspPlanMatlAssignment = inspPlanMatlAssignment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanMatlAssgmtIntVersion</b>
     * </p>
     *
     * @param inspPlanMatlAssgmtIntVersion
     *            Internal counter
     */
    public void setInspPlanMatlAssgmtIntVersion( @Nullable final String inspPlanMatlAssgmtIntVersion )
    {
        rememberChangedField("InspPlanMatlAssgmtIntVersion", this.inspPlanMatlAssgmtIntVersion);
        this.inspPlanMatlAssgmtIntVersion = inspPlanMatlAssgmtIntVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @param inspectionPlanInternalVersion
     *            Internal counter
     */
    public void setInspectionPlanInternalVersion( @Nullable final String inspectionPlanInternalVersion )
    {
        rememberChangedField("InspectionPlanInternalVersion", this.inspectionPlanInternalVersion);
        this.inspectionPlanInternalVersion = inspectionPlanInternalVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Account number of customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObject</b>
     * </p>
     *
     * @param multipleSpecificationObject
     *            Object for Multiple Specifications
     */
    public void setMultipleSpecificationObject( @Nullable final String multipleSpecificationObject )
    {
        rememberChangedField("MultipleSpecificationObject", this.multipleSpecificationObject);
        this.multipleSpecificationObject = multipleSpecificationObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSpecificationObjType</b>
     * </p>
     *
     * @param multipleSpecificationObjType
     *            Type of Object for Multiple Specifications
     */
    public void setMultipleSpecificationObjType( @Nullable final String multipleSpecificationObjType )
    {
        rememberChangedField("MultipleSpecificationObjType", this.multipleSpecificationObjType);
        this.multipleSpecificationObjType = multipleSpecificationObjType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BOOSearchText</b>
     * </p>
     *
     * @param bOOSearchText
     *            Search Field for Customer-Specific Task List Selection
     */
    public void setBOOSearchText( @Nullable final String bOOSearchText )
    {
        rememberChangedField("BOOSearchText", this.bOOSearchText);
        this.bOOSearchText = bOOSearchText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspPlanMaterialAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("InspectionPlanGroup", getInspectionPlanGroup());
        result.put("InspectionPlan", getInspectionPlan());
        result.put("InspPlanMatlAssignment", getInspPlanMatlAssignment());
        result.put("InspPlanMatlAssgmtIntVersion", getInspPlanMatlAssgmtIntVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("InspectionPlanGroup", getInspectionPlanGroup());
        values.put("InspectionPlan", getInspectionPlan());
        values.put("InspPlanMatlAssignment", getInspPlanMatlAssignment());
        values.put("InspPlanMatlAssgmtIntVersion", getInspPlanMatlAssgmtIntVersion());
        values.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("IsDeleted", getIsDeleted());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("MultipleSpecificationObject", getMultipleSpecificationObject());
        values.put("MultipleSpecificationObjType", getMultipleSpecificationObjType());
        values.put("BOOSearchText", getBOOSearchText());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionPlanGroup") ) {
                final Object value = values.remove("InspectionPlanGroup");
                if( (value == null) || (!value.equals(getInspectionPlanGroup())) ) {
                    setInspectionPlanGroup(((String) value));
                }
            }
            if( values.containsKey("InspectionPlan") ) {
                final Object value = values.remove("InspectionPlan");
                if( (value == null) || (!value.equals(getInspectionPlan())) ) {
                    setInspectionPlan(((String) value));
                }
            }
            if( values.containsKey("InspPlanMatlAssignment") ) {
                final Object value = values.remove("InspPlanMatlAssignment");
                if( (value == null) || (!value.equals(getInspPlanMatlAssignment())) ) {
                    setInspPlanMatlAssignment(((String) value));
                }
            }
            if( values.containsKey("InspPlanMatlAssgmtIntVersion") ) {
                final Object value = values.remove("InspPlanMatlAssgmtIntVersion");
                if( (value == null) || (!value.equals(getInspPlanMatlAssgmtIntVersion())) ) {
                    setInspPlanMatlAssgmtIntVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionPlanInternalVersion") ) {
                final Object value = values.remove("InspectionPlanInternalVersion");
                if( (value == null) || (!value.equals(getInspectionPlanInternalVersion())) ) {
                    setInspectionPlanInternalVersion(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("MultipleSpecificationObject") ) {
                final Object value = values.remove("MultipleSpecificationObject");
                if( (value == null) || (!value.equals(getMultipleSpecificationObject())) ) {
                    setMultipleSpecificationObject(((String) value));
                }
            }
            if( values.containsKey("MultipleSpecificationObjType") ) {
                final Object value = values.remove("MultipleSpecificationObjType");
                if( (value == null) || (!value.equals(getMultipleSpecificationObjType())) ) {
                    setMultipleSpecificationObjType(((String) value));
                }
            }
            if( values.containsKey("BOOSearchText") ) {
                final Object value = values.remove("BOOSearchText");
                if( (value == null) || (!value.equals(getBOOSearchText())) ) {
                    setBOOSearchText(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspPlanMaterialAssgmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspPlanMaterialAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspPlanMaterialAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspPlanMaterialAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService.DEFAULT_SERVICE_PATH);
    }

}
